/*
 * Decompiled with CFR 0.152.
 */
package com.easy.component.utils.sql;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.util.TypeUtils;
import com.easy.DataFrame;
import com.easy.component.utils.ClassMapper;
import com.easy.component.utils.MD5Util;
import com.easy.component.utils.ReleaseObject;
import com.easy.component.utils.Traceer;
import com.easy.component.utils.sql.SQLBaseAction;
import com.easy.intf.FieldHandler;
import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SQLBaseDataFrame
extends SQLBaseAction {
    public <T> DataFrame<Object> onGetResult(Connection connection, String querySQL, T params) throws Exception {
        return this.onGetResult(connection, querySQL, params, null, null, null);
    }

    public <T> DataFrame<Object> onGetResult(Connection connection, String querySQL, T params, DataFrame.TagFunction<Object> tagFunction) throws Exception {
        return this.onGetResult(connection, querySQL, params, tagFunction, null, null);
    }

    public <T> DataFrame<Object> onGetResult(Connection connection, String querySQL, T params, DataFrame.TagFunction<Object> tagFunction, DataFrame.IndexFunction<Object> idxFunction) throws Exception {
        return this.onGetResult(connection, querySQL, params, tagFunction, idxFunction, null);
    }

    public <T> DataFrame<Object> onGetResult(Connection connection, String querySQL, T params, DataFrame.TagFunction<Object> tagFunction, List<String> indexList) throws Exception {
        return this.onGetResult(connection, querySQL, params, tagFunction, null, indexList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> DataFrame<Object> onGetResult(Connection connection, String querySQL, T params, DataFrame.TagFunction<Object> tagFunction, DataFrame.IndexFunction<Object> idxFunction, List<String> indexList) throws Exception {
        DataFrame<Object> response = null;
        PreparedStatement pstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            HashBasedTable paramsTable = HashBasedTable.create();
            String statement = SQLBaseAction.onParamsObject(querySQL, (Table<Integer, String, Object>)paramsTable);
            if (!paramsTable.isEmpty()) {
                pstmt = connection.prepareStatement(statement);
                SQLBaseAction.onParamsSet(pstmt, (Table<Integer, String, Object>)paramsTable, params);
                rs = pstmt.executeQuery();
                logger.warn("PreparedStatement Query:{}", (Object)statement);
            } else {
                stmt = connection.createStatement();
                rs = stmt.executeQuery(statement);
                logger.warn("Statement Query:{}", (Object)statement);
            }
            if (rs != null) {
                response = idxFunction != null ? DataFrame.readSql(rs, tagFunction, idxFunction) : DataFrame.readSql(rs, tagFunction, indexList);
            }
        }
        catch (Throwable throwable) {
            ReleaseObject.release(rs);
            ReleaseObject.release(stmt);
            ReleaseObject.release(pstmt);
            throw throwable;
        }
        ReleaseObject.release(rs);
        ReleaseObject.release(stmt);
        ReleaseObject.release(pstmt);
        return response;
    }

    public DataFrame<Object> onGetResult(Connection connection, List<String> fieldList, List<String> keyList, String collectionName, String conditionWhere) throws Exception {
        DataFrame.TagFunction<Object> tagFunction = new DataFrame.TagFunction<Object>(){

            @Override
            public void tagColumn(List<String> columns) {
                columns.add("md5");
            }

            @Override
            public void tagAction(List<String> columns, List<Object> values) {
                String md5Key = MD5Util.getInstance().md5(JSON.toJSONString(values));
                values.add(md5Key);
            }
        };
        final List<String> columnIdx = keyList;
        DataFrame.IndexFunction<Object> idxFunction = new DataFrame.IndexFunction<Object>(){

            @Override
            public Object indexAction(List<String> columns, List<Object> values) {
                StringBuffer buffer = new StringBuffer();
                boolean first = true;
                for (String action : columnIdx) {
                    int indexPos = columns.indexOf(action);
                    if (indexPos >= 0) {
                        Object currentValue = values.get(indexPos);
                        if (first) {
                            first = false;
                        } else {
                            buffer.append("#");
                        }
                        buffer.append(TypeUtils.castToString((Object)currentValue));
                        continue;
                    }
                    System.out.println("--->Not found field:" + action);
                }
                return buffer.toString();
            }
        };
        String querySQL = String.format("SELECT %1$s FROM %2$s %3$s", String.join((CharSequence)",", fieldList), collectionName, StringUtils.isEmpty((CharSequence)conditionWhere) ? "" : String.format(" WHERE %1$s", conditionWhere));
        HashMap paramsMap = new HashMap();
        return this.onGetResult(connection, querySQL, paramsMap, tagFunction, idxFunction);
    }

    public <T> void onWrite(Connection connection, DataFrame<Object> dfSource, List<String> keyList, String collectionName, Class<T> modelCls) throws Exception {
        ArrayList<String> fieldList = new ArrayList<String>();
        dfSource.columns().forEach(action -> {
            String fieldName = TypeUtils.castToString((Object)action);
            fieldList.add(fieldName);
        });
        ArrayList<String> skipSetList = new ArrayList<String>();
        this.onWrite(connection, dfSource, fieldList, skipSetList, keyList, collectionName, modelCls, 0);
    }

    public <T> void onWrite(Connection connection, DataFrame<Object> dfSource, final List<String> fieldList, List<String> skipUpdateList, final List<String> keyList, String collectionName, Class<T> modelCls, Integer batchSize) throws Exception {
        Integer batchIndex = 0;
        final HashMap fieldMap = new HashMap();
        final HashMap dfFieldMap = new HashMap();
        final HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        Iterator<Object> iterColumn = dfSource.columns().iterator();
        int i = 0;
        while (iterColumn.hasNext()) {
            String columnName = iterColumn.next().toString();
            columnMap.put(columnName.toLowerCase(), i);
            ++i;
        }
        T model = modelCls.newInstance();
        ClassMapper.onFieldMapper(model, new FieldHandler(){

            @Override
            public boolean action(Field field) throws Exception {
                field.setAccessible(true);
                String fieldName = field.getName();
                if (columnMap.containsKey(fieldName.toLowerCase())) {
                    Integer colIndex = (Integer)columnMap.get(fieldName.toLowerCase());
                    dfFieldMap.put(colIndex, field);
                }
                String fieldType = field.getType().toString();
                fieldType = fieldType.substring(fieldType.lastIndexOf(".") + 1);
                if (fieldList.contains(fieldName)) {
                    fieldMap.put(fieldName, fieldType);
                } else if (keyList.contains(fieldName)) {
                    fieldMap.put(fieldName, fieldType);
                }
                return false;
            }
        });
        ArrayList valuesList = new ArrayList();
        ArrayList setList = new ArrayList();
        ArrayList whereList = new ArrayList();
        fieldList.forEach(action -> {
            if (fieldMap.containsKey(action)) {
                String value = String.format("${%1$s,%2$s}", action, fieldMap.get(action));
                valuesList.add(value);
                if (!keyList.contains(action) && !skipUpdateList.contains(action)) {
                    setList.add(String.format("%1$s=%2$s", action, value));
                }
            } else {
                String value = String.format("${%1$s,String}", action);
                valuesList.add(value);
                if (!keyList.contains(action) && !skipUpdateList.contains(action)) {
                    setList.add(String.format("%1$s=%2$s", action, value));
                }
            }
        });
        keyList.forEach(action -> {
            if (fieldMap.containsKey(action)) {
                String value = String.format("%1$s=${%1$s,%2$s}", action, fieldMap.get(action));
                whereList.add(value);
            }
        });
        if (whereList.size() < 1) {
            throw new Exception("where\u6761\u4ef6\u751f\u751f\u5931\u8d25");
        }
        String insertSQL = String.format("INSERT INTO %1$s(%2$s) VALUES(%3$s)", collectionName, Joiner.on((String)",").join(fieldList), Joiner.on((String)",").join(valuesList));
        String updateSQL = String.format("UPDATE %1$s SET %2$s WHERE %3$s", collectionName, Joiner.on((String)",").join(setList), Joiner.on((String)" and ").join(whereList));
        logger.info("8.4\u3001\u5408\u5e76\u6570\u636e\u6279\u91cf\u5199\u5165SaleGoods_qianhb\uff1a{}", (Object)formatter.format(new Date()));
        Traceer.getInstance().addTrace("onWriteChanges");
        ArrayList<T> modelList = new ArrayList<T>();
        for (int i2 = 0; i2 < dfSource.length(); ++i2) {
            T rowModel = modelCls.newInstance();
            Iterator<Object> itColumn = dfSource.columns().iterator();
            int j = 0;
            while (itColumn.hasNext()) {
                itColumn.next();
                if (dfFieldMap.containsKey(j)) {
                    Field field = (Field)dfFieldMap.get(j);
                    Object value = dfSource.get(i2, j);
                    this.onFieldSet(rowModel, field, value);
                }
                ++j;
            }
            modelList.add(rowModel);
            if (batchSize <= 0 || modelList.size() < batchSize) continue;
            batchIndex = batchIndex + 1;
            Traceer.getInstance().addTrace("info");
            this.onUpsert(connection, updateSQL, insertSQL, modelList);
            modelList.clear();
            logger.info("8.5\u3001\u5408\u5e76\u6570\u636e\u5199\u5165SaleGoods_qianhb\uff1a{} \u8bb0\u5f55\u6570:{}", (Object)Traceer.getInstance().endTrace("info"), (Object)(batchIndex * batchSize));
        }
        if (modelList.size() > 0) {
            this.onUpsert(connection, updateSQL, insertSQL, modelList);
            logger.info("8.6\u3001\u5408\u5e76\u6570\u636e\u5199\u5165SaleGoods_qianhb\uff1a{} All\u8bb0\u5f55\u6570:{}", (Object)Traceer.getInstance().endTrace("onWriteChanges"), (Object)(batchIndex * batchSize + modelList.size()));
        }
    }
}

