/*
 * Decompiled with CFR 0.152.
 */
package com.easy.component.utils.sql;

import com.easy.constant.VARTYPE;
import com.google.common.collect.Table;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLBaseParser {
    protected static final Logger logger = LoggerFactory.getLogger((String)"sqlbaseLogger");
    protected static final DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static final Pattern patternVariable = Pattern.compile("(?<variable>\\$\\{.+?\\})");
    private static final Pattern patternVarType = Pattern.compile("\\$\\{(?<varname>.+),(?<vartype>.+)\\}");
    private static final Pattern patternVarName = Pattern.compile("\\$\\{(?<varname>.+)\\}");

    private static VARTYPE onParse(String source) {
        VARTYPE type = VARTYPE.String;
        try {
            type = VARTYPE.valueOf(source);
        }
        catch (Exception e) {
            System.out.println("-------->" + source);
            type = VARTYPE.BigDecimal.toString().equalsIgnoreCase(source) ? VARTYPE.BigDecimal : (VARTYPE.Boolean.toString().equalsIgnoreCase(source) ? VARTYPE.Boolean : (VARTYPE.Byte.toString().equalsIgnoreCase(source) ? VARTYPE.Byte : (VARTYPE.Bytes.toString().equalsIgnoreCase(source) ? VARTYPE.Bytes : (VARTYPE.Date.toString().equalsIgnoreCase(source) ? VARTYPE.Date : (VARTYPE.Double.toString().equalsIgnoreCase(source) ? VARTYPE.Double : (VARTYPE.Float.toString().equalsIgnoreCase(source) ? VARTYPE.Float : (VARTYPE.Integer.toString().equalsIgnoreCase(source) ? VARTYPE.Integer : (VARTYPE.Long.toString().equalsIgnoreCase(source) ? VARTYPE.Long : (VARTYPE.NString.toString().equalsIgnoreCase(source) ? VARTYPE.NString : (VARTYPE.Null.toString().equalsIgnoreCase(source) ? VARTYPE.Null : (VARTYPE.Object.toString().equalsIgnoreCase(source) ? VARTYPE.Object : (VARTYPE.Short.toString().equalsIgnoreCase(source) ? VARTYPE.Short : (VARTYPE.String.toString().equalsIgnoreCase(source) ? VARTYPE.String : (VARTYPE.Time.toString().equalsIgnoreCase(source) ? VARTYPE.Time : (VARTYPE.Timestamp.toString().equalsIgnoreCase(source) ? VARTYPE.Timestamp : VARTYPE.NString)))))))))))))));
        }
        return type;
    }

    public static String onParamsObject(String statement, Table<Integer, String, Object> table) throws Exception {
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        Matcher matcher = patternVariable.matcher(statement);
        while (matcher.find()) {
            String variable = matcher.group("variable");
            logger.debug("variable={}", (Object)variable);
            Matcher matcherType = patternVarType.matcher(variable);
            if (matcherType.find()) {
                String varName = matcherType.group("varname");
                String vayType = matcherType.group("vartype");
                logger.debug("name={} type={}", (Object)varName, (Object)vayType);
                VARTYPE type = SQLBaseParser.onParse(vayType);
                table.put((Object)index, (Object)"colName", (Object)varName);
                table.put((Object)index, (Object)"colType", (Object)type);
            } else {
                Matcher matcherName = patternVarName.matcher(variable);
                if (matcherName.find()) {
                    String varName = matcherName.group("varname");
                    table.put((Object)index, (Object)"colName", (Object)varName);
                    table.put((Object)index, (Object)"colType", (Object)VARTYPE.String);
                } else {
                    throw new Exception("\u975e\u6cd5\u53c2\u6570\u5b9a\u4e49:" + variable);
                }
            }
            matcher.appendReplacement(buffer, "?");
            ++index;
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

