/*
 * Decompiled with CFR 0.152.
 */
package com.easy.component.utils.sql.convert;

import com.easy.component.utils.sql.convert.BigDecimalConvert;
import com.easy.component.utils.sql.convert.BooleanConvert;
import com.easy.component.utils.sql.convert.ByteConvert;
import com.easy.component.utils.sql.convert.BytesConvert;
import com.easy.component.utils.sql.convert.DateConvert;
import com.easy.component.utils.sql.convert.DoubleConvert;
import com.easy.component.utils.sql.convert.FloatConvert;
import com.easy.component.utils.sql.convert.IntegerConvert;
import com.easy.component.utils.sql.convert.LongConvert;
import com.easy.component.utils.sql.convert.NStringConvert;
import com.easy.component.utils.sql.convert.ObjectConvert;
import com.easy.component.utils.sql.convert.ShortConvert;
import com.easy.component.utils.sql.convert.StringConvert;
import com.easy.component.utils.sql.convert.TimeConvert;
import com.easy.component.utils.sql.convert.TimestampConvert;
import com.easy.constant.VARTYPE;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class DatabaseTypeConvert {
    private PreparedStatement pStmt;
    private int sqlType;

    protected abstract void onSetValue(PreparedStatement var1, int var2, Object var3) throws SQLException;

    public static DatabaseTypeConvert Create(VARTYPE colType, PreparedStatement pStat) {
        DatabaseTypeConvert response = null;
        switch (colType) {
            case BigDecimal: {
                response = new BigDecimalConvert(pStat);
                break;
            }
            case Boolean: {
                response = new BooleanConvert(pStat);
                break;
            }
            case Byte: {
                response = new ByteConvert(pStat);
                break;
            }
            case Bytes: {
                response = new BytesConvert(pStat);
                break;
            }
            case Date: {
                response = new DateConvert(pStat);
                break;
            }
            case Double: {
                response = new DoubleConvert(pStat);
                break;
            }
            case Float: {
                response = new FloatConvert(pStat);
                break;
            }
            case Integer: {
                response = new IntegerConvert(pStat);
                break;
            }
            case Long: {
                response = new LongConvert(pStat);
                break;
            }
            case NString: {
                response = new NStringConvert(pStat);
                break;
            }
            case Object: {
                response = new ObjectConvert(pStat);
                break;
            }
            case Short: {
                response = new ShortConvert(pStat);
                break;
            }
            case String: {
                response = new StringConvert(pStat);
                break;
            }
            case Time: {
                response = new TimeConvert(pStat);
                break;
            }
            case Timestamp: {
                response = new TimestampConvert(pStat);
                break;
            }
            default: {
                response = new StringConvert(pStat);
            }
        }
        return response;
    }

    public DatabaseTypeConvert(PreparedStatement pStmt) {
        this.pStmt = pStmt;
    }

    protected int getSqlType() {
        return this.sqlType;
    }

    protected void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }

    protected void onSetNull(int parameterIndex) throws SQLException {
        this.pStmt.setNull(parameterIndex, this.getSqlType());
    }

    public void onSetValue(int parameterIndex, Object value) throws SQLException {
        if (value == null) {
            this.onSetNull(parameterIndex);
        } else {
            this.onSetValue(this.pStmt, parameterIndex, value);
        }
    }
}

