/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.component;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.efuture.common.enums.OssPathEnum;
import com.efuture.common.utils.ExceptionUtils;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@ConditionalOnProperty(name={"aliyun.oss.enable"}, havingValue="true")
public class AliyunOSS {
    private static final Logger log = LoggerFactory.getLogger(AliyunOSS.class);
    @Resource
    private HttpServletResponse response;
    private String endpoint;
    private String accesskey;
    private String secretkey;
    private String bucketname;
    private OSS ossClient;
    private static final int DEFAULT_EXPIRETIME_SECONDS = 3600;

    public AliyunOSS(@Value(value="${aliyun.oss.endpoint:}") String endpoint, @Value(value="${aliyun.oss.accesskey:}") String accesskey, @Value(value="${aliyun.oss.secretkey:}") String secretkey, @Value(value="${aliyun.oss.bucketname:}") String bucketname) {
        this.endpoint = endpoint;
        this.accesskey = accesskey;
        this.secretkey = secretkey;
        this.bucketname = bucketname;
        this.ossClient = new OSSClientBuilder().build(endpoint, accesskey, secretkey);
    }

    public String uploadFile(MultipartFile file, OssPathEnum pathEnum) {
        String fileid = "";
        try {
            fileid = UUID.randomUUID().toString().replaceAll("-", "");
            InputStream inputStream = file.getInputStream();
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)inputStream.available());
            objectMetadata.setCacheControl("no-cache");
            objectMetadata.setHeader("Pragma", (Object)"no-cache");
            objectMetadata.setContentType(file.getContentType());
            objectMetadata.setContentDisposition("inline;filename=" + fileid);
            String fileName = pathEnum.getPath() + "/" + fileid;
            this.ossClient.putObject(this.bucketname, fileName, inputStream, objectMetadata);
        }
        catch (IOException e) {
            e.printStackTrace();
            ExceptionUtils.raise("OSS\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01\u539f\u56e0\uff1a{0}", e.toString());
        }
        return fileid;
    }

    public void exportFile(String fileid, OssPathEnum pathEnum) {
        String filename = pathEnum.getPath() + "/" + fileid;
        try {
            OSSObject ossObject = this.ossClient.getObject(this.bucketname, filename);
            BufferedInputStream inputStream = new BufferedInputStream(ossObject.getObjectContent());
            ServletOutputStream outputStream = this.response.getOutputStream();
            this.response.setCharacterEncoding("UTF-8");
            this.response.setContentType("application/octet-stream;charset=UTF-8");
            this.response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(Objects.requireNonNull(ossObject.getKey()), "utf-8"));
            this.response.addHeader("Pragma", "no-cache");
            this.response.addHeader("Cache-Control", "no-cache");
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            ExceptionUtils.raise("OSS\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01\u539f\u56e0\uff1a{0}", e.toString());
        }
    }

    public void exportFile(String fileid) {
        try {
            OSSObject ossObject = this.ossClient.getObject(this.bucketname, fileid);
            BufferedInputStream inputStream = new BufferedInputStream(ossObject.getObjectContent());
            ServletOutputStream outputStream = this.response.getOutputStream();
            this.response.setCharacterEncoding("UTF-8");
            this.response.setContentType("application/octet-stream;charset=UTF-8");
            this.response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(Objects.requireNonNull(ossObject.getKey()), "utf-8"));
            this.response.addHeader("Pragma", "no-cache");
            this.response.addHeader("Cache-Control", "no-cache");
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            ExceptionUtils.raise("OSS\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01\u539f\u56e0\uff1a{0}", e.toString());
        }
    }

    public InputStream getFileInputStream(String fileid, OssPathEnum pathEnum) {
        String filename = pathEnum.getPath() + "/" + fileid;
        OSSObject ossObject = this.ossClient.getObject(this.bucketname, filename);
        return new BufferedInputStream(ossObject.getObjectContent());
    }

    public InputStream getFileInputStream(String fileid) {
        OSSObject ossObject = this.ossClient.getObject(this.bucketname, fileid);
        return new BufferedInputStream(ossObject.getObjectContent());
    }

    public String getFileUrl(String fileid, OssPathEnum pathEnum) {
        return this.getFileUrl(fileid, pathEnum, 3600);
    }

    public String getFileUrl(String fileid, OssPathEnum pathEnum, int expSeconds) {
        String urlStr = null;
        Date expiration = new Date(System.currentTimeMillis() + (long)expSeconds * 1000L);
        String filename = pathEnum.getPath() + "/" + fileid;
        URL url = this.ossClient.generatePresignedUrl(this.bucketname, filename, expiration);
        if (url != null) {
            urlStr = url.toString();
        }
        return urlStr;
    }

    public static MultipartFile convert(File file, String contentType) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            MockMultipartFile mockMultipartFile = new MockMultipartFile(file.getName(), file.getName(), contentType, (InputStream)inputStream);
            return mockMultipartFile;
        }
    }

    public static MultipartFile convert(File file) throws IOException {
        String contentType = AliyunOSS.detectContentType(file.getName());
        return AliyunOSS.convert(file, contentType);
    }

    private static String detectContentType(String fileName) {
        if (fileName == null) {
            return "application/octet-stream";
        }
        String lowerCaseName = fileName.toLowerCase();
        if (lowerCaseName.endsWith(".jpg") || lowerCaseName.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (lowerCaseName.endsWith(".png")) {
            return "image/png";
        }
        if (lowerCaseName.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (lowerCaseName.endsWith(".txt")) {
            return "text/plain";
        }
        if (lowerCaseName.endsWith(".json")) {
            return "application/json";
        }
        return "application/octet-stream";
    }
}

