/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.transaction;

import com.efuture.common.transaction.event.SendAfterCommitEvent;
import com.efuture.common.transaction.event.SendBeforeCommitEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class TransactionAfter {
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public void sendBeforeCommit(IProcesser processer) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            this.eventPublisher.publishEvent((ApplicationEvent)new SendBeforeCommitEvent(processer::handle));
        } else {
            processer.handle();
        }
    }

    public void sendAfterCommit(IProcesser processer) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            this.eventPublisher.publishEvent((ApplicationEvent)new SendAfterCommitEvent(processer::handle));
        } else {
            processer.handle();
        }
    }

    @FunctionalInterface
    public static interface IProcesser {
        public void handle();
    }
}

