/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.aop;

import com.alibaba.fastjson.JSONObject;
import com.efuture.common.annotation.IsceLog;
import com.efuture.common.component.impl.IsceLogMongoRecoderServiceImpl;
import com.efuture.common.model.LogModel;
import com.efuture.common.utils.ExceptionUtils;
import com.product.model.ServiceSession;
import com.product.util.SpringBeanFactory;
import com.product.util.SpringContext;
import com.shiji.core.util.ReflectUtils;
import com.shiji.core.util.SnowFlakeID;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
public class IsceLogAspect {
    private static final Logger log = LoggerFactory.getLogger(IsceLogAspect.class);
    private static ExecutorService logExecutorService = Executors.newFixedThreadPool(10);
    @Autowired
    private IsceLogMongoRecoderServiceImpl logMongoRecoderService;
    private SnowFlakeID snowFlake = new SnowFlakeID(2L, 3L);

    @Pointcut(value="@annotation(com.efuture.common.annotation.IsceLog)")
    private void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object getSessionInitAspect(final ProceedingJoinPoint joinPoint) throws Throwable {
        final Date reqestDate = new Date();
        long beginTime = System.currentTimeMillis();
        Object result = joinPoint.proceed();
        final long costTime = System.currentTimeMillis() - beginTime;
        final ServiceSession session = SpringContext.getSession();
        final HttpServletRequest httpServletRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        logExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    IsceLogAspect.this.saveLog(session, joinPoint, reqestDate, costTime, httpServletRequest);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38\uff01" + String.valueOf(joinPoint));
                }
            }
        });
        return result;
    }

    private void saveLog(ServiceSession session, ProceedingJoinPoint joinPoint, Date reqestDate, long costTime, HttpServletRequest httpServletRequest) throws InvocationTargetException, IllegalAccessException {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        IsceLog isceLog = method.getAnnotation(IsceLog.class);
        if (isceLog.required()) {
            LogModel logModel = new LogModel();
            Map<String, Object> paramMap = this.getNameAndValue(joinPoint);
            String operType = isceLog.operType();
            String tableName = isceLog.tableName();
            if (StringUtils.isEmpty((Object)tableName) || "tableName".equals(tableName)) {
                tableName = this.getCollectionName(httpServletRequest);
            }
            logModel.setId(this.snowFlake.nextId());
            logModel.setOperType(operType);
            logModel.setReqestDate(reqestDate);
            logModel.setCostTime(costTime);
            logModel.setOperatDate(new Date());
            logModel.setModuleCode(session.getModuleCode());
            logModel.setTableName(tableName);
            logModel.setContent(JSONObject.toJSONString(paramMap));
            logModel.setClassStr(String.valueOf(method.getDeclaringClass()) + "." + method.getName());
            logModel.setOperator(session.getUser_name());
            logModel.setOperatorCode(session.getUser_code());
            this.logMongoRecoderService.onRecoder(logModel);
        }
    }

    private Map<String, Object> getNameAndValue(ProceedingJoinPoint joinPoint) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Object[] paramValues = joinPoint.getArgs();
        String[] paramNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
        for (int i = 0; i < paramNames.length; ++i) {
            param.put(paramNames[i], paramValues[i]);
        }
        return param;
    }

    private String getCollectionName(HttpServletRequest httpServletRequest) throws InvocationTargetException, IllegalAccessException {
        int index;
        Map requetParamMap = httpServletRequest.getParameterMap();
        String method = httpServletRequest.getParameter("method");
        if (StringUtils.isEmpty((Object)method)) {
            ExceptionUtils.raise("\u8bf7\u6c42\u65b9\u6cd5\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        if ((index = method.lastIndexOf(".")) > 0) {
            String beanName = null;
            String methodName = null;
            beanName = method.substring(0, index);
            methodName = method.substring(index + 1);
            Object component = SpringBeanFactory.getBean((String)beanName);
            Class componentClazz = ReflectUtils.getClass((Object)component);
            Method getcollectionNameMethod = ReflectionUtils.findMethod((Class)componentClazz, (String)"getcollectionName");
            if (getcollectionNameMethod != null) {
                getcollectionNameMethod.setAccessible(true);
                Object collectionName = getcollectionNameMethod.invoke(component, new Object[0]);
                String collectionNameStr = (String)collectionName;
                return collectionNameStr;
            }
        }
        return "";
    }
}

