/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.aop;

import com.alibaba.fastjson.JSON;
import com.efuture.common.model.AccountPartner;
import com.efuture.common.model.VenderSession;
import com.efuture.common.utils.ExceptionUtils;
import com.efuture.common.utils.PartnerUtils;
import jakarta.annotation.Resource;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class VenderLoginInterceptor {
    private static final Logger log = LoggerFactory.getLogger(VenderLoginInterceptor.class);
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate stringRedisTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(com.efuture.common.annotation.VenderLoginCheck)")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        String userCode = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest().getHeader("LoginTel");
        log.info("---------\u4f9b\u5e94\u5546\u8d26\u53f7[LoginTel]({})", (Object)userCode);
        if (StringUtils.isBlank((String)userCode)) {
            log.info("\u8d26\u53f7\u672a\u767b\u9646");
            ExceptionUtils.raise("\u8d26\u53f7\u672a\u767b\u9646\uff01");
        }
        AccountPartner accountPartner = this.getVenderFromDB(userCode, 1);
        VenderSession.set(accountPartner);
        Object obj = null;
        try {
            obj = joinPoint.proceed();
        }
        finally {
            VenderSession.remove();
        }
        return obj;
    }

    private AccountPartner getVenderFromDB(String userCode, Integer type) {
        AccountPartner accountPartner = null;
        if (type == 0) {
            String key = "isce-tms-vender:user_token:" + userCode;
            String venderStr = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
            log.info("-----\u7f13\u5b58{}\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u662f\u5426\u4e3a\u7a7a\uff1a{}", (Object)key, (Object)StringUtils.isBlank((String)venderStr));
            if (StringUtils.isBlank((String)venderStr)) {
                ExceptionUtils.raise("\u4f9b\u5e94\u5546\u672a\u767b\u9646\uff01");
            }
            accountPartner = (AccountPartner)JSON.parseObject((String)venderStr, AccountPartner.class);
        } else if (type == 1) {
            accountPartner = PartnerUtils.getAccountPartnerByUserCode(userCode, 3);
            log.info(">>>\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u4fe1\u606f\uff1a{}", JSON.toJSON((Object)accountPartner));
            if (Objects.isNull(accountPartner)) {
                ExceptionUtils.raise("\u65e0\u4f9b\u5e94\u5546\u8bb0\u5f55\uff01");
            }
        }
        return accountPartner;
    }
}

