/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JacksonConversionUtil {
    public static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();

    private JacksonConversionUtil() {
    }

    public static Map<String, Object> objectToMap(Object object, ObjectMapper mapper, boolean includeNulls) {
        if (object == null) {
            return null;
        }
        ObjectMapper effectiveMapper = Objects.isNull(mapper) ? DEFAULT_MAPPER : mapper;
        try {
            Map result = (Map)effectiveMapper.convertValue(object, Map.class);
            if (!includeNulls) {
                result.entrySet().removeIf(entry -> entry.getValue() == null);
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("\u5bf9\u8c61\u8f6cMap\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static Map<String, Object> objectStrToMap(String str) {
        return JacksonConversionUtil.objectToMap(str, null, false);
    }

    public static Map<String, Object> objectToMap(Object object) {
        return JacksonConversionUtil.objectToMap(object, null, false);
    }

    public static Map<String, Object> objectToMap(Object object, boolean includeNulls) {
        return JacksonConversionUtil.objectToMap(object, null, includeNulls);
    }

    public static <T> T mapToObject(Map<String, ?> map, Class<T> clazz, ObjectMapper mapper) {
        if (map == null) {
            return null;
        }
        ObjectMapper effectiveMapper = Objects.isNull(mapper) ? DEFAULT_MAPPER : mapper;
        try {
            return (T)effectiveMapper.convertValue(map, clazz);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Map\u8f6c\u5bf9\u8c61\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static <T> T mapToObject(Map<String, ?> map, Class<T> clazz) {
        return JacksonConversionUtil.mapToObject(map, clazz, null);
    }

    public static Map<String, String> jsonToMap(String jsonString, ObjectMapper mapper, boolean includeNulls) {
        if (jsonString == null || jsonString.trim().isEmpty()) {
            return null;
        }
        ObjectMapper effectiveMapper = Objects.isNull(mapper) ? DEFAULT_MAPPER : mapper;
        try {
            Map result = (Map)effectiveMapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, String>>(){});
            if (!includeNulls) {
                result.entrySet().removeIf(entry -> entry.getValue() == null);
            }
            return result;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("JSON\u8f6cMap\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static Map<String, String> jsonToMap(String jsonString) {
        return JacksonConversionUtil.jsonToMap(jsonString, null, false);
    }

    public static Map<String, String> jsonToMap(String jsonString, boolean includeNulls) {
        return JacksonConversionUtil.jsonToMap(jsonString, null, includeNulls);
    }

    public static String mapToJson(Map<String, ?> map, ObjectMapper mapper) {
        if (map == null) {
            return null;
        }
        ObjectMapper effectiveMapper = Objects.isNull(mapper) ? DEFAULT_MAPPER : mapper;
        try {
            return effectiveMapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Map\u8f6cJSON\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static String mapToJson(Map<String, ?> map) {
        return JacksonConversionUtil.mapToJson(map, null);
    }

    public static String objectToJson(Object object) {
        return JacksonConversionUtil.mapToJson(JacksonConversionUtil.objectToMap(object, null, false));
    }

    public static Map<String, String> convertToStringMap(Map<String, Object> objectMap) {
        if (objectMap == null) {
            return new HashMap<String, String>();
        }
        return objectMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
    }

    public static Map<String, Object> jsonToObjectMap(String jsonString, ObjectMapper mapper, boolean includeNulls) {
        if (jsonString == null || jsonString.trim().isEmpty()) {
            return null;
        }
        ObjectMapper effectiveMapper = Objects.isNull(mapper) ? DEFAULT_MAPPER : mapper;
        try {
            Map result = (Map)effectiveMapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
            if (!includeNulls) {
                result.entrySet().removeIf(entry -> entry.getValue() == null);
            }
            return result;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("JSON\u8f6cMap<String, Object>\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static Map<String, Object> jsonToObjectMap(String jsonString) {
        return JacksonConversionUtil.jsonToObjectMap(jsonString, null, false);
    }

    public static Map<String, Object> jsonToObjectMap(String jsonString, boolean includeNulls) {
        return JacksonConversionUtil.jsonToObjectMap(jsonString, null, includeNulls);
    }

    static {
        DEFAULT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

