/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.lang3.StringUtils;

public class PinyinUtil {
    public static String chinese2Pinyin(String chinese) {
        return PinyinUtil.chinese2Pinyin(chinese, false);
    }

    public static String chinese2Pinyin(String chinese, boolean isfull) {
        char[] charArray;
        if (StringUtils.isBlank((CharSequence)chinese)) {
            return null;
        }
        StringBuilder pinyin = new StringBuilder();
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (char c : charArray = chinese.trim().toCharArray()) {
            if (Character.toString(c).matches("[\\u4E00-\\u9FA5]+")) {
                String[] pys = new String[]{};
                try {
                    pys = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)format);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    throw new RuntimeException("\u62fc\u97f3\u8f6c\u6362\u5931\u8d25");
                }
                pinyin.append(pys[0].charAt(0));
                continue;
            }
            pinyin.append(c);
        }
        return pinyin.toString();
    }

    public static void main(String[] args) {
        String str = "\u9ed1\u4eba\u8336\u500d\u5065\u8584\u8377140g+50g\u7259\u818f/\u76d2";
        System.out.println(PinyinUtil.chinese2Pinyin(str));
    }
}

