/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import java.nio.charset.StandardCharsets;

public class SM3SaltUtil {
    private static final int[] IV = new int[]{1937774191, 1226093241, 388252375, -628488704, -1452330820, 372324522, -477237683, -1325724082};
    private static final int T0 = 2043430169;
    private static final int T1 = 2055708042;

    private static int FF(int x, int y, int z, int j) {
        return j < 16 ? x ^ y ^ z : x & y | x & z | y & z;
    }

    private static int GG(int x, int y, int z, int j) {
        return j < 16 ? x ^ y ^ z : x & y | ~x & z;
    }

    private static int P0(int x) {
        return x ^ Integer.rotateLeft(x, 9) ^ Integer.rotateLeft(x, 17);
    }

    private static int P1(int x) {
        return x ^ Integer.rotateLeft(x, 15) ^ Integer.rotateLeft(x, 23);
    }

    private static byte[] pad(byte[] input) {
        int len = input.length;
        int k = (448 - (len * 8 + 1) % 512 + 512) % 512;
        byte[] padded = new byte[len + (k + 1 + 64) / 8];
        System.arraycopy(input, 0, padded, 0, len);
        padded[len] = -128;
        long bitLen = (long)len * 8L;
        for (int i = 0; i < 8; ++i) {
            padded[padded.length - 8 + i] = (byte)(bitLen >>> 56 - i * 8);
        }
        return padded;
    }

    private static void compress(int[] V, byte[] block) {
        int i;
        int[] W = new int[68];
        int[] W1 = new int[64];
        for (i = 0; i < 16; ++i) {
            W[i] = (block[i * 4] & 0xFF) << 24 | (block[i * 4 + 1] & 0xFF) << 16 | (block[i * 4 + 2] & 0xFF) << 8 | block[i * 4 + 3] & 0xFF;
        }
        for (i = 16; i < 68; ++i) {
            W[i] = SM3SaltUtil.P1(W[i - 16] ^ W[i - 9] ^ Integer.rotateLeft(W[i - 3], 15)) ^ Integer.rotateLeft(W[i - 13], 7) ^ W[i - 6];
        }
        for (i = 0; i < 64; ++i) {
            W1[i] = W[i] ^ W[i + 4];
        }
        int A = V[0];
        int B = V[1];
        int C = V[2];
        int D = V[3];
        int E = V[4];
        int F = V[5];
        int G = V[6];
        int H = V[7];
        for (int j = 0; j < 64; ++j) {
            int T = j < 16 ? 2043430169 : 2055708042;
            int SS1 = Integer.rotateLeft(Integer.rotateLeft(A, 12) + E + Integer.rotateLeft(T, j), 7);
            int SS2 = SS1 ^ Integer.rotateLeft(A, 12);
            int TT1 = SM3SaltUtil.FF(A, B, C, j) + D + SS2 + W1[j];
            int TT2 = SM3SaltUtil.GG(E, F, G, j) + H + SS1 + W[j];
            D = C;
            C = Integer.rotateLeft(B, 9);
            B = A;
            A = TT1;
            H = G;
            G = Integer.rotateLeft(F, 19);
            F = E;
            E = SM3SaltUtil.P0(TT2);
        }
        V[0] = V[0] ^ A;
        V[1] = V[1] ^ B;
        V[2] = V[2] ^ C;
        V[3] = V[3] ^ D;
        V[4] = V[4] ^ E;
        V[5] = V[5] ^ F;
        V[6] = V[6] ^ G;
        V[7] = V[7] ^ H;
    }

    public static byte[] hash(byte[] input) {
        byte[] padded = SM3SaltUtil.pad(input);
        int[] V = (int[])IV.clone();
        for (int i = 0; i < padded.length; i += 64) {
            byte[] block = new byte[64];
            System.arraycopy(padded, i, block, 0, 64);
            SM3SaltUtil.compress(V, block);
        }
        byte[] output = new byte[32];
        for (int i = 0; i < 8; ++i) {
            output[i * 4] = (byte)(V[i] >>> 24);
            output[i * 4 + 1] = (byte)(V[i] >>> 16);
            output[i * 4 + 2] = (byte)(V[i] >>> 8);
            output[i * 4 + 3] = (byte)V[i];
        }
        return output;
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    public static String main(String pas) {
        String plaintext = pas;
        byte[] hashBytes = SM3SaltUtil.hash(plaintext.getBytes(StandardCharsets.UTF_8));
        return SM3SaltUtil.toHexString(hashBytes);
    }
}

