/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.aop;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.product.component.BaseCompomentServiceImpl;
import com.product.model.ServiceSession;
import com.shiji.core.component.BaseComponent;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.GenericTypeResolver;

public class UpdateInterceptor {
    private static final Logger log = LoggerFactory.getLogger(UpdateInterceptor.class);

    @Around(value="execution(public * com.product.component.*CompomentServiceImpl.onUpdate(..)) || execution(public * com.product.component.*CompomentServiceImpl.onSave(..))")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Object obj;
        log.info("--------->enter into onUpdate .....");
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method targetMethod = methodSignature.getMethod();
        Object[] args = joinPoint.getArgs();
        if (args.length == 2 && args[0] instanceof ServiceSession && args[1] instanceof JSONObject && (obj = joinPoint.getTarget()) instanceof BaseCompomentServiceImpl) {
            BaseCompomentServiceImpl service = (BaseCompomentServiceImpl)obj;
            Class beanClass = GenericTypeResolver.resolveTypeArgument(obj.getClass(), BaseComponent.class);
            Object[] pds = BeanUtils.getPropertyDescriptors((Class)beanClass);
            ArrayList propertys = Lists.newArrayList((Object[])pds);
            Set<String> proNames = propertys.stream().filter(p -> Number.class.isAssignableFrom(p.getPropertyType())).map(FeatureDescriptor::getName).collect(Collectors.toSet());
            JSONObject paramsObject = (JSONObject)args[1];
            String collectionName = service.getCollectionName();
            if (paramsObject.containsKey((Object)collectionName)) {
                JSONArray response = new JSONArray();
                Object dataObject = paramsObject.get((Object)collectionName);
                if (dataObject != null && dataObject instanceof List) {
                    JSONArray paramsArray = paramsObject.getJSONArray(collectionName);
                    for (int i = 0; i < paramsArray.size(); ++i) {
                        JSONObject params = paramsArray.getJSONObject(i);
                        this.setNumberNull(params, proNames);
                    }
                }
            } else {
                this.setNumberNull(paramsObject, proNames);
            }
        }
        return joinPoint.proceed();
    }

    void setNumberNull(JSONObject params, Set<String> proNames) {
        Set keySet = params.keySet();
        proNames.forEach(p -> {
            if (!keySet.contains(p)) {
                params.put(p, null);
            }
        });
    }
}

