/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.dubbo.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.product.datasource.DynamicDataSourceContextHolder;
import com.product.exception.ServiceRuntimeException;
import com.product.model.ServiceSession;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.SpringContext;
import com.product.util.StaticVariable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcServiceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider", "consumer"})
public class DubboSessionFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DubboSessionFilter.class);
    private static LoadingCache<String, String> shopDataSourceCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).initialCapacity(20).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String shopid) throws Exception {
            String groupCode = null;
            FMybatisTemplate template = (FMybatisTemplate)SpringContext.getBean(FMybatisTemplate.class, (Object[])new Object[0]);
            Map map = (Map)template.getSqlSessionTemplate().selectOne("mybatis.sql.select", (Object)("select * from omdmain.shop where entId = '1' and shopCode = '" + shopid + "'"));
            log.info("\u83b7\u53d6\u4ed3\u5e93\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)map));
            if (null == map) {
                throw new ServiceRuntimeException("\u83b7\u53d6\u4ed3\u5e93\u7ed3\u679c\u4e3a\u7a7a");
            }
            groupCode = (String)map.get("groupCode");
            log.info("\u5b58\u5165\u7f13\u5b58\u4ed3\u5e93\u6570\u636e\uff1a{}", (Object)groupCode);
            return groupCode;
        }
    });
    private SerializerFeature[] serializerFeatures = new SerializerFeature[0];

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        RpcServiceContext context = RpcContext.getServiceContext();
        if (context.isConsumerSide()) {
            log.info("dubbo\u6d88\u8d39\u8005\u8bf7\u6c42\u539f\u59cb\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)context.getObjectAttachments()));
            ServiceSession session = SpringContext.getSession();
            log.info("---->>>>>dubbo consumerSide session shop_group :{}", (Object)(session == null ? "null" : session.getShop_group()));
            if (session != null) {
                String dbKeyCode = session.getShop_group();
                if (StringUtils.isEmpty((CharSequence)dbKeyCode)) {
                    session.setShop_group(DynamicDataSourceContextHolder.getRouterKey());
                }
            } else {
                log.info("session is null ~~~~~~~~~~~~!");
                session = new ServiceSession();
            }
            String groupCode = "";
            if (context.getObjectAttachment("shopid") != null) {
                String shopid = (String)context.getObjectAttachment("shopid");
                try {
                    groupCode = (String)shopDataSourceCache.get((Object)shopid);
                    log.info("------>>>>>>>>>\u4ed3\u5e93\u4fe1\u606f\u4ece\u7f13\u5b58LoadingCache\u4e2d\u83b7\u53d6shop_group:{}", (Object)groupCode);
                    log.info("---------dubbo\u8c03\u7528 \u8bbe\u7f6e\u8bbf\u95ee\u6570\u636e\u5e93:{}", (Object)groupCode);
                    session.setShop_group(groupCode);
                }
                catch (ExecutionException e) {
                    log.error("\u83b7\u53d6\u6570\u636e\u5e93\u7f16\u7801\u5f02\u5e38\uff01");
                    throw new RuntimeException(e);
                }
            }
            if (context.getObjectAttachment("entid") != null) {
                String entid = (String)context.getObjectAttachment("entid");
                session.setEnt_id(Long.parseLong(entid));
            }
            SpringContext.putSession((ServiceSession)session);
            context.setObjectAttachment("entid", (Object)String.valueOf(session.getEnt_id()));
            context.setObjectAttachment("shopgroup", (Object)groupCode);
            log.info("dubbo\u6d88\u8d39\u8005\u8bf7\u6c42\u6700\u7ec8\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)context.getObjectAttachments()));
        } else {
            log.info("dubbo\u63d0\u4f9b\u8005\u63a5\u6536\u539f\u59cb\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)context.getObjectAttachments()));
            String entid = (String)context.getObjectAttachment("entid");
            String shopgroup = (String)context.getObjectAttachment("shopid");
            ServiceSession session = Optional.ofNullable(SpringContext.getSession()).orElseGet(() -> {
                ServiceSession serviceSession = new ServiceSession();
                serviceSession.setEnt_id(Long.parseLong("1"));
                return serviceSession;
            });
            List tempDSkeys = DynamicDataSourceContextHolder.dataSourceKeys;
            log.info("---->>>>>dubbo provicerSide dataSourceKeys\uff1a{}", (Object)tempDSkeys);
            if (StringUtils.isNotBlank((CharSequence)shopgroup)) {
                if (DynamicDataSourceContextHolder.containDataSourceKey((String)shopgroup)) {
                    DynamicDataSourceContextHolder.setRouterKey((String)shopgroup);
                    StaticVariable.put((String)"dbKeyCode", (Object)shopgroup);
                    session.setShop_group(shopgroup);
                } else {
                    DynamicDataSourceContextHolder.setRouterKey((String)"defaultDs");
                }
                log.info("-----> \u5f53\u524d\u9009\u62e9\u6570\u636e\u5e93:{}", (Object)shopgroup);
            } else {
                DynamicDataSourceContextHolder.setRouterKey((String)"A00L");
            }
            if (StringUtils.isNotBlank((CharSequence)entid)) {
                session.setEnt_id(Long.parseLong(entid));
            }
            SpringContext.putSession((ServiceSession)session);
        }
        return invoker.invoke(invocation);
    }
}

