/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.efuture.common.component.ILockService;
import com.efuture.common.utils.ExceptionUtils;
import com.product.util.SpringContext;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockUtils {
    private static final Logger log = LoggerFactory.getLogger(LockUtils.class);
    private static ExecutorService logExecutorService = Executors.newFixedThreadPool(10);
    private static long WAITTIME = 30L;
    private static long LEASETIME = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(String lockKey, ILockService<T> service) throws Exception {
        RedissonClient redissonClient = (RedissonClient)SpringContext.getContext().getBean(RedissonClient.class);
        if (redissonClient == null) {
            ExceptionUtils.raise("RedissonClient \u672a\u88ab\u5b9e\u4f8b\u5316\uff0c\u65e0\u6cd5\u4f7f\u7528\uff01");
        }
        RLock rLock = redissonClient.getLock(lockKey);
        T t = null;
        if (rLock.tryLock(WAITTIME, LEASETIME, TimeUnit.SECONDS)) {
            log.debug("Fetch distribut lock success,key={}", (Object)lockKey);
            try {
                t = service.execute();
            }
            finally {
                log.debug("Release distribut lock success,key={}", (Object)lockKey);
                RLock lock = redissonClient.getLock(lockKey);
                if (lock.isLocked() && lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
            return t;
        }
        throw new RuntimeException("Try lock failure.");
    }
}

