/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.common.model.AccountPartner;
import com.efuture.common.utils.ExceptionUtils;
import com.product.model.ServiceSession;
import com.product.util.RestUtils;
import com.product.util.SpringContext;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class PartnerUtils {
    private static final Logger log = LoggerFactory.getLogger(PartnerUtils.class);
    private static String vipToken;
    @Autowired
    private Environment env;

    @PostConstruct
    public void config() {
        vipToken = this.env.resolvePlaceholders("${tmscust.authorize.viptoken}");
    }

    public static AccountPartner getAccountPartnerByMobile(String username, int userType) {
        AccountPartner accountPartner = null;
        JSONObject param = new JSONObject();
        param.put("mobileNo", (Object)username);
        param.put("partnerType", (Object)userType);
        String accountUrl = "http://amp-user/rest?method=usercenter.accountPartner.query&token=" + vipToken;
        try {
            log.info("------\u83b7\u53d6\u7b2c\u4e09\u65b9\u767b\u9646\u8d26\u6237\u4fe1\u606f\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)param.toJSONString());
            String res = RestUtils.doPost((String)accountUrl, (String)param.toString());
            log.info("\u83b7\u53d6\u4ed3\u5e93\u7ed3\u679c\uff1a{}", (Object)res);
            if (!StringUtils.isEmpty((CharSequence)res)) {
                JSONObject obj = JSON.parseObject((String)res);
                JSONArray jsonArray = obj.getJSONObject("data").getJSONArray("accountpartner");
                if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                    return accountPartner;
                }
                if (jsonArray.size() > 1) {
                    ExceptionUtils.raise("\u67e5\u8be2\u51fa\u591a\u6761\u8d26\u6237\u4fe1\u606f\uff01");
                }
                accountPartner = (AccountPartner)JSONObject.parseObject((String)jsonArray.get(0).toString(), AccountPartner.class);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return accountPartner;
    }

    public static AccountPartner getAccountPartnerByUserCode(String username, int userType) {
        AccountPartner accountPartner = null;
        JSONObject param = new JSONObject();
        param.put("userCode", (Object)username);
        param.put("partnerType", (Object)userType);
        String accountUrl = "http://amp-user/rest?method=usercenter.accountPartner.query&token=" + vipToken;
        try {
            log.info("------\u83b7\u53d6\u7b2c\u4e09\u65b9\u767b\u9646\u8d26\u6237\u4fe1\u606f\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)param.toJSONString());
            String res = RestUtils.doPost((String)accountUrl, (String)param.toString());
            log.info("\u83b7\u53d6\u4ed3\u5e93\u7ed3\u679c\uff1a{}", (Object)res);
            if (!StringUtils.isEmpty((CharSequence)res)) {
                JSONObject obj = JSON.parseObject((String)res);
                JSONArray jsonArray = obj.getJSONObject("data").getJSONArray("accountpartner");
                if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                    log.info("\u67e5\u8be2\u8d26\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01{}", (Object)param.toJSONString());
                } else if (jsonArray.size() > 1) {
                    ExceptionUtils.raise("\u67e5\u8be2\u51fa\u591a\u6761\u8d26\u6237\u4fe1\u606f\uff01");
                } else {
                    accountPartner = (AccountPartner)JSONObject.parseObject((String)jsonArray.get(0).toString(), AccountPartner.class);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return accountPartner;
    }

    public static List<AccountPartner> getAccountPartnerList() {
        List<AccountPartner> accountPartnerList = new ArrayList<AccountPartner>();
        JSONObject param = new JSONObject();
        param.put("page_no", (Object)1);
        param.put("page_size", (Object)10000);
        ServiceSession token = SpringContext.getSession();
        String accountUrl = "http://amp-user/rest?method=usercenter.accountPartner.query";
        try {
            log.info("------\u83b7\u53d6\u6240\u6709\u8d26\u6237\u4fe1\u606f\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)param.toJSONString());
            String res = RestUtils.doPost((String)accountUrl, (String)param.toString());
            log.info("\u83b7\u53d6\u6240\u6709\u8d26\u6237\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)res);
            if (!StringUtils.isEmpty((CharSequence)res)) {
                JSONObject obj = JSON.parseObject((String)res);
                JSONArray jsonArray = obj.getJSONObject("data").getJSONArray("accountpartner");
                if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                    log.info("\u67e5\u8be2\u6240\u6709\u8d26\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01{}", (Object)param.toJSONString());
                } else {
                    accountPartnerList = JSONObject.parseArray((String)jsonArray.toString(), AccountPartner.class);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return accountPartnerList;
    }
}

