/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.efuture.common.model.TmsConfig;
import com.efuture.common.utils.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class TmsConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(TmsConfigUtil.class);
    private MongoTemplate mongoTemplate;

    private TmsConfigUtil(MongoTemplate template) {
        this.mongoTemplate = template;
    }

    public static TmsConfigUtil getInstance(MongoTemplate template) {
        return new TmsConfigUtil(template);
    }

    public TmsConfig getConfig(String prefix) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"configprefix").is((Object)prefix));
        return (TmsConfig)this.mongoTemplate.findOne(query, TmsConfig.class);
    }

    public String getValue(String prefix) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"configprefix").is((Object)prefix));
        TmsConfig tmsConfig = (TmsConfig)this.mongoTemplate.findOne(query, TmsConfig.class);
        if (null == tmsConfig || StringUtils.isBlank((CharSequence)tmsConfig.getConfigstr())) {
            ExceptionUtils.raise(String.format("[%s]\u914d\u7f6e\u4fe1\u606f\u672a\u627e\u5230", prefix));
        }
        return tmsConfig.getConfigstr();
    }
}

