/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.config;

import com.efuture.common.aop.PreventReSubmitInterceptor;
import com.efuture.common.aop.RedisLockInterceptor;
import com.efuture.common.aop.SheetIdLockInterceptor;
import jakarta.annotation.Resource;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(name={"redisLock.enabled"}, havingValue="true")
public class RedissionConfig {
    private static final Logger log = LoggerFactory.getLogger(RedissionConfig.class);
    @Resource
    ConfigurableEnvironment environment;

    @Bean
    RedissonClient redissonSingle() {
        String host = this.environment.getProperty("spring.redis.host");
        String port = this.environment.getProperty("spring.redis.port");
        String password = this.environment.getProperty("spring.redis.password");
        String database = this.environment.getProperty("spring.redis.database");
        Config config = new Config();
        SingleServerConfig singleServerConfig = config.useSingleServer().setAddress("redis://" + host + ":" + port).setDatabase(Integer.parseInt(database));
        if (!StringUtils.isEmpty((Object)password)) {
            singleServerConfig.setPassword(password);
        }
        log.info("--RedissionConfig---,create redisson success!!!---");
        return Redisson.create((Config)config);
    }

    @Bean
    public RedisLockInterceptor createRedisLockInterceptor() {
        RedisLockInterceptor lockInterceptor = new RedisLockInterceptor();
        log.info("-------create RedisLockInterceptor[\u5206\u6b65\u5f0f\u9501\u62e6\u622a\u5668] success!!!---");
        return lockInterceptor;
    }

    @Bean
    public SheetIdLockInterceptor createSheetIdLockInterceptor() {
        SheetIdLockInterceptor lockInterceptor = new SheetIdLockInterceptor();
        log.info("-----create SheetIdLockInterceptor[\u5355\u636eid\u5206\u6b65\u5f0f\u52a0\u9501\u62e6\u622a\u5668] success!!!---");
        return lockInterceptor;
    }

    @Bean
    public PreventReSubmitInterceptor createPreventReSubmitInterceptor() {
        PreventReSubmitInterceptor reSubmitInterceptor = new PreventReSubmitInterceptor();
        log.info(">>>>>>>>\u9632\u6b62\u91cd\u590d\u63d0\u4ea4\u62e6\u622a\u5668!");
        return reSubmitInterceptor;
    }
}

