/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MapUtil {
    public static <K, V> List<Map<K, V>> splitByChunkSize(Map<K, V> map, int chunkSize) {
        if (Objects.isNull(map) || map.isEmpty() || chunkSize < 1) {
            return Collections.emptyList();
        }
        int mapSize = map.size();
        int groupSize = mapSize / chunkSize + (mapSize % chunkSize == 0 ? 0 : 1);
        ArrayList list = Lists.newArrayListWithCapacity((int)groupSize);
        if (chunkSize >= mapSize) {
            list.add(map);
            return list;
        }
        int count = 0;
        HashMap subMap = Maps.newHashMapWithExpectedSize((int)chunkSize);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (count < chunkSize) {
                subMap.put(entry.getKey(), entry.getValue());
                ++count;
                continue;
            }
            list.add(subMap);
            subMap = Maps.newHashMapWithExpectedSize((int)chunkSize);
            subMap.put(entry.getKey(), entry.getValue());
            count = 1;
        }
        list.add(subMap);
        return list;
    }
}

