/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.utils;

import com.efuture.common.enums.ConditionType;
import com.efuture.common.utils.ExceptionUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class QueryUtils {
    public static Query build(Map<String, Object> params) {
        return QueryUtils.build(params, ConditionType.AND);
    }

    public static Query build(Map<String, Object> params, String orderBy) {
        Query query = QueryUtils.build(params, ConditionType.AND);
        if (StringUtils.hasText((String)orderBy)) {
            query.with(QueryUtils.buildOrderBy(orderBy));
        }
        return query;
    }

    public static Query build(Map<String, Object> params, ConditionType conditionType) {
        Query query = new Query();
        if (CollectionUtils.isEmpty(params)) {
            return query;
        }
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        for (Map.Entry<String, Object> p : params.entrySet()) {
            String strValue;
            String field = p.getKey();
            Object value = p.getValue();
            Criteria tmp = null;
            if (value instanceof String && ((strValue = String.valueOf(value).trim()).startsWith("%") || strValue.endsWith("%"))) {
                tmp = Criteria.where((String)field).regex(strValue);
            }
            if (tmp == null) {
                tmp = Criteria.where((String)field).is(value);
            }
            criteriaList.add(tmp);
        }
        Criteria criteria = new Criteria();
        Criteria[] criterias = new Criteria[criteriaList.size()];
        criteriaList.toArray(criterias);
        if (conditionType == ConditionType.AND) {
            criteria.andOperator(criterias);
        } else if (conditionType == ConditionType.OR) {
            criteria.orOperator(criterias);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        return query;
    }

    public static Query build(Criteria criteria) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)criteria);
        return query;
    }

    public static Boolean isEmpty(Map<String, Object> map) {
        if (map != null && map.size() != 0) {
            Object value;
            Iterator<Object> var1 = map.values().iterator();
            do {
                if (var1.hasNext()) continue;
                return true;
            } while ((value = var1.next()) == null);
            return false;
        }
        return true;
    }

    public static Sort buildOrderBy(String orderBy) {
        if (!StringUtils.hasText((String)orderBy)) {
            return null;
        }
        String[] exps = orderBy.split(",");
        ArrayList<Sort.Order> lst = new ArrayList<Sort.Order>();
        String[] var3 = exps;
        int var4 = exps.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            String exp = var3[var5];
            String[] rs = exp.trim().split(" ");
            if (rs.length == 1) {
                lst.add(new Sort.Order(Sort.Direction.DESC, rs[0].trim()));
                continue;
            }
            if (rs.length == 2) {
                String field = rs[0];
                String dir = rs[1];
                lst.add(new Sort.Order(dir.equals("desc") ? Sort.Direction.DESC : Sort.Direction.ASC, field));
                continue;
            }
            ExceptionUtils.raise("\u9519\u8bef\u7684\u8868\u8fbe\u5f0f\uff0c\u53ef\u80fd\u4e2d\u95f4\u6709\u591a\u4e2a\u7a7a\u683c " + exp);
        }
        return Sort.by(lst);
    }
}

