/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invlog;

import com.efuture.common.utils.QueryUtils;
import com.efuture.isce.wms.inv.im.ImInStockItem;
import com.efuture.isce.wms.inv.inv.InvCellMove;
import com.efuture.isce.wmsinv.service.invcell.InvCellQtyService;
import com.efuture.isce.wmsinv.service.invlog.InvCellMoveService;
import com.product.component.JDBCCompomentServiceImpl;
import com.product.storage.template.FMybatisTemplate;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class InvCellMoveServiceImpl
extends JDBCCompomentServiceImpl<InvCellMove>
implements InvCellMoveService {
    private static final Logger log = LoggerFactory.getLogger(InvCellMoveServiceImpl.class);
    @Autowired
    private InvCellQtyService cellQtyService;

    public InvCellMoveServiceImpl(FMybatisTemplate mybatisTemplate) {
        super(mybatisTemplate, "invcellmove", "id");
    }

    protected Document onBeforeRowInsert(Query query, Update update) {
        return this.onDefaultRowInsert(query, update);
    }

    @Override
    public int addLog(ImInStockItem stockItem, Integer papertype) {
        InvCellMove invCellMove;
        String entid = stockItem.getEntid();
        String ownerid = stockItem.getOwnerid();
        String gdid = stockItem.getGdid();
        String shopid = stockItem.getShopid();
        String cellno = stockItem.getCellno();
        Integer cellid = stockItem.getCellid();
        List cellQty = this.cellQtyService.dataQuery(QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("ownerid").is((Object)ownerid).and("cellno").is((Object)cellno)));
        Double f_qty = 0.0;
        Double f_instockqty = 0.0;
        Double f_outstockqty = 0.0;
        if (CollectionUtils.isNotEmpty((Collection)cellQty)) {
            f_qty = cellQty.stream().collect(Collectors.summingDouble(item -> item.getQty().doubleValue()));
            f_instockqty = cellQty.stream().collect(Collectors.summingDouble(item -> item.getInstockqty().doubleValue()));
            f_outstockqty = cellQty.stream().collect(Collectors.summingDouble(item -> item.getOutstockqty().doubleValue()));
        }
        String realcellno = stockItem.getRealcellno();
        Integer realcellid = stockItem.getRealcellid();
        List targetCellQty = this.cellQtyService.dataQuery(QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("ownerid").is((Object)ownerid).and("cellno").is((Object)realcellno)));
        Double t_qty = 0.0;
        Double t_instockqty = 0.0;
        Double t_outstockqty = 0.0;
        if (CollectionUtils.isNotEmpty((Collection)targetCellQty)) {
            t_qty = targetCellQty.stream().collect(Collectors.summingDouble(item -> item.getQty().doubleValue()));
            t_instockqty = targetCellQty.stream().collect(Collectors.summingDouble(item -> item.getInstockqty().doubleValue()));
            t_outstockqty = targetCellQty.stream().collect(Collectors.summingDouble(item -> item.getOutstockqty().doubleValue()));
        }
        if ((invCellMove = (InvCellMove)this.dataQueryFirst(QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("ownerid").is((Object)ownerid).and("papertype").is((Object)papertype).and("paperno").is((Object)stockItem.getSheetid()).and("gdid").is((Object)gdid).and("scellno").is((Object)cellno).and("dcellno").is((Object)realcellno).and("deptid").is((Object)stockItem.getDeptid())))) == null) {
            invCellMove = new InvCellMove();
            BeanUtils.copyProperties((Object)stockItem, (Object)invCellMove, (String[])new String[]{"id"});
            invCellMove.setPapertype(papertype);
            invCellMove.setPaperno(stockItem.getSheetid());
            invCellMove.setScellno(cellno);
            invCellMove.setScellid(cellid);
            invCellMove.setScontainerno(stockItem.getLpnid());
            invCellMove.setDcellno(realcellno);
            invCellMove.setDcellid(realcellid);
            invCellMove.setMoveqty(new BigDecimal(0));
        }
        invCellMove.setSfirstqty(new BigDecimal(f_qty));
        invCellMove.setSfirstinstockqty(new BigDecimal(f_instockqty));
        invCellMove.setSfirstoutstockqty(new BigDecimal(f_outstockqty));
        invCellMove.setDfirstqty(new BigDecimal(t_qty));
        invCellMove.setDfirstinstockqty(new BigDecimal(t_instockqty));
        invCellMove.setDfirstoutstockqty(new BigDecimal(t_outstockqty));
        invCellMove.setMoveqty(invCellMove.getMoveqty().add(new BigDecimal(stockItem.getRealqty())));
        if (invCellMove.getId() == null) {
            this.onInsert(invCellMove);
        } else {
            this.onUpdate(invCellMove);
        }
        return 1;
    }
}

