/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invcell;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.efuture.common.utils.ExceptionUtils;
import com.efuture.common.utils.IsceModelUtil;
import com.efuture.common.utils.QueryUtils;
import com.efuture.isce.mdm.code.Globpara;
import com.efuture.isce.mdm.goods.BmGoodsPack;
import com.efuture.isce.wms.hm.HmOutStockItem;
import com.efuture.isce.wms.hm.HmOutStocksItem;
import com.efuture.isce.wms.im.ImCheckSumItem;
import com.efuture.isce.wms.inv.inv.InvCellMove;
import com.efuture.isce.wms.inv.inv.InvCellQty;
import com.efuture.isce.wms.inv.model.entity.InvLock;
import com.efuture.isce.wms.inv.model.entity.InvLockItem;
import com.efuture.isce.wms.inv.model.entity.InvLocksItem;
import com.efuture.isce.wms.inv.model.entity.InvLot;
import com.efuture.isce.wms.inv.model.entity.InvLotInfo;
import com.efuture.isce.wms.inv.model.entity.InvLotItem;
import com.efuture.isce.wms.inv.vo.DedInvcellqtyOrderVo;
import com.efuture.isce.wms.inv.vo.DedInvcellqtyVo;
import com.efuture.isce.wms.inv.vo.InvCellFreezeVo;
import com.efuture.isce.wms.inv.vo.InvCellGoodListVO;
import com.efuture.isce.wms.inv.vo.InvLotProVo;
import com.efuture.isce.wms.inv.vo.InvcellMoveLogVo;
import com.efuture.isce.wms.inv.vo.InvcellqtyMoveVo;
import com.efuture.isce.wms.inv.vo.InvcellqtyOrderVo;
import com.efuture.isce.wms.inv.vo.InvcellqtyVo;
import com.efuture.isce.wms.inv.vo.RealTimeInvVo;
import com.efuture.isce.wms.om.OmDivideItem;
import com.efuture.isce.wms.om.OmDividesItem;
import com.efuture.isce.wms.stock.OmOutStockItem;
import com.efuture.isce.wms.stock.OmOutStocksItem;
import com.efuture.isce.wms.um.UmCheckSumItem;
import com.efuture.isce.wms.wm.WmOutStockItem;
import com.efuture.isce.wms.wm.WmOutStocksItem;
import com.efuture.isce.wmsinv.enums.ApiServiceEnum;
import com.efuture.isce.wmsinv.enums.SheetFlagEnum;
import com.efuture.isce.wmsinv.mapper.Inv.InvCellQtyMapper;
import com.efuture.isce.wmsinv.service.invcell.InvCellQtyService;
import com.efuture.isce.wmsinv.service.invcell.InvLockItemService;
import com.efuture.isce.wmsinv.service.invcell.InvLockService;
import com.efuture.isce.wmsinv.service.invlog.InvCellMoveService;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.product.config.dynamicds.DynamicJDBCCompomentServiceImpl;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.RestUtils;
import com.product.util.TypeUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvCellQtyServiceImpl
extends DynamicJDBCCompomentServiceImpl<InvCellQty>
implements InvCellQtyService {
    private static final Logger log = LoggerFactory.getLogger(InvCellQtyServiceImpl.class);
    @Autowired
    private InvCellMoveService cellmoveService;
    @Autowired
    private InvLockService invLockService;
    @Autowired
    private InvLockItemService invLockItemService;
    @Autowired
    private InvCellQtyMapper invCellQtyMapper;
    @Autowired
    private InvCellMoveService cellMoveService;

    public InvCellQtyServiceImpl(FMybatisTemplate mybatisTemplate) {
        super(mybatisTemplate, "invcellqty", "id");
    }

    @Override
    public boolean existCellQty(String entid, String shopid, String cellno) {
        Query build = QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("cellno").is((Object)cellno));
        long count = this.getTemplate().count(build, this.getCollectionName());
        return count > 0L;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer addInvCell(InvcellqtyVo invcellqtyVo) {
        InvLotInfo invLotinfo = this.getInvLotinfo(invcellqtyVo.getEntid(), invcellqtyVo.getGdid(), invcellqtyVo.getLotid());
        if (invLotinfo == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4e0b\u6ca1\u6709gdid\u4e3a[{1}]\u5546\u54c1\u5c5e\u6027ID\u4e3a[{2}]\u7684\u4fe1\u606f\uff01[{3}]", invcellqtyVo.getEntid(), invcellqtyVo.getGdid(), invcellqtyVo.getLotid(), "addInvCell"));
        }
        String entid = invcellqtyVo.getEntid();
        String shopid = invcellqtyVo.getShopid();
        String cellno = invcellqtyVo.getCellno();
        JSONObject paramMap = new JSONObject();
        paramMap.put("entid", (Object)entid);
        paramMap.put("shopid", (Object)shopid);
        paramMap.put("cellno", (Object)cellno);
        InvCellQty invcellqty = null;
        if (invcellqtyVo.getCellid() != -1) {
            Integer cellid = invcellqtyVo.getCellid();
            paramMap.put("cellid", (Object)cellid);
            invcellqty = (InvCellQty)this.getTemplate().selectOne(QueryUtils.build((Map)paramMap), InvCellQty.class);
            if (invcellqty == null) {
                invcellqty = this.getAddInvcellqtyEntity(invcellqtyVo, invLotinfo);
                this.onInsert(ServiceSession.getSession(), invcellqty);
            } else {
                Update update = Update.update((String)"qty", (Object)invcellqty.getQty().add(invcellqtyVo.getQty())).set("modifier", (Object)invcellqtyVo.getOperator()).set("modifytime", (Object)new Date());
                int row = this.getTemplate().update(QueryUtils.build((Map)paramMap), update, InvCellQty.class);
                if (row != 1) {
                    log.error("\u66f4\u65b0\u5e93\u5b58\u5931\u8d25\uff01[{}]", (Object)paramMap);
                    ExceptionUtils.raise((String)"\u66f4\u65b0\u5e93\u5b58\u5931\u8d25\uff01");
                }
            }
        } else {
            Integer cellid = this.getMaxCellid(entid, shopid, cellno);
            invcellqty = this.getAddInvcellqtyEntity(invcellqtyVo, invLotinfo);
            invcellqty.setCellid(cellid);
            this.onInsert(invcellqty);
        }
        this.cleanInvCellqty(invcellqtyVo.getEntid(), invcellqtyVo.getShopid(), invcellqtyVo.getCellno());
        return invcellqty.getCellid();
    }

    private Integer getMaxCellid(String entid, String shopid, String cellno) {
        JSONObject paramObj = new JSONObject();
        paramObj.put("entid", (Object)entid);
        paramObj.put("shopid", (Object)shopid);
        paramObj.put("cellno", (Object)cellno);
        Integer cellid = 0;
        List invcellqtyList = this.dataQuery(ServiceSession.getSession(), paramObj, InvCellQty.class);
        if (!CollectionUtils.isEmpty((Collection)invcellqtyList)) {
            InvCellQty maxcell = invcellqtyList.stream().max(Comparator.comparing(InvCellQty::getCellid)).get();
            cellid = maxcell.getCellid() + 1;
        } else {
            cellid = cellid + 1;
            log.info("\u6839\u636e\u6761\u4ef6[{}],\u67e5\u8be2\u4e0d\u5230\u50a8\u4f4d\u5e93\u5b58\u8bb0\u5f55\uff01", (Object)paramObj);
        }
        return cellid;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer invCellOrder(InvcellqtyOrderVo invcellqtyOrderVo) {
        InvCellQty invcellqty;
        BigDecimal subQty;
        InvLotInfo invLotinfo = this.getInvLotinfo(invcellqtyOrderVo.getEntid(), invcellqtyOrderVo.getGdid(), invcellqtyOrderVo.getLotid());
        if (invLotinfo == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4e0b\u6ca1\u6709gdid\u4e3a[{1}]\u5546\u54c1\u5c5e\u6027ID\u4e3a[{2}]\u7684\u4fe1\u606f\uff01[{3}]", invcellqtyOrderVo.getEntid(), invcellqtyOrderVo.getGdid(), invcellqtyOrderVo.getLotid(), "invCellOrder"));
        }
        if ((subQty = (invcellqty = this.getInvcellqty(invcellqtyOrderVo.getEntid(), invcellqtyOrderVo.getShopid(), invcellqtyOrderVo.getCellno(), invcellqtyOrderVo.getCellid())).getQty().subtract(invcellqty.getOutstockqty()).add(invcellqty.getInstockqty()).subtract(invcellqty.getFreezeqty()).subtract(invcellqtyOrderVo.getQty())).compareTo(BigDecimal.ZERO) == -1) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4ed3\u522b[{1}]\u50a8\u4f4d\u4ee3\u7801[{2}]\u50a8\u4f4dID[{3}]\u7684\u50a8\u4f4d\u5e93\u5b58[{4}]\u4e0d\u8db3\u4ee5\u9884\u7ea6\uff01[{5}]", invcellqtyOrderVo.getEntid(), invcellqtyOrderVo.getShopid(), invcellqtyOrderVo.getCellno(), invcellqtyOrderVo.getCellid(), invcellqty.getQty(), "invCellOrder"));
        }
        HashMap map = Maps.newHashMap();
        map.put("entid", invcellqtyOrderVo.getEntid());
        map.put("shopid", invcellqtyOrderVo.getShopid());
        map.put("cellno", invcellqtyOrderVo.getCellno());
        map.put("cellid", invcellqtyOrderVo.getCellid());
        InvCellQty tarInvcellqty = null;
        Update update = null;
        invcellqty.setOutstockqty(invcellqty.getOutstockqty().add(invcellqtyOrderVo.getQty()));
        int up = this.onUpdateBean(invcellqty, Sets.newHashSet((Object[])new String[]{"outstockqty"}));
        if (up == 1) {
            String lpnname = invcellqty.getLpnname();
            if (StringUtils.isEmpty((Object)lpnname)) {
                lpnname = invcellqtyOrderVo.getLpnname();
            }
            HashMap tmap = Maps.newHashMap();
            tmap.put("entid", invcellqtyOrderVo.getEntid());
            tmap.put("shopid", invcellqtyOrderVo.getShopid());
            tmap.put("cellno", StringUtils.isEmpty((Object)invcellqtyOrderVo.getTargetCellno()) ? "-1" : invcellqtyOrderVo.getTargetCellno());
            tmap.put("ownerid", invcellqtyOrderVo.getOwnerid());
            tmap.put("gdid", invcellqtyOrderVo.getGdid());
            tmap.put("lotid", invcellqtyOrderVo.getLotid());
            tmap.put("lpnname", invcellqtyOrderVo.getLpnname());
            tmap.put("instocktype", invcellqtyOrderVo.getInstocktype());
            tmap.put("deptid", invcellqtyOrderVo.getTargetDeptid());
            List tarInvcellqtyList = this.getTemplate().select(QueryUtils.build((Map)tmap), InvCellQty.class);
            if (!CollectionUtils.isEmpty((Collection)tarInvcellqtyList)) {
                tarInvcellqty = (InvCellQty)tarInvcellqtyList.get(0);
                update = Update.update((String)"instockqty", (Object)tarInvcellqty.getInstockqty().add(invcellqtyOrderVo.getQty()));
                int tup = this.getTemplate().update(QueryUtils.build((Map)tmap), update, InvCellQty.class);
                if (tup != 1) {
                    ExceptionUtils.raise((String)MessageFormat.format("\u66f4\u65b0\u50a8\u4f4d\u5e93\u5b58\u5931\u8d25\uff01{0}", tmap));
                }
            } else {
                InvCellQty invcell = this.getAddInvcellqtyEntity((InvcellqtyVo)invcellqtyOrderVo, invLotinfo);
                invcell.setCellid(this.getMaxCellid(invcellqtyOrderVo.getEntid(), invcellqtyOrderVo.getShopid(), invcellqtyOrderVo.getTargetCellno()));
                invcell.setCellno(invcellqtyOrderVo.getTargetCellno());
                invcell.setQty(BigDecimal.ZERO);
                invcell.setOutstockqty(BigDecimal.ZERO);
                invcell.setInstockqty(invcellqtyOrderVo.getQty());
                this.onInsert(ServiceSession.getSession(), invcell);
                tarInvcellqty = (InvCellQty)this.getTemplate().selectOne(QueryUtils.build((Map)tmap), InvCellQty.class);
            }
        } else {
            log.error("[{}]\u66f4\u65b0\u50a8\u4f4d\u5e93\u5b58\u5931\u8d25\uff01{}", (Object)"invCellOrder", (Object)map);
            ExceptionUtils.raise((String)"\u66f4\u65b0\u50a8\u4f4d\u5e93\u5b58\u5931\u8d25\uff01");
        }
        return tarInvcellqty.getCellid();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void dedInvCellOrder(DedInvcellqtyOrderVo dedInvQtyOrderVo) {
        InvCellQty invcellqty = this.getInvcellqty(dedInvQtyOrderVo.getEntid(), dedInvQtyOrderVo.getShopid(), dedInvQtyOrderVo.getCellno(), dedInvQtyOrderVo.getCellid());
        String gdid = invcellqty.getGdid();
        String lotid = invcellqty.getLotid();
        InvLotInfo invLotinfo = this.getInvLotinfo(dedInvQtyOrderVo.getEntid(), gdid, lotid);
        if (invLotinfo == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4e0b\u6ca1\u6709\u5546\u54c1\u5185\u7801\u4e3a[{1}]\u5546\u54c1\u5c5e\u6027ID\u4e3a[{2}]\u7684\u4fe1\u606f\uff01[dedInvCellOrder]", dedInvQtyOrderVo.getEntid(), gdid, lotid));
        }
        invcellqty.setQty(invcellqty.getQty().subtract(dedInvQtyOrderVo.getQty()));
        invcellqty.setOutstockqty(invcellqty.getOutstockqty().subtract(dedInvQtyOrderVo.getPreQty()));
        int row = this.onUpdateBean(invcellqty, Sets.newHashSet((Object[])new String[]{"qty", "outstockqty"}));
        if (row == 1) {
            Integer tarCellid;
            Criteria criteria = Criteria.where((String)"entid").is((Object)dedInvQtyOrderVo.getEntid()).and("shopid").is((Object)dedInvQtyOrderVo.getShopid()).and("paraid").is((Object)"CONTAINER");
            Query query = new Query((CriteriaDefinition)criteria);
            Globpara globpara = (Globpara)this.getTemplate().selectOne(query, Globpara.class);
            String lpnname = dedInvQtyOrderVo.getTargetCellno();
            if (globpara != null && "20".equals(globpara.getParavalue())) {
                lpnname = dedInvQtyOrderVo.getLpnname();
            }
            if ((tarCellid = dedInvQtyOrderVo.getTargetCellId()) == -1) {
                tarCellid = this.getMaxCellid(dedInvQtyOrderVo.getEntid(), dedInvQtyOrderVo.getShopid(), dedInvQtyOrderVo.getTargetCellno());
                InvCellQty tarInvcellqty = new InvCellQty();
                BeanUtils.copyProperties((Object)invcellqty, (Object)tarInvcellqty, (String[])new String[]{"id"});
                tarInvcellqty.setQty(dedInvQtyOrderVo.getQty().add(dedInvQtyOrderVo.getPreQty()));
                tarInvcellqty.setCellid(tarCellid);
                tarInvcellqty.setCellno(dedInvQtyOrderVo.getTargetCellno());
                tarInvcellqty.setLpnname(lpnname);
                this.onInsert(tarInvcellqty);
            } else {
                InvCellQty tarInvCellQty = this.getInvcellqty(dedInvQtyOrderVo.getEntid(), dedInvQtyOrderVo.getShopid(), dedInvQtyOrderVo.getTargetCellno(), dedInvQtyOrderVo.getTargetCellId());
                tarInvCellQty.setQty(tarInvCellQty.getQty().add(dedInvQtyOrderVo.getQty()));
                tarInvCellQty.setInstockqty(tarInvCellQty.getInstockqty().subtract(dedInvQtyOrderVo.getPreQty()));
                tarInvCellQty.setLpnname(lpnname);
                row = this.onUpdateBean(tarInvCellQty, Sets.newHashSet((Object[])new String[]{"qty", "instockqty", "lpnname"}));
                if (row == 1) {
                    this.cleanInvCellqty(dedInvQtyOrderVo.getEntid(), dedInvQtyOrderVo.getShopid(), dedInvQtyOrderVo.getCellno());
                    this.cleanInvCellqty(dedInvQtyOrderVo.getEntid(), dedInvQtyOrderVo.getShopid(), dedInvQtyOrderVo.getTargetCellno());
                } else {
                    ExceptionUtils.raise((String)MessageFormat.format("--\u66f4\u65b0\u76ee\u7684\u50a8\u4f4d\u5e93\u5b58\u5931\u8d25\uff01{0}", invcellqty.getCellid()));
                }
            }
        } else {
            log.error("\u66f4\u65b0\u50a8\u4f4d\u5e93\u5b58\u5931\u8d25id={},[dedInvCellOrder]", (Object)invcellqty.getId());
            ExceptionUtils.raise((String)MessageFormat.format("\u66f4\u65b0\u50a8\u4f4d\u5e93\u5b58\u5931\u8d25\uff01id[{}]", invcellqty.getId()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer invCellMove(InvcellqtyMoveVo invcellqtyMoveVo) {
        InvCellQty invcellqty = this.getInvcellqty(invcellqtyMoveVo.getEntid(), invcellqtyMoveVo.getShopid(), invcellqtyMoveVo.getCellno(), invcellqtyMoveVo.getCellid());
        String gdid = invcellqty.getGdid();
        String lotid = invcellqty.getLotid();
        InvLotInfo invLotinfo = this.getInvLotinfo(invcellqtyMoveVo.getEntid(), gdid, lotid);
        if (invLotinfo == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4e0b\u6ca1\u6709gdid\u4e3a[{1}]\u5546\u54c1\u5c5e\u6027ID\u4e3a[{2}]\u7684\u4fe1\u606f\uff01", invcellqtyMoveVo.getEntid(), gdid, lotid));
        }
        if (invcellqty.getQty().subtract(invcellqtyMoveVo.getQty()).compareTo(BigDecimal.ZERO) == -1) {
            log.error("\u50a8\u4f4d\u5e93\u5b58[{}]\uff0c\u4e0d\u8db3\u4ee5\u6263\u51cf[{}]\uff01", (Object)String.join((CharSequence)"entid=", invcellqtyMoveVo.getEntid(), "shopid=", invcellqtyMoveVo.getShopid(), "cellno=", invcellqtyMoveVo.getCellno(), "cellid=", String.valueOf(invcellqtyMoveVo.getCellid())), (Object)invcellqtyMoveVo.getQty());
            ExceptionUtils.raise((String)MessageFormat.format("\u50a8\u4f4d\u5e93\u5b58[{0}]\uff0c\u4e0d\u8db3\u4ee5\u6263\u51cf[{1}]\uff01", String.join((CharSequence)"entid=", invcellqtyMoveVo.getEntid(), "shopid=", invcellqtyMoveVo.getShopid(), "cellno=", invcellqtyMoveVo.getCellno(), "cellid=", String.valueOf(invcellqtyMoveVo.getCellid())), invcellqtyMoveVo.getQty()));
        }
        Criteria criteria = Criteria.where((String)"entid").is((Object)invcellqtyMoveVo.getEntid()).and("shopid").is((Object)invcellqtyMoveVo.getShopid()).and("paraid").is((Object)"CONTAINER");
        Query query = new Query((CriteriaDefinition)criteria);
        Globpara globpara = (Globpara)this.getTemplate().selectOne(query, Globpara.class);
        String lpnname = invcellqtyMoveVo.getTargetCellno();
        if (globpara != null && "20".equals(globpara.getParavalue())) {
            lpnname = invcellqtyMoveVo.getLpnname();
        }
        Integer tarCellid = invcellqtyMoveVo.getTargetCellId();
        invcellqty.setQty(invcellqty.getQty().subtract(invcellqtyMoveVo.getQty()));
        invcellqty.setLpnname(lpnname);
        int row = this.onUpdateBean(invcellqty, Sets.newHashSet((Object[])new String[]{"qty", "lpnname"}));
        if (row != 1) {
            ExceptionUtils.raise((String)"\u6263\u51cf\u5e93\u5b58\u5931\u8d25\uff01");
        }
        if (tarCellid == -1) {
            tarCellid = this.getMaxCellid(invcellqtyMoveVo.getEntid(), invcellqtyMoveVo.getShopid(), invcellqtyMoveVo.getTargetCellno());
            InvCellQty tarInvcellqty = this.getMoveInvcellqtyEntity(invcellqtyMoveVo, invLotinfo);
            tarInvcellqty.setCellid(tarCellid);
            tarInvcellqty.setCellno(invcellqtyMoveVo.getTargetCellno());
            tarInvcellqty.setLpnname(lpnname);
            this.onInsert(tarInvcellqty);
        } else if (row == 1) {
            InvCellQty tarInvCellQty = this.getInvcellqty(invcellqtyMoveVo.getEntid(), invcellqtyMoveVo.getShopid(), invcellqtyMoveVo.getTargetCellno(), invcellqtyMoveVo.getTargetCellId());
            tarInvCellQty.setQty(tarInvCellQty.getQty().add(invcellqtyMoveVo.getQty()));
            tarInvCellQty.setLpnname(lpnname);
            this.onUpdateBean(tarInvCellQty, Sets.newHashSet((Object[])new String[]{"qty", "lpnname"}));
            this.cleanInvCellqty(invcellqtyMoveVo.getEntid(), invcellqtyMoveVo.getShopid(), invcellqtyMoveVo.getCellno());
            this.cleanInvCellqty(invcellqtyMoveVo.getEntid(), invcellqtyMoveVo.getShopid(), invcellqtyMoveVo.getTargetCellno());
        } else {
            ExceptionUtils.raise((String)MessageFormat.format("--\u66f4\u65b0\u76ee\u7684\u50a8\u4f4d\u5e93\u5b58\u5931\u8d25\uff01{0}", invcellqty.getCellid()));
        }
        return tarCellid;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void dedInvCell(DedInvcellqtyVo dedInvcellqtyVo) {
        List<InvCellQty> invcellqtyList = this.getInvcellqtys(dedInvcellqtyVo.getEntid(), dedInvcellqtyVo.getShopid(), dedInvcellqtyVo.getOwnerid(), dedInvcellqtyVo.getCellno(), dedInvcellqtyVo.getGdid(), dedInvcellqtyVo.getLotid());
        if (invcellqtyList.isEmpty()) {
            log.error("\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u4ee3\u6263\u5e93\u5b58\u8bb0\u5f55![{}]", (Object)JSON.toJSONString((Object)dedInvcellqtyVo));
            ExceptionUtils.raise((String)"\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u4ee3\u6263\u5e93\u5b58\u8bb0\u5f55\uff01");
        }
        BigDecimal tempQty = dedInvcellqtyVo.getQty();
        for (InvCellQty c : invcellqtyList) {
            if (tempQty.compareTo(BigDecimal.ZERO) != 1) break;
            if (tempQty.subtract(c.getQty()).compareTo(BigDecimal.ZERO) == 1) {
                tempQty = tempQty.subtract(c.getQty());
                c.setQty(BigDecimal.ZERO);
            } else {
                BigDecimal qty = c.getQty().subtract(tempQty);
                c.setQty(qty);
                tempQty = BigDecimal.ZERO;
            }
            this.onUpdateBean(c, Sets.newHashSet((Object[])new String[]{"qty"}));
        }
        if (tempQty.compareTo(BigDecimal.ZERO) == 1) {
            log.error("\u5e93\u5b58\u4e0d\u8db3\u4ee5\u6263\u51cf\uff01[{}]", (Object)JSON.toJSONString((Object)dedInvcellqtyVo));
            ExceptionUtils.raise((String)"\u5e93\u5b58\u4e0d\u8db3\u4ee5\u6263\u51cf\uff01");
        }
        this.cleanInvCellqty(dedInvcellqtyVo.getEntid(), dedInvcellqtyVo.getShopid(), dedInvcellqtyVo.getCellno());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void realTimeInvMove(RealTimeInvVo realTimeInvVo) {
        String gdId = realTimeInvVo.getGdid();
        String lotId = realTimeInvVo.getLotid();
        InvLotInfo invLotinfo = this.getInvLotinfo(realTimeInvVo.getEntid(), gdId, lotId);
        if (invLotinfo == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4e0b\u6ca1\u6709gdid\u4e3a[{1}]\u5546\u54c1\u5c5e\u6027ID\u4e3a[{2}]\u7684\u4fe1\u606f\uff01", realTimeInvVo.getEntid(), gdId, lotId));
        }
        Criteria criteria = Criteria.where((String)"entid").is((Object)realTimeInvVo.getEntid()).and("shopid").is((Object)realTimeInvVo.getShopid()).and("paraid").is((Object)"CONTAINER");
        Query query = new Query((CriteriaDefinition)criteria);
        Globpara globpara = (Globpara)this.getTemplate().selectOne(query, Globpara.class);
        String lpnname = realTimeInvVo.getTargetCellno();
        if (globpara != null && "20".equals(globpara.getParavalue())) {
            lpnname = realTimeInvVo.getLpnname();
        }
        int row = 0;
        if (realTimeInvVo.getCellid() == -1) {
            Integer cellid = this.getMaxCellid(realTimeInvVo.getEntid(), realTimeInvVo.getShopid(), realTimeInvVo.getCellno());
            InvCellQty tarInvcellqty = this.getRealTimeInvcellqtyEntity(realTimeInvVo, invLotinfo);
            tarInvcellqty.setCellid(cellid);
            tarInvcellqty.setLpnname(lpnname);
            this.onInsert(tarInvcellqty);
        } else {
            InvCellQty invcellqty = this.getInvcellqty(realTimeInvVo.getEntid(), realTimeInvVo.getShopid(), realTimeInvVo.getCellno(), realTimeInvVo.getCellid());
            invcellqty.setQty(invcellqty.getQty().add(realTimeInvVo.getQty()));
            invcellqty.setLpnname(lpnname);
            row = this.onUpdateBean(invcellqty, Sets.newHashSet((Object[])new String[]{"qty", "lpnname"}));
            if (row != 1) {
                log.error("[{}]\u6e90\u50a8\u4f4d\u5e93\u5b58\u66f4\u65b0\u5931\u8d25\uff01[{}]", (Object)"realTimeInvMove", (Object)JSON.toJSONString((Object)realTimeInvVo));
                ExceptionUtils.raise((String)"\u50a8\u4f4d\u5e93\u5b58\u66f4\u65b0\u5931\u8d25\uff01");
            }
        }
        JSONObject paramsObject = new JSONObject();
        paramsObject.put("entid", (Object)realTimeInvVo.getEntid());
        paramsObject.put("shopid", (Object)realTimeInvVo.getShopid());
        paramsObject.put("ownerid", (Object)realTimeInvVo.getOwnerid());
        paramsObject.put("gdid", (Object)realTimeInvVo.getGdid());
        paramsObject.put("lotid", (Object)realTimeInvVo.getLotid());
        paramsObject.put("cellno", (Object)realTimeInvVo.getTargetCellno());
        InvCellQty targetInvCellQty = (InvCellQty)this.getTemplate().selectOne(QueryUtils.build((Map)paramsObject), InvCellQty.class);
        if (targetInvCellQty == null) {
            realTimeInvVo.setTargetCellId(Integer.valueOf(-1));
        } else {
            realTimeInvVo.setTargetCellId(targetInvCellQty.getCellid());
        }
        if (realTimeInvVo.getTargetCellId() == -1) {
            Integer cellid = this.getMaxCellid(realTimeInvVo.getEntid(), realTimeInvVo.getShopid(), realTimeInvVo.getTargetCellno());
            InvCellQty tarInvcellqty = this.getRealTimeInvcellqtyEntity(realTimeInvVo, invLotinfo);
            tarInvcellqty.setQty(realTimeInvVo.getQty().multiply(new BigDecimal(-1)));
            tarInvcellqty.setCellid(cellid);
            tarInvcellqty.setCellno(realTimeInvVo.getTargetCellno());
            tarInvcellqty.setLpnname(lpnname);
            this.onInsert(tarInvcellqty);
        } else {
            targetInvCellQty.setQty(targetInvCellQty.getQty().subtract(realTimeInvVo.getQty()));
            targetInvCellQty.setLpnname(lpnname);
            row = this.onUpdateBean(targetInvCellQty, Sets.newHashSet((Object[])new String[]{"qty", "lpnname"}));
            if (row != 1) {
                log.error("\u76ee\u6807\u50a8\u4f4d\u5e93\u5b58\u66f4\u65b0\u5931\u8d25\uff01[{}]", (Object)JSON.toJSONString((Object)realTimeInvVo));
                ExceptionUtils.raise((String)"\u50a8\u4f4d\u5e93\u5b58\u66f4\u65b0\u5931\u8d25\uff01");
            }
        }
        this.cleanInvCellqty(realTimeInvVo.getEntid(), realTimeInvVo.getShopid(), realTimeInvVo.getCellno());
        this.cleanInvCellqty(realTimeInvVo.getEntid(), realTimeInvVo.getShopid(), realTimeInvVo.getTargetCellno());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void invCellMoveLog(InvcellMoveLogVo invcellMoveVo) {
        String gdid = invcellMoveVo.getGdid();
        String lotid = invcellMoveVo.getLotid();
        InvLotInfo invLotinfo = this.getInvLotinfo(invcellMoveVo.getEntid(), gdid, lotid);
        InvCellQty sInvcellqty = this.getInvcellqty(invcellMoveVo.getEntid(), invcellMoveVo.getShopid(), invcellMoveVo.getScellno(), invcellMoveVo.getScellid());
        InvCellQty tInvcellqty = this.getInvcellqty(invcellMoveVo.getEntid(), invcellMoveVo.getShopid(), invcellMoveVo.getDcellno(), invcellMoveVo.getDcellid());
        HashMap map = Maps.newHashMap();
        map.put("entid", invcellMoveVo.getEntid());
        map.put("shopid", invcellMoveVo.getShopid());
        map.put("ownerid", invcellMoveVo.getOwnerid());
        map.put("papertype", invcellMoveVo.getPapertype());
        map.put("paperno", invcellMoveVo.getPaperno());
        map.put("gdid", invcellMoveVo.getGdid());
        map.put("lotid", invcellMoveVo.getLotid());
        map.put("scellno", invcellMoveVo.getScellno());
        map.put("scellid", invcellMoveVo.getScellid());
        map.put("dcellno", invcellMoveVo.getDcellno());
        map.put("dcellid", invcellMoveVo.getDcellid());
        map.put("deptid", invcellMoveVo.getDeptid());
        InvCellMove invcellmove = (InvCellMove)this.getTemplate().selectOne(QueryUtils.build((Map)map), InvCellMove.class);
        if (invcellmove == null) {
            invcellmove = new InvCellMove();
            BeanUtils.copyProperties((Object)invcellMoveVo, (Object)invcellmove);
            BeanUtils.copyProperties((Object)invLotinfo, (Object)invcellmove);
            invcellmove.setMoveqty(invcellMoveVo.getQty());
            invcellmove.setScontainerno("N");
            invcellmove.setSfirstqty(sInvcellqty.getQty());
            invcellmove.setSfirstinstockqty(sInvcellqty.getInstockqty());
            invcellmove.setSfirstoutstockqty(sInvcellqty.getOutstockqty());
            invcellmove.setDcontainerno("N");
            invcellmove.setDfirstqty(tInvcellqty.getQty());
            invcellmove.setDfirstinstockqty(tInvcellqty.getInstockqty());
            invcellmove.setDfirstoutstockqty(tInvcellqty.getOutstockqty());
            this.cellmoveService.onInsert(ServiceSession.getSession(), (JSONObject)JSONObject.toJSON((Object)invcellmove));
        } else {
            invcellmove.setSfirstqty(invcellmove.getSfirstqty().add(sInvcellqty.getQty()));
            invcellmove.setSfirstinstockqty(invcellmove.getSfirstinstockqty().add(sInvcellqty.getInstockqty()));
            invcellmove.setSfirstoutstockqty(invcellmove.getSfirstoutstockqty().add(sInvcellqty.getOutstockqty()));
            invcellmove.setDfirstqty(invcellmove.getDfirstqty().add(tInvcellqty.getQty()));
            invcellmove.setDfirstinstockqty(invcellmove.getDfirstinstockqty().add(tInvcellqty.getInstockqty()));
            invcellmove.setDfirstoutstockqty(invcellmove.getDfirstoutstockqty().add(tInvcellqty.getOutstockqty()));
            invcellmove.setMoveqty(invcellmove.getMoveqty().add(invcellMoveVo.getQty()));
            int row = this.cellMoveService.onUpdateBean(invcellmove, Sets.newHashSet((Object[])new String[]{"sfirstqty", "sfirstinstockqty", "sfirstoutstockqty", "dfirstqty", "dfirstinstockqty", "dfirstoutstockqty", "moveqty"}));
            if (row != 1) {
                log.error("\u50a8\u4f4d\u5f02\u52a8\u65e5\u5fd7\u66f4\u65b0\u5931\u8d25![id={}]", (Object)invcellmove.getId());
                ExceptionUtils.raise((String)"\u50a8\u4f4d\u5f02\u52a8\u65e5\u5fd7\u66f4\u65b0\u5931\u8d25\uff01");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void invCellFreeze(InvCellFreezeVo invCellFreezeVo) {
        HashMap map = Maps.newHashMap();
        map.put("entid", invCellFreezeVo.getEntid());
        map.put("shopid", invCellFreezeVo.getShopid());
        map.put("ownerid", invCellFreezeVo.getOwnerid());
        map.put("sheetid", invCellFreezeVo.getSheetid());
        if (invCellFreezeVo.getFlag() == 0) {
            Update update = Update.update((String)"flag", (Object)SheetFlagEnum.CANCEL.getFlag());
            int row = this.getTemplate().update(QueryUtils.build((Map)map), update, InvLock.class);
            if (row != 1) {
                log.error("\u4f5c\u5e9f\u64cd\u4f5c\u5f02\u5e38:{}", (Object)map);
                ExceptionUtils.raise((String)"\u4f5c\u5e9f\u5f02\u5e38\uff01");
            }
        } else if (invCellFreezeVo.getFlag() == 1) {
            InvLock invlock = (InvLock)this.getTemplate().selectOne(QueryUtils.build((Map)map), InvLock.class);
            if (invlock == null) {
                ExceptionUtils.raise((String)MessageFormat.format("\u65e0\u4f01\u4e1a[{0}]\u5355\u636e[{1}]\u7684\u5e93\u5b58\u9501\u5b9a\u8bb0\u5f55\uff01", invCellFreezeVo.getEntid(), invCellFreezeVo.getSheetid()));
            }
            if (invlock.getFlag().equals(SheetFlagEnum.CANCEL.getFlag()) || invlock.getFlag().equals(SheetFlagEnum.AUDIT.getFlag())) {
                ExceptionUtils.raise((String)"\u5e93\u5b58\u9501\u5b9a\u8bb0\u5f55\u5df2\u4f5c\u5e9f\u6216\u5df2\u6838\u5ba1\uff01");
            }
            List invlocks = this.getTemplate().select(QueryUtils.build((Map)map), InvLocksItem.class);
            invlocks.forEach(l -> this.updateInvCell(invlock, (InvLocksItem)l));
            invlock.setFlag(SheetFlagEnum.AUDIT.getFlag());
            invlock.setEditor(invCellFreezeVo.getOperator());
            this.invLockService.onUpdateBean(invlock, Sets.newHashSet((Object[])new String[]{"flag", "editor"}));
        } else {
            ExceptionUtils.raise((String)MessageFormat.format("\u5904\u7406\u6807\u8bb0\u5f02\u5e38[{0}]\uff01\u4e3a\u975e0/1", invCellFreezeVo.getFlag()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void invLotProAdj(InvLotProVo invLotProVo) {
        HashMap param = Maps.newHashMap();
        param.put("entid", invLotProVo.getEntid());
        param.put("shopid", invLotProVo.getShopid());
        param.put("ownerid", invLotProVo.getOwnerid());
        param.put("sheetid", invLotProVo.getSheetid());
        if (invLotProVo.getFlag() == 0) {
            Update update = Update.update((String)"flag", (Object)SheetFlagEnum.CANCEL.getFlag()).set("checker", (Object)invLotProVo.getOperator()).set("checkdate", (Object)new Date());
            int row = this.getTemplate().update(QueryUtils.build((Map)param), update, InvLot.class);
            if (row != 1) {
                ExceptionUtils.raise((String)"\u66f4\u65b0\u6279\u6b21\u5c5e\u6027\u8c03\u6574\u5355\u636e\u5f02\u5e38\uff01");
            }
        } else if (invLotProVo.getFlag() == 1) {
            InvLot invlot = (InvLot)this.getTemplate().selectOne(QueryUtils.build((Map)param), InvLot.class);
            if (Objects.isNull(invlot)) {
                log.info("\u65e0\u6279\u6b21\u5c5e\u6027\u8c03\u6574\u5355\u636e\u8bb0\u5f55\uff01\u6761\u4ef6[{}]", (Object)param);
                return;
            }
            if (invlot.getFlag().equals(SheetFlagEnum.CANCEL.getFlag()) || invlot.getFlag().equals(SheetFlagEnum.AUDIT.getFlag())) {
                ExceptionUtils.raise((String)MessageFormat.format("\u6279\u6b21\u5c5e\u6027\u8c03\u6574\u5355\u636e[{0}]\u5df2\u4f5c\u5e9f\u6216\u88ab\u5ba1\u6838\uff01", invlot.getSheetid()));
            }
            Criteria lotItemCri = Criteria.where((String)"entid").is((Object)invLotProVo.getEntid()).and("sheetid").is((Object)invLotProVo.getSheetid());
            List invlotitemList = this.getTemplate().select(new Query((CriteriaDefinition)lotItemCri), InvLotItem.class);
            if (!CollectionUtils.isEmpty((Collection)invlotitemList)) {
                for (InvLotItem invLotItem : invlotitemList) {
                    Criteria criteria = Criteria.where((String)"entid").is((Object)invLotProVo.getEntid()).and("gdid").is((Object)invLotItem.getGdid()).and("lotid").is((Object)invLotItem.getLotid()).and("flag").lt((Object)13);
                    Query query = new Query((CriteriaDefinition)criteria);
                    List outStockItemList = this.getTemplate().select(query, OmOutStockItem.class);
                    List hmOutStockItemList = this.getTemplate().select(query, HmOutStockItem.class);
                    List divideItemList = this.getTemplate().select(query, OmDivideItem.class);
                    if (!CollectionUtils.isEmpty((Collection)outStockItemList) || !CollectionUtils.isEmpty((Collection)hmOutStockItemList) || !CollectionUtils.isEmpty((Collection)divideItemList)) continue;
                    Criteria cri = Criteria.where((String)"entid").is((Object)invLotProVo.getEntid()).and("gdid").is((Object)invLotItem.getGdid()).and("lotid").is((Object)invLotItem.getLotid());
                    Update update = Update.update((String)"barcode", (Object)invLotItem.getBarcode()).set("packingqty", (Object)invLotItem.getPackingqty()).set("lot01", (Object)invLotItem.getLot01()).set("lot02", (Object)invLotItem.getLot02()).set("lot03", (Object)invLotItem.getLot03()).set("lot04", (Object)invLotItem.getLot04()).set("lot05", (Object)invLotItem.getLot05()).set("lot06", (Object)invLotItem.getLot06()).set("lot07", (Object)invLotItem.getLot07()).set("lot08", (Object)invLotItem.getLot08()).set("lot09", (Object)invLotItem.getLot09()).set("lot10", (Object)invLotItem.getLot10()).set("lot11", (Object)invLotItem.getLot11()).set("lot12", (Object)invLotItem.getLot12()).set("lot13", (Object)invLotItem.getLot13()).set("lot14", (Object)invLotItem.getLot14()).set("lot15", (Object)invLotItem.getLot15()).set("lot16", (Object)invLotItem.getLot16()).set("lot17", (Object)invLotItem.getLot17()).set("lot18", (Object)invLotItem.getLot18()).set("lot19", (Object)invLotItem.getLot19()).set("lot20", (Object)invLotItem.getLot20());
                    Query q = new Query((CriteriaDefinition)cri);
                    this.getTemplate().update(q, update, InvLotInfo.class);
                    this.getTemplate().update(q, update, InvCellQty.class);
                    List outStockItems = this.getTemplate().select(q, OmOutStockItem.class);
                    if (!CollectionUtils.isEmpty((Collection)outStockItems)) {
                        String sheetid = "";
                        for (Object item : outStockItems) {
                            if (!sheetid.equals(item.getSheetid())) continue;
                            Criteria tempCri = Criteria.where((String)"entid").is((Object)item.getEntid()).and("gdid").is((Object)item.getGdid()).and("sheetid").is((Object)item.getSheetid());
                            Query tempQ = new Query((CriteriaDefinition)tempCri);
                            this.getTemplate().update(tempQ, update, OmOutStocksItem.class);
                            sheetid = item.getSheetid();
                        }
                    }
                    this.getTemplate().update(q, update, OmOutStockItem.class);
                    List divideItems = this.getTemplate().select(q, OmDivideItem.class);
                    if (!CollectionUtils.isEmpty((Collection)divideItems)) {
                        Object item;
                        String sheetid = "";
                        item = divideItems.iterator();
                        while (item.hasNext()) {
                            OmDivideItem item2 = (OmDivideItem)item.next();
                            if (!sheetid.equals(item2.getSheetid())) continue;
                            Criteria tempCri = Criteria.where((String)"entid").is((Object)item2.getEntid()).and("gdid").is((Object)item2.getGdid()).and("sheetid").is((Object)item2.getSheetid());
                            Query tempQ = new Query((CriteriaDefinition)tempCri);
                            this.getTemplate().update(tempQ, update, OmDividesItem.class);
                            sheetid = item2.getSheetid();
                        }
                    }
                    this.getTemplate().update(q, update, OmDivideItem.class);
                    List hmOutStockItems = this.getTemplate().select(q, HmOutStockItem.class);
                    if (!CollectionUtils.isEmpty((Collection)hmOutStockItems)) {
                        String sheetid = "";
                        for (HmOutStockItem item : hmOutStockItems) {
                            if (!sheetid.equals(IsceModelUtil.getSheetid((Object)item))) continue;
                            Criteria tempCri = Criteria.where((String)"entid").is((Object)item.getEntid()).and("gdid").is((Object)item.getGdid()).and("sheetid").is((Object)IsceModelUtil.getSheetid((Object)item));
                            Query tempQ = new Query((CriteriaDefinition)tempCri);
                            this.getTemplate().update(tempQ, update, HmOutStocksItem.class);
                            sheetid = IsceModelUtil.getSheetid((Object)item);
                        }
                    }
                    this.getTemplate().update(q, update, HmOutStockItem.class);
                    List wmOutStockItems = this.getTemplate().select(q, WmOutStockItem.class);
                    if (!CollectionUtils.isEmpty((Collection)wmOutStockItems)) {
                        String sheetid = "";
                        for (WmOutStockItem item : wmOutStockItems) {
                            if (!sheetid.equals(IsceModelUtil.getSheetid((Object)item))) continue;
                            Criteria tempCri = Criteria.where((String)"entid").is((Object)item.getEntid()).and("gdid").is((Object)item.getGdid()).and("sheetid").is((Object)IsceModelUtil.getSheetid((Object)item));
                            Query tempQ = new Query((CriteriaDefinition)tempCri);
                            this.getTemplate().update(tempQ, update, WmOutStocksItem.class);
                            sheetid = IsceModelUtil.getSheetid((Object)item);
                        }
                    }
                    this.getTemplate().update(q, update, WmOutStockItem.class);
                    this.getTemplate().update(q, update, ImCheckSumItem.class);
                    this.getTemplate().update(q, update, UmCheckSumItem.class);
                }
            }
            Update update = Update.update((String)"flag", (Object)SheetFlagEnum.AUDIT.getFlag()).set("checker", (Object)invLotProVo.getOperator()).set("checkdate", (Object)new Date());
            this.getTemplate().update(QueryUtils.build((Map)param), update, InvLot.class);
        } else {
            ExceptionUtils.raise((String)"\u5904\u7406\u6807\u8bb0\u5f02\u5e38\uff01\u975e[0/1]");
        }
    }

    @Override
    public List<InvCellQty> selectCellQty(Map param) {
        return this.dataQuery(QueryUtils.build((Map)param));
    }

    @Override
    public ServiceResponse getInvCellGoodList(String entid, String shopid, String ownerid, String gdid) {
        List<InvCellGoodListVO> invCellGoodListVOS = this.invCellQtyMapper.getInvCellGoodList(entid, shopid, ownerid, gdid);
        for (InvCellGoodListVO vo : invCellGoodListVOS) {
            JSONObject param = new JSONObject();
            param.put("entid", (Object)entid);
            param.put("gdcode", (Object)vo.getGdcode());
            param.put("packingqty", (Object)vo.getPackingqty());
            String ownerPacking = null;
            try {
                ownerPacking = RestUtils.doPost((String)ApiServiceEnum.GETBMGOODSPACK.getUrl(), (String)param.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (StringUtils.isEmpty((Object)ownerPacking)) continue;
            BmGoodsPack bmGoodsPack = (BmGoodsPack)JSONObject.parseObject((String)ownerPacking, BmGoodsPack.class);
            vo.setPallethi(bmGoodsPack.getPallethi());
            vo.setPalletti(bmGoodsPack.getPalletti());
            vo.setPalletqty(Double.valueOf(bmGoodsPack.getPalletqty().doubleValue()));
        }
        return ServiceResponse.buildSuccess(invCellGoodListVOS);
    }

    @Override
    public ServiceResponse getInvCellGoodListCell(String entid, String shopid, String cellno) {
        List<InvCellGoodListVO> invCellGoodListVOS = this.invCellQtyMapper.getInvCellGoodListCell(entid, shopid, cellno);
        for (InvCellGoodListVO vo : invCellGoodListVOS) {
            JSONObject param = new JSONObject();
            param.put("entid", (Object)entid);
            param.put("gdcode", (Object)vo.getGdcode());
            param.put("packingqty", (Object)vo.getPackingqty());
            String ownerPacking = null;
            try {
                ownerPacking = RestUtils.doPost((String)ApiServiceEnum.GETBMGOODSPACK.getUrl(), (String)param.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (StringUtils.isEmpty((Object)ownerPacking)) continue;
            BmGoodsPack bmGoodsPack = (BmGoodsPack)JSONObject.parseObject((String)ownerPacking, BmGoodsPack.class);
            vo.setPallethi(bmGoodsPack.getPallethi());
            vo.setPalletti(bmGoodsPack.getPalletti());
            vo.setPalletqty(Double.valueOf(bmGoodsPack.getPalletqty().doubleValue()));
        }
        return ServiceResponse.buildSuccess(invCellGoodListVOS);
    }

    private void updateInvCell(InvLock invlock, InvLocksItem locksItem) {
        Integer lockflag = invlock.getLockflag();
        Criteria criteria = Criteria.where((String)"entid").is((Object)invlock.getEntid()).and("shopid").is((Object)invlock.getShopid()).and("ownerid").is((Object)invlock.getOwnerid()).and("cellno").is((Object)locksItem.getCellno()).and("deptid").is((Object)invlock.getDeptid()).and("gdid").is((Object)locksItem.getGdid()).and("flag").is((Object)SheetFlagEnum.INIT.getFlag()).and("checkstatus").is((Object)0);
        List invcellqtyList = this.getTemplate().select(new Query((CriteriaDefinition)criteria), InvCellQty.class);
        if (!CollectionUtils.isEmpty((Collection)invcellqtyList)) {
            Criteria criter = Criteria.where((String)"entid").is((Object)invlock.getEntid()).and("sheetid").is((Object)invlock.getSheetid());
            List lockItemList = this.invLockItemService.dataQuery(new Query((CriteriaDefinition)criter));
            int row = 0;
            if (!CollectionUtils.isEmpty((Collection)lockItemList)) {
                InvLockItem maxLockItem = lockItemList.stream().max(Comparator.comparing(InvLockItem::getRowno)).get();
                row = maxLockItem.getRowno();
            }
            for (InvCellQty cellQty : invcellqtyList) {
                BigDecimal qty1;
                JSONObject jsonparam;
                InvLockItem invLockItem;
                if (lockflag == 0) {
                    BigDecimal qty12;
                    if (locksItem.getQty().compareTo(BigDecimal.ZERO) != 1) break;
                    BigDecimal tempQty = cellQty.getQty().subtract(cellQty.getOutstockqty()).subtract(cellQty.getFreezeqty());
                    if (tempQty.compareTo(BigDecimal.ZERO) != 1) continue;
                    if (locksItem.getQty().compareTo(tempQty) == 1) {
                        locksItem.setQty(locksItem.getQty().subtract(tempQty));
                        qty12 = tempQty;
                    } else {
                        qty12 = locksItem.getQty();
                        locksItem.setQty(BigDecimal.ZERO);
                    }
                    cellQty.setFreezeqty(cellQty.getFreezeqty().add(qty12));
                    this.onUpdateBean(cellQty, Sets.newHashSet((Object[])new String[]{"freezeqty"}));
                    invLockItem = new InvLockItem();
                    BeanUtils.copyProperties((Object)cellQty, (Object)invLockItem, (String[])new String[]{"id"});
                    invLockItem.setQty(Double.valueOf(qty12.doubleValue()));
                    jsonparam = TypeUtils.toJSONObj((Object)invLockItem, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
                    jsonparam.put("sheetid", (Object)invlock.getSheetid());
                    jsonparam.put("rowno", (Object)(++row));
                    this.invLockItemService.onInsert(jsonparam);
                    continue;
                }
                if (lockflag != 1) continue;
                if (locksItem.getQty().compareTo(BigDecimal.ZERO) != 1) break;
                BigDecimal tempFreeQty = cellQty.getFreezeqty();
                if (tempFreeQty.compareTo(BigDecimal.ZERO) != 1) continue;
                if (locksItem.getQty().compareTo(tempFreeQty) == 1) {
                    qty1 = tempFreeQty;
                    locksItem.setQty(locksItem.getQty().subtract(tempFreeQty));
                } else {
                    qty1 = locksItem.getQty();
                    locksItem.setQty(BigDecimal.ZERO);
                }
                cellQty.setFreezeqty(cellQty.getFreezeqty().multiply(qty1));
                this.onUpdateBean(cellQty, Sets.newHashSet((Object[])new String[]{"freezeqty"}));
                invLockItem = new InvLockItem();
                BeanUtils.copyProperties((Object)cellQty, (Object)invLockItem, (String[])new String[]{"id"});
                invLockItem.setQty(Double.valueOf(qty1.doubleValue()));
                jsonparam = TypeUtils.toJSONObj((Object)invLockItem, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
                jsonparam.put("sheetid", (Object)invlock.getSheetid());
                jsonparam.put("rowno", (Object)(++row));
                this.invLockItemService.onInsert(jsonparam);
            }
        }
    }

    private List<InvCellQty> getInvcellqtys(String entid, String shopid, String ownerid, String cellno, String gdid, String lotid) {
        HashMap map = Maps.newHashMap();
        map.put("entid", entid);
        map.put("shopid", shopid);
        map.put("ownerid", ownerid);
        map.put("cellno", cellno);
        map.put("gdid", gdid);
        map.put("lotid", lotid);
        List invcellqtyList = this.getTemplate().select(QueryUtils.build((Map)map), InvCellQty.class);
        return invcellqtyList;
    }

    private InvCellQty getInvcellqty(String entid, String shopid, String cellno, Integer cellid) {
        JSONObject paramsObject = new JSONObject();
        paramsObject.put("entid", (Object)entid);
        paramsObject.put("shopid", (Object)shopid);
        paramsObject.put("cellno", (Object)cellno);
        paramsObject.put("cellid", (Object)cellid);
        InvCellQty invcellqty = (InvCellQty)this.dataQueryFirst(ServiceSession.getSession(), paramsObject, InvCellQty.class);
        if (invcellqty == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4ed3\u522b[{1}]\u50a8\u4f4d\u4ee3\u7801[{2}]\u50a8\u4f4dID[{3}]\u7684\u50a8\u4f4d\u5e93\u5b58\u4e0d\u5b58\u5728\uff01", entid, shopid, cellno, cellid));
        }
        return invcellqty;
    }

    private void cleanInvCellqty(String entid, String shopid, String cellno) {
        HashMap cleanParam = Maps.newHashMap();
        cleanParam.put("entid", entid);
        cleanParam.put("shopid", shopid);
        cleanParam.put("cellno", cellno);
        cleanParam.put("qty", BigDecimal.ZERO);
        cleanParam.put("instockqty", BigDecimal.ZERO);
        cleanParam.put("outstockqty", BigDecimal.ZERO);
        cleanParam.put("freezeqty", BigDecimal.ZERO);
        int del = this.getTemplate().delete(QueryUtils.build((Map)cleanParam), InvCellQty.class);
        log.info("\u5220\u9664[{}]\u6761\u50a8\u4f4d\u5b58\u50a8\u8bb0\u5f55\uff01\u6761\u4ef6\uff1a{}", (Object)del, (Object)cleanParam);
    }

    private InvCellQty getRealTimeInvcellqtyEntity(RealTimeInvVo realTimeInvVo, InvLotInfo invLotinfo) {
        InvCellQty invcellqty = new InvCellQty();
        BeanUtils.copyProperties((Object)realTimeInvVo, (Object)invcellqty, (String[])new String[]{"operator"});
        this.setInvcellqtyLotInfo(invcellqty, invLotinfo);
        IsceModelUtil.setModeCreator((Object)invcellqty, (String)realTimeInvVo.getOperator());
        IsceModelUtil.setModeCreatetime((Object)invcellqty, (Date)new Date());
        return invcellqty;
    }

    private InvCellQty getMoveInvcellqtyEntity(InvcellqtyMoveVo invcellqtyVo, InvLotInfo invLotinfo) {
        InvCellQty invcellqty = new InvCellQty();
        BeanUtils.copyProperties((Object)invcellqtyVo, (Object)invcellqty, (String[])new String[]{"operator"});
        this.setInvcellqtyLotInfo(invcellqty, invLotinfo);
        IsceModelUtil.setModeCreator((Object)invcellqty, (String)invcellqtyVo.getOperator());
        IsceModelUtil.setModeCreatetime((Object)invcellqty, (Date)new Date());
        return invcellqty;
    }

    private InvCellQty getDedInvcellqtyEntity(DedInvcellqtyOrderVo invcellqtyVo, InvLotInfo invLotinfo) {
        InvCellQty invcellqty = new InvCellQty();
        BeanUtils.copyProperties((Object)invcellqtyVo, (Object)invcellqty, (String[])new String[]{"operator"});
        this.setInvcellqtyLotInfo(invcellqty, invLotinfo);
        IsceModelUtil.setModeCreator((Object)invcellqty, (String)invcellqtyVo.getOperator());
        IsceModelUtil.setModeCreatetime((Object)invcellqty, (Date)new Date());
        return invcellqty;
    }

    private InvCellQty getAddInvcellqtyEntity(InvcellqtyVo invcellqtyVo, InvLotInfo invLotinfo) {
        InvCellQty invcellqty = new InvCellQty();
        BeanUtils.copyProperties((Object)invcellqtyVo, (Object)invcellqty, (String[])new String[]{"operator"});
        this.setInvcellqtyLotInfo(invcellqty, invLotinfo);
        IsceModelUtil.setModeCreator((Object)invcellqty, (String)invcellqtyVo.getOperator());
        IsceModelUtil.setModeCreatetime((Object)invcellqty, (Date)new Date());
        return invcellqty;
    }

    private void setInvcellqtyLotInfo(InvCellQty invcellqty, InvLotInfo invLotinfo) {
        BeanUtils.copyProperties((Object)invLotinfo, (Object)invcellqty, (String[])new String[]{"id"});
    }

    private InvLotInfo getInvLotinfo(String entid, String gdid, String lotid) {
        Criteria criteria = Criteria.where((String)"entid").is((Object)entid).and("gdid").is((Object)gdid).and("lotid").is((Object)lotid);
        InvLotInfo invLotinfo = (InvLotInfo)this.getTemplate().selectOne(QueryUtils.build((Criteria)criteria), InvLotInfo.class);
        return invLotinfo;
    }

    protected Document onBeforeRowInsert(Query query, Update update) {
        return this.onDefaultRowInsert(query, update);
    }
}

