/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invlpn.create;

import com.alibaba.fastjson.JSONObject;
import com.efuture.common.enums.LpnEnum;
import com.efuture.common.utils.ExceptionUtils;
import com.efuture.common.utils.GenRuleCodeUtils;
import com.efuture.common.utils.QueryUtils;
import com.efuture.isce.mdm.code.BsContainer;
import com.efuture.isce.wms.inv.inv.InvLpn;
import com.efuture.isce.wms.inv.inv.InvLpnItem;
import com.efuture.isce.wms.inv.model.entity.InvLotInfo;
import com.efuture.isce.wms.inv.vo.DeliveryLpnCreateVo;
import com.efuture.isce.wms.om.OmExp;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnItemService;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnMasterSalveService;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnService;
import com.efuture.isce.wmsinv.service.invlpn.create.InvLpnCreateService;
import com.google.common.collect.Lists;
import com.product.model.ServiceResponse;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.SpringContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DeliveryLpnServiceImpl
implements InvLpnCreateService<DeliveryLpnCreateVo> {
    private static final Logger log = LoggerFactory.getLogger(DeliveryLpnServiceImpl.class);
    @Autowired
    private InvLpnService invLpnService;
    @Autowired
    private InvLpnItemService invLpnItemService;
    @Autowired
    private InvLpnMasterSalveService invLpnMasterSalveService;
    @Resource
    @Qualifier(value="moreStorageOperation")
    private FMybatisTemplate template;

    @Override
    public String create(DeliveryLpnCreateVo deliveryLpn) throws Exception {
        String entid = deliveryLpn.getEntid();
        String shopid = deliveryLpn.getShopid();
        String lpnname = deliveryLpn.getLpnname();
        String custid = deliveryLpn.getCustid();
        String picktype = deliveryLpn.getPicktype();
        String sourceno = deliveryLpn.getSourceno();
        String refsheettype = deliveryLpn.getRefsheettype();
        String deptid = deliveryLpn.getDeptid();
        String expno = deliveryLpn.getExpno();
        int expid = deliveryLpn.getExpid();
        String gdid = deliveryLpn.getGdid();
        String lotid = deliveryLpn.getLotid();
        Double qty = deliveryLpn.getQty();
        String operator = deliveryLpn.getOperator();
        Criteria criteria = Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("lpnname").is((Object)lpnname).and("flag").nin(new Object[]{13, 23, 43, 93, 73, 53, 41, 83});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = this.invLpnMasterSalveService.dataQuery(query);
        criteria = Criteria.where((String)"entid").is((Object)entid).and("sheetid").is((Object)expno);
        query = new Query((CriteriaDefinition)criteria);
        OmExp omExp = (OmExp)this.template.selectOne(query, OmExp.class);
        if (Objects.isNull(omExp)) {
            log.error("\u67e5\u8be2\u4e0d\u5230\u51fa\u8d27\u5934\u6863\u4fe1\u606f\uff01.{}", (Object)JSONObject.toJSONString((Object)criteria));
            ExceptionUtils.raise((String)"\u67e5\u8be2\u4e0d\u5230\u51fa\u8d27\u5934\u6863\u4fe1\u606f\uff01");
        }
        InvLpnItem invLpnItem = new InvLpnItem();
        invLpnItem.setEntid(entid);
        invLpnItem.setShopid(shopid);
        invLpnItem.setShopname(omExp.getShopname());
        invLpnItem.setOwnerid(omExp.getOwnerid());
        invLpnItem.setOwnername(omExp.getOwnername());
        invLpnItem.setDeptname(omExp.getDeptname());
        invLpnItem.setSourceno(sourceno);
        invLpnItem.setCustid(custid);
        invLpnItem.setDeptid(deptid);
        invLpnItem.setExpno(expno);
        invLpnItem.setExpid(Integer.valueOf(expid));
        invLpnItem.setGdid(gdid);
        InvLotInfo lotInfo = this.getInvLotinfo(entid, gdid, lotid);
        invLpnItem.setGdcode(lotInfo == null ? "" : lotInfo.getGdcode());
        invLpnItem.setGdname(lotInfo == null ? "" : lotInfo.getGdname());
        invLpnItem.setPackingqty(lotInfo == null ? BigDecimal.ZERO : lotInfo.getPackingqty());
        invLpnItem.setSkuspec(lotInfo == null ? "" : lotInfo.getSkuspec());
        invLpnItem.setSkuunit(lotInfo == null ? "" : lotInfo.getSkuunit());
        invLpnItem.setBarcode(lotInfo == null ? "" : lotInfo.getBarcode());
        invLpnItem.setLotid(lotid);
        invLpnItem.setQty(qty);
        invLpnItem.setExpno(expno);
        invLpnItem.setExpid(Integer.valueOf(expid));
        String lpnid = "";
        if (!CollectionUtils.isEmpty((Collection)list)) {
            if (list.size() > 1) {
                log.error("\u67e5\u8be2\u7ed3\u679c\u4e3a\u591a\u6761!{}", (Object)criteria.toString());
                ExceptionUtils.raise((String)"\u67e5\u8be2\u7ed3\u679c\u4e3a\u591a\u6761!");
            } else {
                InvLpn lpn = (InvLpn)list.get(0);
                if (this.verify(lpn)) {
                    lpnid = lpn.getLpnid();
                    log.info("-----Delivery[\u914d\u9001]---lpnid[{}]\u9a8c\u8bc1\u6210\u529f\uff01{}", (Object)lpnid, (Object)JSONObject.toJSONString((Object)deliveryLpn));
                    JSONObject itemParam = new JSONObject();
                    itemParam.put("entid", (Object)entid);
                    itemParam.put("shopid", (Object)shopid);
                    itemParam.put("lpnid", (Object)lpn.getLpnid());
                    List invLpnItemList = this.invLpnItemService.dataQuery(itemParam);
                    int rowno = 1;
                    if (!CollectionUtils.isEmpty((Collection)invLpnItemList)) {
                        rowno = invLpnItemList.stream().mapToInt(InvLpnItem::getRowno).max().getAsInt() + 1;
                    }
                    invLpnItem.setLpnid(lpnid);
                    invLpnItem.setRowno(Integer.valueOf(rowno));
                    this.invLpnItemService.onInsert(invLpnItem);
                }
            }
        } else {
            BsContainer bsContainer = this.getLpntype(entid, "1", 1, lpnname);
            if (Objects.isNull(bsContainer)) {
                log.error("lpnname:{}", (Object)lpnname);
                ExceptionUtils.raise((String)"\u67e5\u8be2\u4e0d\u5230\u5bb9\u5668\u7c7b\u578b\u4fe1\u606f\uff01");
            }
            lpnid = GenRuleCodeUtils.getGenCode((String)"lpnid", (String)LpnEnum.LPN_TYPE.getLpnType());
            InvLpn invLpn = new InvLpn();
            invLpn.setFlag(Integer.valueOf(30));
            invLpn.setOwnerlpnid(lpnid);
            invLpn.setOwnerlpnname(lpnname);
            invLpn.setExpno(expno);
            invLpn.setUsetype(Integer.valueOf(3));
            invLpn.setRefsheetid(sourceno);
            invLpn.setRefsheettype(Integer.valueOf(Integer.parseInt(refsheettype)));
            invLpn.setLpnid(lpnid);
            invLpn.setLpntype(bsContainer.getLpntype());
            invLpn.setLpntypeid(bsContainer.getLpntypeid());
            invLpn.setLpntypename(bsContainer.getLpnname());
            invLpn.setLpnname(lpnname);
            invLpn.setShopid(shopid);
            invLpn.setEntid(entid);
            invLpn.setOwnercustid("N");
            invLpn.setOwnercustname("N");
            invLpn.setCustid("N");
            invLpn.setCustname("N");
            invLpn.setCarrierno("N");
            invLpn.setCarriername("N");
            invLpn.setCellno("N");
            invLpn.setDbsplitcode("1");
            invLpn.setOwnerid(omExp.getOwnerid());
            invLpn.setOwnername(omExp.getOwnername());
            invLpn.setShopname(omExp.getShopname());
            invLpn.setDeptid(omExp.getDeptid());
            invLpn.setDeptname(omExp.getDeptname());
            invLpnItem.setLpnid(lpnid);
            invLpnItem.setRowno(Integer.valueOf(1));
            ArrayList invLpnItemList = Lists.newArrayList((Object[])new InvLpnItem[]{invLpnItem});
            invLpn.setInvlpnitem((List)invLpnItemList);
            this.invLpnMasterSalveService.onInsert(SpringContext.getSession(), invLpn);
        }
        return lpnid;
    }

    @Override
    public boolean verify(InvLpn invLpn) {
        ServiceResponse response = ServiceResponse.buildSuccess(null);
        if (Objects.nonNull(invLpn)) {
            int status = invLpn.getFlag();
            if (Lists.newArrayList((Object[])new Integer[]{10, 11}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u9a8c\u6536\u4e0a\u67b6\u73af\u8282!");
            } else if (Lists.newArrayList((Object[])new Integer[]{20, 21}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u79fb\u5e93\u73af\u8282\u4e2d\u4e14\u79fb\u5e93\u672a\u5b8c\u6210!");
            } else if (Lists.newArrayList((Object[])new Integer[]{41, 42}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u5206\u64ad\u73af\u8282\u4e2d\u4e14\u5206\u64ad\u672a\u5b8c\u6210!");
            } else if (Lists.newArrayList((Object[])new Integer[]{50, 51}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u4ee3\u8fd0\u73af\u8282\u4e2d!");
            } else if (Lists.newArrayList((Object[])new Integer[]{70, 71}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u8fd4\u914d\u73af\u8282\u4e2d!");
            } else if (Lists.newArrayList((Object[])new Integer[]{80, 81}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u9000\u5382\u73af\u8282\u4e2d!");
            } else if (status == 90) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5df2\u5c01\u7b3c!");
            } else if (status == 91) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5df2\u88c5\u8f66");
            }
        }
        return true;
    }

    public InvLotInfo getInvLotinfo(String entid, String gdid, String lotid) {
        Criteria criteria = Criteria.where((String)"entid").is((Object)entid).and("gdid").is((Object)gdid).and("lotid").is((Object)lotid);
        InvLotInfo invLotinfo = (InvLotInfo)this.template.selectOne(QueryUtils.build((Criteria)criteria), InvLotInfo.class);
        return invLotinfo;
    }
}

