/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invlog;

import com.efuture.common.utils.QueryUtils;
import com.efuture.isce.wms.inv.inv.InvCellMove;
import com.efuture.isce.wms.inv.inv.InvCellQty;
import com.efuture.isce.wms.inv.vo.InvcellMoveLogVo;
import com.efuture.isce.wms.stock.InStockItemVo;
import com.efuture.isce.wmsinv.service.invcell.InvCellQtyService;
import com.efuture.isce.wmsinv.service.invlog.InvCellMoveService;
import com.product.config.dynamicds.DynamicJDBCCompomentServiceImpl;
import com.product.storage.template.FMybatisTemplate;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class InvCellMoveServiceImpl
extends DynamicJDBCCompomentServiceImpl<InvCellMove>
implements InvCellMoveService {
    private static final Logger log = LoggerFactory.getLogger(InvCellMoveServiceImpl.class);
    @Autowired
    private InvCellQtyService cellQtyService;

    public InvCellMoveServiceImpl(FMybatisTemplate mybatisTemplate) {
        super(mybatisTemplate, "invcellmove", "id");
    }

    protected Document onBeforeRowInsert(Query query, Update update) {
        return this.onDefaultRowInsert(query, update);
    }

    @Override
    public int addLog(InStockItemVo stockItem) {
        InvCellMove invCellMove;
        String entid = stockItem.getEntid();
        String ownerid = stockItem.getOwnerid();
        String gdid = stockItem.getGdid();
        String shopid = stockItem.getShopid();
        String cellno = stockItem.getCellno();
        Integer cellid = stockItem.getCellid();
        List cellQty = this.cellQtyService.dataQuery(QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("cellno").is((Object)cellno).and("ownerid").is((Object)ownerid).and("gdid").is((Object)gdid)));
        double f_qty = 0.0;
        double f_instockqty = 0.0;
        double f_outstockqty = 0.0;
        String slpnname = stockItem.getLpnname();
        if (CollectionUtils.isNotEmpty((Collection)cellQty)) {
            f_qty = cellQty.stream().mapToDouble(item -> item.getQty().doubleValue()).sum();
            f_instockqty = cellQty.stream().mapToDouble(item -> item.getInstockqty().doubleValue()).sum();
            f_outstockqty = cellQty.stream().mapToDouble(item -> item.getOutstockqty().doubleValue()).sum();
            slpnname = ((InvCellQty)cellQty.get(0)).getLpnname();
        }
        String realcellno = stockItem.getRealcellno();
        Integer realcellid = stockItem.getRealcellid();
        List targetCellQty = this.cellQtyService.dataQuery(QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("cellno").is((Object)realcellno).and("ownerid").is((Object)ownerid).and("gdid").is((Object)gdid)));
        double t_qty = 0.0;
        double t_instockqty = 0.0;
        double t_outstockqty = 0.0;
        String dlpnname = "N";
        if (CollectionUtils.isNotEmpty((Collection)targetCellQty)) {
            t_qty = targetCellQty.stream().mapToDouble(item -> item.getQty().doubleValue()).sum();
            t_instockqty = targetCellQty.stream().mapToDouble(item -> item.getInstockqty().doubleValue()).sum();
            t_outstockqty = targetCellQty.stream().mapToDouble(item -> item.getOutstockqty().doubleValue()).sum();
            dlpnname = ((InvCellQty)targetCellQty.get(0)).getLpnname();
        }
        if ((invCellMove = (InvCellMove)this.dataQueryFirst(QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("ownerid").is((Object)ownerid).and("papertype").is((Object)stockItem.getPapertype()).and("paperno").is((Object)stockItem.getSheetid()).and("gdid").is((Object)gdid).and("scellno").is((Object)cellno).and("dcellno").is((Object)realcellno).and("deptid").is((Object)stockItem.getDeptid())))) == null) {
            invCellMove = new InvCellMove();
            BeanUtils.copyProperties((Object)stockItem, (Object)invCellMove, (String[])new String[]{"id"});
            invCellMove.setPaperno(stockItem.getSheetid());
            invCellMove.setScellno(cellno);
            invCellMove.setScellid(cellid);
            invCellMove.setScontainerno(slpnname);
            invCellMove.setDcellno(realcellno);
            invCellMove.setDcellid(realcellid);
            invCellMove.setMoveqty(BigDecimal.valueOf(stockItem.getRealqty()));
            invCellMove.setPackingqty(BigDecimal.valueOf(stockItem.getPackingqty()));
            invCellMove.setDcontainerno(dlpnname);
        }
        invCellMove.setDeptid(stockItem.getDeptid());
        invCellMove.setDeptname(stockItem.getDeptname());
        invCellMove.setSfirstqty(new BigDecimal(f_qty));
        invCellMove.setSfirstinstockqty(new BigDecimal(f_instockqty));
        invCellMove.setSfirstoutstockqty(new BigDecimal(f_outstockqty));
        invCellMove.setDfirstqty(new BigDecimal(t_qty));
        invCellMove.setDfirstinstockqty(new BigDecimal(t_instockqty));
        invCellMove.setDfirstoutstockqty(new BigDecimal(t_outstockqty));
        invCellMove.setMoveqty(invCellMove.getMoveqty().add(BigDecimal.valueOf(stockItem.getRealqty())));
        if (invCellMove.getId() == null) {
            this.onInsert(invCellMove);
        } else {
            this.onUpdate(invCellMove);
        }
        return 1;
    }

    @Override
    public InvcellMoveLogVo createMoveLog(InvCellQty fmCellQty, InvCellQty tarCellQty, BigDecimal qty, String sheetid, Integer papertype, String operator) {
        if (papertype == null) {
            return null;
        }
        InvcellMoveLogVo moveLog = new InvcellMoveLogVo();
        moveLog.setEntid(fmCellQty.getEntid());
        moveLog.setShopid(fmCellQty.getShopid());
        moveLog.setOwnerid(fmCellQty.getOwnerid());
        moveLog.setGdid(fmCellQty.getGdid());
        moveLog.setDeptid(fmCellQty.getDeptid());
        moveLog.setLotid(fmCellQty.getLotid());
        moveLog.setQty(qty);
        moveLog.setScellno(fmCellQty.getCellno());
        moveLog.setScellid(fmCellQty.getCellid());
        moveLog.setSQty(this.getDefDecimal(fmCellQty.getQty()));
        moveLog.setSInstockqty(this.getDefDecimal(fmCellQty.getInstockqty()));
        moveLog.setSOutstockqty(this.getDefDecimal(fmCellQty.getOutstockqty()));
        if (tarCellQty != null) {
            moveLog.setDcellno(tarCellQty.getCellno());
            moveLog.setDcellid(tarCellQty.getCellid());
            moveLog.setDQty(this.getDefDecimal(tarCellQty.getQty()));
            moveLog.setDInstockqty(this.getDefDecimal(tarCellQty.getInstockqty()));
            moveLog.setDOutstockqty(this.getDefDecimal(tarCellQty.getOutstockqty()));
        }
        moveLog.setPaperno(sheetid);
        moveLog.setOperator(operator);
        return moveLog;
    }

    private BigDecimal getDefDecimal(BigDecimal qty) {
        if (qty == null) {
            return BigDecimal.ZERO;
        }
        return qty;
    }
}

