/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invlpn.create;

import com.alibaba.fastjson.JSONObject;
import com.efuture.common.enums.LpnEnum;
import com.efuture.common.utils.ExceptionUtils;
import com.efuture.common.utils.GenRuleCodeUtils;
import com.efuture.isce.mdm.code.BsContainer;
import com.efuture.isce.wms.im.ImImportSum;
import com.efuture.isce.wms.inv.inv.InvLpn;
import com.efuture.isce.wms.inv.vo.DivideLpnCreateVo;
import com.efuture.isce.wms.stock.OmOutStocksItem;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnService;
import com.efuture.isce.wmsinv.service.invlpn.create.InvLpnCreateService;
import com.google.common.collect.Lists;
import com.product.model.ServiceResponse;
import com.product.storage.template.FMybatisTemplate;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DivideLpnServiceImpl
implements InvLpnCreateService<DivideLpnCreateVo> {
    private static final Logger log = LoggerFactory.getLogger(DivideLpnServiceImpl.class);
    @Autowired
    private InvLpnService invLpnService;
    @Resource
    @Qualifier(value="moreStorageOperation")
    private FMybatisTemplate template;

    @Override
    public String create(DivideLpnCreateVo divideLpn) throws Exception {
        log.info("\u5206\u64ad\u6807\u7b7e\u751f\u6210\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)divideLpn));
        String entid = divideLpn.getEntid();
        String shopid = divideLpn.getShopid();
        String lpnname = divideLpn.getLpnname();
        String venderid = divideLpn.getVenderid();
        int lpndevtype = divideLpn.getLpndevtype();
        int refsheettype = divideLpn.getRefsheettype();
        String deptid = divideLpn.getDeptid();
        String operator = divideLpn.getOperator();
        Criteria criteria = null;
        criteria = lpndevtype == 1 ? Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("lpnname").is((Object)lpnname).and("usetype").is((Object)4).and("flag").nin(new Object[]{13, 23, 30, 93, 43, 73, 83, 53}) : Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("lpnname").is((Object)lpnname).and("usetype").is((Object)4).and("flag").nin(new Object[]{13, 23, 93, 43, 73, 83, 53});
        Query query = new Query((CriteriaDefinition)criteria);
        InvLpn invLpn = null;
        String lpnid = "";
        List invLpnList = this.invLpnService.dataQuery(query);
        if (!CollectionUtils.isEmpty((Collection)invLpnList)) {
            if (invLpnList.size() > 1) {
                log.error("\u67e5\u8be2\u7ed3\u679c\u4e3a\u591a\u6761!{}", (Object)criteria.toString());
                ExceptionUtils.raise((String)"\u67e5\u8be2\u7ed3\u679c\u4e3a\u591a\u6761!");
            } else {
                invLpn = (InvLpn)invLpnList.get(0);
            }
            if (this.verify(invLpn)) {
                lpnid = invLpn.getLpnid();
                log.info("-----Distribution[\u5206\u64ad]---lpnid[{}]\u9a8c\u8bc1\u6210\u529f\uff01{}", (Object)lpnid, (Object)JSONObject.toJSONString((Object)divideLpn));
            }
        } else {
            BsContainer bsContainer = this.getLpntype(entid, "1", 1, lpnname);
            if (Objects.isNull(bsContainer)) {
                log.error("lpnname:{}", (Object)lpnname);
                ExceptionUtils.raise((String)"\u67e5\u8be2\u4e0d\u5230\u5bb9\u5668\u7c7b\u578b\u4fe1\u606f\uff01");
            }
            criteria = Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("lpnname").is((Object)lpnname);
            query = new Query((CriteriaDefinition)criteria);
            String ownerid = "";
            String ownername = "";
            String shopname = "";
            String deptname = "";
            if (lpndevtype == 0) {
                List outStocksItemList = this.template.select(query, OmOutStocksItem.class);
                if (!CollectionUtils.isEmpty((Collection)outStocksItemList)) {
                    ownerid = ((OmOutStocksItem)outStocksItemList.get(0)).getOwnerid();
                    ownername = ((OmOutStocksItem)outStocksItemList.get(0)).getOwnername();
                    shopname = ((OmOutStocksItem)outStocksItemList.get(0)).getShopname();
                    deptid = ((OmOutStocksItem)outStocksItemList.get(0)).getDeptid();
                    deptname = ((OmOutStocksItem)outStocksItemList.get(0)).getDeptname();
                } else {
                    ExceptionUtils.raise((String)MessageFormat.format("\u67e5\u8be2\u4e0d\u5230\u660e\u7ec6\u6c47\u603b\u5355\uff01{0}", JSONObject.toJSONString((Object)query)));
                }
            } else {
                criteria = Criteria.where((String)"entid").is((Object)entid).and("sheetid").is((Object)divideLpn.getSheetid());
                query = new Query((CriteriaDefinition)criteria);
                ImImportSum imImportSum = (ImImportSum)this.template.selectOne(query, ImImportSum.class);
                if (Objects.nonNull(imImportSum)) {
                    ownerid = imImportSum.getOwnerid();
                    ownername = imImportSum.getOwnername();
                    shopname = imImportSum.getShopname();
                    deptid = imImportSum.getDeptid();
                    deptname = imImportSum.getDeptname();
                } else {
                    ExceptionUtils.raise((String)MessageFormat.format("\u67e5\u8be2\u4e0d\u5230\u8fdb\u8d27\u6c47\u603b\u5355\uff01{0}", JSONObject.toJSONString((Object)query)));
                }
            }
            lpnid = GenRuleCodeUtils.getGenCode((String)"lpnid", (String)LpnEnum.LPN_TYPE.getLpnType());
            invLpn = new InvLpn();
            invLpn.setFlag(Integer.valueOf(40));
            invLpn.setOwnerlpnid(lpnid);
            invLpn.setOwnerlpnname(lpnname);
            invLpn.setUsetype(Integer.valueOf(4));
            invLpn.setLpndevtype(Integer.valueOf(lpndevtype));
            invLpn.setRefsheetid(divideLpn.getSheetid());
            invLpn.setRefsheettype(Integer.valueOf(refsheettype));
            invLpn.setDeptid(deptid);
            invLpn.setLpnid(lpnid);
            invLpn.setLpntype(bsContainer.getLpntype());
            invLpn.setLpntypeid(bsContainer.getLpntypeid());
            invLpn.setLpntypename(bsContainer.getLpnname());
            invLpn.setLpnname(lpnname);
            invLpn.setShopid(shopid);
            invLpn.setEntid(entid);
            invLpn.setOwnercustid("N");
            invLpn.setOwnercustname("N");
            invLpn.setCustid("N");
            invLpn.setCustname("N");
            invLpn.setCarrierno("N");
            invLpn.setCarriername("N");
            invLpn.setCellno("N");
            invLpn.setDbsplitcode("1");
            invLpn.setOwnerid(ownerid);
            invLpn.setOwnername(ownername);
            invLpn.setShopname(shopname);
            invLpn.setDeptid(deptid);
            invLpn.setDeptname(deptname);
            this.invLpnService.onInsert(invLpn);
        }
        return lpnid;
    }

    @Override
    public boolean verify(InvLpn invLpn) {
        ServiceResponse response = ServiceResponse.buildSuccess(null);
        if (Objects.nonNull(invLpn)) {
            int status = invLpn.getFlag();
            if (status == 10) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u9a8c\u6536\u4e0a\u67b6\u73af\u8282!");
            } else if (status == 11) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u4e0a\u67b6\u4e2d!");
            } else if (Lists.newArrayList((Object[])new Integer[]{20, 21}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u79fb\u5e93\u73af\u8282\u4e2d\u4e14\u79fb\u5e93\u672a\u5b8c\u6210!");
            } else if (Lists.newArrayList((Object[])new Integer[]{50, 51}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u4ee3\u8fd0\u73af\u8282\u4e2d!");
            } else if (Lists.newArrayList((Object[])new Integer[]{30, 31}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u914d\u9001\u73af\u8282\u4e2d!");
            } else if (Lists.newArrayList((Object[])new Integer[]{70, 71}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u8fd4\u914d\u73af\u8282\u4e2d!");
            } else if (Lists.newArrayList((Object[])new Integer[]{80, 81}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u9000\u5382\u73af\u8282\u4e2d!");
            } else if (status == 90) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5df2\u5c01\u7b3c!");
            } else if (status == 91) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5df2\u88c5\u8f66");
            }
        }
        return true;
    }
}

