/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invlpn;

import com.efuture.common.enums.VerifyStatus;
import com.efuture.common.utils.QueryUtils;
import com.efuture.isce.wms.inv.inv.InvLpn;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnLogService;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnService;
import com.product.config.dynamicds.DynamicJDBCCompomentServiceImpl;
import com.product.model.ServiceSession;
import com.product.storage.template.FMybatisTemplate;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class InvLpnServiceImpl
extends DynamicJDBCCompomentServiceImpl<InvLpn>
implements InvLpnService {
    private static final Logger log = LoggerFactory.getLogger(InvLpnServiceImpl.class);
    @Autowired
    private InvLpnLogService lpnLogService;

    public InvLpnServiceImpl(FMybatisTemplate mybatisTemplate) {
        super(mybatisTemplate, "invlpn", "id");
    }

    protected Document onBeforeRowInsert(Query query, Update update) {
        return this.onDefaultRowInsert(query, update);
    }

    @Override
    public int batchDelete(String entid, String shopid, List<String> lpnid) {
        return this.getTemplate().delete((Object)QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("lpnid").in(lpnid)));
    }

    protected void onBeforeDelete(ServiceSession session, Criteria criteria) {
        List invLpns = this.dataQuery(QueryUtils.build((Criteria)criteria));
        if (CollectionUtils.isNotEmpty((Collection)invLpns)) {
            invLpns.forEach(invLpn -> this.lpnLogService.log((InvLpn)invLpn, VerifyStatus.REJECT.value()));
        }
    }
}

