/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invcell;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.efuture.common.annotation.Key;
import com.efuture.common.annotation.Keys;
import com.efuture.common.annotation.RedisLock;
import com.efuture.common.annotation.RedisMultiLock;
import com.efuture.common.rocketmq.producer.MQProducerService;
import com.efuture.common.transaction.TransactionAfter;
import com.efuture.common.utils.DateUtils;
import com.efuture.common.utils.ExceptionUtils;
import com.efuture.common.utils.QueryUtils;
import com.efuture.isce.mdm.exposedapi.BmGoodsDubboService;
import com.efuture.isce.mdm.exposedapi.MdmDubboApi;
import com.efuture.isce.mdm.goods.BmGoodsPack;
import com.efuture.isce.mdm.warehouse.BmShopDc;
import com.efuture.isce.wms.conf.cmcell.CmCellMove;
import com.efuture.isce.wms.conf.exposedapi.WmsConfApi;
import com.efuture.isce.wms.conf.para.GlobPara;
import com.efuture.isce.wms.hm.HmOutStockItem;
import com.efuture.isce.wms.hm.HmOutStocksItem;
import com.efuture.isce.wms.im.ImCheckSumItem;
import com.efuture.isce.wms.inv.dto.InvCellWarningDTO;
import com.efuture.isce.wms.inv.inv.InvCellMove;
import com.efuture.isce.wms.inv.inv.InvCellQty;
import com.efuture.isce.wms.inv.model.entity.InvLock;
import com.efuture.isce.wms.inv.model.entity.InvLockItem;
import com.efuture.isce.wms.inv.model.entity.InvLocksItem;
import com.efuture.isce.wms.inv.model.entity.InvLot;
import com.efuture.isce.wms.inv.model.entity.InvLotInfo;
import com.efuture.isce.wms.inv.model.entity.InvLotItem;
import com.efuture.isce.wms.inv.vo.CmCellQtyCacheVO;
import com.efuture.isce.wms.inv.vo.CmCellQtyVo;
import com.efuture.isce.wms.inv.vo.DedInvcellqtyOrderVo;
import com.efuture.isce.wms.inv.vo.DedInvcellqtyVo;
import com.efuture.isce.wms.inv.vo.InvCellFreezeVo;
import com.efuture.isce.wms.inv.vo.InvCellGoodListVO;
import com.efuture.isce.wms.inv.vo.InvCellGoodsQtyVO;
import com.efuture.isce.wms.inv.vo.InvLotProVo;
import com.efuture.isce.wms.inv.vo.InvcellFreezeqtyVO;
import com.efuture.isce.wms.inv.vo.InvcellMoveLogVo;
import com.efuture.isce.wms.inv.vo.InvcellqtyMoveVo;
import com.efuture.isce.wms.inv.vo.InvcellqtyOrderVo;
import com.efuture.isce.wms.inv.vo.InvcellqtyVo;
import com.efuture.isce.wms.inv.vo.RealTimeInvVo;
import com.efuture.isce.wms.om.OmDivideItem;
import com.efuture.isce.wms.om.OmDividesItem;
import com.efuture.isce.wms.reverse.um.UmCheckSumItem;
import com.efuture.isce.wms.reverse.wm.WmOutStockItem;
import com.efuture.isce.wms.reverse.wm.WmOutStocksItem;
import com.efuture.isce.wms.stock.OmOutStockItem;
import com.efuture.isce.wms.stock.OmOutStocksItem;
import com.efuture.isce.wms.task.vo.ShowHomePageVo;
import com.efuture.isce.wmsinv.enums.SheetFlagEnum;
import com.efuture.isce.wmsinv.mapper.Inv.InvCellQtyMapper;
import com.efuture.isce.wmsinv.rocketmq.callback.InvMQSendCallBack;
import com.efuture.isce.wmsinv.service.invcell.InvCellQtyService;
import com.efuture.isce.wmsinv.service.invcell.InvLockItemService;
import com.efuture.isce.wmsinv.service.invcell.InvLockService;
import com.efuture.isce.wmsinv.service.invlog.InvCellMoveService;
import com.efuture.isce.wmsinv.service.invlotinfo.InvLotInfoService;
import com.efuture.isce.wmsinv.utils.StaticCellIdUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.product.config.dynamicds.DynamicJDBCCompomentServiceImpl;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.model.isce.BaseEntityModel;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.SpringContext;
import com.product.util.TypeUtils;
import com.product.util.UniqueID;
import com.shiji.core.exception.BaseException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.rocketmq.client.producer.SendCallback;
import org.assertj.core.util.Lists;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InvCellQtyServiceImpl
extends DynamicJDBCCompomentServiceImpl<InvCellQty>
implements InvCellQtyService {
    private static final Logger log = LoggerFactory.getLogger(InvCellQtyServiceImpl.class);
    @Autowired
    private InvCellMoveService invCellMoveService;
    @Autowired
    private InvLockService invLockService;
    @Autowired
    private InvLockItemService invLockItemService;
    @Autowired
    private InvCellQtyMapper invCellQtyMapper;
    @DubboReference
    private BmGoodsDubboService bmGoodsDubboService;
    @Autowired
    private InvLotInfoService invLotInfoService;
    @Autowired
    private MQProducerService producerService;
    @Autowired
    private TransactionAfter transactionAfter;
    @DubboReference
    private WmsConfApi wmsConfApi;
    @DubboReference
    private MdmDubboApi mdmDubboApi;
    @Autowired
    private StaticCellIdUtils staticCellIdUtils;
    @Autowired
    private InvMQSendCallBack sendCallBack;

    public InvCellQtyServiceImpl(FMybatisTemplate mybatisTemplate) {
        super(mybatisTemplate, "invcellqty", "id");
    }

    @Override
    public boolean existCellQty(String entid, String shopid, String cellno) {
        Query build = QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("cellno").is((Object)cellno));
        long count = super.count(build);
        return count > 0L;
    }

    @Override
    public Integer getMaxCellid(String entid, String shopid, String cellno) {
        JSONObject paramObj = new JSONObject();
        paramObj.put("entid", (Object)entid);
        paramObj.put("shopid", (Object)shopid);
        paramObj.put("cellno", (Object)cellno);
        Integer cellid = (Integer)this.max(paramObj, "cellid");
        if (cellid == null) {
            cellid = 0;
        }
        return cellid;
    }

    private Integer getMaxCellidInner(String entid, String shopid, String cellno) {
        return this.staticCellIdUtils.onIncrementName(entid, shopid, cellno);
    }

    @Override
    @RedisLock(prefix="invCellQty")
    @Transactional(rollbackFor={Exception.class})
    public Integer addInvCell(@Key(expr="#invcellqtyVo.entid +'-'+ #invcellqtyVo.shopid +'-'+ #invcellqtyVo.cellno") InvcellqtyVo invcellqtyVo) {
        return this.addInvCell(invcellqtyVo, null);
    }

    @Override
    @RedisLock(prefix="invCellQty")
    @Transactional(rollbackFor={Exception.class})
    public Integer addInvCell(@Key(expr="#invcellqtyVo.entid +'-'+ #invcellqtyVo.shopid +'-'+ #invcellqtyVo.cellno") InvcellqtyVo invcellqtyVo, Integer papertype) {
        InvCellQty invcellqty;
        Integer cellid;
        String ownerid = invcellqtyVo.getOwnerid();
        String gdid = invcellqtyVo.getGdid();
        InvLotInfo invLotinfo = this.getInvLotinfo(invcellqtyVo.getEntid(), ownerid, gdid, invcellqtyVo.getLotid());
        if (invLotinfo == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4e0b\u6ca1\u6709gdid\u4e3a[{1}]\u5546\u54c1\u5c5e\u6027ID\u4e3a[{2}]\u7684\u4fe1\u606f\uff01[{3}]", invcellqtyVo.getEntid(), invcellqtyVo.getGdid(), invcellqtyVo.getLotid(), "addInvCell"));
        }
        String entid = invcellqtyVo.getEntid();
        String shopid = invcellqtyVo.getShopid();
        String cellno = invcellqtyVo.getCellno();
        BigDecimal qty = invcellqtyVo.getQty();
        JSONObject paramMap = new JSONObject();
        paramMap.put("entid", (Object)entid);
        paramMap.put("shopid", (Object)shopid);
        paramMap.put("cellno", (Object)cellno);
        if (invcellqtyVo.getCellid() != -1) {
            cellid = invcellqtyVo.getCellid();
            paramMap.put("cellid", (Object)cellid);
            invcellqty = (InvCellQty)this.getTemplate().selectOne(QueryUtils.build((Map)paramMap), InvCellQty.class);
            if (invcellqty == null) {
                invcellqty = this.getAddInvcellqtyEntity(invcellqtyVo, invLotinfo);
                this.onInsert(ServiceSession.getSession(), invcellqty);
            } else {
                invcellqty.setQty(invcellqty.getQty().add(qty));
                Update update = Update.update((String)"qty", (Object)invcellqty.getQty()).set("modifier", (Object)invcellqtyVo.getOperator()).set("modifytime", (Object)new Date());
                this.getTemplate().update(QueryUtils.build((Criteria)Criteria.where((String)"id").is((Object)invcellqty.getId())), update, InvCellQty.class);
            }
        } else {
            cellid = this.getMaxCellidInner(entid, shopid, cellno);
            invcellqty = this.getAddInvcellqtyEntity(invcellqtyVo, invLotinfo);
            invcellqty.setCellid(cellid);
            this.onInsert(invcellqty);
        }
        if (papertype != null) {
            InvCellQty fmCellQty = new InvCellQty();
            BeanUtils.copyProperties((Object)invcellqty, (Object)fmCellQty);
            fmCellQty.setQty(invcellqty.getQty().subtract(qty));
            InvcellMoveLogVo moveLog = this.invCellMoveService.createMoveLog(fmCellQty, invcellqty, qty, invcellqtyVo.getRefsheetid(), papertype, invcellqtyVo.getOperator());
            this.invCellMoveLog(moveLog);
        }
        if (qty.compareTo(BigDecimal.ZERO) < 0) {
            this.cleanInvCellqty(entid, shopid, cellno);
        }
        return invcellqty.getCellid();
    }

    @Override
    @RedisMultiLock(prefix="invCellQty")
    @Transactional(rollbackFor={Exception.class})
    public InvCellQty invCellOrder(@Keys(exprs={"#invcellqtyOrderVo.entid +'-'+ #invcellqtyOrderVo.shopid +'-'+ #invcellqtyOrderVo.cellno", "#invcellqtyOrderVo.entid +'-'+ #invcellqtyOrderVo.shopid +'-'+ #invcellqtyOrderVo.targetCellno"}) InvcellqtyOrderVo invcellqtyOrderVo) {
        InvCellQty tarInvcellqty;
        String entid = invcellqtyOrderVo.getEntid();
        String shopid = invcellqtyOrderVo.getShopid();
        String ownerid = invcellqtyOrderVo.getOwnerid();
        String gdid = invcellqtyOrderVo.getGdid();
        String lotid = invcellqtyOrderVo.getLotid();
        String cellno = invcellqtyOrderVo.getCellno();
        Integer cellid = invcellqtyOrderVo.getCellid();
        String targetCellno = invcellqtyOrderVo.getTargetCellno();
        BigDecimal qty = invcellqtyOrderVo.getQty();
        String targetDeptid = invcellqtyOrderVo.getTargetDeptid();
        InvLotInfo invLotinfo = this.getInvLotinfo(entid, ownerid, gdid, lotid);
        if (invLotinfo == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4e0b\u6ca1\u6709gdid\u4e3a[{1}]\u5546\u54c1\u5c5e\u6027ID\u4e3a[{2}]\u7684\u4fe1\u606f\uff01[{3}]", invcellqtyOrderVo.getEntid(), invcellqtyOrderVo.getGdid(), invcellqtyOrderVo.getLotid(), "invCellOrder"));
        }
        InvCellQty invcellqty = this.getInvcellqty(entid, shopid, cellno, cellid);
        invcellqty.setOutstockqty(invcellqty.getOutstockqty().add(qty));
        this.onUpdateBean(invcellqty, (Set<String>)Sets.newHashSet((Object[])new String[]{"outstockqty"}));
        HashMap tmap = Maps.newHashMap();
        tmap.put("entid", entid);
        tmap.put("shopid", shopid);
        tmap.put("cellno", StringUtils.isEmpty((Object)targetCellno) ? "-1" : targetCellno);
        tmap.put("ownerid", ownerid);
        tmap.put("gdid", gdid);
        tmap.put("lotid", lotid);
        tmap.put("lpnname", invcellqtyOrderVo.getLpnname());
        tmap.put("instocktype", invcellqtyOrderVo.getInstocktype());
        tmap.put("deptid", targetDeptid);
        List tarInvcellqtyList = this.getTemplate().select(QueryUtils.build((Map)tmap), InvCellQty.class);
        if (!CollectionUtils.isEmpty((Collection)tarInvcellqtyList)) {
            tarInvcellqty = (InvCellQty)tarInvcellqtyList.get(0);
            Update update = Update.update((String)"instockqty", (Object)tarInvcellqty.getInstockqty().add(qty));
            Criteria criteria = Criteria.where((String)"id").is((Object)tarInvcellqty.getId());
            Query query = new Query((CriteriaDefinition)criteria);
            this.getTemplate().update(query, update, InvCellQty.class);
        } else {
            InvCellQty invcell = this.getAddInvcellqtyEntity((InvcellqtyVo)invcellqtyOrderVo, invLotinfo);
            invcell.setCellid(this.getMaxCellidInner(entid, shopid, targetCellno));
            invcell.setCellno(targetCellno);
            invcell.setQty(BigDecimal.ZERO);
            invcell.setOutstockqty(BigDecimal.ZERO);
            invcell.setInstockqty(qty);
            invcell.setDeptid(targetDeptid);
            invcell.setDeptname(invcellqtyOrderVo.getTargetDeptname());
            this.onInsert(ServiceSession.getSession(), invcell);
            tarInvcellqty = invcell;
        }
        return tarInvcellqty;
    }

    @Override
    @RedisMultiLock(prefix="invCellQty")
    @Transactional(rollbackFor={Exception.class})
    public void dedInvCellOrder(@Keys(exprs={"#dedInvQtyOrderVo.entid +'-'+ #dedInvQtyOrderVo.shopid +'-'+ #dedInvQtyOrderVo.cellno", "#dedInvQtyOrderVo.entid +'-'+ #dedInvQtyOrderVo.shopid +'-'+ #dedInvQtyOrderVo.targetCellno"}) DedInvcellqtyOrderVo dedInvQtyOrderVo, Integer papertype) {
        InvCellQty tarInvcellqty;
        String sheetid = dedInvQtyOrderVo.getSheetid();
        String entid = dedInvQtyOrderVo.getEntid();
        String shopid = dedInvQtyOrderVo.getShopid();
        String cellno = dedInvQtyOrderVo.getCellno();
        Integer cellid = dedInvQtyOrderVo.getCellid();
        String targetCellno = dedInvQtyOrderVo.getTargetCellno();
        BigDecimal qty = dedInvQtyOrderVo.getQty();
        BigDecimal preQty = dedInvQtyOrderVo.getPreQty();
        InvCellQty fmCellQty = this.getInvcellqty(entid, shopid, cellno, cellid);
        Integer tarCellid = dedInvQtyOrderVo.getTargetCellId();
        String globpara = this.wmsConfApi.getGlobParaValue(entid, shopid, "CONTAINER", null);
        log.info("\u51cf\u6263\u9884\u7ea6\u5e93\u5b58 CONTAINER \u53c2\u6570\u8bbe\u7f6e\u503c\uff1a{}", (Object)globpara);
        String lpnname = dedInvQtyOrderVo.getTargetCellno();
        if ("20".equals(globpara)) {
            lpnname = dedInvQtyOrderVo.getLpnname();
        }
        if (tarCellid == -1) {
            tarCellid = this.getMaxCellidInner(entid, shopid, targetCellno);
            tarInvcellqty = new InvCellQty();
            BeanUtils.copyProperties((Object)fmCellQty, (Object)tarInvcellqty, (String[])new String[]{"id"});
            tarInvcellqty.setCellid(tarCellid);
            tarInvcellqty.setCellno(targetCellno);
            tarInvcellqty.setLpnname(lpnname);
            tarInvcellqty.setDeptid(dedInvQtyOrderVo.getDeptid());
            tarInvcellqty.setDeptname(dedInvQtyOrderVo.getDeptname());
        } else {
            tarInvcellqty = this.getInvcellqty(entid, shopid, targetCellno, tarCellid);
        }
        if (papertype != null) {
            InvcellMoveLogVo moveLog = this.invCellMoveService.createMoveLog(fmCellQty, tarInvcellqty, qty, sheetid, papertype, dedInvQtyOrderVo.getOperator());
            this.invCellMoveLog(moveLog);
        }
        fmCellQty.setQty(fmCellQty.getQty().subtract(qty));
        BigDecimal tempOutQty = fmCellQty.getOutstockqty().subtract(preQty);
        if (tempOutQty.compareTo(BigDecimal.ZERO) < 0) {
            log.info(">>>>>\u6263\u51cf\u9884\u7ea6\u5e93\u5b58\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a[{}]\uff0c---fmCellQty:[{}],preQty:{}", new Object[]{JSONObject.toJSONString((Object)dedInvQtyOrderVo), JSONObject.toJSONString((Object)fmCellQty), preQty});
            ExceptionUtils.raise((String)MessageFormat.format("\u9884\u7ea6\u6263\u51cf\u5e93\u5b58\u4e0b\u67b6\u6570\u4e3a\u8d1f\u503c\uff01cellno:[{0}],cellid[{1}]", cellno, cellid));
        }
        fmCellQty.setOutstockqty(tempOutQty);
        this.onUpdateBean(fmCellQty, (Set<String>)Sets.newHashSet((Object[])new String[]{"qty", "outstockqty"}));
        if (tarInvcellqty.getId() == null) {
            tarInvcellqty.setQty(qty.add(preQty));
            tarInvcellqty.setCreator(dedInvQtyOrderVo.getOperator());
            tarInvcellqty.setModifier(dedInvQtyOrderVo.getOperator());
            this.onInsert(tarInvcellqty);
        } else {
            tarInvcellqty.setQty(tarInvcellqty.getQty().add(qty));
            tarInvcellqty.setInstockqty(tarInvcellqty.getInstockqty().subtract(preQty));
            tarInvcellqty.setLpnname(lpnname);
            this.onUpdateBean(tarInvcellqty, (Set<String>)Sets.newHashSet((Object[])new String[]{"qty", "instockqty", "lpnname"}));
        }
        this.cleanInvCellqty(entid, shopid, cellno);
        this.cleanInvCellqty(entid, shopid, targetCellno);
    }

    @Override
    @RedisMultiLock(prefix="invCellQty")
    @Transactional(rollbackFor={Exception.class})
    public Integer invCellMove(@Keys(exprs={"#invcellqtyMoveVo.entid +'-'+ #invcellqtyMoveVo.shopid +'-'+ #invcellqtyMoveVo.cellno", "#invcellqtyMoveVo.entid +'-'+ #invcellqtyMoveVo.shopid +'-'+ #invcellqtyMoveVo.targetCellno"}) InvcellqtyMoveVo invcellqtyMoveVo, Integer papertype) {
        InvCellQty tarInvcellqty;
        Integer tarCellid;
        String entid = invcellqtyMoveVo.getEntid();
        String shopid = invcellqtyMoveVo.getShopid();
        String sheetid = invcellqtyMoveVo.getSheetid();
        BigDecimal qty = invcellqtyMoveVo.getQty();
        String cellno = invcellqtyMoveVo.getCellno();
        Integer cellid = invcellqtyMoveVo.getCellid();
        String targetCellno = invcellqtyMoveVo.getTargetCellno();
        InvCellQty fmCellQty = this.getInvcellqty(entid, shopid, cellno, cellid);
        String gdid = fmCellQty.getGdid();
        String lotid = fmCellQty.getLotid();
        String ownerid = fmCellQty.getOwnerid();
        InvLotInfo invLotinfo = this.getInvLotinfo(invcellqtyMoveVo.getEntid(), ownerid, gdid, lotid);
        if (invLotinfo == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4e0b\u6ca1\u6709gdid\u4e3a[{1}]\u5546\u54c1\u5c5e\u6027ID\u4e3a[{2}]\u7684\u4fe1\u606f\uff01", entid, gdid, lotid));
        }
        String globpara = this.wmsConfApi.getGlobParaValue(entid, shopid, "CONTAINER", null);
        String lpnname = invcellqtyMoveVo.getTargetCellno();
        if ("20".equals(globpara)) {
            lpnname = invcellqtyMoveVo.getLpnname();
        }
        if ((tarCellid = invcellqtyMoveVo.getTargetCellId()) == -1) {
            tarCellid = this.getMaxCellidInner(entid, shopid, targetCellno);
            tarInvcellqty = this.getMoveInvcellqtyEntity(invcellqtyMoveVo, invLotinfo);
            tarInvcellqty.setCellid(tarCellid);
            tarInvcellqty.setCellno(invcellqtyMoveVo.getTargetCellno());
            tarInvcellqty.setLpnname(lpnname);
            tarInvcellqty.setQty(BigDecimal.ZERO);
        } else {
            tarInvcellqty = this.getInvcellqty(entid, shopid, targetCellno, tarCellid);
            tarInvcellqty.setLpnname(lpnname);
        }
        if (papertype != null) {
            InvcellMoveLogVo moveLog = this.invCellMoveService.createMoveLog(fmCellQty, tarInvcellqty, qty, sheetid, papertype, invcellqtyMoveVo.getOperator());
            this.invCellMoveLog(moveLog);
        }
        fmCellQty.setQty(fmCellQty.getQty().subtract(qty));
        fmCellQty.setLpnname(lpnname);
        this.onUpdateBean(fmCellQty, (Set<String>)Sets.newHashSet((Object[])new String[]{"qty", "lpnname"}));
        if (tarInvcellqty.getId() == null) {
            tarInvcellqty.setQty(qty);
            this.onInsert(tarInvcellqty);
        } else {
            tarInvcellqty.setQty(tarInvcellqty.getQty().add(qty));
            this.onUpdateBean(tarInvcellqty, (Set<String>)Sets.newHashSet((Object[])new String[]{"qty", "lpnname"}));
        }
        this.cleanInvCellqty(entid, shopid, cellno);
        this.cleanInvCellqty(entid, shopid, targetCellno);
        return tarCellid;
    }

    @Override
    @RedisLock(prefix="invCellQty")
    @Transactional(rollbackFor={Exception.class})
    public void dedInvCell(@Key(expr="#dedInvcellqtyVo.entid +'-'+ #dedInvcellqtyVo.shopid +'-'+ #dedInvcellqtyVo.cellno") DedInvcellqtyVo dedInvcellqtyVo, Integer papertype) {
        String entid = dedInvcellqtyVo.getEntid();
        String shopid = dedInvcellqtyVo.getShopid();
        String ownerid = dedInvcellqtyVo.getOwnerid();
        String gdid = dedInvcellqtyVo.getGdid();
        String cellno = dedInvcellqtyVo.getCellno();
        String sheetid = dedInvcellqtyVo.getSheetid();
        String operator = dedInvcellqtyVo.getOperator();
        ArrayList moveLogList = Lists.newArrayList();
        List<InvCellQty> invcellqtyList = this.getInvcellqtys(entid, shopid, ownerid, cellno, gdid, dedInvcellqtyVo.getLotid());
        if (invcellqtyList.isEmpty()) {
            log.error("\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u4ee3\u6263\u5e93\u5b58\u8bb0\u5f55![cellno:{},ownerid:{},gdid:{}]", new Object[]{cellno, ownerid, gdid});
            ExceptionUtils.raise((String)MessageFormat.format("\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u4ee3\u6263\u5e93\u5b58\u8bb0\u5f55\uff01[cellno:{0},ownerid:{1},gdid:{2}]", cellno, ownerid, gdid));
        }
        BigDecimal tempQty = dedInvcellqtyVo.getQty();
        for (InvCellQty c : invcellqtyList) {
            if (tempQty.compareTo(BigDecimal.ZERO) <= 0) break;
            if (tempQty.subtract(c.getQty()).compareTo(BigDecimal.ZERO) > 0) {
                moveLogList.add(this.invCellMoveService.createMoveLog(c, null, c.getQty(), sheetid, papertype, operator));
                tempQty = tempQty.subtract(c.getQty());
                c.setQty(BigDecimal.ZERO);
            } else {
                moveLogList.add(this.invCellMoveService.createMoveLog(c, null, tempQty, sheetid, papertype, operator));
                BigDecimal qty = c.getQty().subtract(tempQty);
                c.setQty(qty);
                tempQty = BigDecimal.ZERO;
            }
            this.onUpdateBean(c, (Set<String>)Sets.newHashSet((Object[])new String[]{"qty"}));
        }
        if (tempQty.compareTo(BigDecimal.ZERO) > 0) {
            log.error("\u5e93\u5b58\u4e0d\u8db3\u4ee5\u6263\u51cf\uff01[{}]", (Object)JSON.toJSONString((Object)dedInvcellqtyVo));
            ExceptionUtils.raise((String)MessageFormat.format("\u5e93\u5b58\u4e0d\u8db3\u4ee5\u6263\u51cf\uff01{0}", JSON.toJSONString((Object)dedInvcellqtyVo)));
        }
        if (papertype != null) {
            moveLogList.forEach(this::invCellMoveLog);
        }
        this.cleanInvCellqty(entid, shopid, cellno);
    }

    @Override
    @RedisMultiLock(prefix="invCellQty")
    @Transactional(rollbackFor={Exception.class})
    public void realTimeInvMove(@Keys(exprs={"#realTimeInvVo.entid +'-'+ #realTimeInvVo.shopid +'-'+ #realTimeInvVo.cellno", "#realTimeInvVo.entid +'-'+ #realTimeInvVo.shopid +'-'+ #realTimeInvVo.targetCellno"}) RealTimeInvVo realTimeInvVo, Integer papertype) {
        InvCellQty tarCellQty;
        InvCellQty fmCellQty;
        String entid = realTimeInvVo.getEntid();
        String shopid = realTimeInvVo.getShopid();
        String sheetid = realTimeInvVo.getSheetid();
        String gdId = realTimeInvVo.getGdid();
        String lotId = realTimeInvVo.getLotid();
        String ownerid = realTimeInvVo.getOwnerid();
        InvLotInfo invLotinfo = this.getInvLotinfo(entid, ownerid, gdId, lotId);
        if (invLotinfo == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4e0b\u6ca1\u6709gdid\u4e3a[{1}]\u5546\u54c1\u5c5e\u6027ID\u4e3a[{2}]\u7684\u4fe1\u606f\uff01", entid, gdId, lotId));
        }
        String globpara = this.wmsConfApi.getGlobParaValue(entid, shopid, "CONTAINER", null);
        String lpnname = realTimeInvVo.getTargetCellno();
        if ("20".equals(globpara)) {
            lpnname = realTimeInvVo.getLpnname();
        }
        if (realTimeInvVo.getCellid() == -1) {
            Integer cellid = this.getMaxCellidInner(entid, shopid, realTimeInvVo.getCellno());
            fmCellQty = this.getRealTimeInvcellqtyEntity(realTimeInvVo, invLotinfo);
            fmCellQty.setCellid(cellid);
            fmCellQty.setLpnname(lpnname);
            fmCellQty.setQty(BigDecimal.ZERO);
        } else {
            fmCellQty = this.getInvcellqty(entid, shopid, realTimeInvVo.getCellno(), realTimeInvVo.getCellid());
            fmCellQty.setLpnname(lpnname);
        }
        List<InvCellQty> invcellqtys = this.getInvcellqtys(entid, shopid, ownerid, realTimeInvVo.getTargetCellno(), gdId, lotId);
        if (CollectionUtils.isEmpty(invcellqtys)) {
            Integer cellid = this.getMaxCellidInner(entid, shopid, realTimeInvVo.getTargetCellno());
            tarCellQty = this.getRealTimeInvcellqtyEntity(realTimeInvVo, invLotinfo);
            tarCellQty.setCellid(cellid);
            tarCellQty.setCellno(realTimeInvVo.getTargetCellno());
            tarCellQty.setLpnname(lpnname);
            tarCellQty.setQty(BigDecimal.ZERO);
        } else {
            tarCellQty = invcellqtys.get(0);
            tarCellQty.setLpnname(lpnname);
            realTimeInvVo.setTargetCellId(tarCellQty.getCellid());
        }
        if (papertype != null) {
            InvcellMoveLogVo moveLog = this.invCellMoveService.createMoveLog(fmCellQty, tarCellQty, realTimeInvVo.getQty(), sheetid, papertype, realTimeInvVo.getOperator());
            this.invCellMoveLog(moveLog);
        }
        if (fmCellQty.getId() == null) {
            fmCellQty.setQty(realTimeInvVo.getQty());
            this.onInsert(fmCellQty);
        } else {
            fmCellQty.setQty(fmCellQty.getQty().add(realTimeInvVo.getQty()));
            this.onUpdateBean(fmCellQty, (Set<String>)Sets.newHashSet((Object[])new String[]{"qty", "lpnname"}));
        }
        if (tarCellQty.getId() == null) {
            tarCellQty.setQty(realTimeInvVo.getQty().multiply(new BigDecimal(-1)));
            this.onInsert(tarCellQty);
        } else {
            tarCellQty.setQty(tarCellQty.getQty().subtract(realTimeInvVo.getQty()));
            this.onUpdateBean(tarCellQty, (Set<String>)Sets.newHashSet((Object[])new String[]{"qty", "lpnname"}));
        }
        this.cleanInvCellqty(realTimeInvVo.getEntid(), realTimeInvVo.getShopid(), realTimeInvVo.getCellno());
        this.cleanInvCellqty(realTimeInvVo.getEntid(), realTimeInvVo.getShopid(), realTimeInvVo.getTargetCellno());
    }

    @Override
    @RedisLock(prefix="invCellQty")
    public void deleteCellQty(@Key(expr="#param[entid] +'-'+ #param[shopid] +'-'+ #param[cellno]") JSONObject param) {
        super.onDelete(param);
    }

    @Override
    public List<InvCellGoodsQtyVO> selectInvCellGoodsQty(String entid, String shopid, String ownerid, String deptid, List<String> gdids) {
        return this.invCellQtyMapper.selectInvCellQtyGrpGoods(entid, shopid, deptid, ownerid, gdids);
    }

    @Override
    public List<CmCellQtyCacheVO> selectCellQtyCache(String entid, String shopid) {
        Query build = QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid));
        build.fields().include("id").include("entid").include("shopid").include("cellno").include("cellid").include("ownerid").include("gdid").include("lpnname").include("lotid").include("lot01").include("lot02").include("lot03").include("lot04").include("lot05").include("lot06").include("lot07").include("lot08").include("lot09").include("lot10").include("lot11").include("lot12").include("lot13").include("lot14").include("lot15").include("lot16").include("lot17").include("lot18").include("lot19").include("lot20");
        return this.getTemplate().select(build, CmCellQtyCacheVO.class, this.getCollectionName());
    }

    @Override
    public List<CmCellQtyVo> selectInvCellQty(String entid, String shopid, String deptid, String ownerid, List<String> gdids) {
        return this.invCellQtyMapper.selectInvCellQty(entid, shopid, deptid, ownerid, gdids);
    }

    @Override
    public List<CmCellQtyVo> pcsTrialInvQty(String entid, String shopid, String ownerid, List<String> gdids, String deptid, List<String> defdeptids) {
        return this.invCellQtyMapper.pcsTrialIvnQty(entid, shopid, ownerid, gdids, deptid, defdeptids);
    }

    @Override
    public List<InvCellWarningDTO> selectInvWarning(String entid, String shopid, String ownerid, List<String> gdids) {
        return this.invCellQtyMapper.selectInvWarning(entid, shopid, ownerid, gdids);
    }

    @Override
    public List<ShowHomePageVo> selectInvWarningDetail(String entid, String shopid, String ownerid, List<String> gdids) {
        return this.invCellQtyMapper.selectInvWarningDetail(entid, shopid, ownerid, gdids);
    }

    @Override
    public List<InvCellWarningDTO> selectInvWarning(String entid, String shopid, List<String> cellnos) {
        return this.invCellQtyMapper.selectInvWarningByCellno(entid, shopid, cellnos);
    }

    @Override
    public void invCellMoveLog(InvcellMoveLogVo invcellMoveVo) {
        String gdid = invcellMoveVo.getGdid();
        String lotid = invcellMoveVo.getLotid();
        String ownerid = invcellMoveVo.getOwnerid();
        InvLotInfo invLotinfo = this.getInvLotinfo(invcellMoveVo.getEntid(), ownerid, gdid, lotid);
        if (StringUtils.isEmpty((Object)invcellMoveVo.getScellno())) {
            invcellMoveVo.setScellno("N");
        }
        if (StringUtils.isEmpty((Object)invcellMoveVo.getDcellno())) {
            invcellMoveVo.setDcellno("N");
        }
        this.cellMoveInterd(invcellMoveVo, invLotinfo, "S");
        this.cellMoveInterd(invcellMoveVo, invLotinfo, "T");
        HashMap map = Maps.newHashMap();
        map.put("entid", invcellMoveVo.getEntid());
        map.put("shopid", invcellMoveVo.getShopid());
        map.put("ownerid", invcellMoveVo.getOwnerid());
        map.put("papertype", invcellMoveVo.getPapertype());
        map.put("paperno", invcellMoveVo.getPaperno());
        map.put("gdid", invcellMoveVo.getGdid());
        map.put("lotid", invcellMoveVo.getLotid());
        map.put("scellno", invcellMoveVo.getScellno());
        map.put("scellid", invcellMoveVo.getScellid());
        map.put("dcellno", invcellMoveVo.getDcellno());
        map.put("dcellid", invcellMoveVo.getDcellid());
        map.put("deptid", invcellMoveVo.getDeptid());
        InvCellMove invcellmove = (InvCellMove)this.getTemplate().selectOne(QueryUtils.build((Map)map), InvCellMove.class);
        if (invcellmove == null) {
            invcellmove = new InvCellMove();
            BeanUtils.copyProperties((Object)invcellMoveVo, (Object)invcellmove, (String[])new String[]{"id", "modifier", "modifytime"});
            BeanUtils.copyProperties((Object)invLotinfo, (Object)invcellmove, (String[])new String[]{"id", "modifier", "modifytime"});
            invcellmove.setMoveqty(invcellMoveVo.getQty());
            invcellmove.setScontainerno("N");
            invcellmove.setSfirstqty(invcellMoveVo.getSQty());
            invcellmove.setSfirstinstockqty(invcellMoveVo.getSInstockqty());
            invcellmove.setSfirstoutstockqty(invcellMoveVo.getSOutstockqty());
            invcellmove.setDcontainerno("N");
            invcellmove.setDfirstqty(invcellMoveVo.getDQty());
            invcellmove.setDfirstinstockqty(invcellMoveVo.getDInstockqty());
            invcellmove.setDfirstoutstockqty(invcellMoveVo.getDOutstockqty());
            invcellmove.setCreatetime(new Date());
            this.invCellMoveService.onInsert(invcellmove);
        } else {
            invcellmove.setSfirstqty(invcellmove.getSfirstqty().add(invcellMoveVo.getSQty()));
            invcellmove.setSfirstinstockqty(invcellmove.getSfirstinstockqty().add(invcellMoveVo.getSInstockqty()));
            invcellmove.setSfirstoutstockqty(invcellmove.getSfirstoutstockqty().add(invcellMoveVo.getSOutstockqty()));
            invcellmove.setDfirstqty(invcellmove.getDfirstqty().add(invcellMoveVo.getDQty()));
            invcellmove.setDfirstinstockqty(invcellmove.getDfirstinstockqty().add(invcellMoveVo.getDInstockqty()));
            invcellmove.setDfirstoutstockqty(invcellmove.getDfirstoutstockqty().add(invcellMoveVo.getDOutstockqty()));
            invcellmove.setMoveqty(invcellmove.getMoveqty().add(invcellMoveVo.getQty()));
            invcellmove.setModifytime(new Date());
            int row = this.invCellMoveService.onUpdateBean(invcellmove, Sets.newHashSet((Object[])new String[]{"sfirstqty", "sfirstinstockqty", "sfirstoutstockqty", "dfirstqty", "dfirstinstockqty", "dfirstoutstockqty", "moveqty"}));
            if (row != 1) {
                log.error("\u50a8\u4f4d\u5f02\u52a8\u65e5\u5fd7\u66f4\u65b0\u5931\u8d25![id={}]", (Object)invcellmove.getId());
                ExceptionUtils.raise((String)"\u50a8\u4f4d\u5f02\u52a8\u65e5\u5fd7\u66f4\u65b0\u5931\u8d25\uff01");
            }
        }
    }

    private void cellMoveInterd(InvcellMoveLogVo invcellMoveVo, InvLotInfo invLotinfo, String direct) {
        JSONObject paramObj = new JSONObject();
        paramObj.put("entid", (Object)invcellMoveVo.getEntid());
        paramObj.put("papertype", (Object)invcellMoveVo.getPapertype());
        paramObj.put("shopid", (Object)invcellMoveVo.getShopid());
        if ("S".equals(direct)) {
            paramObj.put("cellno", (Object)invcellMoveVo.getScellno());
        } else if ("T".equals(direct)) {
            paramObj.put("cellno", (Object)invcellMoveVo.getDcellno());
        }
        paramObj.put("ownerid", (Object)invcellMoveVo.getOwnerid());
        paramObj.put("gdid", (Object)invcellMoveVo.getGdid());
        CmCellMove sCmCellMove = (CmCellMove)this.getTemplate().selectOne(QueryUtils.build((Map)paramObj), CmCellMove.class);
        if (Objects.isNull(sCmCellMove)) {
            ServiceSession session = SpringContext.getSession();
            CmCellMove cmCellMove = new CmCellMove();
            BeanUtils.copyProperties((Object)invcellMoveVo, (Object)cmCellMove, (String[])new String[]{"id"});
            if ("S".equals(direct)) {
                cmCellMove.setCellno(invcellMoveVo.getScellno());
            } else if ("T".equals(direct)) {
                cmCellMove.setCellno(invcellMoveVo.getDcellno());
            }
            cmCellMove.setId(Long.valueOf(UniqueID.getUniqueID((boolean)true)));
            String plantype = Lists.list((Object[])new Integer[]{100, 102, 103, 105, 106}).contains(invcellMoveVo.getPapertype()) ? "IM" : (Lists.list((Object[])new Integer[]{200, 202, 203, 206}).contains(invcellMoveVo.getPapertype()) ? "OM" : (Lists.list((Object[])new Integer[]{101, 107}).contains(invcellMoveVo.getPapertype()) ? "UM" : (Lists.list((Object[])new Integer[]{201, 207}).contains(invcellMoveVo.getPapertype()) ? "WM" : (Lists.list((Object[])new Integer[]{108, 208, 210, 250}).contains(invcellMoveVo.getPapertype()) ? "PCS" : "HM"))));
            cmCellMove.setPlantype(plantype);
            cmCellMove.setOwnername(invLotinfo.getOwnername());
            cmCellMove.setGdcode(invLotinfo.getGdcode());
            cmCellMove.setGdname(invLotinfo.getGdname());
            cmCellMove.setDbsplitcode(invLotinfo.getDbsplitcode());
            cmCellMove.setEditor(session == null ? "" : session.getUser_name());
            cmCellMove.setEditdate(new Date());
            cmCellMove.setYddate(DateUtils.str2Date((String)DateUtils.date2Str((Date)new Date(), (String[])new String[]{"yyyy-MM-dd"}), (String[])new String[]{"yyyy-MM-dd"}));
            this.getTemplate().insert((Object)cmCellMove, "cmcellmove");
        } else {
            Criteria criteria = Criteria.where((String)"id").is((Object)sCmCellMove.getId());
            Query query = Query.query((CriteriaDefinition)criteria);
            Update update = Update.update((String)"yddate", (Object)new Date()).set("editor", (Object)invcellMoveVo.getOperator()).set("editdate", (Object)new Date());
            this.getTemplate().update(query, update, CmCellMove.class);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void invCellFreeze(InvCellFreezeVo invCellFreezeVo) {
        HashMap map = Maps.newHashMap();
        map.put("entid", invCellFreezeVo.getEntid());
        map.put("shopid", invCellFreezeVo.getShopid());
        map.put("ownerid", invCellFreezeVo.getOwnerid());
        map.put("sheetid", invCellFreezeVo.getSheetid());
        if (invCellFreezeVo.getFlag() == 0) {
            Update update = Update.update((String)"flag", (Object)SheetFlagEnum.CANCEL.getFlag());
            int row = this.getTemplate().update(QueryUtils.build((Map)map), update, InvLock.class);
            if (row != 1) {
                log.error("\u4f5c\u5e9f\u64cd\u4f5c\u5f02\u5e38:{}", (Object)map);
                ExceptionUtils.raise((String)"\u4f5c\u5e9f\u5f02\u5e38\uff01");
            }
        } else if (invCellFreezeVo.getFlag() == 1) {
            InvLock invlock = (InvLock)this.getTemplate().selectOne(QueryUtils.build((Map)map), InvLock.class);
            if (invlock == null) {
                ExceptionUtils.raise((String)MessageFormat.format("\u65e0\u4f01\u4e1a[{0}]\u5355\u636e[{1}]\u7684\u5e93\u5b58\u9501\u5b9a\u8bb0\u5f55\uff01", invCellFreezeVo.getEntid(), invCellFreezeVo.getSheetid()));
            }
            if (invlock.getFlag().equals(SheetFlagEnum.CANCEL.getFlag()) || invlock.getFlag().equals(SheetFlagEnum.AUDIT.getFlag())) {
                ExceptionUtils.raise((String)"\u5e93\u5b58\u9501\u5b9a\u8bb0\u5f55\u5df2\u4f5c\u5e9f\u6216\u5df2\u6838\u5ba1\uff01");
            }
            List invlocks = this.getTemplate().select(QueryUtils.build((Map)map), InvLocksItem.class);
            invlocks.forEach(l -> this.updateInvCell(invlock, (InvLocksItem)l));
            invlock.setFlag(SheetFlagEnum.AUDIT.getFlag());
            invlock.setChecker(invCellFreezeVo.getOperator());
            invlock.setCheckdate(new Date());
            this.invLockService.onUpdateBean(invlock, Sets.newHashSet((Object[])new String[]{"flag", "checker", "checkdate"}));
        } else {
            ExceptionUtils.raise((String)MessageFormat.format("\u5904\u7406\u6807\u8bb0\u5f02\u5e38[{0}]\uff01\u4e3a\u975e0/1", invCellFreezeVo.getFlag()));
        }
    }

    @Override
    @RedisLock(prefix="invCellQty")
    @Transactional(rollbackFor={Exception.class})
    public void invCellFreezeQty(@Key(expr="#invcellFreezeqtyVO.entid +'-'+ #invcellFreezeqtyVO.shopid +'-'+ #invcellFreezeqtyVO.cellno") InvcellFreezeqtyVO invcellFreezeqtyVO) {
        Query build = QueryUtils.build((Criteria)Criteria.where((String)"entid").is((Object)invcellFreezeqtyVO.getEntid()).and("shopid").is((Object)invcellFreezeqtyVO.getShopid()).and("cellno").is((Object)invcellFreezeqtyVO.getCellno()).and("cellid").is((Object)invcellFreezeqtyVO.getCellid()));
        build.fields().include("id").include("entid").include("freezeqty");
        InvCellQty cellQty = (InvCellQty)this.dataQueryFirst(build);
        if (ObjectUtils.isNotEmpty((Object)cellQty)) {
            cellQty.setFreezeqty(cellQty.getFreezeqty().add(invcellFreezeqtyVO.getQty()));
            super.onUpdateBean((Object)cellQty, (Set)Sets.newHashSet((Object[])new String[]{"freezeqty"}));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void invLotProAdj(InvLotProVo invLotProVo) {
        HashMap param = Maps.newHashMap();
        param.put("entid", invLotProVo.getEntid());
        param.put("sheetid", invLotProVo.getSheetid());
        if (invLotProVo.getFlag() == 0) {
            Update update = Update.update((String)"flag", (Object)SheetFlagEnum.CANCEL.getFlag()).set("checker", (Object)invLotProVo.getOperator()).set("checkdate", (Object)new Date());
            int row = this.getTemplate().update(QueryUtils.build((Map)param), update, InvLot.class);
            if (row != 1) {
                ExceptionUtils.raise((String)"\u66f4\u65b0\u6279\u6b21\u5c5e\u6027\u8c03\u6574\u5355\u636e\u5f02\u5e38\uff01");
            }
        } else if (invLotProVo.getFlag() == 1) {
            InvLot invlot = (InvLot)this.getTemplate().selectOne(QueryUtils.build((Map)param), InvLot.class);
            if (Objects.isNull(invlot)) {
                log.info("\u65e0\u6279\u6b21\u5c5e\u6027\u8c03\u6574\u5355\u636e\u8bb0\u5f55\uff01\u6761\u4ef6[{}]", (Object)param);
                return;
            }
            if (invlot.getFlag().equals(SheetFlagEnum.CANCEL.getFlag()) || invlot.getFlag().equals(SheetFlagEnum.AUDIT.getFlag())) {
                ExceptionUtils.raise((String)MessageFormat.format("\u6279\u6b21\u5c5e\u6027\u8c03\u6574\u5355\u636e[{0}]\u5df2\u4f5c\u5e9f\u6216\u88ab\u5ba1\u6838\uff01", invlot.getSheetid()));
            }
            Criteria lotItemCri = Criteria.where((String)"entid").is((Object)invLotProVo.getEntid()).and("sheetid").is((Object)invLotProVo.getSheetid());
            List invlotitemList = this.getTemplate().select(new Query((CriteriaDefinition)lotItemCri), InvLotItem.class);
            if (!CollectionUtils.isEmpty((Collection)invlotitemList)) {
                for (InvLotItem invLotItem : invlotitemList) {
                    Criteria criteria = Criteria.where((String)"entid").is((Object)invLotProVo.getEntid()).and("gdid").is((Object)invLotItem.getGdid()).and("lotid").is((Object)invLotItem.getLotid()).and("flag").lt((Object)13);
                    Query query = new Query((CriteriaDefinition)criteria);
                    List outStockItemList = this.getTemplate().select(query, OmOutStockItem.class);
                    List hmOutStockItemList = this.getTemplate().select(query, HmOutStockItem.class);
                    List divideItemList = this.getTemplate().select(query, OmDivideItem.class);
                    if (!CollectionUtils.isEmpty((Collection)outStockItemList) || !CollectionUtils.isEmpty((Collection)hmOutStockItemList) || !CollectionUtils.isEmpty((Collection)divideItemList)) continue;
                    Criteria cri = Criteria.where((String)"entid").is((Object)invLotProVo.getEntid()).and("gdid").is((Object)invLotItem.getGdid()).and("lotid").is((Object)invLotItem.getLotid());
                    Update update = Update.update((String)"barcode", (Object)invLotItem.getBarcode()).set("packingqty", (Object)invLotItem.getPackingqty()).set("lot01", (Object)invLotItem.getLot01()).set("lot02", (Object)invLotItem.getLot02()).set("lot03", (Object)invLotItem.getLot03()).set("lot04", (Object)invLotItem.getLot04()).set("lot05", (Object)invLotItem.getLot05()).set("lot06", (Object)invLotItem.getLot06()).set("lot07", (Object)invLotItem.getLot07()).set("lot08", (Object)invLotItem.getLot08()).set("lot09", (Object)invLotItem.getLot09()).set("lot10", (Object)invLotItem.getLot10()).set("lot11", (Object)invLotItem.getLot11()).set("lot12", (Object)invLotItem.getLot12()).set("lot13", (Object)invLotItem.getLot13()).set("lot14", (Object)invLotItem.getLot14()).set("lot15", (Object)invLotItem.getLot15()).set("lot16", (Object)invLotItem.getLot16()).set("lot17", (Object)invLotItem.getLot17()).set("lot18", (Object)invLotItem.getLot18()).set("lot19", (Object)invLotItem.getLot19()).set("lot20", (Object)invLotItem.getLot20());
                    Query q = new Query((CriteriaDefinition)cri);
                    this.getTemplate().update(q, update, InvLotInfo.class);
                    this.getTemplate().update(q, update, InvCellQty.class);
                    List outStockItems = this.getTemplate().select(q, OmOutStockItem.class);
                    if (!CollectionUtils.isEmpty((Collection)outStockItems)) {
                        String sheetid = "";
                        for (Object item : outStockItems) {
                            if (!sheetid.equals(item.getSheetid())) continue;
                            Criteria tempCri = Criteria.where((String)"entid").is((Object)item.getEntid()).and("gdid").is((Object)item.getGdid()).and("sheetid").is((Object)item.getSheetid());
                            Query tempQ = new Query((CriteriaDefinition)tempCri);
                            this.getTemplate().update(tempQ, update, OmOutStocksItem.class);
                            sheetid = item.getSheetid();
                        }
                    }
                    this.getTemplate().update(q, update, OmOutStockItem.class);
                    List divideItems = this.getTemplate().select(q, OmDivideItem.class);
                    if (!CollectionUtils.isEmpty((Collection)divideItems)) {
                        Object item;
                        String sheetid = "";
                        item = divideItems.iterator();
                        while (item.hasNext()) {
                            OmDivideItem item2 = (OmDivideItem)item.next();
                            if (!sheetid.equals(item2.getSheetid())) continue;
                            Criteria tempCri = Criteria.where((String)"entid").is((Object)item2.getEntid()).and("gdid").is((Object)item2.getGdid()).and("sheetid").is((Object)item2.getSheetid());
                            Query tempQ = new Query((CriteriaDefinition)tempCri);
                            this.getTemplate().update(tempQ, update, OmDividesItem.class);
                            sheetid = item2.getSheetid();
                        }
                    }
                    this.getTemplate().update(q, update, OmDivideItem.class);
                    List hmOutStockItems = this.getTemplate().select(q, HmOutStockItem.class);
                    if (!CollectionUtils.isEmpty((Collection)hmOutStockItems)) {
                        String sheetid = "";
                        for (HmOutStockItem item : hmOutStockItems) {
                            if (!sheetid.equals(item.getSheetid())) continue;
                            Criteria tempCri = Criteria.where((String)"entid").is((Object)item.getEntid()).and("gdid").is((Object)item.getGdid()).and("sheetid").is((Object)item.getSheetid());
                            Query tempQ = new Query((CriteriaDefinition)tempCri);
                            this.getTemplate().update(tempQ, update, HmOutStocksItem.class);
                            sheetid = item.getSheetid();
                        }
                    }
                    this.getTemplate().update(q, update, HmOutStockItem.class);
                    List wmOutStockItems = this.getTemplate().select(q, WmOutStockItem.class);
                    if (!CollectionUtils.isEmpty((Collection)wmOutStockItems)) {
                        String sheetid = "";
                        for (WmOutStockItem item : wmOutStockItems) {
                            if (!sheetid.equals(item.getSheetid())) continue;
                            Criteria tempCri = Criteria.where((String)"entid").is((Object)item.getEntid()).and("gdid").is((Object)item.getGdid()).and("sheetid").is((Object)item.getSheetid());
                            Query tempQ = new Query((CriteriaDefinition)tempCri);
                            this.getTemplate().update(tempQ, update, WmOutStocksItem.class);
                            sheetid = item.getSheetid();
                        }
                    }
                    this.getTemplate().update(q, update, WmOutStockItem.class);
                    this.getTemplate().update(q, update, ImCheckSumItem.class);
                    this.getTemplate().update(q, update, UmCheckSumItem.class);
                }
            }
            Update update = Update.update((String)"flag", (Object)SheetFlagEnum.AUDIT.getFlag()).set("checker", (Object)invLotProVo.getOperator()).set("checkdate", (Object)new Date());
            this.getTemplate().update(QueryUtils.build((Map)param), update, InvLot.class);
        } else {
            ExceptionUtils.raise((String)"\u5904\u7406\u6807\u8bb0\u5f02\u5e38\uff01\u975e[0/1]");
        }
    }

    @Override
    public List<InvCellQty> selectCellQty(Map param) {
        return this.dataQueryTotal(QueryUtils.build((Map)param));
    }

    @Override
    public ServiceResponse getInvCellGoodList(String entid, String shopid, String ownerid, String gdid) {
        List<InvCellGoodListVO> invCellGoodListVOS = this.invCellQtyMapper.getInvCellGoodList(entid, shopid, ownerid, gdid);
        for (InvCellGoodListVO vo : invCellGoodListVOS) {
            BmGoodsPack bmGoodsPack = this.bmGoodsDubboService.getBmGoodsPackOne(entid, vo.getGdcode(), Double.valueOf(vo.getPackingqty().doubleValue()));
            Optional.ofNullable(bmGoodsPack).orElseThrow(() -> new BaseException("\u67e5\u8be2\u5546\u54c1\u5305\u88c5\u4fe1\u606f\u4e3a\u7a7a!"));
            vo.setPallethi(bmGoodsPack.getPallethi());
            vo.setPalletti(bmGoodsPack.getPalletti());
            vo.setPalletqty(Double.valueOf(bmGoodsPack.getPalletqty().doubleValue()));
        }
        return ServiceResponse.buildSuccess(invCellGoodListVOS);
    }

    @Override
    public List<InvCellQty> getInvCellGoodAll(InvCellQty dto, GlobPara globPara) {
        ArrayList<InvCellQty> invCellQtyList = new ArrayList<InvCellQty>();
        List<InvCellQty> invCellQties = this.invCellQtyMapper.getInvCellGoodAll(dto.getEntid(), dto.getShopid(), dto.getOwnerid(), dto.getDeptid(), dto.getCellno(), dto.getGdid());
        ArrayList<String> groupField = new ArrayList<String>();
        groupField.add("shopid");
        groupField.add("ownerid");
        groupField.add("deptid");
        groupField.add("cellno");
        groupField.add("lotid");
        groupField.add("gdid");
        if ("20".equals(null == globPara ? "N" : globPara.getParavalue())) {
            groupField.add("lpnname");
        }
        Map<String, List<InvCellQty>> map = invCellQties.stream().collect(Collectors.groupingBy(item -> {
            ArrayList fieldValue = Lists.newArrayList();
            for (String fieldName : groupField) {
                try {
                    Field field = item.getClass().getDeclaredField(fieldName);
                    field.setAccessible(true);
                    Object lot = field.get(item);
                    if (!Objects.nonNull(lot)) continue;
                    fieldValue.add((String)lot);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
            return String.join((CharSequence)"-", fieldValue);
        }));
        for (Map.Entry<String, List<InvCellQty>> entry : map.entrySet()) {
            InvCellQty invCellQty = new InvCellQty();
            List<InvCellQty> invCellQties1 = entry.getValue();
            invCellQty = invCellQties1.get(0);
            invCellQty.setQty(invCellQties1.stream().map(InvCellQty::getQty).reduce(BigDecimal.ZERO, BigDecimal::add));
            invCellQty.setOutstockqty(invCellQties1.stream().map(InvCellQty::getOutstockqty).reduce(BigDecimal.ZERO, BigDecimal::add));
            invCellQty.setInstockqty(invCellQties1.stream().map(InvCellQty::getInstockqty).reduce(BigDecimal.ZERO, BigDecimal::add));
            invCellQty.setFreezeqty(invCellQties1.stream().map(InvCellQty::getFreezeqty).reduce(BigDecimal.ZERO, BigDecimal::add));
            invCellQtyList.add(invCellQty);
        }
        return invCellQtyList;
    }

    @Override
    public List<InvCellQty> getInvCellGood(InvCellQty dto) {
        ArrayList<InvCellQty> invCellQtyList = new ArrayList<InvCellQty>();
        List<InvCellQty> invCellQties = this.invCellQtyMapper.getInvCellGoodAll(dto.getEntid(), dto.getShopid(), dto.getOwnerid(), dto.getDeptid(), dto.getCellno(), dto.getGdid());
        ArrayList<String> groupField = new ArrayList<String>();
        groupField.add("shopid");
        groupField.add("ownerid");
        groupField.add("deptid");
        groupField.add("cellno");
        groupField.add("gdid");
        Map<String, List<InvCellQty>> map = invCellQties.stream().collect(Collectors.groupingBy(item -> {
            ArrayList fieldValue = Lists.newArrayList();
            for (String fieldName : groupField) {
                try {
                    Field field = item.getClass().getDeclaredField(fieldName);
                    field.setAccessible(true);
                    Object lot = field.get(item);
                    if (!Objects.nonNull(lot)) continue;
                    fieldValue.add((String)lot);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
            return String.join((CharSequence)"-", fieldValue);
        }));
        for (Map.Entry<String, List<InvCellQty>> entry : map.entrySet()) {
            List<InvCellQty> invCellQties1 = entry.getValue();
            InvCellQty invCellQty = invCellQties1.get(0);
            invCellQty.setQty(invCellQties1.stream().map(InvCellQty::getQty).reduce(BigDecimal.ZERO, BigDecimal::add));
            invCellQty.setOutstockqty(invCellQties1.stream().map(InvCellQty::getOutstockqty).reduce(BigDecimal.ZERO, BigDecimal::add));
            invCellQty.setInstockqty(invCellQties1.stream().map(InvCellQty::getInstockqty).reduce(BigDecimal.ZERO, BigDecimal::add));
            invCellQty.setFreezeqty(invCellQties1.stream().map(InvCellQty::getFreezeqty).reduce(BigDecimal.ZERO, BigDecimal::add));
            invCellQtyList.add(invCellQty);
        }
        return invCellQtyList;
    }

    @Override
    public ServiceResponse getInvCellGoodListCell(String entid, String shopid, String cellno) {
        List<InvCellGoodListVO> invCellGoodListVOS = this.invCellQtyMapper.getInvCellGoodListCell(entid, shopid, cellno);
        for (InvCellGoodListVO vo : invCellGoodListVOS) {
            BmGoodsPack bmGoodsPack = this.bmGoodsDubboService.getBmGoodsPackOne(entid, vo.getGdcode(), Double.valueOf(vo.getPackingqty().doubleValue()));
            Optional.ofNullable(bmGoodsPack).orElseThrow(() -> new BaseException("\u67e5\u8be2\u5546\u54c1\u5305\u88c5\u4fe1\u606f\u4e3a\u7a7a!"));
            vo.setPallethi(bmGoodsPack.getPallethi());
            vo.setPalletti(bmGoodsPack.getPalletti());
            vo.setPalletqty(Double.valueOf(bmGoodsPack.getPalletqty().doubleValue()));
        }
        return ServiceResponse.buildSuccess(invCellGoodListVOS);
    }

    private void updateInvCell(InvLock invlock, InvLocksItem locksItem) {
        Integer lockflag = invlock.getLockflag();
        Criteria criteria = Criteria.where((String)"entid").is((Object)invlock.getEntid()).and("shopid").is((Object)invlock.getShopid()).and("ownerid").is((Object)invlock.getOwnerid()).and("cellno").is((Object)locksItem.getCellno()).and("deptid").is((Object)invlock.getDeptid()).and("gdid").is((Object)locksItem.getGdid()).and("flag").is((Object)SheetFlagEnum.INIT.getFlag()).and("checkstatus").is((Object)0);
        List invcellqtyList = this.getTemplate().select(new Query((CriteriaDefinition)criteria), InvCellQty.class);
        if (!CollectionUtils.isEmpty((Collection)invcellqtyList)) {
            Criteria criter = Criteria.where((String)"entid").is((Object)invlock.getEntid()).and("sheetid").is((Object)invlock.getSheetid());
            List lockItemList = this.invLockItemService.dataQueryTotal(new Query((CriteriaDefinition)criter));
            int row = 0;
            if (!CollectionUtils.isEmpty((Collection)lockItemList)) {
                InvLockItem maxLockItem = lockItemList.stream().max(Comparator.comparing(InvLockItem::getRowno)).get();
                row = maxLockItem.getRowno();
            }
            for (InvCellQty cellQty : invcellqtyList) {
                BigDecimal qty1;
                JSONObject jsonparam;
                InvLockItem invLockItem;
                if (lockflag == 0) {
                    BigDecimal qty12;
                    if (locksItem.getQty().compareTo(BigDecimal.ZERO) <= 0) break;
                    BigDecimal tempQty = cellQty.getQty().subtract(cellQty.getOutstockqty()).subtract(cellQty.getFreezeqty());
                    if (tempQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    if (locksItem.getQty().compareTo(tempQty) > 0) {
                        locksItem.setQty(locksItem.getQty().subtract(tempQty));
                        qty12 = tempQty;
                    } else {
                        qty12 = locksItem.getQty();
                        locksItem.setQty(BigDecimal.ZERO);
                    }
                    cellQty.setFreezeqty(cellQty.getFreezeqty().add(qty12));
                    this.onUpdateBean(cellQty, (Set<String>)Sets.newHashSet((Object[])new String[]{"freezeqty"}));
                    invLockItem = new InvLockItem();
                    BeanUtils.copyProperties((Object)cellQty, (Object)invLockItem, (String[])new String[]{"id"});
                    invLockItem.setQty(qty12);
                    jsonparam = TypeUtils.toJSONObj((Object)invLockItem, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
                    jsonparam.put("sheetid", (Object)invlock.getSheetid());
                    jsonparam.put("rowno", (Object)(++row));
                    this.invLockItemService.onInsert(jsonparam);
                    continue;
                }
                if (lockflag != 1) continue;
                if (locksItem.getQty().compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal tempFreeQty = cellQty.getFreezeqty();
                if (tempFreeQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (locksItem.getQty().compareTo(tempFreeQty) > 0) {
                    qty1 = tempFreeQty;
                    locksItem.setQty(locksItem.getQty().subtract(tempFreeQty));
                } else {
                    qty1 = locksItem.getQty();
                    locksItem.setQty(BigDecimal.ZERO);
                }
                cellQty.setFreezeqty(cellQty.getFreezeqty().subtract(qty1));
                this.onUpdateBean(cellQty, (Set<String>)Sets.newHashSet((Object[])new String[]{"freezeqty"}));
                invLockItem = new InvLockItem();
                BeanUtils.copyProperties((Object)cellQty, (Object)invLockItem, (String[])new String[]{"id"});
                invLockItem.setQty(qty1);
                jsonparam = TypeUtils.toJSONObj((Object)invLockItem, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
                jsonparam.put("sheetid", (Object)invlock.getSheetid());
                jsonparam.put("rowno", (Object)(++row));
                this.invLockItemService.onInsert(jsonparam);
            }
        }
    }

    private List<InvCellQty> getInvcellqtys(String entid, String shopid, String ownerid, String cellno, String gdid, String lotid) {
        HashMap map = Maps.newHashMap();
        map.put("entid", entid);
        map.put("shopid", shopid);
        map.put("ownerid", ownerid);
        map.put("cellno", cellno);
        map.put("gdid", gdid);
        map.put("lotid", lotid);
        List invcellqtyList = this.getTemplate().select(QueryUtils.build((Map)map), InvCellQty.class);
        return invcellqtyList;
    }

    private InvCellQty getInvcellqty(String entid, String shopid, String cellno, Integer cellid) {
        JSONObject paramsObject = new JSONObject();
        paramsObject.put("entid", (Object)entid);
        paramsObject.put("shopid", (Object)shopid);
        paramsObject.put("cellno", (Object)cellno);
        paramsObject.put("cellid", (Object)cellid);
        InvCellQty invcellqty = (InvCellQty)this.dataQueryFirst(paramsObject);
        if (invcellqty == null) {
            ExceptionUtils.raise((String)MessageFormat.format("\u4f01\u4e1a[{0}]\u4ed3\u522b[{1}]\u50a8\u4f4d\u4ee3\u7801[{2}]\u50a8\u4f4dID[{3}]\u7684\u50a8\u4f4d\u5e93\u5b58\u4e0d\u5b58\u5728\uff01", entid, shopid, cellno, cellid));
        }
        return invcellqty;
    }

    private void cleanInvCellqty(String entid, String shopid, String cellno) {
        JSONObject cleanParam = new JSONObject();
        cleanParam.put("entid", (Object)entid);
        cleanParam.put("shopid", (Object)shopid);
        cleanParam.put("cellno", (Object)cellno);
        cleanParam.put("qty", (Object)BigDecimal.ZERO);
        cleanParam.put("instockqty", (Object)BigDecimal.ZERO);
        cleanParam.put("outstockqty", (Object)BigDecimal.ZERO);
        cleanParam.put("freezeqty", (Object)BigDecimal.ZERO);
        Query build = QueryUtils.build((Map)cleanParam);
        build.fields().include("id").include("entid").include("shopid");
        List invCellQtyList = this.dataQueryTotal(build);
        if (CollectionUtils.isEmpty((Collection)invCellQtyList)) {
            return;
        }
        List ids = invCellQtyList.stream().map(BaseEntityModel::getId).collect(Collectors.toList());
        log.info("\u5c06\u6e05\u9664\u50a8\u4f4d[ID]:{}", ids);
        this.getTemplate().delete(QueryUtils.build((Criteria)Criteria.where((String)"id").in(ids).and("entid").is((Object)entid)), this.getCollectionName());
        String body = JSON.toJSONString((Object)invCellQtyList);
        this.transactionAfter.sendAfterCommit(() -> this.producerService.sendAsyncMsg((Object)body, "ISCE_WMS_CELLMOVE", (SendCallback)this.sendCallBack));
    }

    protected void onBeforeInsert(ServiceSession session, JSONObject dataRow) {
        this.transactionAfter.sendAfterCommit(() -> this.producerService.sendAsyncMsg((Object)dataRow, "ISCE_WMS_CELLMOVE", (SendCallback)this.sendCallBack));
    }

    @Override
    public int onUpdateBean(InvCellQty bean, Set<String> keys) {
        if (keys.contains("lpnname")) {
            CmCellQtyCacheVO cmCellQtyCacheVO = new CmCellQtyCacheVO();
            BeanUtils.copyProperties((Object)bean, (Object)cmCellQtyCacheVO);
            this.transactionAfter.sendAfterCommit(() -> this.producerService.sendAsyncMsg((Object)cmCellQtyCacheVO, "ISCE_WMS_CELLMOVE", (SendCallback)this.sendCallBack));
        }
        return super.onUpdateBean((Object)bean, keys);
    }

    private InvCellQty getRealTimeInvcellqtyEntity(RealTimeInvVo realTimeInvVo, InvLotInfo invLotinfo) {
        InvCellQty invcellqty = new InvCellQty();
        BeanUtils.copyProperties((Object)realTimeInvVo, (Object)invcellqty, (String[])new String[]{"id", "operator"});
        this.setInvcellqtyLotInfo(invcellqty, invLotinfo);
        this.setShopName(realTimeInvVo.getEntid(), realTimeInvVo.getShopid(), invcellqty);
        invcellqty.setCreator(realTimeInvVo.getOperator());
        invcellqty.setCreatetime(new Date());
        return invcellqty;
    }

    private InvCellQty getMoveInvcellqtyEntity(InvcellqtyMoveVo invcellqtyVo, InvLotInfo invLotinfo) {
        InvCellQty invcellqty = new InvCellQty();
        BeanUtils.copyProperties((Object)invcellqtyVo, (Object)invcellqty, (String[])new String[]{"id", "operator"});
        this.setInvcellqtyLotInfo(invcellqty, invLotinfo);
        this.setShopName(invcellqtyVo.getEntid(), invcellqtyVo.getShopid(), invcellqty);
        invcellqty.setCreator(invcellqtyVo.getOperator());
        invcellqty.setCreatetime(new Date());
        return invcellqty;
    }

    private InvCellQty getDedInvcellqtyEntity(DedInvcellqtyOrderVo invcellqtyVo, InvLotInfo invLotinfo) {
        InvCellQty invcellqty = new InvCellQty();
        BeanUtils.copyProperties((Object)invcellqtyVo, (Object)invcellqty, (String[])new String[]{"id", "operator"});
        this.setInvcellqtyLotInfo(invcellqty, invLotinfo);
        this.setShopName(invcellqtyVo.getEntid(), invcellqtyVo.getShopid(), invcellqty);
        invcellqty.setCreator(invcellqtyVo.getOperator());
        invcellqty.setCreatetime(new Date());
        return invcellqty;
    }

    private InvCellQty getAddInvcellqtyEntity(InvcellqtyVo invcellqtyVo, InvLotInfo invLotinfo) {
        InvCellQty invcellqty = new InvCellQty();
        BeanUtils.copyProperties((Object)invcellqtyVo, (Object)invcellqty, (String[])new String[]{"id", "operator"});
        this.setInvcellqtyLotInfo(invcellqty, invLotinfo);
        this.setShopName(invcellqtyVo.getEntid(), invcellqtyVo.getShopid(), invcellqty);
        invcellqty.setCreator(invcellqtyVo.getOperator());
        invcellqty.setCreatetime(new Date());
        return invcellqty;
    }

    private void setShopName(String entid, String shopid, InvCellQty invcellqty) {
        BmShopDc bmShopDc = this.mdmDubboApi.getShopDc(entid, shopid);
        if (Objects.nonNull(bmShopDc)) {
            invcellqty.setShopname(bmShopDc.getShopname());
        } else {
            ExceptionUtils.raise((String)"\u67e5\u4e0d\u5230\u4ed3\u5e93DC\u4fe1\u606f\u3002[entid:{},shopid:{}]", (Object[])new Object[]{entid, shopid});
        }
    }

    private void setInvcellqtyLotInfo(InvCellQty invcellqty, InvLotInfo invLotinfo) {
        BeanUtils.copyProperties((Object)invLotinfo, (Object)invcellqty, (String[])new String[]{"id"});
    }

    private InvLotInfo getInvLotinfo(String entid, String ownerid, String gdid, String lotid) {
        return this.invLotInfoService.getInvLotInfo(entid, ownerid, gdid, lotid);
    }

    protected Document onBeforeRowInsert(Query query, Update update) {
        return this.onDefaultRowInsert(query, update);
    }
}

