/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.service.impl.invlpn.create;

import com.alibaba.fastjson.JSONObject;
import com.efuture.common.annotation.Key;
import com.efuture.common.annotation.RedisLock;
import com.efuture.common.enums.ChangeTypeEnum;
import com.efuture.common.enums.LpnEnum;
import com.efuture.common.utils.ExceptionUtils;
import com.efuture.common.utils.GenRuleCodeUtils;
import com.efuture.common.utils.QueryUtils;
import com.efuture.isce.mdm.code.BmDept;
import com.efuture.isce.mdm.code.BsContainer;
import com.efuture.isce.mdm.code.Globpara;
import com.efuture.isce.mdm.exposedapi.MdmDubboApi;
import com.efuture.isce.wms.conf.exposedapi.WmsConfApi;
import com.efuture.isce.wms.inv.inv.InvLpn;
import com.efuture.isce.wms.inv.inv.InvLpnItem;
import com.efuture.isce.wms.inv.model.entity.InvLotInfo;
import com.efuture.isce.wms.inv.vo.DeliveryLpnCreateVo;
import com.efuture.isce.wms.om.OmExp;
import com.efuture.isce.wms.om.OmExpItem;
import com.efuture.isce.wmsinv.service.invlog.InvLpnMoveLogService;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnItemService;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnMasterSalveService;
import com.efuture.isce.wmsinv.service.invlpn.InvLpnService;
import com.efuture.isce.wmsinv.service.invlpn.create.InvLpnCreateService;
import com.efuture.isce.wmsinv.utils.StaticLpnRowUtils;
import com.google.common.collect.Lists;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.SpringContext;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DeliveryLpnServiceImpl
implements InvLpnCreateService<DeliveryLpnCreateVo> {
    private static final Logger log = LoggerFactory.getLogger(DeliveryLpnServiceImpl.class);
    @Autowired
    private InvLpnService invLpnService;
    @Autowired
    private InvLpnItemService invLpnItemService;
    @Autowired
    private InvLpnMasterSalveService invLpnMasterSalveService;
    @Resource
    @Qualifier(value="moreStorageOperation")
    private FMybatisTemplate template;
    @DubboReference
    private WmsConfApi wmsConfApi;
    @DubboReference
    private MdmDubboApi mdmDubboApi;
    @Autowired
    private InvLpnMoveLogService invLpnMoveLogService;
    @Autowired
    private StaticLpnRowUtils staticLpnRowUtils;

    @Override
    @RedisLock(prefix="createlpn")
    public String create(@Key(expr="#deliveryLpn.entid +'-'+ #deliveryLpn.lpnname") DeliveryLpnCreateVo deliveryLpn) throws Exception {
        long start = System.currentTimeMillis();
        log.info("\u914d\u9001\u6807\u7b7e\u751f\u6210\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)deliveryLpn));
        String entid = deliveryLpn.getEntid();
        String shopid = deliveryLpn.getShopid();
        String lpnname = deliveryLpn.getLpnname();
        String ownercustid = deliveryLpn.getCustid();
        String picktype = deliveryLpn.getPicktype();
        String sourceno = deliveryLpn.getSourceno();
        String refsheettype = deliveryLpn.getRefsheettype();
        String deptid = deliveryLpn.getDeptid();
        String expno = deliveryLpn.getExpno();
        int expid = deliveryLpn.getExpid();
        String gdid = deliveryLpn.getGdid();
        String lotid = deliveryLpn.getLotid();
        Double qty = deliveryLpn.getQty();
        Criteria criteria = Criteria.where((String)"entid").is((Object)entid).and("shopid").is((Object)shopid).and("lpnname").is((Object)lpnname).and("usetype").is((Object)3).and("flag").nin(new Object[]{13, 23, 43, 93, 73, 53, 41, 83});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = this.invLpnMasterSalveService.dataQueryTotal(query);
        log.info("\u9a8c\u6536\u63d0\u4ea4\u8282\u70b9\u521b\u5efa\u5bb9\u56681\u8017\u65f6 - \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        criteria = Criteria.where((String)"entid").is((Object)entid).and("sheetid").is((Object)expno);
        query = new Query((CriteriaDefinition)criteria);
        OmExp omExp = (OmExp)this.template.selectOne(query, OmExp.class);
        criteria = Criteria.where((String)"entid").is((Object)entid).and("sheetid").is((Object)expno).and("rowno").is((Object)expid);
        OmExpItem omExpItem = (OmExpItem)this.template.selectOne(QueryUtils.build((Criteria)criteria), OmExpItem.class);
        if (Objects.isNull(omExp)) {
            log.error("\u67e5\u8be2\u4e0d\u5230\u51fa\u8d27\u5934\u6863\u4fe1\u606f\uff01.{}", (Object)JSONObject.toJSONString((Object)criteria));
            ExceptionUtils.raise((String)"\u67e5\u8be2\u4e0d\u5230\u51fa\u8d27\u5934\u6863\u4fe1\u606f\uff01");
        }
        if (Objects.isNull(omExpItem)) {
            log.error("\u67e5\u8be2\u4e0d\u5230\u51fa\u8d27\u660e\u7ec6\u4fe1\u606f\uff01.{}", (Object)JSONObject.toJSONString((Object)criteria));
            ExceptionUtils.raise((String)"\u67e5\u8be2\u4e0d\u5230\u51fa\u8d27\u660e\u7ec6\u4fe1\u606f\uff01");
        }
        log.info("\u9a8c\u6536\u63d0\u4ea4\u8282\u70b9\u521b\u5efa\u5bb9\u56682\u8017\u65f6 - \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        BmDept bmDept = this.mdmDubboApi.getBmDept(entid, deptid);
        if (Objects.isNull(bmDept)) {
            ExceptionUtils.raise((String)MessageFormat.format("\u90e8\u95e8\u4fe1\u606f\u4e3a\u7a7a\uff01[entid:{0},deptid:{1}]", entid, deptid));
        }
        log.info("\u9a8c\u6536\u63d0\u4ea4\u8282\u70b9\u521b\u5efa\u5bb9\u56683\u8017\u65f6 - \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        InvLpnItem invLpnItem = null;
        InvLotInfo lotInfo = null;
        if (!StringUtils.isEmpty((Object)gdid) && !"n".equalsIgnoreCase(gdid)) {
            invLpnItem = new InvLpnItem();
            invLpnItem.setEntid(entid);
            invLpnItem.setShopid(shopid);
            invLpnItem.setShopname(omExp.getShopname());
            invLpnItem.setOwnerid(omExp.getOwnerid());
            invLpnItem.setOwnername(omExp.getOwnername());
            invLpnItem.setDeptname(omExp.getDeptname());
            invLpnItem.setSourceno(sourceno);
            invLpnItem.setCustid(omExp.getCustid());
            invLpnItem.setCustname(omExp.getCustname());
            invLpnItem.setOwnercustid(omExp.getOwnercustid());
            invLpnItem.setOwnercustname(omExp.getOwnercustname());
            invLpnItem.setDeptid(deptid);
            invLpnItem.setExpno(expno);
            invLpnItem.setExpid(Integer.valueOf(expid));
            invLpnItem.setGdid(gdid);
            lotInfo = this.getInvLotinfo(entid, gdid, lotid);
            invLpnItem.setGdcode(lotInfo == null ? "" : lotInfo.getGdcode());
            invLpnItem.setGdname(lotInfo == null ? "" : lotInfo.getGdname());
            if (null != deliveryLpn.getPackingqty()) {
                invLpnItem.setPackingqty(deliveryLpn.getPackingqty());
            } else {
                invLpnItem.setPackingqty(lotInfo == null ? BigDecimal.ZERO : lotInfo.getPackingqty());
            }
            invLpnItem.setGroupno(lotInfo == null || lotInfo.getGroupno() == null ? "" : lotInfo.getGroupno());
            invLpnItem.setGroupname(lotInfo == null || lotInfo.getGroupname() == null ? "" : lotInfo.getGroupname());
            invLpnItem.setGdid(gdid);
            invLpnItem.setSkuspec(lotInfo == null || lotInfo.getSkuspec() == null ? "" : lotInfo.getSkuspec());
            invLpnItem.setSkuunit(lotInfo == null || lotInfo.getSkuunit() == null ? "" : lotInfo.getSkuunit());
            invLpnItem.setBarcode(lotInfo == null ? "" : lotInfo.getBarcode());
            invLpnItem.setLotid(lotid);
            invLpnItem.setQty(qty);
            invLpnItem.setExpno(expno);
            invLpnItem.setExpid(Integer.valueOf(expid));
            invLpnItem.setDbsplitcode(omExp.getDbsplitcode());
            invLpnItem.setSellprice(omExpItem.getSellprice());
            invLpnItem.setImporttype(omExp.getImporttype());
        }
        if (null != lotInfo) {
            invLpnItem.setLot01(lotInfo.getLot01());
            invLpnItem.setLot02(lotInfo.getLot02());
            invLpnItem.setLot03(lotInfo.getLot03());
            invLpnItem.setLot04(lotInfo.getLot04());
            invLpnItem.setLot05(lotInfo.getLot05());
            invLpnItem.setLot06(lotInfo.getLot06());
            invLpnItem.setLot07(lotInfo.getLot07());
            invLpnItem.setLot08(lotInfo.getLot08());
            invLpnItem.setLot09(lotInfo.getLot09());
            invLpnItem.setLot10(lotInfo.getLot10());
            invLpnItem.setLot11(lotInfo.getLot11());
            invLpnItem.setLot12(lotInfo.getLot12());
            invLpnItem.setLot13(lotInfo.getLot13());
            invLpnItem.setLot14(lotInfo.getLot14());
            invLpnItem.setLot15(lotInfo.getLot15());
            invLpnItem.setLot16(lotInfo.getLot16());
            invLpnItem.setLot17(lotInfo.getLot17());
            invLpnItem.setLot18(lotInfo.getLot18());
            invLpnItem.setLot19(lotInfo.getLot19());
            invLpnItem.setLot20(lotInfo.getLot20());
        }
        log.info("\u9a8c\u6536\u63d0\u4ea4\u8282\u70b9\u521b\u5efa\u5bb9\u56684\u8017\u65f6 - \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        String lpnid = "";
        if (!CollectionUtils.isEmpty((Collection)list)) {
            if (list.size() > 1) {
                log.error("\u67e5\u8be2\u7ed3\u679c\u4e3a\u591a\u6761!{}", (Object)criteria.toString());
                ExceptionUtils.raise((String)"\u67e5\u8be2\u7ed3\u679c\u4e3a\u591a\u6761!\u8bf7\u6362\u5bb9\u5668");
            } else {
                InvLpn lpn = (InvLpn)list.get(0);
                lpn.setPicktype(picktype);
                lpn.setScustid(omExp.getCustid());
                log.info("\u914d\u9001\u6807\u7b7e\u751f\u6210\u9a8c\u8bc1 verify :{}", (Object)JSONObject.toJSONString((Object)lpn));
                if (this.verify(lpn)) {
                    log.info("\u9a8c\u6536\u63d0\u4ea4\u8282\u70b9\u521b\u5efa\u5bb9\u56684.1\u8017\u65f6 - \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                    start = System.currentTimeMillis();
                    lpnid = lpn.getLpnid();
                    log.info("-----Delivery[\u914d\u9001]---lpnid[{}]\u9a8c\u8bc1\u6210\u529f\uff01{}", (Object)lpnid, (Object)JSONObject.toJSONString((Object)deliveryLpn));
                    Integer rowno = this.getMaxRowInner(entid, shopid, lpn.getLpnid());
                    log.info("\u9a8c\u6536\u63d0\u4ea4\u8282\u70b9\u521b\u5efa\u5bb9\u56684.1.1\u8017\u65f6 - \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                    start = System.currentTimeMillis();
                    if (Objects.nonNull(invLpnItem)) {
                        invLpnItem.setLpnid(lpnid);
                        invLpnItem.setRowno(rowno);
                        this.invLpnItemService.onInsert(invLpnItem);
                    }
                    log.info("\u9a8c\u6536\u63d0\u4ea4\u8282\u70b9\u521b\u5efa\u5bb9\u56684.3\u8017\u65f6 - \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                    start = System.currentTimeMillis();
                }
            }
            log.info("\u9a8c\u6536\u63d0\u4ea4\u8282\u70b9\u521b\u5efa\u5bb9\u56685\u8017\u65f6 - \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
        } else {
            BsContainer bsContainer;
            if (StringUtils.isEmpty((Object)lpnname)) {
                ExceptionUtils.raise((String)"\u53c2\u6570lpnname\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(bsContainer = this.getLpntype(entid, "1", 1, lpnname))) {
                log.error("lpnname:{}", (Object)lpnname);
                ExceptionUtils.raise((String)("\u67e5\u8be2\u4e0d\u5230\u3010" + lpnname + "\u3011\u7684\u5bb9\u5668\u7c7b\u578b\u4fe1\u606f\uff01"));
            }
            Globpara lpntemp = this.mdmDubboApi.getGlobPara(entid, "LPNTEMPORIENT");
            lpnid = GenRuleCodeUtils.getGenCode((String)"lpnid", (String)LpnEnum.LPN_TYPE.getLpnType());
            InvLpn invLpn = new InvLpn();
            invLpn.setFlag(Integer.valueOf(30));
            invLpn.setOwnerlpnid(lpnid);
            invLpn.setOwnerlpnname(lpnname);
            invLpn.setExpno(expno);
            invLpn.setUsetype(Integer.valueOf(3));
            invLpn.setRefsheetid(sourceno);
            invLpn.setRefsheettype(Integer.valueOf(Integer.parseInt(refsheettype)));
            invLpn.setLpnid(lpnid);
            invLpn.setLpntype(bsContainer.getLpntype());
            invLpn.setLpntypeid(bsContainer.getLpntypeid());
            invLpn.setLpntypename(bsContainer.getLpnname());
            invLpn.setLpnname(lpnname);
            invLpn.setShopid(shopid);
            invLpn.setEntid(entid);
            invLpn.setOwnercustid(omExp.getOwnercustid());
            invLpn.setOwnercustname(omExp.getOwnercustname());
            invLpn.setCustid(omExp.getCustid());
            invLpn.setCustname(omExp.getCustname());
            invLpn.setCarrierno("N");
            invLpn.setCarriername("N");
            invLpn.setCellno("N");
            invLpn.setDbsplitcode("1");
            invLpn.setOwnerid(omExp.getOwnerid());
            invLpn.setOwnername(omExp.getOwnername());
            invLpn.setShopname(omExp.getShopname());
            invLpn.setDeptid(omExp.getDeptid());
            invLpn.setDeptname(omExp.getDeptname());
            if (null != lpntemp && "0".equals(lpntemp.getParavalue())) {
                invLpn.setTemptype(bsContainer.getTemptype());
            } else {
                if (Objects.isNull(bmDept.getSyslevel())) {
                    ExceptionUtils.raise((String)"\u90e8\u95e8bmdept[{0}]\u672a\u8bbe\u7f6e\u6e29\u5c42\uff01[syslevel]", (Object[])new Object[]{deptid});
                }
                invLpn.setTemptype(bmDept.getSyslevel().toString());
            }
            if (Objects.nonNull(invLpnItem)) {
                invLpnItem.setLpnid(lpnid);
                invLpnItem.setRowno(Integer.valueOf(1));
                ArrayList invLpnItemList = Lists.newArrayList((Object[])new InvLpnItem[]{invLpnItem});
                invLpn.setInvlpnitem((List)invLpnItemList);
            }
            log.info("\u9a8c\u6536\u63d0\u4ea4\u8282\u70b9\u521b\u5efa\u5bb9\u56686\u8017\u65f6 - \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            this.invLpnMasterSalveService.onInsert(SpringContext.getSession(), invLpn);
            invLpn.setChangetype(ChangeTypeEnum.CREATE.getChangeType());
            this.invLpnMoveLogService.insert(invLpn);
            log.info("\u9a8c\u6536\u63d0\u4ea4\u8282\u70b9\u521b\u5efa\u5bb9\u56687\u8017\u65f6 - \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
        }
        return lpnid;
    }

    @Override
    public boolean verify(InvLpn invLpn) {
        if (Objects.nonNull(invLpn)) {
            int status = invLpn.getFlag();
            if (Lists.newArrayList((Object[])new Integer[]{10, 11}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u9a8c\u6536\u4e0a\u67b6\u73af\u8282!");
            } else if (Lists.newArrayList((Object[])new Integer[]{20, 21}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u79fb\u5e93\u73af\u8282\u4e2d\u4e14\u79fb\u5e93\u672a\u5b8c\u6210!");
            } else if (Lists.newArrayList((Object[])new Integer[]{41, 42}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u5206\u64ad\u73af\u8282\u4e2d\u4e14\u5206\u64ad\u672a\u5b8c\u6210!");
            } else if (Lists.newArrayList((Object[])new Integer[]{50, 51}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u4ee3\u8fd0\u73af\u8282\u4e2d!");
            } else if (invLpn.getUsetype() == 3 && !invLpn.getCustid().equals(invLpn.getScustid())) {
                ExceptionUtils.raise((String)MessageFormat.format("[{0}]\u88ab\u5176\u4ed6\u5ba2\u6237\u5360\u7528{1}}!", invLpn.getLpnname(), invLpn.getCustname()));
            } else if (Lists.newArrayList((Object[])new Integer[]{70, 71}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u8fd4\u914d\u73af\u8282\u4e2d!");
            } else if (Lists.newArrayList((Object[])new Integer[]{80, 81}).contains(status)) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5728\u9000\u5382\u73af\u8282\u4e2d!");
            } else if (status == 90) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5df2\u5c01\u7b3c!");
            } else if (status == 91) {
                ExceptionUtils.raise((String)"\u677f\u53f7\u5df2\u88c5\u8f66");
            }
        }
        return true;
    }

    public InvLotInfo getInvLotinfo(String entid, String gdid, String lotid) {
        Criteria criteria = Criteria.where((String)"entid").is((Object)entid).and("gdid").is((Object)gdid).and("lotid").is((Object)lotid);
        InvLotInfo invLotinfo = (InvLotInfo)this.template.selectOne(QueryUtils.build((Criteria)criteria), InvLotInfo.class);
        return invLotinfo;
    }

    private Integer getMaxRowInner(String entid, String shopid, String cellno) {
        return this.staticLpnRowUtils.onIncrementName(entid, shopid, cellno);
    }
}

