/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.isce.wmsinv.aop;

import com.efuture.common.rocketmq.producer.MQProducerService;
import com.efuture.isce.wms.task.dto.TaskEpmDTO;
import com.efuture.isce.wmsinv.annotations.TaskRecord;
import com.product.model.ServiceSession;
import com.product.util.SpringContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=3)
public class TaskEpmInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TaskEpmInterceptor.class);
    @Autowired
    private MQProducerService producerService;
    private String[] sheetTypeName = new String[]{"getSheetid", "getSheetId", "getChbatchno"};

    @Around(value="@annotation(com.efuture.isce.wmsinv.annotations.TaskRecord)")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Object proceed = joinPoint.proceed();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        TaskRecord annotation = method.getAnnotation(TaskRecord.class);
        Object[] args = joinPoint.getArgs();
        String operationsteps = annotation.operationsteps();
        Object optype = annotation.optype();
        int opser = annotation.opser();
        if (StringUtils.equalsIgnoreCase((CharSequence)operationsteps, (CharSequence)"tasklist")) {
            operationsteps = this.getByTaskType(args, method);
            optype = operationsteps + (String)optype;
        }
        ServiceSession session = SpringContext.getSession();
        String entid = String.valueOf(session.getEnt_id());
        String workerno = session.getUser_code();
        String workername = session.getUser_name();
        String shopid = session.getShop_code();
        String shopname = session.getShop_Name();
        String sheetid = this.getSheetid(args, method);
        String operatetools = this.getOperatetools(args, method);
        String refsheetid = "N";
        TaskEpmDTO taskEpmDTO = new TaskEpmDTO();
        taskEpmDTO.setEntid(entid);
        taskEpmDTO.setShopid(shopid);
        taskEpmDTO.setShopname(shopname);
        taskEpmDTO.setSheetid(sheetid);
        taskEpmDTO.setRefsheetid(refsheetid);
        taskEpmDTO.setOperationsteps(operationsteps);
        taskEpmDTO.setWorkerno(workerno);
        taskEpmDTO.setWorkername(workername);
        taskEpmDTO.setWorktime(new Date());
        taskEpmDTO.setOptype((String)optype);
        taskEpmDTO.setOpser(opser);
        taskEpmDTO.setOperatetools(operatetools);
        if (StringUtils.isBlank((CharSequence)taskEpmDTO.getSheetid()) || StringUtils.isBlank((CharSequence)taskEpmDTO.getShopid()) || StringUtils.isBlank((CharSequence)taskEpmDTO.getWorkerno())) {
            return proceed;
        }
        this.producerService.sendSyncMsg((Object)taskEpmDTO, sheetid, "ISCE_WMS_TASKEPM");
        return proceed;
    }

    private String getByTaskType(Object[] args, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            try {
                Method getTasktype = parameterType.getMethod("getTasktype", new Class[0]);
                Integer taskType = (Integer)getTasktype.invoke(args[i], new Object[0]);
                if (taskType == 20) {
                    return "OMOUTSTOCK";
                }
                if (taskType != 45 && taskType != 50) continue;
                return "HMOUTSTOCK";
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.info("==============\u4f20\u5165\u5b9e\u4f53\u6ca1\u6709entid,sheetid\u7684get\u65b9\u6cd5\uff01");
            }
        }
        return null;
    }

    private String getSheetid(Object[] args, Method method) {
        Parameter[] parameters = method.getParameters();
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            if (parameterType.getName().startsWith("java.lang")) {
                Parameter parameter;
                if (!StringUtils.equalsIgnoreCase((CharSequence)parameterType.getSimpleName(), (CharSequence)"String") || !StringUtils.equalsIgnoreCase((CharSequence)"sheetid", (CharSequence)(parameter = parameters[i]).getName())) continue;
                return args[i].toString();
            }
            return this.deepGetSheetid(args[i], parameterType);
        }
        return null;
    }

    private String deepGetSheetid(Object arg, Class<?> parameterType) {
        int i = 0;
        while (i < this.sheetTypeName.length) {
            try {
                Method getSheetid = parameterType.getMethod(this.sheetTypeName[i], new Class[0]);
                String invoke = (String)getSheetid.invoke(arg, new Object[0]);
                if (StringUtils.isBlank((CharSequence)invoke)) {
                    ++i;
                    continue;
                }
                return invoke;
            }
            catch (Exception e) {
                ++i;
            }
        }
        return null;
    }

    private String getOperatetools(Object[] args, Method method) {
        Parameter[] parameters = method.getParameters();
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            if (parameterType.getName().startsWith("java.lang")) {
                Parameter parameter;
                if (!StringUtils.equalsIgnoreCase((CharSequence)parameterType.getSimpleName(), (CharSequence)"String") || !StringUtils.equalsIgnoreCase((CharSequence)"operatetools", (CharSequence)(parameter = parameters[i]).getName())) continue;
                return args[i].toString();
            }
            try {
                Method getOperatetools = parameterType.getMethod("getOperatetools", new Class[0]);
                Object obj = getOperatetools.invoke(args[i], new Object[0]);
                if (!ObjectUtils.isNotEmpty((Object)obj)) continue;
                return (String)obj;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return "2";
            }
        }
        return "2";
    }
}

