package com.efuture.msboot.client;


import com.alibaba.fastjson.JSONObject;

/**
 * Created by Guanwf on 2018/8/30.
 */
public interface ServiceAccess {

    /**
     * 访问微服务接口
     *
     * String url="/rest?method=mdm.demo.get&token=e93aae35-3360-4cb7-bbf2-10f3825e3d87&ent_id=0";
     * String body="{id:2}";
     *
     * @param service 微服服务名称
     * @param method 方法名称
     * @param body JSON格式参数
     * @return
     */
    String doRest(String service, String method, String body);

    /**
     * 访问微服务接口
     *
     * String url="/rest?method=mdm.demo.get&token=e93aae35-3360-4cb7-bbf2-10f3825e3d87&ent_id=0";
     * String body="{id:2}";
     *
     * @param service 微服服务名称
     * @param method 方法名称
     * @param body JSON格式参数
     * @return
     */
    JSONObject doRest(String service, String method, JSONObject body);


    /**
     * 访问微服务接口
     *
     * ep.1: DemoBean demoBean = serviceAccess.doRest("u51bs-test", "com.demo.get", params, DemoBean.class);
     *
     * ep.2: Long demoBean = serviceAccess.doRest("u51bs-test", "com.demo.add", params, Long.class);
     *
     * ep.3: serviceAccess.doRest("u51bs-test", "com.demo.delete", params, Void.class);
     *
     * @param service 服务名
     * @param method  方法名
     * @param request 请求，必须是 object 类型
     * @param responseClazz 返回的类
     * @param <T>
     * @return
     */
    <T> T doRest(String service, String method, Object request, Class responseClazz);
}
