package com.efuture.msboot.client.config;

import com.efuture.msboot.client.ServiceAccess;
import com.efuture.msboot.client.impl.ServiceAccessImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

import java.nio.charset.StandardCharsets;

/**
 * Created by wzm on 2018/9/3.
 */
@Configuration
public class MsBootClientConfig {
    @ConditionalOnMissingBean
    @Bean
    public ServiceAccess serviceAccess(){
        return new ServiceAccessImpl();
    }

    @ConditionalOnMissingBean
    @Bean
    @LoadBalanced
    public RestTemplate restTempldate(){
        SimpleClientHttpRequestFactory httpRequestFactory = new SimpleClientHttpRequestFactory();
        httpRequestFactory.setReadTimeout(60*1000);
        httpRequestFactory.setConnectTimeout(10*1000);

        RestTemplate restTemplate = new RestTemplate(httpRequestFactory);
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));

        return restTemplate;
    }
}
