/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds.druid;

import cn.hutool.core.util.StrUtil;
import cn.hutool.db.ds.AbstractDSFactory;
import cn.hutool.setting.Setting;
import com.alibaba.druid.pool.DruidDataSource;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class DruidDSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = 4680621702534433222L;
    public static final String DS_NAME = "Druid";

    public DruidDSFactory() {
        this((Setting)null);
    }

    public DruidDSFactory(Setting setting) {
        super(DS_NAME, DruidDataSource.class, setting);
    }

    @Override
    protected DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, Setting poolSetting) {
        DruidDataSource ds = new DruidDataSource();
        ds.setUrl(jdbcUrl);
        ds.setDriverClassName(driver);
        ds.setUsername(user);
        ds.setPassword(pass);
        Properties druidProps = new Properties();
        for (Map.Entry entry : poolSetting.entrySet()) {
            String keyStr = StrUtil.addPrefixIfNot((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"druid.");
            druidProps.put(keyStr, entry.getValue());
        }
        ds.configFromPropety(druidProps);
        if (null == ds.getValidationQuery()) {
            ds.setTestOnBorrow(false);
            ds.setTestOnReturn(false);
            ds.setTestWhileIdle(false);
        }
        return ds;
    }
}

