/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.device;

import cn.jpush.api.common.ClientConfig;
import cn.jpush.api.common.ServiceHelper;
import cn.jpush.api.common.connection.HttpProxy;
import cn.jpush.api.common.connection.NativeHttpClient;
import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.common.resp.BaseResult;
import cn.jpush.api.common.resp.BooleanResult;
import cn.jpush.api.common.resp.DefaultResult;
import cn.jpush.api.common.resp.ResponseWrapper;
import cn.jpush.api.device.AliasDeviceListResult;
import cn.jpush.api.device.OnlineStatus;
import cn.jpush.api.device.TagAliasResult;
import cn.jpush.api.device.TagListResult;
import cn.jpush.api.utils.Preconditions;
import cn.jpush.api.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

public class DeviceClient {
    private final NativeHttpClient _httpClient;
    private String hostName;
    private String devicesPath;
    private String tagsPath;
    private String aliasesPath;

    public DeviceClient(String masterSecret, String appKey) {
        this(masterSecret, appKey, null, ClientConfig.getInstance());
    }

    @Deprecated
    public DeviceClient(String masterSecret, String appKey, int maxRetryTimes) {
        this(masterSecret, appKey, maxRetryTimes, null);
    }

    @Deprecated
    public DeviceClient(String masterSecret, String appKey, int maxRetryTimes, HttpProxy proxy) {
        ClientConfig conf = ClientConfig.getInstance();
        conf.setMaxRetryTimes(maxRetryTimes);
        ServiceHelper.checkBasic(appKey, masterSecret);
        this.hostName = (String)conf.get("device.host.name");
        this.devicesPath = (String)conf.get("devices.path");
        this.tagsPath = (String)conf.get("tags.path");
        this.aliasesPath = (String)conf.get("aliases.path");
        String authCode = ServiceHelper.getBasicAuthorization(appKey, masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    public DeviceClient(String masterSecret, String appKey, HttpProxy proxy, ClientConfig conf) {
        ServiceHelper.checkBasic(appKey, masterSecret);
        this.hostName = (String)conf.get("device.host.name");
        this.devicesPath = (String)conf.get("devices.path");
        this.tagsPath = (String)conf.get("tags.path");
        this.aliasesPath = (String)conf.get("aliases.path");
        String authCode = ServiceHelper.getBasicAuthorization(appKey, masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    public TagAliasResult getDeviceTagAlias(String registrationId) throws APIConnectionException, APIRequestException {
        String url = this.hostName + this.devicesPath + "/" + registrationId;
        ResponseWrapper response = this._httpClient.sendGet(url);
        return BaseResult.fromResponse(response, TagAliasResult.class);
    }

    public DefaultResult updateDeviceTagAlias(String registrationId, boolean clearAlias, boolean clearTag) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument(clearAlias || clearTag, "It is not meaningful to do nothing.");
        String url = this.hostName + this.devicesPath + "/" + registrationId;
        JsonObject top = new JsonObject();
        if (clearAlias) {
            top.addProperty("alias", "");
        }
        if (clearTag) {
            top.addProperty("tags", "");
        }
        ResponseWrapper response = this._httpClient.sendPost(url, top.toString());
        return DefaultResult.fromResponse(response);
    }

    public DefaultResult updateDeviceTagAlias(String registrationId, String alias, Set<String> tagsToAdd, Set<String> tagsToRemove) throws APIConnectionException, APIRequestException {
        JsonArray tagsRemove;
        String url = this.hostName + this.devicesPath + "/" + registrationId;
        JsonObject top = new JsonObject();
        if (null != alias) {
            top.addProperty("alias", alias);
        }
        JsonObject tagObject = new JsonObject();
        JsonArray tagsAdd = ServiceHelper.fromSet(tagsToAdd);
        if (tagsAdd.size() > 0) {
            tagObject.add("add", (JsonElement)tagsAdd);
        }
        if ((tagsRemove = ServiceHelper.fromSet(tagsToRemove)).size() > 0) {
            tagObject.add("remove", (JsonElement)tagsRemove);
        }
        if (tagObject.entrySet().size() > 0) {
            top.add("tags", (JsonElement)tagObject);
        }
        ResponseWrapper response = this._httpClient.sendPost(url, top.toString());
        return DefaultResult.fromResponse(response);
    }

    public DefaultResult bindMobile(String registrationId, String mobile) throws APIConnectionException, APIRequestException {
        if (StringUtils.isEmpty(mobile)) {
            mobile = "";
        } else {
            Preconditions.checkArgument(StringUtils.isMobileNumber(mobile), "The mobile format is incorrect. " + mobile);
        }
        String url = this.hostName + this.devicesPath + "/" + registrationId;
        JsonObject top = new JsonObject();
        top.addProperty("mobile", mobile);
        ResponseWrapper response = this._httpClient.sendPost(url, top.toString());
        return DefaultResult.fromResponse(response);
    }

    public TagListResult getTagList() throws APIConnectionException, APIRequestException {
        String url = this.hostName + this.tagsPath + "/";
        ResponseWrapper response = this._httpClient.sendGet(url);
        return TagListResult.fromResponse(response, TagListResult.class);
    }

    public BooleanResult isDeviceInTag(String theTag, String registrationID) throws APIConnectionException, APIRequestException {
        String url = this.hostName + this.tagsPath + "/" + theTag + "/registration_ids/" + registrationID;
        ResponseWrapper response = this._httpClient.sendGet(url);
        return BaseResult.fromResponse(response, BooleanResult.class);
    }

    public DefaultResult addRemoveDevicesFromTag(String theTag, Set<String> toAddUsers, Set<String> toRemoveUsers) throws APIConnectionException, APIRequestException {
        JsonArray array;
        String url = this.hostName + this.tagsPath + "/" + theTag;
        JsonObject top = new JsonObject();
        JsonObject registrationIds = new JsonObject();
        if (null != toAddUsers && toAddUsers.size() > 0) {
            array = new JsonArray();
            for (String user : toAddUsers) {
                array.add((JsonElement)new JsonPrimitive(user));
            }
            registrationIds.add("add", (JsonElement)array);
        }
        if (null != toRemoveUsers && toRemoveUsers.size() > 0) {
            array = new JsonArray();
            for (String user : toRemoveUsers) {
                array.add((JsonElement)new JsonPrimitive(user));
            }
            registrationIds.add("remove", (JsonElement)array);
        }
        top.add("registration_ids", (JsonElement)registrationIds);
        ResponseWrapper response = this._httpClient.sendPost(url, top.toString());
        return DefaultResult.fromResponse(response);
    }

    public DefaultResult deleteTag(String theTag, String platform) throws APIConnectionException, APIRequestException {
        String url = this.hostName + this.tagsPath + "/" + theTag;
        if (null != platform) {
            url = url + "?platform=" + platform;
        }
        ResponseWrapper response = this._httpClient.sendDelete(url);
        return DefaultResult.fromResponse(response);
    }

    public AliasDeviceListResult getAliasDeviceList(String alias, String platform) throws APIConnectionException, APIRequestException {
        String url = this.hostName + this.aliasesPath + "/" + alias;
        if (null != platform) {
            url = url + "?platform=" + platform;
        }
        ResponseWrapper response = this._httpClient.sendGet(url);
        return BaseResult.fromResponse(response, AliasDeviceListResult.class);
    }

    public DefaultResult deleteAlias(String alias, String platform) throws APIConnectionException, APIRequestException {
        String url = this.hostName + this.aliasesPath + "/" + alias;
        if (null != platform) {
            url = url + "?platform=" + platform;
        }
        ResponseWrapper response = this._httpClient.sendDelete(url);
        return DefaultResult.fromResponse(response);
    }

    public Map<String, OnlineStatus> getUserOnlineStatus(String ... registrationIds) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument(null != registrationIds, "The registration id list should not be null.");
        Preconditions.checkArgument(registrationIds.length > 0 && registrationIds.length <= 1000, "The length of registration id list should between 1 and 1000.");
        String url = this.hostName + this.devicesPath + "/status";
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        for (int i = 0; i < registrationIds.length; ++i) {
            array.add((JsonElement)new JsonPrimitive(registrationIds[i]));
        }
        json.add("registration_ids", (JsonElement)array);
        Type type = new TypeToken<Map<String, OnlineStatus>>(){}.getType();
        ResponseWrapper response = this._httpClient.sendPost(url, json.toString());
        Map map = (Map)new Gson().fromJson(response.responseContent, type);
        return map;
    }
}

