/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.TransactionTimeoutException;
import com.alibaba.druid.VERSION;
import com.alibaba.druid.filter.AutoLoad;
import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.FilterChainImpl;
import com.alibaba.druid.mock.MockDriver;
import com.alibaba.druid.pool.DataSourceClosedException;
import com.alibaba.druid.pool.DataSourceDisableException;
import com.alibaba.druid.pool.DataSourceNotAvailableException;
import com.alibaba.druid.pool.DruidAbstractDataSource;
import com.alibaba.druid.pool.DruidConnectionHolder;
import com.alibaba.druid.pool.DruidDataSourceMBean;
import com.alibaba.druid.pool.DruidDataSourceStatLogger;
import com.alibaba.druid.pool.DruidDataSourceStatValue;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.DruidPooledPreparedStatement;
import com.alibaba.druid.pool.GetConnectionTimeoutException;
import com.alibaba.druid.pool.ManagedDataSource;
import com.alibaba.druid.pool.PreparedStatementHolder;
import com.alibaba.druid.pool.PreparedStatementPool;
import com.alibaba.druid.pool.vendor.DB2ExceptionSorter;
import com.alibaba.druid.pool.vendor.InformixExceptionSorter;
import com.alibaba.druid.pool.vendor.MSSQLValidConnectionChecker;
import com.alibaba.druid.pool.vendor.MockExceptionSorter;
import com.alibaba.druid.pool.vendor.MySqlExceptionSorter;
import com.alibaba.druid.pool.vendor.MySqlValidConnectionChecker;
import com.alibaba.druid.pool.vendor.NullExceptionSorter;
import com.alibaba.druid.pool.vendor.OracleExceptionSorter;
import com.alibaba.druid.pool.vendor.OracleValidConnectionChecker;
import com.alibaba.druid.pool.vendor.PGExceptionSorter;
import com.alibaba.druid.pool.vendor.PGValidConnectionChecker;
import com.alibaba.druid.pool.vendor.SybaseExceptionSorter;
import com.alibaba.druid.proxy.DruidDriver;
import com.alibaba.druid.proxy.jdbc.DataSourceProxyConfig;
import com.alibaba.druid.proxy.jdbc.TransactionInfo;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.stat.DruidDataSourceStatManager;
import com.alibaba.druid.stat.JdbcDataSourceStat;
import com.alibaba.druid.stat.JdbcSqlStat;
import com.alibaba.druid.stat.JdbcSqlStatValue;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JMXUtils;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.druid.util.Utils;
import com.alibaba.druid.wall.WallFilter;
import com.alibaba.druid.wall.WallProviderStatValue;
import java.io.Closeable;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class DruidDataSource
extends DruidAbstractDataSource
implements DruidDataSourceMBean,
ManagedDataSource,
Referenceable,
Closeable,
Cloneable,
ConnectionPoolDataSource,
MBeanRegistration {
    private static final Log LOG = LogFactory.getLog(DruidDataSource.class);
    private static final long serialVersionUID = 1L;
    private final AtomicLong recycleErrorCount = new AtomicLong();
    private long connectCount = 0L;
    private long closeCount = 0L;
    private final AtomicLong connectErrorCount = new AtomicLong();
    private long recycleCount = 0L;
    private long removeAbandonedCount = 0L;
    private long notEmptyWaitCount = 0L;
    private long notEmptySignalCount = 0L;
    private long notEmptyWaitNanos = 0L;
    private int activePeak = 0;
    private long activePeakTime = 0L;
    private int poolingPeak = 0;
    private long poolingPeakTime = 0L;
    private volatile DruidConnectionHolder[] connections;
    private int poolingCount = 0;
    private int activeCount = 0;
    private long discardCount = 0L;
    private int notEmptyWaitThreadCount = 0;
    private int notEmptyWaitThreadPeak = 0;
    private ScheduledFuture<?> destroySchedulerFuture;
    private DestroyTask destroyTask;
    private CreateConnectionThread createConnectionThread;
    private DestroyConnectionThread destroyConnectionThread;
    private LogStatsThread logStatsThread;
    private int createTaskCount;
    private final CountDownLatch initedLatch = new CountDownLatch(2);
    private volatile boolean enable = true;
    private boolean resetStatEnable = true;
    private final AtomicLong resetCount = new AtomicLong();
    private String initStackTrace;
    private volatile boolean closed = false;
    private long closeTimeMillis = -1L;
    protected JdbcDataSourceStat dataSourceStat;
    private boolean useGlobalDataSourceStat = false;
    private boolean mbeanRegistered = false;
    public static ThreadLocal<Long> waitNanosLocal = new ThreadLocal();
    private boolean logDifferentThread = true;
    protected String instanceKey = null;

    public DruidDataSource() {
        this(false);
    }

    public DruidDataSource(boolean fairLock) {
        super(fairLock);
        this.configFromPropety(System.getProperties());
    }

    public void configFromPropety(Properties properties) {
        String property;
        Boolean value = Utils.getBoolean(properties, "druid.testWhileIdle");
        if (value != null) {
            this.setTestWhileIdle(value);
        }
        if ((value = Utils.getBoolean(properties, "druid.testOnBorrow")) != null) {
            this.setTestOnBorrow(value);
        }
        if ((property = properties.getProperty("druid.validationQuery")) != null && property.length() > 0) {
            this.setValidationQuery(property);
        }
        if ((value = Utils.getBoolean(properties, "druid.useGlobalDataSourceStat")) != null) {
            this.setUseGlobalDataSourceStat(value);
        }
        if ((value = Utils.getBoolean(properties, "druid.useGloalDataSourceStat")) != null) {
            this.setUseGlobalDataSourceStat(value);
        }
        if ((property = properties.getProperty("druid.filters")) != null && property.length() > 0) {
            try {
                this.setFilters(property);
            }
            catch (SQLException e) {
                LOG.error("setFilters error", e);
            }
        }
        if ((property = properties.getProperty("druid.timeBetweenLogStatsMillis")) != null && property.length() > 0) {
            try {
                long value2 = Long.parseLong(property);
                this.setTimeBetweenLogStatsMillis(value2);
            }
            catch (NumberFormatException e) {
                LOG.error("illegal property 'druid.timeBetweenLogStatsMillis'", e);
            }
        }
        if ((property = properties.getProperty("druid.stat.sql.MaxSize")) != null && property.length() > 0) {
            try {
                int value3 = Integer.parseInt(property);
                if (this.dataSourceStat != null) {
                    this.dataSourceStat.setMaxSqlSize(value3);
                }
            }
            catch (NumberFormatException e) {
                LOG.error("illegal property 'druid.stat.sql.MaxSize'", e);
            }
        }
        if ((value = Utils.getBoolean(properties, "druid.clearFiltersEnable")) != null) {
            this.setClearFiltersEnable(value);
        }
        if ((value = Utils.getBoolean(properties, "druid.resetStatEnable")) != null) {
            this.setResetStatEnable(value);
        }
        if ((property = properties.getProperty("druid.notFullTimeoutRetryCount")) != null && property.length() > 0) {
            try {
                int value4 = Integer.parseInt(property);
                this.setNotFullTimeoutRetryCount(value4);
            }
            catch (NumberFormatException e) {
                LOG.error("illegal property 'druid.notFullTimeoutRetryCount'", e);
            }
        }
        if ((property = properties.getProperty("druid.maxWaitThreadCount")) != null && property.length() > 0) {
            try {
                int value5 = Integer.parseInt(property);
                this.setMaxWaitThreadCount(value5);
            }
            catch (NumberFormatException e) {
                LOG.error("illegal property 'druid.maxWaitThreadCount'", e);
            }
        }
        if ((value = Utils.getBoolean(properties, "druid.failFast")) != null) {
            this.setFailFast(value);
        }
        if ((property = properties.getProperty("druid.phyTimeoutMillis")) != null && property.length() > 0) {
            try {
                long value6 = Long.parseLong(property);
                this.setPhyTimeoutMillis(value6);
            }
            catch (NumberFormatException e) {
                LOG.error("illegal property 'druid.phyTimeoutMillis'", e);
            }
        }
        if ((property = properties.getProperty("druid.minEvictableIdleTimeMillis")) != null && property.length() > 0) {
            try {
                long value7 = Long.parseLong(property);
                this.setMinEvictableIdleTimeMillis(value7);
            }
            catch (NumberFormatException e) {
                LOG.error("illegal property 'druid.minEvictableIdleTimeMillis'", e);
            }
        }
        if ((property = properties.getProperty("druid.maxEvictableIdleTimeMillis")) != null && property.length() > 0) {
            try {
                long value8 = Long.parseLong(property);
                this.setMaxEvictableIdleTimeMillis(value8);
            }
            catch (NumberFormatException e) {
                LOG.error("illegal property 'druid.maxEvictableIdleTimeMillis'", e);
            }
        }
    }

    public boolean isUseGlobalDataSourceStat() {
        return this.useGlobalDataSourceStat;
    }

    public void setUseGlobalDataSourceStat(boolean useGlobalDataSourceStat) {
        this.useGlobalDataSourceStat = useGlobalDataSourceStat;
    }

    public String getInitStackTrace() {
        return this.initStackTrace;
    }

    @Override
    public boolean isResetStatEnable() {
        return this.resetStatEnable;
    }

    @Override
    public void setResetStatEnable(boolean resetStatEnable) {
        this.resetStatEnable = resetStatEnable;
        if (this.dataSourceStat != null) {
            this.dataSourceStat.setResetStatEnable(resetStatEnable);
        }
    }

    @Override
    public long getDiscardCount() {
        return this.discardCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() throws SQLException {
        this.lock.lock();
        try {
            if (this.activeCount > 0) {
                throw new SQLException("can not restart, activeCount not zero. " + this.activeCount);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("{dataSource-" + this.getID() + "} restart");
            }
            this.close();
            this.resetStat();
            this.inited = false;
            this.enable = true;
            this.closed = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetStat() {
        if (!this.isResetStatEnable()) {
            return;
        }
        this.lock.lock();
        try {
            this.connectCount = 0L;
            this.closeCount = 0L;
            this.discardCount = 0L;
            this.recycleCount = 0L;
            this.createCount.set(0L);
            this.destroyCount.set(0L);
            this.removeAbandonedCount = 0L;
            this.notEmptyWaitCount = 0L;
            this.notEmptySignalCount = 0L;
            this.notEmptyWaitNanos = 0L;
            this.activePeak = 0;
            this.activePeakTime = 0L;
            this.poolingPeak = 0;
            this.createTimespan = 0L;
            this.lastError = null;
            this.lastErrorTimeMillis = 0L;
            this.lastCreateError = null;
            this.lastCreateErrorTimeMillis = 0L;
        }
        finally {
            this.lock.unlock();
        }
        this.connectErrorCount.set(0L);
        this.errorCount.set(0L);
        this.commitCount.set(0L);
        this.rollbackCount.set(0L);
        this.startTransactionCount.set(0L);
        this.cachedPreparedStatementHitCount.set(0L);
        this.closedPreparedStatementCount.set(0L);
        this.preparedStatementCount.set(0L);
        this.transactionHistogram.reset();
        this.cachedPreparedStatementDeleteCount.set(0L);
        this.recycleErrorCount.set(0L);
        this.resetCount.incrementAndGet();
    }

    @Override
    public long getResetCount() {
        return this.resetCount.get();
    }

    @Override
    public boolean isEnable() {
        return this.enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnable(boolean enable) {
        this.lock.lock();
        try {
            this.enable = enable;
            if (!enable) {
                this.notEmpty.signalAll();
                ++this.notEmptySignalCount;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPoolPreparedStatements(boolean value) {
        if (this.poolPreparedStatements == value) {
            return;
        }
        this.poolPreparedStatements = value;
        if (!this.inited) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("set poolPreparedStatements " + this.poolPreparedStatements + " -> " + value);
        }
        if (!value) {
            this.lock.lock();
            try {
                for (int i = 0; i < this.poolingCount; ++i) {
                    DruidConnectionHolder connection = this.connections[i];
                    for (PreparedStatementHolder holder : connection.getStatementPool().getMap().values()) {
                        this.closePreapredStatement(holder);
                    }
                    connection.getStatementPool().getMap().clear();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxActive(int maxActive) {
        if (this.maxActive == maxActive) {
            return;
        }
        if (maxActive == 0) {
            throw new IllegalArgumentException("maxActive can't not set zero");
        }
        if (!this.inited) {
            this.maxActive = maxActive;
            return;
        }
        if (maxActive < this.minIdle) {
            throw new IllegalArgumentException("maxActive less than minIdle, " + maxActive + " < " + this.minIdle);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("maxActive changed : " + this.maxActive + " -> " + maxActive);
        }
        this.lock.lock();
        try {
            int allCount = this.poolingCount + this.activeCount;
            this.connections = maxActive > allCount ? Arrays.copyOf(this.connections, maxActive) : Arrays.copyOf(this.connections, allCount);
            this.maxActive = maxActive;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setConnectProperties(Properties properties) {
        boolean equals;
        if (properties == null) {
            properties = new Properties();
        }
        if (properties.size() == this.connectProperties.size()) {
            equals = true;
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object value = this.connectProperties.get(entry.getKey());
                Object entryValue = entry.getValue();
                if (value == null && entryValue != null) {
                    equals = false;
                } else {
                    if (value.equals(entry.getValue())) continue;
                    equals = false;
                }
                break;
            }
        } else {
            equals = false;
        }
        if (!equals) {
            if (this.inited && LOG.isInfoEnabled()) {
                LOG.info("connectProperties changed : " + this.connectProperties + " -> " + properties);
            }
            this.configFromPropety(properties);
            for (Filter filter : this.filters) {
                filter.configFromProperties(properties);
            }
            if (this.exceptionSorter != null) {
                this.exceptionSorter.configFromProperties(properties);
            }
            if (this.validConnectionChecker != null) {
                this.validConnectionChecker.configFromProperties(properties);
            }
            if (this.statLogger != null) {
                this.statLogger.configFromProperties(properties);
            }
        }
        this.connectProperties = properties;
    }

    public void init() throws SQLException {
        if (this.inited) {
            return;
        }
        ReentrantLock lock = this.lock;
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new SQLException("interrupt", e);
        }
        boolean init = false;
        try {
            if (this.inited) {
                return;
            }
            this.initStackTrace = Utils.toString(Thread.currentThread().getStackTrace());
            this.id = DruidDriver.createDataSourceId();
            if (this.id > 1L) {
                long delta = (this.id - 1L) * 100000L;
                this.connectionIdSeed.addAndGet(delta);
                this.statementIdSeed.addAndGet(delta);
                this.resultSetIdSeed.addAndGet(delta);
                this.transactionIdSeed.addAndGet(delta);
            }
            if (this.jdbcUrl != null) {
                this.jdbcUrl = this.jdbcUrl.trim();
                this.initFromWrapDriverUrl();
            }
            for (Filter filter : this.filters) {
                filter.init(this);
            }
            if (this.dbType == null || this.dbType.length() == 0) {
                this.dbType = JdbcUtils.getDbType(this.jdbcUrl, null);
            }
            if ("mysql".equals(this.dbType) || "mariadb".equals(this.dbType)) {
                boolean cacheServerConfigurationSet = false;
                if (this.connectProperties.containsKey("cacheServerConfiguration")) {
                    cacheServerConfigurationSet = true;
                } else if (this.jdbcUrl.indexOf("cacheServerConfiguration") != -1) {
                    cacheServerConfigurationSet = true;
                }
                if (cacheServerConfigurationSet) {
                    this.connectProperties.put("cacheServerConfiguration", "true");
                }
            }
            if (this.maxActive <= 0) {
                throw new IllegalArgumentException("illegal maxActive " + this.maxActive);
            }
            if (this.maxActive < this.minIdle) {
                throw new IllegalArgumentException("illegal maxActive " + this.maxActive);
            }
            if (this.getInitialSize() > this.maxActive) {
                throw new IllegalArgumentException("illegal initialSize " + this.initialSize + ", maxActieve " + this.maxActive);
            }
            if (this.timeBetweenLogStatsMillis > 0L && this.useGlobalDataSourceStat) {
                throw new IllegalArgumentException("timeBetweenLogStatsMillis not support useGlobalDataSourceStat=true");
            }
            if (this.maxEvictableIdleTimeMillis < this.minEvictableIdleTimeMillis) {
                throw new SQLException("maxEvictableIdleTimeMillis must be grater than minEvictableIdleTimeMillis");
            }
            if (this.driverClass != null) {
                this.driverClass = this.driverClass.trim();
            }
            this.initFromSPIServiceLoader();
            if (this.driver == null) {
                if (this.driverClass == null || this.driverClass.isEmpty()) {
                    this.driverClass = JdbcUtils.getDriverClassName(this.jdbcUrl);
                }
                this.driver = MockDriver.class.getName().equals(this.driverClass) ? MockDriver.instance : JdbcUtils.createDriver(this.driverClassLoader, this.driverClass);
            } else if (this.driverClass == null) {
                this.driverClass = this.driver.getClass().getName();
            }
            this.initCheck();
            this.initExceptionSorter();
            this.initValidConnectionChecker();
            this.validationQueryCheck();
            if (this.isUseGlobalDataSourceStat()) {
                this.dataSourceStat = JdbcDataSourceStat.getGlobal();
                if (this.dataSourceStat == null) {
                    this.dataSourceStat = new JdbcDataSourceStat("Global", "Global", this.dbType);
                    JdbcDataSourceStat.setGlobal(this.dataSourceStat);
                }
                if (this.dataSourceStat.getDbType() == null) {
                    this.dataSourceStat.setDbType(this.getDbType());
                }
            } else {
                this.dataSourceStat = new JdbcDataSourceStat(this.name, this.jdbcUrl, this.dbType, this.connectProperties);
            }
            this.dataSourceStat.setResetStatEnable(this.resetStatEnable);
            this.connections = new DruidConnectionHolder[this.maxActive];
            SQLException connectError = null;
            try {
                int size = this.getInitialSize();
                for (int i = 0; i < size; ++i) {
                    DruidConnectionHolder holder;
                    DruidAbstractDataSource.PhysicalConnectionInfo pyConnectInfo = this.createPhysicalConnection();
                    this.connections[this.poolingCount] = holder = new DruidConnectionHolder(this, pyConnectInfo);
                    this.incrementPoolingCount();
                }
                if (this.poolingCount > 0) {
                    this.poolingPeak = this.poolingCount;
                    this.poolingPeakTime = System.currentTimeMillis();
                }
            }
            catch (SQLException ex) {
                LOG.error("init datasource error, url: " + this.getUrl(), ex);
                connectError = ex;
            }
            this.createAndLogThread();
            this.createAndStartCreatorThread();
            this.createAndStartDestroyThread();
            this.initedLatch.await();
            init = true;
            this.initedTime = new Date();
            this.registerMbean();
            if (connectError != null && this.poolingCount == 0) {
                throw connectError;
            }
        }
        catch (SQLException e) {
            LOG.error("{dataSource-" + this.getID() + "} init error", e);
            throw e;
        }
        catch (InterruptedException e) {
            throw new SQLException(e.getMessage(), e);
        }
        finally {
            this.inited = true;
            lock.unlock();
            if (init && LOG.isInfoEnabled()) {
                LOG.info("{dataSource-" + this.getID() + "} inited");
            }
        }
    }

    private void createAndLogThread() {
        if (this.timeBetweenLogStatsMillis <= 0L) {
            return;
        }
        String threadName = "Druid-ConnectionPool-Log-" + System.identityHashCode(this);
        this.logStatsThread = new LogStatsThread(threadName);
        this.logStatsThread.start();
        this.resetStatEnable = false;
    }

    protected void createAndStartDestroyThread() {
        this.destroyTask = new DestroyTask();
        if (this.destroyScheduler != null) {
            long period = this.timeBetweenEvictionRunsMillis;
            if (period <= 0L) {
                period = 1000L;
            }
            this.destroySchedulerFuture = this.destroyScheduler.scheduleAtFixedRate(this.destroyTask, period, period, TimeUnit.MILLISECONDS);
            this.initedLatch.countDown();
            return;
        }
        String threadName = "Druid-ConnectionPool-Destroy-" + System.identityHashCode(this);
        this.destroyConnectionThread = new DestroyConnectionThread(threadName);
        this.destroyConnectionThread.start();
    }

    protected void createAndStartCreatorThread() {
        if (this.createScheduler == null) {
            String threadName = "Druid-ConnectionPool-Create-" + System.identityHashCode(this);
            this.createConnectionThread = new CreateConnectionThread(threadName);
            this.createConnectionThread.start();
            return;
        }
        this.initedLatch.countDown();
    }

    private void initFromSPIServiceLoader() {
        String property = System.getProperty("druid.load.spifilter.skip");
        if (property != null) {
            return;
        }
        ServiceLoader<Filter> druidAutoFilterLoader = ServiceLoader.load(Filter.class);
        for (Filter autoFilter : druidAutoFilterLoader) {
            AutoLoad autoLoad = autoFilter.getClass().getAnnotation(AutoLoad.class);
            if (autoLoad == null || !autoLoad.value()) continue;
            if (LOG.isInfoEnabled()) {
                LOG.info("load filter from spi :" + autoFilter.getClass().getName());
            }
            this.addFilter(autoFilter);
        }
    }

    private void initFromWrapDriverUrl() throws SQLException {
        if (!this.jdbcUrl.startsWith("jdbc:wrap-jdbc:")) {
            return;
        }
        DataSourceProxyConfig config = DruidDriver.parseConfig(this.jdbcUrl, null);
        this.driverClass = config.getRawDriverClassName();
        LOG.error("error url : '" + this.jdbcUrl + "', it should be : '" + config.getRawUrl() + "'");
        this.jdbcUrl = config.getRawUrl();
        if (this.name == null) {
            this.name = config.getName();
        }
        for (Filter filter : config.getFilters()) {
            this.addFilter(filter);
        }
    }

    private void addFilter(Filter filter) {
        boolean exists = false;
        for (Filter initedFilter : this.filters) {
            if (initedFilter.getClass() != filter.getClass()) continue;
            exists = true;
            break;
        }
        if (!exists) {
            filter.init(this);
            this.filters.add(filter);
        }
    }

    private void validationQueryCheck() {
        if (!(this.isTestOnBorrow() || this.isTestOnReturn() || this.isTestWhileIdle())) {
            return;
        }
        if (this.validConnectionChecker != null) {
            return;
        }
        if (this.getValidationQuery() != null && this.getValidationQuery().length() > 0) {
            return;
        }
        String errorMessage = "";
        if (this.isTestOnBorrow()) {
            errorMessage = errorMessage + "testOnBorrow is true, ";
        }
        if (this.isTestOnReturn()) {
            errorMessage = errorMessage + "testOnReturn is true, ";
        }
        if (this.isTestWhileIdle()) {
            errorMessage = errorMessage + "testWhileIdle is true, ";
        }
        LOG.error(errorMessage + "validationQuery not set");
    }

    protected void initCheck() throws SQLException {
        if ("oracle".equals(this.dbType)) {
            this.isOracle = true;
            if (this.driver.getMajorVersion() < 10) {
                throw new SQLException("not support oracle driver " + this.driver.getMajorVersion() + "." + this.driver.getMinorVersion());
            }
            if (this.driver.getMajorVersion() == 10 && this.isUseOracleImplicitCache()) {
                this.getConnectProperties().setProperty("oracle.jdbc.FreeMemoryOnEnterImplicitCache", "true");
            }
            this.oracleValidationQueryCheck();
        } else if ("db2".equals(this.dbType)) {
            this.db2ValidationQueryCheck();
        }
    }

    private void oracleValidationQueryCheck() {
        if (this.validationQuery == null) {
            return;
        }
        if (this.validationQuery.length() == 0) {
            return;
        }
        SQLStatementParser sqlStmtParser = SQLParserUtils.createSQLStatementParser(this.validationQuery, this.dbType);
        List<SQLStatement> stmtList = sqlStmtParser.parseStatementList();
        if (stmtList.size() != 1) {
            return;
        }
        SQLStatement stmt = stmtList.get(0);
        if (!(stmt instanceof SQLSelectStatement)) {
            return;
        }
        SQLSelectQuery query = ((SQLSelectStatement)stmt).getSelect().getQuery();
        if (query instanceof SQLSelectQueryBlock && ((SQLSelectQueryBlock)query).getFrom() == null) {
            LOG.error("invalid oracle validationQuery. " + this.validationQuery + ", may should be : " + this.validationQuery + " FROM DUAL");
        }
    }

    private void db2ValidationQueryCheck() {
        if (this.validationQuery == null) {
            return;
        }
        if (this.validationQuery.length() == 0) {
            return;
        }
        SQLStatementParser sqlStmtParser = SQLParserUtils.createSQLStatementParser(this.validationQuery, this.dbType);
        List<SQLStatement> stmtList = sqlStmtParser.parseStatementList();
        if (stmtList.size() != 1) {
            return;
        }
        SQLStatement stmt = stmtList.get(0);
        if (!(stmt instanceof SQLSelectStatement)) {
            return;
        }
        SQLSelectQuery query = ((SQLSelectStatement)stmt).getSelect().getQuery();
        if (query instanceof SQLSelectQueryBlock && ((SQLSelectQueryBlock)query).getFrom() == null) {
            LOG.error("invalid db2 validationQuery. " + this.validationQuery + ", may should be : " + this.validationQuery + " FROM SYSDUMMY");
        }
    }

    private void initValidConnectionChecker() {
        String realDriverClassName = this.driver.getClass().getName();
        if (realDriverClassName.equals("com.mysql.jdbc.Driver")) {
            this.validConnectionChecker = new MySqlValidConnectionChecker();
        } else if (realDriverClassName.equals("oracle.jdbc.OracleDriver")) {
            this.validConnectionChecker = new OracleValidConnectionChecker();
        } else if (realDriverClassName.equals("com.microsoft.jdbc.sqlserver.SQLServerDriver")) {
            this.validConnectionChecker = new MSSQLValidConnectionChecker();
        } else if (realDriverClassName.equals("org.postgresql.Driver")) {
            this.validConnectionChecker = new PGValidConnectionChecker();
        }
    }

    private void initExceptionSorter() {
        if (this.exceptionSorter instanceof NullExceptionSorter ? this.driver instanceof MockDriver : this.exceptionSorter != null) {
            return;
        }
        String realDriverClassName = this.driver.getClass().getName();
        if (realDriverClassName.equals("com.mysql.jdbc.Driver")) {
            this.exceptionSorter = new MySqlExceptionSorter();
        } else if (realDriverClassName.equals("oracle.jdbc.OracleDriver")) {
            this.exceptionSorter = new OracleExceptionSorter();
        } else if (realDriverClassName.equals("com.informix.jdbc.IfxDriver")) {
            this.exceptionSorter = new InformixExceptionSorter();
        } else if (realDriverClassName.equals("com.sybase.jdbc2.jdbc.SybDriver")) {
            this.exceptionSorter = new SybaseExceptionSorter();
        } else if (realDriverClassName.equals("org.postgresql.Driver")) {
            this.exceptionSorter = new PGExceptionSorter();
        } else if (realDriverClassName.equals("com.alibaba.druid.mock.MockDriver")) {
            this.exceptionSorter = new MockExceptionSorter();
        } else if (realDriverClassName.contains("DB2")) {
            this.exceptionSorter = new DB2ExceptionSorter();
        }
    }

    @Override
    public DruidPooledConnection getConnection() throws SQLException {
        return this.getConnection(this.maxWait);
    }

    public DruidPooledConnection getConnection(long maxWaitMillis) throws SQLException {
        this.init();
        if (this.filters.size() > 0) {
            FilterChainImpl filterChain = new FilterChainImpl(this);
            return filterChain.dataSource_connect(this, maxWaitMillis);
        }
        return this.getConnectionDirect(maxWaitMillis);
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return this.getConnection(this.maxWait);
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        throw new UnsupportedOperationException("Not supported by DruidDataSource");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidPooledConnection getConnectionDirect(long maxWaitMillis) throws SQLException {
        DruidPooledConnection poolableConnection;
        int notFullTimeoutRetryCnt = 0;
        while (true) {
            boolean validate;
            try {
                poolableConnection = this.getConnectionInternal(maxWaitMillis);
            }
            catch (GetConnectionTimeoutException ex) {
                if (notFullTimeoutRetryCnt <= this.notFullTimeoutRetryCount && !this.isFull()) {
                    ++notFullTimeoutRetryCnt;
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn("not full timeout retry : " + notFullTimeoutRetryCnt);
                    continue;
                }
                throw ex;
            }
            if (this.isTestOnBorrow()) {
                boolean validate2 = this.testConnectionInternal(poolableConnection.getConnection());
                if (validate2) break;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("skip not validate connection.");
                }
                Connection realConnection = poolableConnection.getConnection();
                this.discardConnection(realConnection);
                continue;
            }
            Connection realConnection = poolableConnection.getConnection();
            if (realConnection.isClosed()) {
                this.discardConnection(null);
                continue;
            }
            if (!this.isTestWhileIdle()) break;
            long currentTimeMillis = System.currentTimeMillis();
            long lastActiveTimeMillis = poolableConnection.getConnectionHolder().getLastActiveTimeMillis();
            long idleMillis = currentTimeMillis - lastActiveTimeMillis;
            long timeBetweenEvictionRunsMillis = this.getTimeBetweenEvictionRunsMillis();
            if (timeBetweenEvictionRunsMillis <= 0L) {
                timeBetweenEvictionRunsMillis = 60000L;
            }
            if (idleMillis < timeBetweenEvictionRunsMillis || (validate = this.testConnectionInternal(poolableConnection.getConnection()))) break;
            if (LOG.isDebugEnabled()) {
                LOG.debug("skip not validate connection.");
            }
            this.discardConnection(realConnection);
        }
        if (this.isRemoveAbandoned()) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            poolableConnection.setConnectStackTrace(stackTrace);
            poolableConnection.setConnectedTimeNano();
            poolableConnection.setTraceEnable(true);
            Map map = this.activeConnections;
            synchronized (map) {
                this.activeConnections.put(poolableConnection, PRESENT);
            }
        }
        if (!this.isDefaultAutoCommit()) {
            poolableConnection.setAutoCommit(false);
        }
        return poolableConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardConnection(Connection realConnection) {
        JdbcUtils.close(realConnection);
        this.lock.lock();
        try {
            --this.activeCount;
            ++this.discardCount;
            if (this.activeCount <= this.minIdle) {
                this.emptySignal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private DruidPooledConnection getConnectionInternal(long maxWait) throws SQLException {
        DruidConnectionHolder holder;
        if (this.closed) {
            this.connectErrorCount.incrementAndGet();
            throw new DataSourceClosedException("dataSource already closed at " + new Date(this.closeTimeMillis));
        }
        if (!this.enable) {
            this.connectErrorCount.incrementAndGet();
            throw new DataSourceDisableException();
        }
        long nanos = TimeUnit.MILLISECONDS.toNanos(maxWait);
        int maxWaitThreadCount = this.getMaxWaitThreadCount();
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            this.connectErrorCount.incrementAndGet();
            throw new SQLException("interrupt", e);
        }
        try {
            if (maxWaitThreadCount > 0 && this.notEmptyWaitThreadCount >= maxWaitThreadCount) {
                this.connectErrorCount.incrementAndGet();
                throw new SQLException("maxWaitThreadCount " + maxWaitThreadCount + ", current wait Thread count " + this.lock.getQueueLength());
            }
            ++this.connectCount;
            holder = maxWait > 0L ? this.pollLast(nanos) : this.takeLast();
            if (holder != null) {
                ++this.activeCount;
                if (this.activeCount > this.activePeak) {
                    this.activePeak = this.activeCount;
                    this.activePeakTime = System.currentTimeMillis();
                }
            }
        }
        catch (InterruptedException e) {
            this.connectErrorCount.incrementAndGet();
            throw new SQLException(e.getMessage(), e);
        }
        catch (SQLException e) {
            this.connectErrorCount.incrementAndGet();
            throw e;
        }
        finally {
            this.lock.unlock();
        }
        if (holder == null) {
            long waitNanos = waitNanosLocal.get();
            StringBuilder buf = new StringBuilder();
            buf.append("wait millis ").append(waitNanos / 1000000L).append(", active " + this.activeCount).append(", maxActive " + this.maxActive);
            List<JdbcSqlStatValue> sqlList = this.getDataSourceStat().getRuningSqlList();
            for (int i = 0; i < sqlList.size(); ++i) {
                if (i != 0) {
                    buf.append('\n');
                } else {
                    buf.append(", ");
                }
                JdbcSqlStatValue sql = sqlList.get(i);
                buf.append("runningSqlCount ");
                buf.append(sql.getRunningCount());
                buf.append(" : ");
                buf.append(sql.getSql());
            }
            String errorMessage = buf.toString();
            if (this.createError != null) {
                throw new GetConnectionTimeoutException(errorMessage, this.createError);
            }
            throw new GetConnectionTimeoutException(errorMessage);
        }
        holder.incrementUseCount();
        DruidPooledConnection poolalbeConnection = new DruidPooledConnection(holder);
        return poolalbeConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleConnectionException(DruidPooledConnection pooledConnection, Throwable t) throws SQLException {
        DruidConnectionHolder holder = pooledConnection.getConnectionHolder();
        this.errorCount.incrementAndGet();
        this.lastError = t;
        this.lastErrorTimeMillis = System.currentTimeMillis();
        if (t instanceof SQLException) {
            SQLException sqlEx = (SQLException)t;
            ConnectionEvent event = new ConnectionEvent(pooledConnection, sqlEx);
            for (ConnectionEventListener eventListener : holder.getConnectionEventListeners()) {
                eventListener.connectionErrorOccurred(event);
            }
            if (this.exceptionSorter != null && this.exceptionSorter.isExceptionFatal(sqlEx)) {
                if (pooledConnection.isTraceEnable()) {
                    Map i$ = this.activeConnections;
                    synchronized (i$) {
                        if (pooledConnection.isTraceEnable()) {
                            this.activeConnections.remove(pooledConnection);
                            pooledConnection.setTraceEnable(false);
                        }
                    }
                }
                boolean requireDiscard = false;
                DruidPooledConnection druidPooledConnection = pooledConnection;
                synchronized (druidPooledConnection) {
                    if (!pooledConnection.isClosed() || !pooledConnection.isDisable()) {
                        holder.setDiscard(true);
                        pooledConnection.disable(t);
                        requireDiscard = true;
                    }
                }
                if (requireDiscard) {
                    this.discardConnection(holder.getConnection());
                    holder.setDiscard(true);
                }
                LOG.error("discard connection", sqlEx);
            }
            throw sqlEx;
        }
        throw new SQLException("Error", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void recycle(DruidPooledConnection pooledConnection) throws SQLException {
        DruidConnectionHolder holder = pooledConnection.getConnectionHolder();
        if (holder == null) {
            LOG.warn("connectionHolder is null");
            return;
        }
        if (this.logDifferentThread && !this.isAsyncCloseConnectionEnable() && pooledConnection.getOwnerThread() != Thread.currentThread()) {
            LOG.warn("get/close not same thread");
        }
        Connection physicalConnection = holder.getConnection();
        if (pooledConnection.isTraceEnable()) {
            Map map = this.activeConnections;
            synchronized (map) {
                if (pooledConnection.isTraceEnable()) {
                    Object oldInfo = this.activeConnections.remove(pooledConnection);
                    if (oldInfo == null && LOG.isWarnEnabled()) {
                        LOG.warn("remove abandonded failed. activeConnections.size " + this.activeConnections.size());
                    }
                    pooledConnection.setTraceEnable(false);
                }
            }
        }
        boolean isAutoCommit = holder.isUnderlyingAutoCommit();
        boolean isReadOnly = holder.isUnderlyingReadOnly();
        boolean testOnReturn = this.isTestOnReturn();
        try {
            boolean result;
            boolean validate;
            boolean isSameThread;
            if (!isAutoCommit && !isReadOnly) {
                pooledConnection.rollback();
            }
            boolean bl = isSameThread = pooledConnection.getOwnerThread() == Thread.currentThread();
            if (!isSameThread) {
                DruidPooledConnection druidPooledConnection = pooledConnection;
                synchronized (druidPooledConnection) {
                    holder.reset();
                }
            } else {
                holder.reset();
            }
            if (holder.isDiscard()) {
                return;
            }
            if (testOnReturn && !(validate = this.testConnectionInternal(physicalConnection))) {
                JdbcUtils.close(physicalConnection);
                this.destroyCount.incrementAndGet();
                this.lock.lock();
                try {
                    --this.activeCount;
                    ++this.closeCount;
                }
                finally {
                    this.lock.unlock();
                }
                return;
            }
            if (!this.enable) {
                this.discardConnection(holder.getConnection());
                return;
            }
            long lastActiveTimeMillis = System.currentTimeMillis();
            this.lock.lockInterruptibly();
            try {
                --this.activeCount;
                ++this.closeCount;
                result = this.putLast(holder, lastActiveTimeMillis);
                ++this.recycleCount;
            }
            finally {
                this.lock.unlock();
            }
            if (!result) {
                JdbcUtils.close(holder.getConnection());
                LOG.info("connection recyle failed.");
            }
        }
        catch (Throwable e) {
            holder.clearStatementCache();
            if (!holder.isDiscard()) {
                this.discardConnection(physicalConnection);
                holder.setDiscard(true);
            }
            LOG.error("recyle error", e);
            this.recycleErrorCount.incrementAndGet();
        }
    }

    public long getRecycleErrorCount() {
        return this.recycleErrorCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStatementCache() throws SQLException {
        this.lock.lock();
        try {
            for (int i = 0; i < this.poolingCount; ++i) {
                DruidConnectionHolder conn = this.connections[i];
                conn.getStatementPool().clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            if (!this.inited) {
                return;
            }
            if (this.logStatsThread != null) {
                this.logStatsThread.interrupt();
            }
            if (this.createConnectionThread != null) {
                this.createConnectionThread.interrupt();
            }
            if (this.destroyConnectionThread != null) {
                this.destroyConnectionThread.interrupt();
            }
            if (this.destroySchedulerFuture != null) {
                this.destroySchedulerFuture.cancel(true);
            }
            for (int i = 0; i < this.poolingCount; ++i) {
                try {
                    DruidConnectionHolder connHolder = this.connections[i];
                    for (PreparedStatementHolder stmtHolder : connHolder.getStatementPool().getMap().values()) {
                        connHolder.getStatementPool().closeRemovedStatement(stmtHolder);
                    }
                    connHolder.getStatementPool().getMap().clear();
                    Connection physicalConnection = connHolder.getConnection();
                    physicalConnection.close();
                    this.connections[i] = null;
                    this.destroyCount.incrementAndGet();
                    continue;
                }
                catch (Exception ex) {
                    LOG.warn("close connection error", ex);
                }
            }
            this.poolingCount = 0;
            this.unregisterMbean();
            this.enable = false;
            this.notEmpty.signalAll();
            ++this.notEmptySignalCount;
            this.closed = true;
            this.closeTimeMillis = System.currentTimeMillis();
            for (Filter filter : this.filters) {
                filter.destroy();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("{dataSource-" + this.getID() + "} closed");
        }
    }

    public void registerMbean() {
        if (!this.mbeanRegistered) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ObjectName objectName = DruidDataSourceStatManager.addDataSource(DruidDataSource.this, DruidDataSource.this.name);
                    DruidDataSource.this.setObjectName(objectName);
                    DruidDataSource.this.mbeanRegistered = true;
                    return null;
                }
            });
        }
    }

    public void unregisterMbean() {
        if (this.mbeanRegistered) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    DruidDataSourceStatManager.removeDataSource(DruidDataSource.this);
                    DruidDataSource.this.mbeanRegistered = false;
                    return null;
                }
            });
        }
    }

    public boolean isMbeanRegistered() {
        return this.mbeanRegistered;
    }

    boolean putLast(DruidConnectionHolder e, long lastActiveTimeMillis) {
        if (this.poolingCount >= this.maxActive) {
            return false;
        }
        e.setLastActiveTimeMillis(lastActiveTimeMillis);
        this.connections[this.poolingCount] = e;
        this.incrementPoolingCount();
        if (this.poolingCount > this.poolingPeak) {
            this.poolingPeak = this.poolingCount;
            this.poolingPeakTime = lastActiveTimeMillis;
        }
        this.notEmpty.signal();
        ++this.notEmptySignalCount;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DruidConnectionHolder takeLast() throws InterruptedException, SQLException {
        try {
            while (this.poolingCount == 0) {
                this.emptySignal();
                if (this.failFast && this.failContinuous.get()) {
                    throw new DataSourceNotAvailableException(this.createError);
                }
                ++this.notEmptyWaitThreadCount;
                if (this.notEmptyWaitThreadCount > this.notEmptyWaitThreadPeak) {
                    this.notEmptyWaitThreadPeak = this.notEmptyWaitThreadCount;
                }
                try {
                    this.notEmpty.await();
                }
                finally {
                    --this.notEmptyWaitThreadCount;
                }
                ++this.notEmptyWaitCount;
                if (this.enable) continue;
                this.connectErrorCount.incrementAndGet();
                throw new DataSourceDisableException();
            }
        }
        catch (InterruptedException ie) {
            this.notEmpty.signal();
            ++this.notEmptySignalCount;
            throw ie;
        }
        this.decrementPoolingCount();
        DruidConnectionHolder last = this.connections[this.poolingCount];
        this.connections[this.poolingCount] = null;
        return last;
    }

    private DruidConnectionHolder pollLast(long nanos) throws InterruptedException, SQLException {
        long estimate = nanos;
        while (this.poolingCount == 0) {
            this.emptySignal();
            if (this.failFast && this.failContinuous.get()) {
                throw new DataSourceNotAvailableException(this.createError);
            }
            if (estimate <= 0L) {
                waitNanosLocal.set(nanos - estimate);
                return null;
            }
            ++this.notEmptyWaitThreadCount;
            if (this.notEmptyWaitThreadCount > this.notEmptyWaitThreadPeak) {
                this.notEmptyWaitThreadPeak = this.notEmptyWaitThreadCount;
            }
            try {
                long startEstimate = estimate;
                estimate = this.notEmpty.awaitNanos(estimate);
                ++this.notEmptyWaitCount;
                this.notEmptyWaitNanos += startEstimate - estimate;
                if (!this.enable) {
                    this.connectErrorCount.incrementAndGet();
                    throw new DataSourceDisableException();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                ++this.notEmptySignalCount;
                throw ie;
            }
            finally {
                --this.notEmptyWaitThreadCount;
            }
            if (this.poolingCount != 0) break;
            if (estimate > 0L) continue;
            waitNanosLocal.set(nanos - estimate);
            return null;
        }
        this.decrementPoolingCount();
        DruidConnectionHolder last = this.connections[this.poolingCount];
        this.connections[this.poolingCount] = null;
        long waitNanos = nanos - estimate;
        last.setLastNotEmptyWaitNanos(waitNanos);
        return last;
    }

    private final void decrementPoolingCount() {
        --this.poolingCount;
    }

    private final void incrementPoolingCount() {
        ++this.poolingCount;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (!StringUtils.equals(username, this.username)) {
            throw new UnsupportedOperationException("Not supported by DruidDataSource");
        }
        if (!StringUtils.equals(password, this.password)) {
            throw new UnsupportedOperationException("Not supported by DruidDataSource");
        }
        return this.getConnection();
    }

    @Override
    public long getCreateCount() {
        return this.createCount.get();
    }

    @Override
    public long getDestroyCount() {
        return this.destroyCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getConnectCount() {
        this.lock.lock();
        try {
            long l = this.connectCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getCloseCount() {
        return this.closeCount;
    }

    @Override
    public long getConnectErrorCount() {
        return this.connectErrorCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPoolingCount() {
        this.lock.lock();
        try {
            int n = this.poolingCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPoolingPeak() {
        this.lock.lock();
        try {
            int n = this.poolingPeak;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Date getPoolingPeakTime() {
        if (this.poolingPeakTime <= 0L) {
            return null;
        }
        return new Date(this.poolingPeakTime);
    }

    @Override
    public long getRecycleCount() {
        return this.recycleCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveCount() {
        this.lock.lock();
        try {
            int n = this.activeCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void logStats() {
        DruidDataSourceStatLogger statLogger = this.statLogger;
        if (statLogger == null) {
            return;
        }
        DruidDataSourceStatValue statValue = this.getStatValueAndReset();
        statLogger.log(statValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidDataSourceStatValue getStatValueAndReset() {
        DruidDataSourceStatValue value = new DruidDataSourceStatValue();
        this.lock.lock();
        try {
            value.setPoolingCount(this.poolingCount);
            value.setPoolingPeak(this.poolingPeak);
            value.setPoolingPeakTime(this.poolingPeakTime);
            value.setActiveCount(this.activeCount);
            value.setActivePeak(this.activePeak);
            value.setActivePeakTime(this.activePeakTime);
            value.setConnectCount(this.connectCount);
            value.setCloseCount(this.closeCount);
            value.setWaitThreadCount(this.lock.getWaitQueueLength(this.notEmpty));
            value.setNotEmptyWaitCount(this.notEmptyWaitCount);
            value.setNotEmptyWaitNanos(this.notEmptyWaitNanos);
            this.poolingPeak = 0;
            this.poolingPeakTime = 0L;
            this.activePeak = 0;
            this.activePeakTime = 0L;
            this.connectCount = 0L;
            this.closeCount = 0L;
            this.notEmptyWaitCount = 0L;
            this.notEmptyWaitNanos = 0L;
        }
        finally {
            this.lock.unlock();
        }
        value.setName(this.getName());
        value.setDbType(this.getDbType());
        value.setDriverClassName(this.getDriverClassName());
        value.setUrl(this.getUrl());
        value.setUserName(this.getUsername());
        value.setFilterClassNames(this.getFilterClassNames());
        value.setInitialSize(this.getInitialSize());
        value.setMinIdle(this.getMinIdle());
        value.setMaxActive(this.getMaxActive());
        value.setQueryTimeout(this.getQueryTimeout());
        value.setTransactionQueryTimeout(this.getTransactionQueryTimeout());
        value.setLoginTimeout(this.getLoginTimeout());
        value.setValidConnectionCheckerClassName(this.getValidConnectionCheckerClassName());
        value.setExceptionSorterClassName(this.getExceptionSorterClassName());
        value.setTestOnBorrow(this.isTestOnBorrow());
        value.setTestOnReturn(this.isTestOnReturn());
        value.setTestWhileIdle(this.isTestWhileIdle());
        value.setDefaultAutoCommit(this.isDefaultAutoCommit());
        if (this.defaultReadOnly != null) {
            value.setDefaultReadOnly(this.defaultReadOnly);
        }
        value.setDefaultTransactionIsolation(this.getDefaultTransactionIsolation());
        value.setLogicConnectErrorCount(this.connectErrorCount.getAndSet(0L));
        value.setPhysicalConnectCount(this.createCount.getAndSet(0L));
        value.setPhysicalCloseCount(this.destroyCount.getAndSet(0L));
        value.setPhysicalConnectErrorCount(this.createErrorCount.getAndSet(0L));
        value.setExecuteCount(this.executeCount.getAndSet(0L));
        value.setErrorCount(this.errorCount.getAndSet(0L));
        value.setCommitCount(this.commitCount.getAndSet(0L));
        value.setRollbackCount(this.rollbackCount.getAndSet(0L));
        value.setPstmtCacheHitCount(this.cachedPreparedStatementHitCount.getAndSet(0L));
        value.setPstmtCacheMissCount(this.cachedPreparedStatementMissCount.getAndSet(0L));
        value.setStartTransactionCount(this.startTransactionCount.getAndSet(0L));
        value.setTransactionHistogram(this.getTransactionHistogram().toArrayAndReset());
        value.setConnectionHoldTimeHistogram(this.getDataSourceStat().getConnectionHoldHistogram().toArrayAndReset());
        value.removeAbandoned = this.isRemoveAbandoned();
        value.setClobOpenCount(this.getDataSourceStat().getClobOpenCountAndReset());
        value.setBlobOpenCount(this.getDataSourceStat().getBlobOpenCountAndReset());
        value.setSqlSkipCount(this.getDataSourceStat().getSkipSqlCountAndReset());
        value.setSqlList(this.getDataSourceStat().getSqlStatMapAndReset());
        return value;
    }

    @Override
    public long getRemoveAbandonedCount() {
        return this.removeAbandonedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean put(DruidAbstractDataSource.PhysicalConnectionInfo physicalConnectionInfo) {
        DruidConnectionHolder holder = null;
        try {
            holder = new DruidConnectionHolder(this, physicalConnectionInfo);
        }
        catch (SQLException ex) {
            this.lock.lock();
            try {
                if (this.createScheduler != null) {
                    --this.createTaskCount;
                }
            }
            finally {
                this.lock.unlock();
            }
            LOG.error("create connection holder error", ex);
            return false;
        }
        this.lock.lock();
        try {
            if (this.poolingCount >= this.maxActive) {
                boolean bl = false;
                return bl;
            }
            this.connections[this.poolingCount] = holder;
            this.incrementPoolingCount();
            if (this.poolingCount > this.poolingPeak) {
                this.poolingPeak = this.poolingCount;
                this.poolingPeakTime = System.currentTimeMillis();
            }
            this.notEmpty.signal();
            ++this.notEmptySignalCount;
            if (this.createScheduler != null) {
                --this.createTaskCount;
                if (this.poolingCount + this.createTaskCount < this.notEmptyWaitThreadCount && this.activeCount + this.poolingCount + this.createTaskCount < this.maxActive) {
                    this.emptySignal();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAbandoned() {
        DruidPooledConnection pooledConnection;
        int removeCount = 0;
        long currrentNanos = System.nanoTime();
        ArrayList<DruidPooledConnection> abandonedList = new ArrayList<DruidPooledConnection>();
        Map map = this.activeConnections;
        synchronized (map) {
            Iterator iter = this.activeConnections.keySet().iterator();
            while (iter.hasNext()) {
                long timeMillis;
                pooledConnection = (DruidPooledConnection)iter.next();
                if (pooledConnection.isRunning() || (timeMillis = (currrentNanos - pooledConnection.getConnectedTimeNano()) / 1000000L) < this.removeAbandonedTimeoutMillis) continue;
                iter.remove();
                pooledConnection.setTraceEnable(false);
                abandonedList.add(pooledConnection);
            }
        }
        if (abandonedList.size() > 0) {
            Iterator i$ = abandonedList.iterator();
            while (i$.hasNext()) {
                int i;
                DruidPooledConnection pooledConnection2;
                pooledConnection = pooledConnection2 = (DruidPooledConnection)i$.next();
                synchronized (pooledConnection) {
                    if (pooledConnection2.isDisable()) {
                        continue;
                    }
                }
                JdbcUtils.close(pooledConnection2);
                pooledConnection2.abandond();
                ++this.removeAbandonedCount;
                ++removeCount;
                if (!this.isLogAbandoned()) continue;
                StringBuilder buf = new StringBuilder();
                buf.append("abandon connection, owner thread: ");
                buf.append(pooledConnection2.getOwnerThread().getName());
                buf.append(", connected at : ");
                buf.append(pooledConnection2.getConnectedTimeMillis());
                buf.append(", open stackTrace\n");
                StackTraceElement[] trace = pooledConnection2.getConnectStackTrace();
                for (i = 0; i < trace.length; ++i) {
                    buf.append("\tat ");
                    buf.append(trace[i].toString());
                    buf.append("\n");
                }
                buf.append("ownerThread current state is " + (Object)((Object)pooledConnection2.getOwnerThread().getState()) + ", current stackTrace\n");
                trace = pooledConnection2.getOwnerThread().getStackTrace();
                for (i = 0; i < trace.length; ++i) {
                    buf.append("\tat ");
                    buf.append(trace[i].toString());
                    buf.append("\n");
                }
                LOG.error(buf.toString());
            }
        }
        return removeCount;
    }

    @Override
    public Reference getReference() throws NamingException {
        String className = this.getClass().getName();
        String factoryName = className + "Factory";
        Reference ref = new Reference(className, factoryName, null);
        ref.add(new StringRefAddr("instanceKey", this.instanceKey));
        ref.add(new StringRefAddr("url", this.getUrl()));
        ref.add(new StringRefAddr("username", this.getUsername()));
        ref.add(new StringRefAddr("password", this.getPassword()));
        return ref;
    }

    @Override
    public List<String> getFilterClassNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Filter filter : this.filters) {
            names.add(filter.getClass().getName());
        }
        return names;
    }

    @Override
    public int getRawDriverMajorVersion() {
        int version = -1;
        if (this.driver != null) {
            version = this.driver.getMajorVersion();
        }
        return version;
    }

    @Override
    public int getRawDriverMinorVersion() {
        int version = -1;
        if (this.driver != null) {
            version = this.driver.getMinorVersion();
        }
        return version;
    }

    @Override
    public String getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.connectProperties);
        if (properties.containsKey("password")) {
            properties.put("password", "******");
        }
        return properties.toString();
    }

    @Override
    public void shrink() {
        this.shrink(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shrink(boolean checkTime) {
        ArrayList<DruidConnectionHolder> evictList = new ArrayList<DruidConnectionHolder>();
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            return;
        }
        try {
            int removeCount;
            int checkCount = this.poolingCount - this.minIdle;
            long currentTimeMillis = System.currentTimeMillis();
            for (int i = 0; i < this.poolingCount; ++i) {
                DruidConnectionHolder connection = this.connections[i];
                if (checkTime) {
                    long phyConnectTimeMillis;
                    if (this.phyTimeoutMillis > 0L && (phyConnectTimeMillis = currentTimeMillis - connection.getTimeMillis()) > this.phyTimeoutMillis) {
                        evictList.add(connection);
                        continue;
                    }
                    long idleMillis = currentTimeMillis - connection.getLastActiveTimeMillis();
                    if (idleMillis < this.minEvictableIdleTimeMillis) break;
                    if (checkTime && i < checkCount) {
                        evictList.add(connection);
                        continue;
                    }
                    if (idleMillis <= this.maxEvictableIdleTimeMillis) continue;
                    evictList.add(connection);
                    continue;
                }
                if (i >= checkCount) break;
                evictList.add(connection);
            }
            if ((removeCount = evictList.size()) > 0) {
                System.arraycopy(this.connections, removeCount, this.connections, 0, this.poolingCount - removeCount);
                Arrays.fill(this.connections, this.poolingCount - removeCount, this.poolingCount, null);
                this.poolingCount -= removeCount;
            }
        }
        finally {
            this.lock.unlock();
        }
        for (DruidConnectionHolder item : evictList) {
            Connection connection = item.getConnection();
            JdbcUtils.close(connection);
            this.destroyCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWaitThreadCount() {
        this.lock.lock();
        try {
            int n = this.lock.getWaitQueueLength(this.notEmpty);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getNotEmptyWaitCount() {
        return this.notEmptyWaitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNotEmptyWaitThreadCount() {
        this.lock.lock();
        try {
            int n = this.notEmptyWaitThreadCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNotEmptyWaitThreadPeak() {
        this.lock.lock();
        try {
            int n = this.notEmptyWaitThreadPeak;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getNotEmptySignalCount() {
        return this.notEmptySignalCount;
    }

    @Override
    public long getNotEmptyWaitMillis() {
        return this.notEmptyWaitNanos / 1000000L;
    }

    @Override
    public long getNotEmptyWaitNanos() {
        return this.notEmptyWaitNanos;
    }

    @Override
    public int getLockQueueLength() {
        return this.lock.getQueueLength();
    }

    @Override
    public int getActivePeak() {
        return this.activePeak;
    }

    @Override
    public Date getActivePeakTime() {
        if (this.activePeakTime <= 0L) {
            return null;
        }
        return new Date(this.activePeakTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dump() {
        this.lock.lock();
        try {
            String string = this.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getErrorCount() {
        return this.errorCount.get();
    }

    public String toString() {
        DruidConnectionHolder conn;
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("\n\tCreateTime:\"");
        buf.append(Utils.toString(this.getCreatedTime()));
        buf.append("\"");
        buf.append(",\n\tActiveCount:");
        buf.append(this.getActiveCount());
        buf.append(",\n\tPoolingCount:");
        buf.append(this.getPoolingCount());
        buf.append(",\n\tCreateCount:");
        buf.append(this.getCreateCount());
        buf.append(",\n\tDestroyCount:");
        buf.append(this.getDestroyCount());
        buf.append(",\n\tCloseCount:");
        buf.append(this.getCloseCount());
        buf.append(",\n\tConnectCount:");
        buf.append(this.getConnectCount());
        buf.append(",\n\tConnections:[");
        for (i = 0; i < this.poolingCount; ++i) {
            conn = this.connections[i];
            if (conn == null) continue;
            if (i != 0) {
                buf.append(",");
            }
            buf.append("\n\t\t");
            buf.append(conn.toString());
        }
        buf.append("\n\t]");
        buf.append("\n}");
        if (this.isPoolPreparedStatements()) {
            buf.append("\n\n[");
            for (i = 0; i < this.poolingCount; ++i) {
                conn = this.connections[i];
                if (conn == null) continue;
                if (i != 0) {
                    buf.append(",");
                }
                buf.append("\n\t{\n\tID:");
                buf.append(System.identityHashCode(conn.getConnection()));
                PreparedStatementPool pool = conn.getStatementPool();
                buf.append(", \n\tpoolStatements:[");
                int entryIndex = 0;
                try {
                    for (Map.Entry<DruidPooledPreparedStatement.PreparedStatementKey, PreparedStatementHolder> entry : pool.getMap().entrySet()) {
                        if (entryIndex != 0) {
                            buf.append(",");
                        }
                        buf.append("\n\t\t{hitCount:");
                        buf.append(entry.getValue().getHitCount());
                        buf.append(",sql:\"");
                        buf.append(entry.getKey().getSql());
                        buf.append("\"");
                        buf.append("\t}");
                        ++entryIndex;
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                buf.append("\n\t\t]");
                buf.append("\n\t}");
            }
            buf.append("\n]");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getPoolingConnectionInfo() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.lock.lock();
        try {
            for (int i = 0; i < this.poolingCount; ++i) {
                DruidConnectionHolder connHolder = this.connections[i];
                Connection conn = connHolder.getConnection();
                LinkedHashMap<String, Serializable> map = new LinkedHashMap<String, Serializable>();
                map.put("id", Integer.valueOf(System.identityHashCode(conn)));
                map.put("useCount", Long.valueOf(connHolder.getUseCount()));
                if (connHolder.getLastActiveTimeMillis() > 0L) {
                    map.put("lastActiveTime", new Date(connHolder.getLastActiveTimeMillis()));
                }
                map.put("connectTime", new Date(connHolder.getTimeMillis()));
                map.put("holdability", Integer.valueOf(connHolder.getUnderlyingHoldability()));
                map.put("transactionIsolation", Integer.valueOf(connHolder.getUnderlyingTransactionIsolation()));
                map.put("autoCommit", Boolean.valueOf(connHolder.isUnderlyingAutoCommit()));
                map.put("readoOnly", Boolean.valueOf(connHolder.isUnderlyingReadOnly()));
                if (connHolder.isPoolPreparedStatements()) {
                    ArrayList stmtCache = new ArrayList();
                    PreparedStatementPool stmtPool = connHolder.getStatementPool();
                    for (PreparedStatementHolder stmtHolder : stmtPool.getMap().values()) {
                        LinkedHashMap<String, Object> stmtInfo = new LinkedHashMap<String, Object>();
                        stmtInfo.put("sql", stmtHolder.getKey().getSql());
                        stmtInfo.put("defaultRowPretch", stmtHolder.getDefaultRowPrefetch());
                        stmtInfo.put("rowPrefetch", stmtHolder.getRowPrefetch());
                        stmtInfo.put("hitCount", stmtHolder.getHitCount());
                        stmtCache.add(stmtInfo);
                    }
                    map.put("pscache", stmtCache);
                }
                list.add(map);
            }
        }
        finally {
            this.lock.unlock();
        }
        return list;
    }

    @Override
    public void logTransaction(TransactionInfo info) {
        long transactionMillis = info.getEndTimeMillis() - info.getStartTimeMillis();
        if (this.transactionThresholdMillis > 0L && transactionMillis > this.transactionThresholdMillis) {
            StringBuilder buf = new StringBuilder();
            buf.append("long time transaction, take ");
            buf.append(transactionMillis);
            buf.append(" ms : ");
            for (String sql : info.getSqlList()) {
                buf.append(sql);
                buf.append(";");
            }
            LOG.error(buf.toString(), new TransactionTimeoutException());
        }
    }

    @Override
    public String getVersion() {
        return VERSION.getVersionNumber();
    }

    @Override
    public JdbcDataSourceStat getDataSourceStat() {
        return this.dataSourceStat;
    }

    public Object clone() throws CloneNotSupportedException {
        return this.cloneDruidDataSource();
    }

    public DruidDataSource cloneDruidDataSource() {
        DruidDataSource x = new DruidDataSource();
        this.cloneTo(x);
        return x;
    }

    public Map<String, Object> getStatDataForMBean() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Name", this.getName());
            map.put("URL", this.getUrl());
            map.put("CreateCount", this.getCreateCount());
            map.put("DestroyCount", this.getDestroyCount());
            map.put("ConnectCount", this.getConnectCount());
            map.put("CloseCount", this.getCloseCount());
            map.put("ActiveCount", this.getActiveCount());
            map.put("PoolingCount", this.getPoolingCount());
            map.put("LockQueueLength", this.getLockQueueLength());
            map.put("WaitThreadCount", this.getNotEmptyWaitThreadPeak());
            map.put("InitialSize", this.getInitialSize());
            map.put("MaxActive", this.getMaxActive());
            map.put("MinIdle", this.getMinIdle());
            map.put("PoolPreparedStatements", this.isPoolPreparedStatements());
            map.put("TestOnBorrow", this.isTestOnBorrow());
            map.put("TestOnReturn", this.isTestOnReturn());
            map.put("MinEvictableIdleTimeMillis", this.getMinEvictableIdleTimeMillis());
            map.put("ConnectErrorCount", this.getConnectErrorCount());
            map.put("CreateTimespanMillis", this.getCreateTimespanMillis());
            map.put("DbType", this.getDbType());
            map.put("ValidationQuery", this.getValidationQuery());
            map.put("ValidationQueryTimeout", this.getValidationQueryTimeout());
            map.put("DriverClassName", this.getDriverClassName());
            map.put("Username", this.getUsername());
            map.put("RemoveAbandonedCount", this.getRemoveAbandonedCount());
            map.put("NotEmptyWaitCount", this.getNotEmptyWaitCount());
            map.put("NotEmptyWaitNanos", this.getNotEmptyWaitNanos());
            map.put("ErrorCount", this.getErrorCount());
            map.put("ReusePreparedStatementCount", this.getCachedPreparedStatementHitCount());
            map.put("StartTransactionCount", this.getStartTransactionCount());
            map.put("CommitCount", this.getCommitCount());
            map.put("RollbackCount", this.getRollbackCount());
            map.put("LastError", JMXUtils.getErrorCompositeData(this.getLastError()));
            map.put("LastCreateError", JMXUtils.getErrorCompositeData(this.getLastCreateError()));
            map.put("PreparedStatementCacheDeleteCount", this.getCachedPreparedStatementDeleteCount());
            map.put("PreparedStatementCacheAccessCount", this.getCachedPreparedStatementAccessCount());
            map.put("PreparedStatementCacheMissCount", this.getCachedPreparedStatementMissCount());
            map.put("PreparedStatementCacheHitCount", this.getCachedPreparedStatementHitCount());
            map.put("PreparedStatementCacheCurrentCount", this.getCachedPreparedStatementCount());
            map.put("Version", this.getVersion());
            map.put("LastErrorTime", this.getLastErrorTime());
            map.put("LastCreateErrorTime", this.getLastCreateErrorTime());
            map.put("CreateErrorCount", this.getCreateErrorCount());
            map.put("DiscardCount", this.getDiscardCount());
            return map;
        }
        catch (JMException ex) {
            throw new IllegalStateException("getStatData error", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getStatData() {
        long closeCount;
        long connectCount;
        Date activePeakTime;
        int activePeak;
        int activeCount;
        Date poolingPeakTime;
        int poolingPeak;
        int poolingCount;
        this.lock.lock();
        try {
            poolingCount = this.poolingCount;
            poolingPeak = this.poolingPeak;
            poolingPeakTime = this.getPoolingPeakTime();
            activeCount = this.activeCount;
            activePeak = this.activePeak;
            activePeakTime = this.getActivePeakTime();
            connectCount = this.connectCount;
            closeCount = this.closeCount;
        }
        finally {
            this.lock.unlock();
        }
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("Identity", System.identityHashCode(this));
        dataMap.put("Name", this.getName());
        dataMap.put("DbType", this.getDbType());
        dataMap.put("DriverClassName", this.getDriverClassName());
        dataMap.put("URL", this.getUrl());
        dataMap.put("UserName", this.getUsername());
        dataMap.put("FilterClassNames", this.getFilterClassNames());
        dataMap.put("WaitThreadCount", this.getWaitThreadCount());
        dataMap.put("NotEmptyWaitCount", this.getNotEmptyWaitCount());
        dataMap.put("NotEmptyWaitMillis", this.getNotEmptyWaitMillis());
        dataMap.put("PoolingCount", poolingCount);
        dataMap.put("PoolingPeak", poolingPeak);
        dataMap.put("PoolingPeakTime", poolingPeakTime);
        dataMap.put("ActiveCount", activeCount);
        dataMap.put("ActivePeak", activePeak);
        dataMap.put("ActivePeakTime", activePeakTime);
        dataMap.put("InitialSize", this.getInitialSize());
        dataMap.put("MinIdle", this.getMinIdle());
        dataMap.put("MaxActive", this.getMaxActive());
        dataMap.put("QueryTimeout", this.getQueryTimeout());
        dataMap.put("TransactionQueryTimeout", this.getTransactionQueryTimeout());
        dataMap.put("LoginTimeout", this.getLoginTimeout());
        dataMap.put("ValidConnectionCheckerClassName", this.getValidConnectionCheckerClassName());
        dataMap.put("ExceptionSorterClassName", this.getExceptionSorterClassName());
        dataMap.put("TestOnBorrow", this.isTestOnBorrow());
        dataMap.put("TestOnReturn", this.isTestOnReturn());
        dataMap.put("TestWhileIdle", this.isTestWhileIdle());
        dataMap.put("DefaultAutoCommit", this.isDefaultAutoCommit());
        dataMap.put("DefaultReadOnly", this.getDefaultReadOnly());
        dataMap.put("DefaultTransactionIsolation", this.getDefaultTransactionIsolation());
        dataMap.put("LogicConnectCount", connectCount);
        dataMap.put("LogicCloseCount", closeCount);
        dataMap.put("LogicConnectErrorCount", this.getConnectErrorCount());
        dataMap.put("PhysicalConnectCount", this.getCreateCount());
        dataMap.put("PhysicalCloseCount", this.getDestroyCount());
        dataMap.put("PhysicalConnectErrorCount", this.getCreateErrorCount());
        dataMap.put("ExecuteCount", this.getExecuteCount());
        dataMap.put("ErrorCount", this.getErrorCount());
        dataMap.put("CommitCount", this.getCommitCount());
        dataMap.put("RollbackCount", this.getRollbackCount());
        dataMap.put("PSCacheAccessCount", this.getCachedPreparedStatementAccessCount());
        dataMap.put("PSCacheHitCount", this.getCachedPreparedStatementHitCount());
        dataMap.put("PSCacheMissCount", this.getCachedPreparedStatementMissCount());
        dataMap.put("StartTransactionCount", this.getStartTransactionCount());
        dataMap.put("TransactionHistogram", this.getTransactionHistogramValues());
        dataMap.put("ConnectionHoldTimeHistogram", this.getDataSourceStat().getConnectionHoldHistogram().toArray());
        dataMap.put("RemoveAbandoned", this.isRemoveAbandoned());
        dataMap.put("ClobOpenCount", this.getDataSourceStat().getClobOpenCount());
        dataMap.put("BlobOpenCount", this.getDataSourceStat().getBlobOpenCount());
        return dataMap;
    }

    public JdbcSqlStat getSqlStat(int sqlId) {
        return this.getDataSourceStat().getSqlStat(sqlId);
    }

    public JdbcSqlStat getSqlStat(long sqlId) {
        return this.getDataSourceStat().getSqlStat(sqlId);
    }

    public Map<String, JdbcSqlStat> getSqlStatMap() {
        return this.getDataSourceStat().getSqlStatMap();
    }

    public Map<String, Object> getWallStatMap() {
        WallProviderStatValue wallStatValue = this.getWallStatValue(false);
        if (wallStatValue != null) {
            return wallStatValue.toMap();
        }
        return null;
    }

    public WallProviderStatValue getWallStatValue(boolean reset) {
        for (Filter filter : this.filters) {
            if (!(filter instanceof WallFilter)) continue;
            WallFilter wallFilter = (WallFilter)filter;
            return wallFilter.getProvider().getStatValue(reset);
        }
        return null;
    }

    public Lock getLock() {
        return this.lock;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        for (Filter filter : this.filters) {
            if (!filter.isWrapperFor(iface)) continue;
            return true;
        }
        if (this.statLogger != null && (this.statLogger.getClass() == iface || DruidDataSourceStatLogger.class == iface)) {
            return true;
        }
        return super.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        for (Filter filter : this.filters) {
            if (!filter.isWrapperFor(iface)) continue;
            return (T)filter;
        }
        if (this.statLogger != null && (this.statLogger.getClass() == iface || DruidDataSourceStatLogger.class == iface)) {
            return (T)this.statLogger;
        }
        return super.unwrap(iface);
    }

    public boolean isLogDifferentThread() {
        return this.logDifferentThread;
    }

    public void setLogDifferentThread(boolean logDifferentThread) {
        this.logDifferentThread = logDifferentThread;
    }

    public DruidPooledConnection tryGetConnection() throws SQLException {
        if (this.poolingCount == 0) {
            return null;
        }
        return this.getConnection();
    }

    @Override
    public int fill() throws SQLException {
        return this.fill(this.maxActive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fill(int toCount) throws SQLException {
        if (this.closed) {
            throw new DataSourceClosedException("dataSource already closed at " + new Date(this.closeTimeMillis));
        }
        if (toCount < 0) {
            throw new IllegalArgumentException("toCount can't not be less than zero");
        }
        this.init();
        if (toCount > this.maxActive) {
            toCount = this.maxActive;
        }
        int fillCount = 0;
        while (true) {
            DruidConnectionHolder holder;
            try {
                this.lock.lockInterruptibly();
            }
            catch (InterruptedException e) {
                this.connectErrorCount.incrementAndGet();
                throw new SQLException("interrupt", e);
            }
            boolean fillable = this.isFillable(toCount);
            this.lock.unlock();
            if (!fillable) break;
            try {
                DruidAbstractDataSource.PhysicalConnectionInfo pyConnInfo = this.createPhysicalConnection();
                holder = new DruidConnectionHolder(this, pyConnInfo);
            }
            catch (SQLException e) {
                LOG.error("fill connection error, url: " + this.jdbcUrl, e);
                this.connectErrorCount.incrementAndGet();
                throw e;
            }
            try {
                this.lock.lockInterruptibly();
            }
            catch (InterruptedException e) {
                this.connectErrorCount.incrementAndGet();
                throw new SQLException("interrupt", e);
            }
            try {
                if (!this.isFillable(toCount)) {
                    JdbcUtils.close(holder.getConnection());
                    LOG.info("fill connections skip.");
                    break;
                }
                this.putLast(holder, System.currentTimeMillis());
                ++fillCount;
                continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("fill " + fillCount + " connections");
        }
        return fillCount;
    }

    private boolean isFillable(int toCount) {
        int currentCount = this.poolingCount + this.activeCount;
        return currentCount < toCount && currentCount < this.maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFull() {
        this.lock.lock();
        try {
            boolean bl = this.poolingCount + this.activeCount >= this.maxActive;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void emptySignal() {
        if (this.createScheduler == null) {
            this.empty.signal();
            return;
        }
        if (this.createTaskCount >= this.maxCreateTaskCount) {
            return;
        }
        if (this.activeCount + this.poolingCount + this.createTaskCount >= this.maxActive) {
            return;
        }
        ++this.createTaskCount;
        CreateConnectionTask task = new CreateConnectionTask();
        this.createScheduler.submit(task);
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (server != null) {
            try {
                if (server.isRegistered(name)) {
                    server.unregisterMBean(name);
                }
            }
            catch (Exception ex) {
                LOG.warn("DruidDataSource preRegister error", ex);
            }
        }
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public boolean isClosed() {
        return this.closed;
    }

    public class LogStatsThread
    extends Thread {
        public LogStatsThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    try {
                        DruidDataSource.this.logStats();
                    }
                    catch (Exception e) {
                        LOG.error("logStats error", e);
                    }
                    Thread.sleep(DruidDataSource.this.timeBetweenLogStatsMillis);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public class DestroyTask
    implements Runnable {
        @Override
        public void run() {
            DruidDataSource.this.shrink(true);
            if (DruidDataSource.this.isRemoveAbandoned()) {
                DruidDataSource.this.removeAbandoned();
            }
        }
    }

    public class DestroyConnectionThread
    extends Thread {
        public DestroyConnectionThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block6: {
                DruidDataSource.this.initedLatch.countDown();
                try {
                    while (!DruidDataSource.this.closed) {
                        if (DruidDataSource.this.timeBetweenEvictionRunsMillis > 0L) {
                            Thread.sleep(DruidDataSource.this.timeBetweenEvictionRunsMillis);
                        } else {
                            Thread.sleep(1000L);
                        }
                        if (!Thread.interrupted()) {
                            DruidDataSource.this.destroyTask.run();
                            continue;
                        }
                        break block6;
                    }
                }
                catch (InterruptedException e) {}
                {
                }
            }
        }
    }

    public class CreateConnectionThread
    extends Thread {
        public CreateConnectionThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DruidDataSource.this.initedLatch.countDown();
            int errorCount = 0;
            while (true) {
                DruidAbstractDataSource.PhysicalConnectionInfo connection;
                block23: {
                    block22: {
                        try {
                            DruidDataSource.this.lock.lockInterruptibly();
                        }
                        catch (InterruptedException e2) {
                            break;
                        }
                        try {
                            boolean emptyWait = true;
                            if (DruidDataSource.this.createError != null && DruidDataSource.this.poolingCount == 0) {
                                emptyWait = false;
                            }
                            if (!emptyWait) break block22;
                            if (DruidDataSource.this.poolingCount >= DruidDataSource.this.notEmptyWaitThreadCount) {
                                DruidDataSource.this.empty.await();
                            }
                            if (DruidDataSource.this.activeCount + DruidDataSource.this.poolingCount >= DruidDataSource.this.maxActive) {
                                DruidDataSource.this.empty.await();
                                continue;
                            }
                        }
                        catch (InterruptedException e) {
                            DruidDataSource.this.lastCreateError = e;
                            DruidDataSource.this.lastErrorTimeMillis = System.currentTimeMillis();
                            break;
                        }
                        finally {
                            DruidDataSource.this.lock.unlock();
                            continue;
                        }
                    }
                    connection = null;
                    try {
                        connection = DruidDataSource.this.createPhysicalConnection();
                        DruidDataSource.this.setFailContinuous(false);
                    }
                    catch (SQLException e) {
                        LOG.error("create connection error, url: " + DruidDataSource.this.jdbcUrl + ", errorCode " + e.getErrorCode() + ", state " + e.getSQLState(), e);
                        if (++errorCount <= DruidDataSource.this.connectionErrorRetryAttempts || DruidDataSource.this.timeBetweenConnectErrorMillis <= 0L) break block23;
                        DruidDataSource.this.setFailContinuous(true);
                        if (DruidDataSource.this.failFast) {
                            DruidDataSource.this.lock.lock();
                            try {
                                DruidDataSource.this.notEmpty.signalAll();
                            }
                            finally {
                                DruidDataSource.this.lock.unlock();
                            }
                        }
                        if (DruidDataSource.this.breakAfterAcquireFailure) break;
                        try {
                            Thread.sleep(DruidDataSource.this.timeBetweenConnectErrorMillis);
                        }
                        catch (InterruptedException interruptEx) {
                            break;
                        }
                    }
                    catch (RuntimeException e) {
                        LOG.error("create connection error", e);
                        DruidDataSource.this.setFailContinuous(true);
                        continue;
                    }
                    catch (Error e) {
                        LOG.error("create connection error", e);
                        DruidDataSource.this.setFailContinuous(true);
                        break;
                    }
                }
                if (connection == null) continue;
                boolean result = DruidDataSource.this.put(connection);
                if (!result) {
                    JdbcUtils.close(connection.getPhysicalConnection());
                    LOG.info("put physical connection to pool failed.");
                }
                errorCount = 0;
            }
        }
    }

    public class CreateConnectionTask
    implements Runnable {
        private int errorCount = 0;

        @Override
        public void run() {
            this.runInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runInternal() {
            block29: {
                DruidAbstractDataSource.PhysicalConnectionInfo physicalConnection;
                while (true) {
                    block25: {
                        DruidDataSource.this.lock.lock();
                        try {
                            boolean emptyWait = true;
                            if (DruidDataSource.this.createError != null && DruidDataSource.this.poolingCount == 0) {
                                emptyWait = false;
                            }
                            if (emptyWait) {
                                if (DruidDataSource.this.poolingCount >= DruidDataSource.this.notEmptyWaitThreadCount) {
                                    DruidDataSource.this.createTaskCount--;
                                    return;
                                }
                                if (DruidDataSource.this.activeCount + DruidDataSource.this.poolingCount >= DruidDataSource.this.maxActive) {
                                    DruidDataSource.this.createTaskCount--;
                                    return;
                                }
                            }
                        }
                        finally {
                            DruidDataSource.this.lock.unlock();
                        }
                        physicalConnection = null;
                        try {
                            physicalConnection = DruidDataSource.this.createPhysicalConnection();
                            DruidDataSource.this.setFailContinuous(false);
                        }
                        catch (SQLException e) {
                            LOG.error("create connection error, url: " + DruidDataSource.this.jdbcUrl, e);
                            ++this.errorCount;
                            if (this.errorCount <= DruidDataSource.this.connectionErrorRetryAttempts || DruidDataSource.this.timeBetweenConnectErrorMillis <= 0L) break block25;
                            DruidDataSource.this.setFailContinuous(true);
                            if (DruidDataSource.this.failFast) {
                                DruidDataSource.this.lock.lock();
                                try {
                                    DruidDataSource.this.notEmpty.signalAll();
                                }
                                finally {
                                    DruidDataSource.this.lock.unlock();
                                }
                            }
                            if (DruidDataSource.this.breakAfterAcquireFailure) {
                                DruidDataSource.this.lock.lock();
                                try {
                                    DruidDataSource.this.createTaskCount--;
                                }
                                finally {
                                    DruidDataSource.this.lock.unlock();
                                }
                                return;
                            }
                            this.errorCount = 0;
                            DruidDataSource.this.createScheduler.schedule(this, DruidDataSource.this.timeBetweenConnectErrorMillis, TimeUnit.MILLISECONDS);
                            return;
                        }
                        catch (RuntimeException e) {
                            LOG.error("create connection error", e);
                            DruidDataSource.this.setFailContinuous(true);
                            continue;
                        }
                        catch (Error e) {
                            DruidDataSource.this.lock.lock();
                            try {
                                DruidDataSource.this.createTaskCount--;
                            }
                            finally {
                                DruidDataSource.this.lock.unlock();
                            }
                            LOG.error("create connection error", e);
                            DruidDataSource.this.setFailContinuous(true);
                            break block29;
                        }
                    }
                    if (physicalConnection != null) break;
                }
                boolean result = DruidDataSource.this.put(physicalConnection);
                if (result) break block29;
                JdbcUtils.close(physicalConnection.getPhysicalConnection());
                LOG.info("put physical connection to pool failed.");
            }
        }
    }
}

