/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.repository;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLUniqueConstraint;
import com.alibaba.druid.sql.repository.SchemaObject;
import com.alibaba.druid.sql.repository.SchemaObjectType;

public class SchemaObjectImpl
implements SchemaObject {
    private final String name;
    private final SchemaObjectType type;
    private SQLStatement statement;
    public long rowCount = -1L;

    public SchemaObjectImpl(String name, SchemaObjectType type) {
        this(name, type, null);
    }

    public SchemaObjectImpl(String name, SchemaObjectType type, SQLStatement statement) {
        this.name = name;
        this.type = type;
        this.statement = statement;
    }

    @Override
    public SQLStatement getStatement() {
        return this.statement;
    }

    @Override
    public SQLColumnDefinition findColumn(String columName) {
        if (this.statement == null) {
            return null;
        }
        if (this.statement instanceof SQLCreateTableStatement) {
            return ((SQLCreateTableStatement)this.statement).findColumn(columName);
        }
        return null;
    }

    @Override
    public boolean matchIndex(String columnName) {
        if (this.statement == null) {
            return false;
        }
        if (this.statement instanceof SQLCreateTableStatement) {
            SQLTableElement index = ((SQLCreateTableStatement)this.statement).findIndex(columnName);
            return index != null;
        }
        return false;
    }

    @Override
    public boolean matchKey(String columnName) {
        if (this.statement == null) {
            return false;
        }
        if (this.statement instanceof SQLCreateTableStatement) {
            SQLTableElement index = ((SQLCreateTableStatement)this.statement).findIndex(columnName);
            return index instanceof SQLUniqueConstraint;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SchemaObjectType getType() {
        return this.type;
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    public static enum Type {
        Sequence,
        Table,
        View,
        Index,
        Function;

    }
}

