/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog.event;

import com.taobao.tddl.dbsync.binlog.LogBuffer;
import com.taobao.tddl.dbsync.binlog.event.FormatDescriptionLogEvent;

public final class LogHeader {
    protected final int type;
    protected long logPos;
    protected long when;
    protected int eventLen;
    protected long serverId;
    protected int flags;
    protected int checksumAlg;
    protected long crc;

    public LogHeader(int type) {
        this.type = type;
    }

    public LogHeader(LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) {
        this.when = buffer.getUint32();
        this.type = buffer.getUint8();
        this.serverId = buffer.getUint32();
        this.eventLen = (int)buffer.getUint32();
        if (descriptionEvent.binlogVersion == 1) {
            this.logPos = 0L;
            this.flags = 0;
            return;
        }
        this.logPos = buffer.getUint32();
        if (descriptionEvent.binlogVersion == 3 && this.type < 15 && this.logPos != 0L) {
            this.logPos += (long)this.eventLen;
        }
        this.flags = buffer.getUint16();
        if (this.type == 15 || this.type == 4) {
            if (this.type == 15) {
                int commonHeaderLen = buffer.getUint8(75);
                buffer.position(commonHeaderLen + 2);
                String serverVersion = buffer.getFixString(50);
                int[] versionSplit = new int[]{0, 0, 0};
                FormatDescriptionLogEvent.doServerVersionSplit(serverVersion, versionSplit);
                this.checksumAlg = 255;
                if (FormatDescriptionLogEvent.versionProduct(versionSplit) >= FormatDescriptionLogEvent.checksumVersionProduct) {
                    buffer.position(this.eventLen - 4 - 1);
                    this.checksumAlg = buffer.getUint8();
                }
                this.processCheckSum(buffer);
            }
            return;
        }
        this.checksumAlg = descriptionEvent.getHeader().checksumAlg;
        this.processCheckSum(buffer);
    }

    public final int getType() {
        return this.type;
    }

    public final long getLogPos() {
        return this.logPos;
    }

    public final int getEventLen() {
        return this.eventLen;
    }

    public final long getWhen() {
        return this.when;
    }

    public final long getServerId() {
        return this.serverId;
    }

    public final int getFlags() {
        return this.flags;
    }

    public long getCrc() {
        return this.crc;
    }

    public int getChecksumAlg() {
        return this.checksumAlg;
    }

    private void processCheckSum(LogBuffer buffer) {
        if (this.checksumAlg != 0 && this.checksumAlg != 255) {
            this.crc = buffer.getUint32(this.eventLen - 4);
        }
    }
}

