/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.local;

import com.alibaba.otter.canal.parse.exception.CanalParseException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

public class BinLogFileQueue {
    private String baseName = "mysql-bin.";
    private List<File> binlogs = new ArrayList<File>();
    private File directory;
    private ReentrantLock lock = new ReentrantLock();
    private Condition nextCondition = this.lock.newCondition();
    private Timer timer = new Timer(true);
    private long reloadInterval = 10000L;

    public BinLogFileQueue(String directory) {
        this(new File(directory));
    }

    public BinLogFileQueue(File directory) {
        this.directory = directory;
        if (!directory.canRead()) {
            throw new CanalParseException("Binlog index missing or unreadable;  " + directory.getAbsolutePath());
        }
        List<File> files = this.listBinlogFiles();
        for (File file : files) {
            this.offer(file);
        }
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                List files = BinLogFileQueue.this.listBinlogFiles();
                for (File file : files) {
                    BinLogFileQueue.this.offer(file);
                }
            }
        }, this.reloadInterval, this.reloadInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getNextFile(File pre) {
        try {
            this.lock.lockInterruptibly();
            if (this.binlogs.size() == 0) {
                File file = null;
                return file;
            }
            if (pre == null) {
                File file = this.binlogs.get(0);
                return file;
            }
            int index = this.seek(pre);
            if (index < this.binlogs.size() - 1) {
                File file = this.binlogs.get(index + 1);
                return file;
            }
            File file = null;
            return file;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            File file = null;
            return file;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getBefore(File file) {
        try {
            this.lock.lockInterruptibly();
            if (this.binlogs.size() == 0) {
                File file2 = null;
                return file2;
            }
            if (file == null) {
                File file3 = this.binlogs.get(this.binlogs.size() - 1);
                return file3;
            }
            int index = this.seek(file);
            if (index > 0) {
                File file4 = this.binlogs.get(index - 1);
                return file4;
            }
            File file5 = null;
            return file5;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            File file6 = null;
            return file6;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File waitForNextFile(File pre) throws InterruptedException {
        try {
            this.lock.lockInterruptibly();
            if (this.binlogs.size() == 0) {
                this.nextCondition.await();
            }
            if (pre == null) {
                File file = this.binlogs.get(0);
                return file;
            }
            int index = this.seek(pre);
            if (index < this.binlogs.size() - 1) {
                File file = this.binlogs.get(index + 1);
                return file;
            }
            this.nextCondition.await();
            File file = this.waitForNextFile(pre);
            return file;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<File> currentBinlogs() {
        return new ArrayList<File>(this.binlogs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destory() {
        try {
            this.lock.lockInterruptibly();
            this.timer.cancel();
            this.binlogs.clear();
            this.nextCondition.signalAll();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean offer(File file) {
        try {
            this.lock.lockInterruptibly();
            if (!this.binlogs.contains(file)) {
                this.binlogs.add(file);
                this.nextCondition.signalAll();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private List<File> listBinlogFiles() {
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(FileUtils.listFiles((File)this.directory, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith(BinLogFileQueue.this.baseName);
            }

            public boolean accept(File dir, String name) {
                return true;
            }
        }, null));
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return files;
    }

    private int seek(File file) {
        for (int i = 0; i < this.binlogs.size(); ++i) {
            File binlog = this.binlogs.get(i);
            if (!binlog.getName().equals(file.getName())) continue;
            return i;
        }
        return -1;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }
}

