/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.index;

import com.alibaba.otter.canal.parse.index.CanalLogPositionManager;
import com.alibaba.otter.canal.parse.index.MemoryLogPositionManager;
import com.alibaba.otter.canal.parse.index.ZooKeeperLogPositionManager;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import com.google.common.base.Function;
import com.google.common.collect.MigrateMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class MixedLogPositionManager
extends MemoryLogPositionManager
implements CanalLogPositionManager {
    private static final Logger logger = LoggerFactory.getLogger(MixedLogPositionManager.class);
    private ZooKeeperLogPositionManager zooKeeperLogPositionManager;
    private ExecutorService executor;
    private final LogPosition nullPosition = new LogPosition(){};

    @Override
    public void start() {
        super.start();
        Assert.notNull((Object)this.zooKeeperLogPositionManager);
        if (!this.zooKeeperLogPositionManager.isStart()) {
            this.zooKeeperLogPositionManager.start();
        }
        this.executor = Executors.newFixedThreadPool(1);
        this.positions = MigrateMap.makeComputingMap((Function)new Function<String, LogPosition>(){

            public LogPosition apply(String destination) {
                LogPosition logPosition = MixedLogPositionManager.this.zooKeeperLogPositionManager.getLatestIndexBy(destination);
                if (logPosition == null) {
                    return MixedLogPositionManager.this.nullPosition;
                }
                return logPosition;
            }
        });
    }

    @Override
    public void stop() {
        super.stop();
        if (this.zooKeeperLogPositionManager.isStart()) {
            this.zooKeeperLogPositionManager.stop();
        }
        this.executor.shutdownNow();
        this.positions.clear();
    }

    @Override
    public void persistLogPosition(final String destination, final LogPosition logPosition) {
        super.persistLogPosition(destination, logPosition);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    MixedLogPositionManager.this.zooKeeperLogPositionManager.persistLogPosition(destination, logPosition);
                }
                catch (Exception e) {
                    logger.error("ERROR # persist to zookeepr has an error", (Throwable)e);
                }
            }
        });
    }

    @Override
    public LogPosition getLatestIndexBy(String destination) {
        LogPosition logPosition = super.getLatestIndexBy(destination);
        if (logPosition == this.nullPosition) {
            return null;
        }
        return logPosition;
    }

    public void setZooKeeperLogPositionManager(ZooKeeperLogPositionManager zooKeeperLogPositionManager) {
        this.zooKeeperLogPositionManager = zooKeeperLogPositionManager;
    }
}

