/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.index;

import com.alibaba.otter.canal.parse.index.CanalLogPositionManager;
import com.alibaba.otter.canal.parse.index.MemoryLogPositionManager;
import com.alibaba.otter.canal.parse.index.ZooKeeperLogPositionManager;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import com.google.common.base.Function;
import com.google.common.collect.MigrateMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class PeriodMixedLogPositionManager
extends MemoryLogPositionManager
implements CanalLogPositionManager {
    private static final Logger logger = LoggerFactory.getLogger(PeriodMixedLogPositionManager.class);
    private ZooKeeperLogPositionManager zooKeeperLogPositionManager;
    private ScheduledExecutorService executor;
    private final LogPosition nullPosition = new LogPosition(){};
    private long period = 1000L;
    private Set<String> persistTasks;

    @Override
    public void start() {
        super.start();
        Assert.notNull((Object)this.zooKeeperLogPositionManager);
        if (!this.zooKeeperLogPositionManager.isStart()) {
            this.zooKeeperLogPositionManager.start();
        }
        this.executor = Executors.newScheduledThreadPool(1);
        this.positions = MigrateMap.makeComputingMap((Function)new Function<String, LogPosition>(){

            public LogPosition apply(String destination) {
                LogPosition logPosition = PeriodMixedLogPositionManager.this.zooKeeperLogPositionManager.getLatestIndexBy(destination);
                if (logPosition == null) {
                    return PeriodMixedLogPositionManager.this.nullPosition;
                }
                return logPosition;
            }
        });
        this.persistTasks = Collections.synchronizedSet(new HashSet());
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ArrayList tasks = new ArrayList(PeriodMixedLogPositionManager.this.persistTasks);
                for (String destination : tasks) {
                    try {
                        PeriodMixedLogPositionManager.this.zooKeeperLogPositionManager.persistLogPosition(destination, PeriodMixedLogPositionManager.this.getLatestIndexBy(destination));
                        PeriodMixedLogPositionManager.this.persistTasks.remove(destination);
                    }
                    catch (Throwable e) {
                        logger.error("period update" + destination + " curosr failed!", e);
                    }
                }
            }
        }, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        super.stop();
        if (this.zooKeeperLogPositionManager.isStart()) {
            this.zooKeeperLogPositionManager.stop();
        }
        this.executor.shutdownNow();
        this.positions.clear();
    }

    @Override
    public void persistLogPosition(String destination, LogPosition logPosition) {
        this.persistTasks.add(destination);
        super.persistLogPosition(destination, logPosition);
    }

    @Override
    public LogPosition getLatestIndexBy(String destination) {
        LogPosition logPostion = super.getLatestIndexBy(destination);
        if (logPostion == this.nullPosition) {
            return null;
        }
        return logPostion;
    }

    public void setZooKeeperLogPositionManager(ZooKeeperLogPositionManager zooKeeperLogPositionManager) {
        this.zooKeeperLogPositionManager = zooKeeperLogPositionManager;
    }

    public void setPeriod(long period) {
        this.period = period;
    }
}

