/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.autoconfigure;

import com.alicp.jetcache.CacheBuilder;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.autoconfigure.AutoConfigureBeans;
import com.alicp.jetcache.autoconfigure.ConfigTree;
import com.alicp.jetcache.autoconfigure.ExternalCacheAutoInit;
import com.alicp.jetcache.autoconfigure.JetCacheCondition;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.redis.RedisCacheBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.util.Pool;

@Configuration
@Conditional(value={RedisCondition.class})
public class RedisAutoConfiguration {
    public static final String AUTO_INIT_BEAN_NAME = "redisAutoInit";

    @Bean(name={"redisAutoInit"})
    public RedisAutoInit redisAutoInit() {
        return new RedisAutoInit();
    }

    public static class RedisAutoInit
    extends ExternalCacheAutoInit {
        @Autowired
        private AutoConfigureBeans autoConfigureBeans;

        public RedisAutoInit() {
            super("redis");
        }

        @Override
        protected CacheBuilder initCache(ConfigTree ct, String cacheAreaWithPrefix) {
            Pool<Jedis> jedisPool = this.parsePool(ct);
            Pool[] slavesPool = null;
            int[] slavesPoolWeights = null;
            boolean readFromSlave = Boolean.parseBoolean(ct.getProperty("readFromSlave", "False"));
            ConfigTree slaves = ct.subTree("slaves.");
            Set<String> slaveNames = slaves.directChildrenKeys();
            if (slaveNames.size() > 0) {
                slavesPool = new Pool[slaveNames.size()];
                slavesPoolWeights = new int[slaveNames.size()];
                int i = 0;
                for (String slaveName : slaveNames) {
                    ConfigTree slaveConfig = slaves.subTree(slaveName + ".");
                    slavesPool[i] = this.parsePool(slaveConfig);
                    slavesPoolWeights[i] = Integer.parseInt(slaveConfig.getProperty("weight", "100"));
                    ++i;
                }
            }
            ExternalCacheBuilder externalCacheBuilder = ((RedisCacheBuilder.RedisCacheBuilderImpl)((RedisCacheBuilder.RedisCacheBuilderImpl)((RedisCacheBuilder.RedisCacheBuilderImpl)RedisCacheBuilder.createRedisCacheBuilder().jedisPool(jedisPool)).readFromSlave(readFromSlave)).jedisSlavePools(slavesPool)).slaveReadWeights(slavesPoolWeights);
            this.parseGeneralConfig((CacheBuilder)externalCacheBuilder, ct);
            this.autoConfigureBeans.getCustomContainer().put("jedisPool." + cacheAreaWithPrefix, jedisPool);
            return externalCacheBuilder;
        }

        private Pool<Jedis> parsePool(ConfigTree ct) {
            JedisPool jedisPool;
            GenericObjectPoolConfig poolConfig = this.parsePoolConfig(ct);
            String host = ct.getProperty("host", null);
            int port = Integer.parseInt(ct.getProperty("port", "0"));
            int timeout = Integer.parseInt(ct.getProperty("timeout", String.valueOf(2000)));
            String password = ct.getProperty("password", null);
            int database = Integer.parseInt(ct.getProperty("database", String.valueOf(0)));
            String clientName = ct.getProperty("clientName", null);
            boolean ssl = Boolean.parseBoolean(ct.getProperty("ssl", "false"));
            String masterName = ct.getProperty("masterName", null);
            String sentinels = ct.getProperty("sentinels", null);
            if (sentinels == null) {
                Objects.requireNonNull(host, "host/port or sentinels/masterName is required");
                if (port == 0) {
                    throw new IllegalStateException("host/port or sentinels/masterName is required");
                }
                jedisPool = new JedisPool(poolConfig, host, port, timeout, password, database, clientName, ssl);
            } else {
                Objects.requireNonNull(masterName, "host/port or sentinels/masterName is required");
                String[] strings = sentinels.split(",");
                HashSet<String> sentinelsSet = new HashSet<String>();
                for (String s : strings) {
                    if (s == null || s.trim().equals("")) continue;
                    sentinelsSet.add(s.trim());
                }
                jedisPool = new JedisSentinelPool(masterName, sentinelsSet, poolConfig, timeout, password, database, clientName);
            }
            return jedisPool;
        }

        private GenericObjectPoolConfig parsePoolConfig(ConfigTree ct) {
            try {
                if (ClassUtils.isPresent((String)"org.springframework.boot.context.properties.bind.Binder", (ClassLoader)this.getClass().getClassLoader())) {
                    String prefix = ct.subTree("poolConfig").getPrefix().toLowerCase();
                    Class<?> binderClass = Class.forName("org.springframework.boot.context.properties.bind.Binder");
                    Class<?> bindableClass = Class.forName("org.springframework.boot.context.properties.bind.Bindable");
                    Class<?> bindResultClass = Class.forName("org.springframework.boot.context.properties.bind.BindResult");
                    Method getMethodOnBinder = binderClass.getMethod("get", Environment.class);
                    Method getMethodOnBindResult = bindResultClass.getMethod("get", new Class[0]);
                    Method bindMethod = binderClass.getMethod("bind", String.class, bindableClass);
                    Method ofMethod = bindableClass.getMethod("of", Class.class);
                    Object binder = getMethodOnBinder.invoke(null, this.environment);
                    Object bindable = ofMethod.invoke(null, GenericObjectPoolConfig.class);
                    Object bindResult = bindMethod.invoke(binder, prefix, bindable);
                    return (GenericObjectPoolConfig)getMethodOnBindResult.invoke(bindResult, new Object[0]);
                }
                GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
                Map<String, Object> props = ct.subTree("poolConfig.").getProperties();
                Class<?> relaxedDataBinderClass = Class.forName("org.springframework.boot.bind.RelaxedDataBinder");
                Class<?> mutablePropertyValuesClass = Class.forName("org.springframework.beans.MutablePropertyValues");
                Constructor<?> c1 = relaxedDataBinderClass.getConstructor(Object.class);
                Constructor<?> c2 = mutablePropertyValuesClass.getConstructor(Map.class);
                Method bindMethod = relaxedDataBinderClass.getMethod("bind", PropertyValues.class);
                Object binder = c1.newInstance(poolConfig);
                bindMethod.invoke(binder, c2.newInstance(props));
                return poolConfig;
            }
            catch (Throwable ex) {
                throw new CacheConfigException("parse poolConfig fail", ex);
            }
        }
    }

    public static class RedisCondition
    extends JetCacheCondition {
        public RedisCondition() {
            super("redis");
        }
    }
}

