/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.ons.open.trace.core.common.OnsTraceDispatcherType;
import com.alibaba.ons.open.trace.core.dispatch.NameServerAddressSetter;
import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncArrayDispatcher;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSUnitUtils;
import com.aliyun.openservices.ons.api.OnExceptionContext;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.rocketmq.FAQ;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.ons.api.impl.rocketmq.OnsClientRPCHook;
import com.aliyun.openservices.ons.api.impl.tracehook.OnsClientSendMessageHookImpl;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.ons.api.spi.DefaultInvocationContext;
import com.aliyun.openservices.ons.api.spi.InvocationContext;
import com.aliyun.openservices.ons.api.spi.ProducerInterceptor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.TopicPublishInfo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageClientIDSetter;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.route.QueueData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.sysflag.TopicSysFlag;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;

public class ProducerImpl
extends ONSClientAbstract
implements Producer {
    private static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    private final DefaultMQProducer defaultMQProducer;
    private ServiceLoader<ProducerInterceptor> serviceLoader;

    public ProducerImpl(Properties properties) {
        super(properties);
        String producerGroup = properties.getProperty("GROUP_ID", properties.getProperty("ProducerId"));
        if (StringUtils.isEmpty(producerGroup)) {
            producerGroup = "__ONS_PRODUCER_DEFAULT_GROUP";
        }
        this.defaultMQProducer = new DefaultMQProducer(this.getNamespace(), producerGroup, new OnsClientRPCHook(this.sessionCredentials));
        this.defaultMQProducer.setProducerGroup(producerGroup);
        boolean isVipChannelEnabled = Boolean.parseBoolean(properties.getProperty("isVipChannelEnabled", "false"));
        this.defaultMQProducer.setVipChannelEnabled(isVipChannelEnabled);
        if (properties.containsKey("SendMsgTimeoutMillis")) {
            this.defaultMQProducer.setSendMsgTimeout(Integer.valueOf(properties.get("SendMsgTimeoutMillis").toString()));
        } else {
            this.defaultMQProducer.setSendMsgTimeout(5000);
        }
        if (properties.containsKey("exactlyOnceDelivery")) {
            this.defaultMQProducer.setAddExtendUniqInfo(Boolean.valueOf(properties.get("exactlyOnceDelivery").toString()));
        }
        String instanceName = StringUtils.defaultIfEmpty(properties.getProperty("InstanceName"), this.buildIntanceName());
        this.defaultMQProducer.setInstanceName(instanceName);
        this.defaultMQProducer.setNamesrvAddr(this.getNameServerAddr());
        this.defaultMQProducer.setMaxMessageSize(0x400000);
        String msgTraceSwitch = properties.getProperty("MsgTraceSwitch");
        if (!UtilAll.isBlank(msgTraceSwitch) && !Boolean.parseBoolean(msgTraceSwitch)) {
            LOGGER.info("MQ Client Disable the Trace Hook!");
        } else {
            try {
                Properties tempProperties = new Properties();
                tempProperties.put("AccessKey", this.sessionCredentials.getAccessKey());
                tempProperties.put("SecretKey", this.sessionCredentials.getSecretKey());
                tempProperties.put("MaxMsgSize", "128000");
                tempProperties.put("AsyncBufferSize", "2048");
                tempProperties.put("MaxBatchNum", "100");
                String traceInstanceName = UtilAll.getPid() + "_CLIENT_INNER_TRACE_PRODUCER";
                tempProperties.put("InstanceName", traceInstanceName);
                tempProperties.put("DispatcherType", OnsTraceDispatcherType.PRODUCER.name());
                String selectQueueEnableStr = properties.getProperty("MsgTraceSelectQueueEnable", "true");
                tempProperties.put("MsgTraceSelectQueueEnable", selectQueueEnableStr);
                AsyncArrayDispatcher dispatcher = new AsyncArrayDispatcher(tempProperties, this.sessionCredentials, new NameServerAddressSetter(){

                    @Override
                    public String getNewNameServerAddress() {
                        return ProducerImpl.this.getNameServerAddr();
                    }
                });
                dispatcher.setHostProducer(this.defaultMQProducer.getDefaultMQProducerImpl());
                this.traceDispatcher = dispatcher;
                this.defaultMQProducer.getDefaultMQProducerImpl().registerSendMessageHook(new OnsClientSendMessageHookImpl(this.traceDispatcher));
            }
            catch (Throwable e) {
                LOGGER.error("system mqtrace hook init failed ,maybe can't send msg trace data.", e);
            }
        }
        this.serviceLoader = ServiceLoader.load(ProducerInterceptor.class);
    }

    @Override
    protected void updateNameServerAddr(String newAddrs) {
        this.defaultMQProducer.setNamesrvAddr(newAddrs);
        this.defaultMQProducer.getDefaultMQProducerImpl().getmQClientFactory().getMQClientAPIImpl().updateNameServerAddressList(newAddrs);
    }

    @Override
    public void start() {
        try {
            if (this.started.compareAndSet(false, true)) {
                this.defaultMQProducer.start();
                super.start();
            }
        }
        catch (Exception e) {
            throw new ONSClientException(e.getMessage());
        }
    }

    @Override
    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            this.defaultMQProducer.shutdown();
        }
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendResult send(Message message) {
        this.checkONSProducerServiceState(this.defaultMQProducer.getDefaultMQProducerImpl());
        DefaultInvocationContext invocationContext = new DefaultInvocationContext();
        invocationContext.setMessages(Collections.singletonList(message));
        ArrayList<Runnable> postHandleStack = new ArrayList<Runnable>();
        this.setTopicUnitFlagToContext(invocationContext, message);
        boolean proceed = this.preHandle(this.serviceLoader, invocationContext, postHandleStack);
        try {
            if (proceed) {
                com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message msgRMQ = ONSUtil.msgConvert(message);
                try {
                    com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult sendResultRMQ = this.defaultMQProducer.send(msgRMQ);
                    message.setMsgID(sendResultRMQ.getMsgId());
                    SendResult sendResult = new SendResult();
                    sendResult.setTopic(sendResultRMQ.getMessageQueue().getTopic());
                    sendResult.setMessageId(sendResultRMQ.getMsgId());
                    invocationContext.setSendResult(sendResult);
                    SendResult sendResult2 = sendResult;
                    return sendResult2;
                }
                catch (Exception e) {
                    LOGGER.error(String.format("Send message Exception, %s", message), e);
                    ONSClientException onsClientException = this.checkProducerException(message.getTopic(), message.getMsgID(), e);
                    invocationContext.setException(onsClientException);
                    throw onsClientException;
                }
            }
        }
        finally {
            this.executePostHandle(postHandleStack);
        }
        throw new ONSClientException("ProducerInterceptor aborts sending");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendOneway(Message message) {
        block5: {
            this.checkONSProducerServiceState(this.defaultMQProducer.getDefaultMQProducerImpl());
            DefaultInvocationContext invocationContext = new DefaultInvocationContext();
            invocationContext.setMessages(Collections.singletonList(message));
            ArrayList<Runnable> postHandleStack = new ArrayList<Runnable>();
            this.setTopicUnitFlagToContext(invocationContext, message);
            boolean proceed = this.preHandle(this.serviceLoader, invocationContext, postHandleStack);
            try {
                if (!proceed) break block5;
                com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message msgRMQ = ONSUtil.msgConvert(message);
                try {
                    this.defaultMQProducer.sendOneway(msgRMQ);
                    message.setMsgID(MessageClientIDSetter.getUniqID(msgRMQ));
                }
                catch (Exception e) {
                    LOGGER.error(String.format("Send message oneway Exception, %s", message), e);
                    ONSClientException onsClientException = this.checkProducerException(message.getTopic(), message.getMsgID(), e);
                    invocationContext.setException(onsClientException);
                    throw onsClientException;
                }
            }
            finally {
                this.executePostHandle(postHandleStack);
            }
        }
    }

    protected void setTopicUnitFlagToContext(InvocationContext context, Message message) {
        List<QueueData> queueDatas;
        if (message == null || StringUtils.isBlank(message.getTopic())) {
            throw new ONSClientException("message or topic is null");
        }
        DefaultMQProducerImpl rocketProducer = this.defaultMQProducer.getDefaultMQProducerImpl();
        String topicWithNamespace = this.defaultMQProducer.withNamespace(message.getTopic());
        TopicPublishInfo topicPublishInfo = (TopicPublishInfo)rocketProducer.getTopicPublishInfoTable().get(topicWithNamespace);
        if (null == topicPublishInfo || !topicPublishInfo.ok()) {
            rocketProducer.getmQClientFactory().updateTopicRouteInfoFromNameServer(topicWithNamespace);
            topicPublishInfo = (TopicPublishInfo)rocketProducer.getTopicPublishInfoTable().get(topicWithNamespace);
        }
        if (topicPublishInfo != null && (queueDatas = topicPublishInfo.getTopicRouteData().getQueueDatas()).size() > 0) {
            ONSUnitUtils.setUnitTopic(context, TopicSysFlag.hasUnitFlag(queueDatas.get(0).getTopicSynFlag()));
        }
    }

    @Override
    public void sendAsync(Message message, SendCallback sendCallback) {
        this.checkONSProducerServiceState(this.defaultMQProducer.getDefaultMQProducerImpl());
        DefaultInvocationContext invocationContext = new DefaultInvocationContext();
        invocationContext.setMessages(Collections.singletonList(message));
        ArrayList<Runnable> postHandleStack = new ArrayList<Runnable>();
        this.setTopicUnitFlagToContext(invocationContext, message);
        boolean proceed = this.preHandle(this.serviceLoader, invocationContext, postHandleStack);
        if (proceed) {
            com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message msgRMQ = ONSUtil.msgConvert(message);
            try {
                this.defaultMQProducer.send(msgRMQ, this.sendCallbackConvert(message, sendCallback, postHandleStack, invocationContext));
                message.setMsgID(MessageClientIDSetter.getUniqID(msgRMQ));
            }
            catch (Exception e) {
                LOGGER.error(String.format("Send message async Exception, %s", message), e);
                ONSClientException onsClientException = this.checkProducerException(message.getTopic(), message.getMsgID(), e);
                invocationContext.setException(onsClientException);
                this.executePostHandle(postHandleStack);
                throw onsClientException;
            }
        }
    }

    @Override
    public void setCallbackExecutor(ExecutorService callbackExecutor) {
        this.defaultMQProducer.setCallbackExecutor(callbackExecutor);
    }

    public DefaultMQProducer getDefaultMQProducer() {
        return this.defaultMQProducer;
    }

    private com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendCallback sendCallbackConvert(final Message message, final SendCallback sendCallback, final List<Runnable> postHandleStack, final DefaultInvocationContext invocationContext) {
        return new com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult sendResult) {
                try {
                    SendResult result = ProducerImpl.this.sendResultConvert(sendResult);
                    invocationContext.setMessages(Collections.singletonList(message));
                    invocationContext.setSendResult(result);
                    sendCallback.onSuccess(result);
                }
                finally {
                    ProducerImpl.this.executePostHandle(postHandleStack);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onException(Throwable e) {
                try {
                    String topic = message.getTopic();
                    String msgId = message.getMsgID();
                    ONSClientException onsEx = ProducerImpl.this.checkProducerException(topic, msgId, e);
                    OnExceptionContext context = new OnExceptionContext();
                    context.setTopic(topic);
                    context.setMessageId(msgId);
                    context.setException(onsEx);
                    invocationContext.setMessages(Collections.singletonList(message));
                    invocationContext.setException(onsEx);
                    sendCallback.onException(context);
                }
                finally {
                    ProducerImpl.this.executePostHandle(postHandleStack);
                }
            }
        };
    }

    private SendResult sendResultConvert(com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult rmqSendResult) {
        SendResult sendResult = new SendResult();
        sendResult.setTopic(rmqSendResult.getMessageQueue().getTopic());
        sendResult.setMessageId(rmqSendResult.getMsgId());
        return sendResult;
    }

    private ONSClientException checkProducerException(String topic, String msgId, Throwable e) {
        if (e instanceof MQClientException) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof RemotingConnectException) {
                    return new ONSClientException(FAQ.errorMessage(String.format("Connect broker failed, Topic=%s, msgId=%s", topic, msgId), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&connect_broker_failed"));
                }
                if (e.getCause() instanceof RemotingTimeoutException) {
                    return new ONSClientException(FAQ.errorMessage(String.format("Send message to broker timeout, %dms, Topic=%s, msgId=%s", this.defaultMQProducer.getSendMsgTimeout(), topic, msgId), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&send_msg_failed"));
                }
                if (e.getCause() instanceof MQBrokerException) {
                    MQBrokerException excep = (MQBrokerException)e.getCause();
                    return new ONSClientException(FAQ.errorMessage(String.format("Receive a broker exception, Topic=%s, msgId=%s, %s", topic, msgId, excep.getErrorMessage()), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&broker_response_exception"));
                }
            } else {
                MQClientException excep = (MQClientException)e;
                if (-1 == excep.getResponseCode()) {
                    return new ONSClientException(FAQ.errorMessage(String.format("Topic does not exist, Topic=%s, msgId=%s", topic, msgId), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&topic_not_exist"));
                }
                if (13 == excep.getResponseCode()) {
                    return new ONSClientException(FAQ.errorMessage(String.format("ONS Client check message exception, Topic=%s, msgId=%s", topic, msgId), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&msg_check_failed"));
                }
            }
        }
        return new ONSClientException("defaultMQProducer send exception", e);
    }
}

