/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MixAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public abstract class ConfigManager {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqCommon");

    public boolean load() {
        String fileName = null;
        try {
            fileName = this.configFilePath();
            String jsonString = MixAll.file2String(fileName);
            if (null == jsonString || jsonString.length() == 0) {
                return this.loadBak();
            }
            this.decode(jsonString);
            log.info("load " + fileName + " OK");
            return true;
        }
        catch (Exception e) {
            log.error("load " + fileName + " failed, and try to load backup file", e);
            return this.loadBak();
        }
    }

    public abstract String configFilePath();

    private boolean loadBak() {
        String fileName = null;
        try {
            fileName = this.configFilePath();
            String jsonString = MixAll.file2String(fileName + ".bak");
            if (jsonString != null && jsonString.length() > 0) {
                this.decode(jsonString);
                log.info("load " + fileName + " OK");
                return true;
            }
        }
        catch (Exception e) {
            log.error("load " + fileName + " Failed", e);
            return false;
        }
        return true;
    }

    public abstract void decode(String var1);

    protected abstract void write0(Writer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void persist() {
        String config = this.configFilePath();
        String temp = config + ".tmp";
        String backup = config + ".bak";
        BufferedWriter bufferedWriter = null;
        try {
            File tmpFile = new File(temp);
            File parentDirectory = tmpFile.getParentFile();
            if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
                log.error("Failed to create directory: {}", (Object)parentDirectory.getCanonicalPath());
                return;
            }
            if (!tmpFile.exists() && !tmpFile.createNewFile()) {
                log.error("Failed to create file: {}", (Object)tmpFile.getCanonicalPath());
                return;
            }
            bufferedWriter = new BufferedWriter(new FileWriter(tmpFile, false));
            this.write0(bufferedWriter);
            bufferedWriter.flush();
            log.debug("Finished writing tmp file: {}", (Object)temp);
            File configFile = new File(config);
            if (configFile.exists()) {
                Files.copy(configFile, new File(backup));
                configFile.delete();
            }
            tmpFile.renameTo(configFile);
            return;
        }
        catch (IOException e) {
            log.error("Failed to persist {}", (Object)temp, (Object)e);
            return;
        }
        finally {
            if (null != bufferedWriter) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

