/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.client.impl;

import com.baiwang.bop.client.BopException;
import com.baiwang.bop.client.IAsyncBopClient;
import com.baiwang.bop.client.IBopClient;
import com.baiwang.bop.request.IBopRequest;
import com.baiwang.bop.respose.entity.input.BatchResultModelResponse;
import com.baiwang.bop.respose.parser.IBopResposeParser;
import com.baiwang.bop.respose.parser.impl.JsonResposeParser;
import com.baiwang.bop.respose.parser.impl.XmlResposeParser;
import com.baiwang.bop.utils.BopHashMap;
import com.baiwang.bop.utils.BopUtils;
import com.baiwang.bop.utils.JacksonUtil;
import com.baiwang.bop.utils.OperationController;
import com.baiwang.bop.utils.StrUtils;
import com.baiwang.bop.utils.WebUtils;
import com.baiwang.logging.Log;
import com.baiwang.logging.LogFactory;
import com.baiwang.open.utils.CommonWebUtils;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;

public class BopRestClient
implements IBopClient,
IAsyncBopClient {
    private static final Log LOG = LogFactory.getLog(BopRestClient.class);
    private static final String sdkVersion = BopRestClient.class.getPackage().getImplementationVersion();
    private static final String APP_KEY = "appKey";
    private static final String FORMAT = "format";
    private static final String METHOD = "method";
    private static final String TIMESTAMP = "timestamp";
    private static final String VERSION = "version";
    private static final String SIGN = "sign";
    private static final String SESSION = "token";
    private static final String TYPE = "type";
    private static final String REQUEST_ID = "requestId";
    private static final String SDK_VERSION = "sdkVersion";
    private String serverUrl;
    private String appKey;
    private String appSecret;
    private String format = "json";
    private WebUtils webUtils;

    private WebUtils getWebUtil() {
        if (this.webUtils == null) {
            this.webUtils = new WebUtils();
        }
        return this.webUtils;
    }

    public BopRestClient(String serverUrl, String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
        this.getWebUtil();
    }

    @Override
    public void setProxy(String proxyHost, int proxyPort) {
        this.webUtils.setProxy(proxyHost, proxyPort);
    }

    @Override
    public void setAuthorization(String userName, String passWord) {
        this.webUtils.setAuthorization(userName, passWord);
    }

    public BopRestClient(String serverUrl, String appKey, String appSecret, String format) {
        this(serverUrl, appKey, appSecret);
        this.format = format;
        this.getWebUtil();
    }

    @Override
    public <T> T execute(IBopRequest request, String requestId, String session, Class<T> respClazz) throws BopException {
        String rsp;
        if (StrUtils.isEmpty(requestId)) {
            requestId = UUID.randomUUID().toString();
        }
        if (StrUtils.isEmpty(this.serverUrl)) {
            throw new BopException("\u767e\u671b\u5f00\u653e\u5e73\u53f0\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StrUtils.isEmpty(this.appKey)) {
            throw new BopException("\u767e\u671b\u5f00\u653e\u5e73\u53f0appKey\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StrUtils.isEmpty(this.appSecret)) {
            throw new BopException("\u767e\u671b\u5f00\u653e\u5e73\u53f0appSecret\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        String requestJson = JacksonUtil.beanToString(request);
        if (OperationController.canLog(request.getApiName())) {
            LOG.warn("\u8bf7\u6c42\u62a5\u6587\uff1a" + requestJson);
        }
        String postServerUrl = this.appendSystemParamsToUrl(this.serverUrl, request.getApiName(), session, "sync", null, requestId, requestJson);
        try {
            LOG.warn("\u8bf7\u6c42url\uff1a" + postServerUrl);
            rsp = WebUtils.isHttps(this.serverUrl) ? WebUtils.doPostHttps(postServerUrl, requestJson) : WebUtils.doPost(postServerUrl, requestJson);
            LOG.warn("\u54cd\u5e94\u4fe1\u606f\uff1a" + rsp);
            if (rsp.contains("errorResponse")) {
                LOG.warn("\u95ee\u9898\u89e3\u51b3\u65b9\u6848\u67e5\u8be2\u8bf7\u5230\uff1ahttp://39.106.110.81/openplatform/#/SupportCenter");
            }
        }
        catch (IOException e) {
            throw new BopException(e);
        }
        this.tryParseException(rsp);
        return this.getResposeParser(this.format, respClazz).parse(rsp, request.getApiName());
    }

    public static void main(String[] args) {
        String resp = "{\n\t\"method\": \"baiwang.input.batchResult\",\n\t\"requestId\": \"af5e935c-5b61-44e7-b5be-b276cf5d8792\",\n\t\"response\": {\n\t\t\"taskList\": [{\n\t\t\t\"deductiblePeriod\": \"201903\",\n\t\t\t\"DeductibleDate\": \"\",\n\t\t\t\"TaskNo\": \"3\",\n\t\t\t\"InvoiceCode\": \"032001900312\",\n\t\t\t\"InvoiceNumber\": \"03220119\",\n\t\t\t\"ResultCode\": \"1\"\n\t\t}, {\n\t\t\t\"TaskNo\": \"4\",\n\t\t\t\"InvoiceCode\": \"032001900312\",\n\t\t\t\"InvoiceNumber\": \"03220120\",\n\t\t\t\"ResultCode\": \"1\"\n\t\t}, {\n\t\t\t\"TaskNo\": \"5\",\n\t\t\t\"InvoiceCode\": \"032001900312\",\n\t\t\t\"InvoiceNumber\": \"03220121\",\n\t\t\t\"ResultCode\": \"1\"\n\t\t}],\n\t\t\"message\": \"\u6267\u884c\u6210\u529f\",\n\t\t\"taxNo\": \"911501006800056214\"\n\t}\n}";
        BopRestClient bopRestClient = new BopRestClient("a", "a", "a");
        BatchResultModelResponse parse = bopRestClient.getResposeParser(bopRestClient.format, BatchResultModelResponse.class).parse(resp, "baiwang.input.batchResult");
        System.out.println(parse);
    }

    @Override
    public <T> T execute(IBopRequest request, String session, Class<T> respClazz) throws BopException {
        return this.execute(request, null, session, respClazz);
    }

    @Override
    public String execute(String requestJson, String method, String session) throws BopException {
        String rsp;
        if (OperationController.canLog(method)) {
            LOG.warn("\u8bf7\u6c42\u62a5\u6587\uff1a" + requestJson);
        }
        String postServerUrl = this.appendSystemParamsToUrl(this.serverUrl, method, session, "sync", null, null, requestJson);
        try {
            LOG.warn("\u8bf7\u6c42url\uff1a" + postServerUrl);
            rsp = WebUtils.isHttps(this.serverUrl) ? WebUtils.doPostHttps(postServerUrl, requestJson) : WebUtils.doPost(postServerUrl, requestJson);
            LOG.warn("\u54cd\u5e94\u4fe1\u606f\uff1a" + rsp);
            if (rsp.contains("errorResponse")) {
                LOG.warn("\u95ee\u9898\u89e3\u51b3\u65b9\u6848\u67e5\u8be2\u8bf7\u5230\uff1ahttp://39.106.110.81/openplatform/#/SupportCenter");
            }
        }
        catch (IOException e) {
            throw new BopException(e);
        }
        this.tryParseException(rsp);
        return rsp;
    }

    @Override
    public <T> T executeAsyn(IBopRequest request, String session, Class<T> respClazz, Integer outTime) throws BopException {
        String rsp;
        int sleepTime = 100;
        int maxTime = outTime / sleepTime;
        String requestJson = JacksonUtil.beanToString(request);
        if (OperationController.canLog(request.getApiName())) {
            LOG.warn("\u8bf7\u6c42\u62a5\u6587\uff1a" + requestJson);
        }
        String postServerUrl1 = this.appendSystemParamsToUrl(this.serverUrl, request.getApiName(), session, "asyn", null, null, requestJson);
        try {
            rsp = WebUtils.isHttps(this.serverUrl) ? WebUtils.doPostHttps(postServerUrl1, requestJson) : WebUtils.doPost(postServerUrl1, requestJson);
        }
        catch (IOException e) {
            throw new BopException(e);
        }
        String requestId = this.getRequestId(rsp);
        String postServerUrl2 = this.appendSystemParamsToUrl(this.serverUrl, request.getApiName(), session, "result", null, requestId, ".");
        LOG.warn("\u83b7\u53d6\u7ed3\u679c\u5730\u5740\uff1a" + postServerUrl2);
        int count = 1;
        try {
            while (true) {
                rsp = WebUtils.isHttps(this.serverUrl) ? WebUtils.doPostHttps(postServerUrl2, ".") : WebUtils.doPost(postServerUrl2, ".");
                LOG.warn("\u7b2c" + count + "\u6b21\u54cd\u5e94\u7ed3\u679c\uff1a" + rsp);
                this.tryParseException(rsp);
                T responseBean = this.getResposeParser(this.format, respClazz).parse(rsp, request.getApiName());
                if (null != responseBean) {
                    return responseBean;
                }
                if (++count > maxTime) {
                    LOG.warn("\u54cd\u5e94\u8d85\u65f6...");
                    throw new BopException("system.error", "time out!");
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            throw new BopException(e);
        }
    }

    @Override
    public String sendRequest(IBopRequest request, String session) throws BopException {
        String rsp;
        String requestJson = JacksonUtil.beanToString(request);
        if (OperationController.canLog(request.getApiName())) {
            LOG.warn("\u8bf7\u6c42\u62a5\u6587\uff1a" + requestJson);
        }
        String postServerUrl1 = this.appendSystemParamsToUrl(this.serverUrl, request.getApiName(), session, "asyn", null, null, requestJson);
        LOG.warn("\u8bf7\u6c42\u5730\u5740\uff1a" + postServerUrl1);
        try {
            rsp = WebUtils.isHttps(this.serverUrl) ? WebUtils.doPostHttps(postServerUrl1, requestJson) : WebUtils.doPost(postServerUrl1, requestJson);
        }
        catch (IOException e) {
            throw new BopException(e);
        }
        LOG.warn("\u54cd\u5e94\u7ed3\u679c\uff1a" + rsp);
        this.tryParseException(rsp);
        String requestId = this.getRequestId(rsp);
        LOG.warn("\u8bf7\u6c42id\uff1a" + requestId);
        return requestId;
    }

    @Override
    public <T> T getResponse(String requestId, String session, Class<T> respClazz, String requestApiName) throws BopException {
        T responseBean;
        String postServerUrl2 = this.appendSystemParamsToUrl(this.serverUrl, requestApiName, session, "result", null, requestId, ".");
        LOG.warn("\u83b7\u53d6\u7ed3\u679c\u5730\u5740\uff1a" + postServerUrl2);
        try {
            String rsp = WebUtils.isHttps(this.serverUrl) ? WebUtils.doPostHttps(postServerUrl2, ".") : WebUtils.doPost(postServerUrl2, ".");
            LOG.warn("\u54cd\u5e94\u7ed3\u679c\uff1a" + rsp);
            this.tryParseException(rsp);
            responseBean = this.getResposeParser(this.format, respClazz).parse(rsp, requestApiName);
        }
        catch (Exception e) {
            throw new BopException(e);
        }
        return responseBean;
    }

    private <T> IBopResposeParser<T> getResposeParser(String format, Class<T> clazz) {
        if (format.equals("xml")) {
            return new XmlResposeParser<T>(clazz);
        }
        return new JsonResposeParser<T>(clazz);
    }

    private void tryParseException(String rsp) throws BopException {
        if ("json".equals(this.format)) {
            BopUtils.tryParseException(rsp);
        } else {
            BopUtils.tryParseXmlException(rsp);
        }
    }

    private String getRequestId(String rsp) throws BopException {
        if ("json".equals(this.format)) {
            return BopUtils.getJsonRequestId(rsp);
        }
        return BopUtils.getXmlRequestId(rsp);
    }

    private void appendSystemParams(BopHashMap textParams, String apiName, String session, String body) {
        textParams.put(METHOD, apiName);
        textParams.put(VERSION, "6.0");
        textParams.put(APP_KEY, this.appKey);
        textParams.put(FORMAT, this.format);
        textParams.put(TIMESTAMP, (Object)new Date());
        textParams.put(SESSION, session);
        try {
            textParams.put(SIGN, BopUtils.signTopRequest(textParams, this.appSecret, body));
        }
        catch (Exception e) {
            throw new BopException(e);
        }
    }

    private String appendSystemParamsToUrl(String url, String apiName, String session, String type, String asynId, String requestId, String body) {
        Long time = new Date().getTime();
        StringBuilder sburl = new StringBuilder(url);
        sburl = CommonWebUtils.adaptUrl(url, sburl);
        sburl.append(METHOD);
        sburl.append("=");
        sburl.append(apiName);
        sburl.append("&");
        sburl.append(VERSION);
        sburl.append("=6.0&");
        sburl.append(APP_KEY);
        sburl.append("=");
        sburl.append(this.appKey);
        sburl.append("&");
        sburl.append(FORMAT);
        sburl.append("=");
        sburl.append(this.format);
        sburl.append("&");
        sburl.append(TIMESTAMP);
        sburl.append("=");
        sburl.append(time);
        sburl.append("&");
        sburl.append(SESSION);
        sburl.append("=");
        sburl.append(session);
        sburl.append("&");
        sburl.append(TYPE);
        sburl.append("=");
        sburl.append(type);
        if (asynId != null) {
            sburl.append("&");
            sburl.append("asynRequestId");
            sburl.append("=");
            sburl.append(asynId);
        }
        if (requestId != null) {
            sburl.append("&");
            sburl.append(REQUEST_ID);
            sburl.append("=");
            sburl.append(requestId);
        }
        try {
            BopHashMap textParams = new BopHashMap();
            textParams.put(METHOD, apiName);
            textParams.put(VERSION, "6.0");
            textParams.put(APP_KEY, this.appKey);
            textParams.put(FORMAT, this.format);
            textParams.put(TIMESTAMP, (Object)time);
            textParams.put(SESSION, session);
            textParams.put(TYPE, type);
            if (requestId != null) {
                textParams.put(REQUEST_ID, requestId);
            }
            if (asynId != null) {
                textParams.put("asynRequestId", asynId);
            }
            sburl.append("&").append(SDK_VERSION).append("=").append(sdkVersion);
            textParams.put(SDK_VERSION, sdkVersion);
            sburl.append("&");
            sburl.append(SIGN);
            sburl.append("=");
            sburl.append(BopUtils.signTopRequest(textParams, this.appSecret, body));
        }
        catch (Exception e) {
            throw new BopException(e);
        }
        return sburl.toString();
    }
}

