/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.client.impl;

import com.baiwang.bop.client.BopException;
import com.baiwang.bop.client.ILoginClient;
import com.baiwang.bop.request.impl.LoginRequest;
import com.baiwang.bop.respose.entity.LoginResponse;
import com.baiwang.bop.respose.parser.impl.JsonResposeParser;
import com.baiwang.bop.utils.BopHashMap;
import com.baiwang.bop.utils.BopUtils;
import com.baiwang.bop.utils.WebUtils;
import com.baiwang.logging.Log;
import com.baiwang.logging.LogFactory;
import com.baiwang.open.utils.CommonWebUtils;
import com.baiwang.open.utils.JacksonUtil;
import java.io.IOException;
import java.util.Date;

public class PostLogin
implements ILoginClient {
    private String url;
    private static final Log log = LogFactory.getLog(PostLogin.class);
    private WebUtils webUtils;

    private WebUtils getWebUtil() {
        if (this.webUtils == null) {
            this.webUtils = new WebUtils();
        }
        return this.webUtils;
    }

    public PostLogin(String url) {
        this.url = url;
        this.getWebUtil();
    }

    @Override
    public void setProxy(String proxyHost, int proxyPort) {
        this.webUtils.setProxy(proxyHost, proxyPort);
    }

    @Override
    public void setAuthorization(String userName, String passWord) {
        this.webUtils.setAuthorization(userName, passWord);
    }

    @Override
    public LoginResponse login(LoginRequest loginRequest) throws BopException {
        try {
            this.url = CommonWebUtils.adaptUrl(this.url, new StringBuilder(this.url)).toString();
            String loginUrl = this.url + WebUtils.buildQuery(loginRequest.getTextParams(), "UTF-8");
            String body = JacksonUtil.beanToString(loginRequest.getTextBody());
            log.warn("\u8bf7\u6c42url\uff1a" + loginUrl + ";\u8bf7\u6c42body\uff1a" + body);
            String result = null;
            result = WebUtils.isHttps(this.url) ? WebUtils.doPostHttps(loginUrl, body) : WebUtils.doPost(loginUrl, body);
            log.warn("\u8fd4\u56de\u4fe1\u606f\uff1a" + result);
            BopUtils.tryParseException(result);
            JsonResposeParser<LoginResponse> parser = new JsonResposeParser<LoginResponse>(LoginResponse.class);
            LoginResponse loginResponse = (LoginResponse)parser.parse(result, loginRequest.getApiName());
            return loginResponse;
        }
        catch (IOException e) {
            throw new BopException(e);
        }
    }

    @Override
    public LoginResponse refreshToken(String clientId, String clientSecret, String refreshValue) throws BopException {
        try {
            String transformedUrl = CommonWebUtils.adaptUrl(this.url, new StringBuilder(this.url)).toString();
            String refreshTokenUrl = transformedUrl + "version=" + "6.0" + "&grant_type=refresh_token&refresh_token=" + refreshValue + "&client_id=" + clientId + "&method=baiwang.oauth.token&timestamp=" + new Date().getTime();
            BopHashMap bodyMap = new BopHashMap();
            bodyMap.put("client_secret", clientSecret);
            String body = JacksonUtil.beanToString(bodyMap);
            log.warn("\u5237\u65b0url\uff1a" + refreshTokenUrl + "\uff0c\u8bf7\u6c42body\uff1a" + body);
            String result = null;
            result = WebUtils.isHttps(this.url) ? WebUtils.doPostHttps(refreshTokenUrl, body) : WebUtils.doPost(refreshTokenUrl, body);
            log.warn("\u8fd4\u56de\u4fe1\u606f\uff1a" + result);
            BopUtils.tryParseException(result);
            JsonResposeParser<LoginResponse> parser = new JsonResposeParser<LoginResponse>(LoginResponse.class);
            LoginResponse loginResponse = (LoginResponse)parser.parse(result, "baiwang.oauth.token");
            return loginResponse;
        }
        catch (IOException e) {
            throw new BopException(e);
        }
    }
}

