/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.ex.bean.common;

import com.baiwang.bop.ex.bean.request.model.OCRStandInvoice;
import com.baiwang.bop.ex.bean.response.model.AirTicket;
import com.baiwang.bop.ex.bean.response.model.SingleTrialInfo;
import com.baiwang.bop.utils.StrUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class OCRParseUtil {
    private static final Logger LOG = Logger.getLogger(OCRParseUtil.class.toString());
    private static final String DATE_PATTERN_ZH11 = "yyyy\u5e74MM\u6708dd\u65e5";
    private static final String DATE_PATTERN_ZH17 = "yyyy\u5e74MM\u6708dd\u65e5 HH:mm";
    private static final String INIT_YEAR = "1970\u5e7410\u670810\u65e5 ";

    public static List<OCRStandInvoice> parseStandInvoice(Map<String, Object> mapObject) {
        ArrayList<OCRStandInvoice> standInvoiceList = new ArrayList<OCRStandInvoice>();
        Map jnObject = (Map)mapObject.get("response");
        Map object = (Map)jnObject.get("data");
        List jsonArray = (List)object.get("identify_results");
        if (jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                Map jsObject = (Map)jsonArray.get(i);
                String type = (String)jsObject.get("type");
                List region = (List)jsObject.get("region");
                Map js = (Map)jsObject.get("details");
                OCRStandInvoice standInvoice = OCRParseUtil.parseStandInvoice(js, type);
                standInvoice.setPositionRegion(region);
                standInvoiceList.add(standInvoice);
            }
        }
        return standInvoiceList;
    }

    public static List<SingleTrialInfo> parseCustomInvoice(Map<String, Object> jsonObject) {
        ArrayList<SingleTrialInfo> list = new ArrayList<SingleTrialInfo>();
        Map jnObject = (Map)jsonObject.get("response");
        Map object = (Map)jnObject.get("data");
        List jsonArray = (List)object.get("identify_results");
        if (jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                Map jsObject = (Map)jsonArray.get(i);
                SingleTrialInfo singleTrialInfo = new SingleTrialInfo();
                String type = (String)jsObject.get("type");
                List region = (List)jsObject.get("region");
                Map js = (Map)jsObject.get("details");
                String title = (String)js.get("title");
                String code = (String)js.get("code");
                String number = (String)js.get("number");
                String date = (String)js.get("date");
                String time = (String)js.get("time");
                if (!StrUtils.isEmpty(date)) {
                    date = date.replace("\u5e74", ".").replace("\u6708", ".").replace("\u65e5", " ");
                    if (!StrUtils.isEmpty(time)) {
                        date = date + time;
                    }
                }
                String check_code = (String)js.get("check_code");
                String pretax_amount = (String)js.get("pretax_amount");
                String tax = (String)js.get("tax");
                String kind = (String)js.get("kind");
                String seller = (String)js.get("seller");
                String seller_tax_id = (String)js.get("seller_tax_id");
                String buyer = (String)js.get("buyer");
                String buyer_tax_id = (String)js.get("buyer_tax_id");
                String user_id = (String)js.get("user_id");
                String total = (String)js.get("total");
                String station_geton = (String)js.get("station_geton");
                String station_getoff = (String)js.get("station_getoff");
                String train_number = (String)js.get("train_number");
                String seat = (String)js.get("seat");
                String mileage = (String)js.get("mileage");
                String time_geton = (String)js.get("time_geton");
                String time_getoff = (String)js.get("time_getoff");
                String user_name = (String)js.get("user_name");
                String carName = (String)js.get("name");
                String buyer_id = (String)js.get("buyer_id");
                String fare = (String)js.get("fare");
                String fuel_surcharge = (String)js.get("fuel_surcharge");
                String caac_development_fund = (String)js.get("caac_development_fund");
                List flights = (List)js.get("flights");
                ArrayList<AirTicket> airTicketList = new ArrayList<AirTicket>();
                if (flights != null && flights.size() > 0) {
                    for (int j = 0; j < flights.size(); ++j) {
                        AirTicket airTicket = new AirTicket();
                        Map flightsJSONObject = (Map)flights.get(j);
                        airTicket.setFromStand((String)flightsJSONObject.get("from"));
                        airTicket.setToStand((String)flightsJSONObject.get("to"));
                        airTicket.setFlightNumber((String)flightsJSONObject.get("flight_number"));
                        airTicket.setSeatLevel((String)flightsJSONObject.get("seat"));
                        String ridingDate = (String)flightsJSONObject.get("date");
                        String ridingTime = (String)flightsJSONObject.get("time");
                        if (!StrUtils.isEmpty(ridingDate)) {
                            ridingDate = ridingDate.replace("\u5e74", ".").replace("\u6708", ".").replace("\u65e5", " ");
                            if (!StrUtils.isEmpty(ridingTime)) {
                                ridingDate = ridingDate + ridingTime;
                            }
                        }
                        airTicket.setRidingDate(ridingDate);
                        airTicketList.add(airTicket);
                    }
                    singleTrialInfo.setAirTicketList(airTicketList);
                }
                singleTrialInfo.setType(type);
                singleTrialInfo.setRegion(region);
                singleTrialInfo.setInvoiceCode(code);
                singleTrialInfo.setInvoiceNumber(number);
                singleTrialInfo.setBillingDate(date);
                singleTrialInfo.setCheckCode(check_code);
                singleTrialInfo.setTotalAmount(pretax_amount);
                singleTrialInfo.setMoney(total);
                singleTrialInfo.setOriginator(station_geton);
                singleTrialInfo.setDestination(station_getoff);
                singleTrialInfo.setTrainNumber(train_number);
                singleTrialInfo.setSeat(seat);
                singleTrialInfo.setMileage(mileage);
                singleTrialInfo.setTimeGeton(time_geton);
                singleTrialInfo.setTimeGetoff(time_getoff);
                singleTrialInfo.setBillingDate(date);
                singleTrialInfo.setUserId(user_id);
                singleTrialInfo.setUserName(user_name);
                singleTrialInfo.setKind(kind);
                singleTrialInfo.setSeller(seller);
                singleTrialInfo.setSellerTaxId(seller_tax_id);
                singleTrialInfo.setBuyer(buyer);
                singleTrialInfo.setBuyerTaxId(buyer_tax_id);
                singleTrialInfo.setBuyerId(buyer_id);
                singleTrialInfo.setTax(tax);
                singleTrialInfo.setCarName(carName);
                singleTrialInfo.setFares(fare);
                singleTrialInfo.setFuelCharge(fuel_surcharge);
                singleTrialInfo.setFund(caac_development_fund);
                singleTrialInfo.setTitle(title);
                list.add(singleTrialInfo);
            }
        }
        return list;
    }

    private static OCRStandInvoice parseStandInvoice(Map<String, Object> jsObject, String type) {
        OCRStandInvoice ocrStandInvoice = new OCRStandInvoice();
        String invoiceType = OCRParseUtil.convertType(type);
        ocrStandInvoice.setInvoiceType(invoiceType);
        if ("100".equals(invoiceType) || "101".equals(invoiceType) || "102".equals(invoiceType)) {
            ocrStandInvoice.setInvoiceCode((String)jsObject.get("code"));
            ocrStandInvoice.setInvoiceNo((String)jsObject.get("number"));
            ocrStandInvoice.setInvoiceDate(OCRParseUtil.parseDate((String)jsObject.get("date"), DATE_PATTERN_ZH11));
            ocrStandInvoice.setTotalAmount(OCRParseUtil.parseNumber((String)jsObject.get("pretax_amount")));
            ocrStandInvoice.setAmountTax(OCRParseUtil.parseNumber((String)jsObject.get("total")));
            ocrStandInvoice.setTotalTax(OCRParseUtil.parseNumber((String)jsObject.get("tax")));
            ocrStandInvoice.setCheckCode((String)jsObject.get("check_code"));
            ocrStandInvoice.setSaleTaxNo((String)jsObject.get("seller_tax_id"));
            ocrStandInvoice.setPurchaserTaxNo((String)jsObject.get("buyer_tax_id"));
        } else if ("300".equals(invoiceType)) {
            ocrStandInvoice.setInvoiceCode((String)jsObject.get("code"));
            ocrStandInvoice.setInvoiceNo((String)jsObject.get("number"));
            ocrStandInvoice.setInvoiceDate(OCRParseUtil.parseDate((String)jsObject.get("date"), DATE_PATTERN_ZH11));
            ocrStandInvoice.setAmountTax(OCRParseUtil.parseNumber((String)jsObject.get("total")));
            ocrStandInvoice.setCheckCode((String)jsObject.get("check_code"));
            ocrStandInvoice.setSaleTaxNo((String)jsObject.get("seller_tax_id"));
            ocrStandInvoice.setPurchaserTaxNo((String)jsObject.get("buyer_tax_id"));
        } else if ("303".equals(invoiceType)) {
            ocrStandInvoice.setInvoiceCode((String)jsObject.get("code"));
            ocrStandInvoice.setInvoiceNo((String)jsObject.get("number"));
            ocrStandInvoice.setInvoiceDate(OCRParseUtil.parseDate((String)jsObject.get("date"), DATE_PATTERN_ZH11));
            ocrStandInvoice.setAmountTax(OCRParseUtil.parseNumber((String)jsObject.get("total")));
            ocrStandInvoice.setLeaveTime(OCRParseUtil.parseDate(INIT_YEAR + (String)jsObject.get("time_geton"), DATE_PATTERN_ZH17));
            ocrStandInvoice.setArriveTime(OCRParseUtil.parseDate(INIT_YEAR + (String)jsObject.get("time_getoff"), DATE_PATTERN_ZH17));
            ocrStandInvoice.setMileage((String)jsObject.get("mileage"));
        } else if ("301".equals(invoiceType)) {
            ocrStandInvoice.setInvoiceNo((String)jsObject.get("number"));
            ocrStandInvoice.setInvoiceDate(OCRParseUtil.parseDate((String)jsObject.get("date"), DATE_PATTERN_ZH11));
            ocrStandInvoice.setAmountTax(OCRParseUtil.parseNumber((String)jsObject.get("total")));
            ocrStandInvoice.setTotalAmount(ocrStandInvoice.getAmountTax());
            ocrStandInvoice.setDrawer((String)jsObject.get("name"));
            ocrStandInvoice.setLeaveTime(OCRParseUtil.parseDate(INIT_YEAR + (String)jsObject.get("time"), DATE_PATTERN_ZH17));
            ocrStandInvoice.setLeaveCity((String)jsObject.get("station_geton"));
            ocrStandInvoice.setArriveCity((String)jsObject.get("station_getoff"));
            ocrStandInvoice.setTrainNumber((String)jsObject.get("train_number"));
            ocrStandInvoice.setTrainSeat((String)jsObject.get("seat"));
        } else if ("304".equals(invoiceType)) {
            ocrStandInvoice.setInvoiceCode((String)jsObject.get("code"));
            ocrStandInvoice.setInvoiceNo((String)jsObject.get("number"));
            ocrStandInvoice.setInvoiceDate(OCRParseUtil.parseDate((String)jsObject.get("date"), DATE_PATTERN_ZH11));
            ocrStandInvoice.setAmountTax(OCRParseUtil.parseNumber((String)jsObject.get("total")));
            ocrStandInvoice.setTotalAmount(ocrStandInvoice.getAmountTax());
            ocrStandInvoice.setDrawer((String)jsObject.get("name"));
            ocrStandInvoice.setLeaveTime(OCRParseUtil.parseDate(INIT_YEAR + (String)jsObject.get("time"), DATE_PATTERN_ZH17));
            ocrStandInvoice.setLeaveCity((String)jsObject.get("station_geton"));
            ocrStandInvoice.setArriveCity((String)jsObject.get("station_getoff"));
        } else if ("305".equals(invoiceType)) {
            ocrStandInvoice.setInvoiceCode((String)jsObject.get("code"));
            ocrStandInvoice.setInvoiceNo((String)jsObject.get("number"));
            ocrStandInvoice.setAmountTax(OCRParseUtil.parseNumber((String)jsObject.get("total")));
        } else if ("200".equals(invoiceType)) {
            ocrStandInvoice.setInvoiceCode((String)jsObject.get("code"));
            ocrStandInvoice.setInvoiceNo((String)jsObject.get("number"));
            ocrStandInvoice.setInvoiceDate(OCRParseUtil.parseDate((String)jsObject.get("date"), DATE_PATTERN_ZH11));
            ocrStandInvoice.setAmountTax(OCRParseUtil.parseNumber((String)jsObject.get("total")));
            ocrStandInvoice.setTotalAmount(OCRParseUtil.parseNumber((String)jsObject.get("pretax_amount")));
            ocrStandInvoice.setSaleTaxNo((String)jsObject.get("seller_tax_id"));
            ocrStandInvoice.setBuyerIdentification((String)jsObject.get("buyer_id"));
        } else if ("201".equals(invoiceType)) {
            ocrStandInvoice.setInvoiceCode((String)jsObject.get("code"));
            ocrStandInvoice.setInvoiceNo((String)jsObject.get("number"));
            ocrStandInvoice.setInvoiceDate(OCRParseUtil.parseDate((String)jsObject.get("date"), DATE_PATTERN_ZH11));
            ocrStandInvoice.setAmountTax(OCRParseUtil.parseNumber((String)jsObject.get("total")));
            ocrStandInvoice.setBuyerIdentification((String)jsObject.get("buyer_id"));
            ocrStandInvoice.setSellerId((String)jsObject.get("seller_id"));
            ocrStandInvoice.setMarketTaxNo((String)jsObject.get("company_tax_id"));
        } else if ("302".equals(invoiceType)) {
            ocrStandInvoice.setInvoiceNo((String)jsObject.get("number"));
            ocrStandInvoice.setDrawer((String)jsObject.get("user_name"));
            ocrStandInvoice.setIdNum((String)jsObject.get("user_id"));
            ocrStandInvoice.setCheckCode((String)jsObject.get("check_code"));
            ocrStandInvoice.setInvoiceDate(OCRParseUtil.parseDate((String)jsObject.get("date"), DATE_PATTERN_ZH11));
            ocrStandInvoice.setTotalAmount(OCRParseUtil.parseNumber((String)jsObject.get("fare")));
            ocrStandInvoice.setAmountTax(OCRParseUtil.parseNumber((String)jsObject.get("total")));
            ocrStandInvoice.setTotalTax(OCRParseUtil.parseNumber((String)jsObject.get("fuel_surcharge")));
            ocrStandInvoice.setOtherTax(OCRParseUtil.parseNumber((String)jsObject.get("tax")));
            ocrStandInvoice.setCivilAviationFund(OCRParseUtil.parseNumber((String)jsObject.get("caac_development_fund")));
        } else if ("999".equals(invoiceType)) {
            ocrStandInvoice.setInvoiceCode((String)jsObject.get("code"));
            ocrStandInvoice.setInvoiceNo((String)jsObject.get("number"));
            ocrStandInvoice.setInvoiceDate(OCRParseUtil.parseDate((String)jsObject.get("date"), DATE_PATTERN_ZH11));
            ocrStandInvoice.setAmountTax(OCRParseUtil.parseNumber((String)jsObject.get("total")));
        }
        return ocrStandInvoice;
    }

    private static final String convertType(String glorityInvoiceType) {
        String invoiceType = "999";
        if ("10100".equals(glorityInvoiceType)) {
            invoiceType = "100";
        } else if ("10101".equals(glorityInvoiceType)) {
            invoiceType = "101";
        } else if ("10102".equals(glorityInvoiceType)) {
            invoiceType = "102";
        } else if ("10103".equals(glorityInvoiceType)) {
            invoiceType = "300";
        } else if ("10104".equals(glorityInvoiceType)) {
            invoiceType = "200";
        } else if ("10105".equals(glorityInvoiceType)) {
            invoiceType = "201";
        } else if ("10200".equals(glorityInvoiceType)) {
            invoiceType = "305";
        } else if ("10503".equals(glorityInvoiceType)) {
            invoiceType = "301";
        } else if ("10500".equals(glorityInvoiceType)) {
            invoiceType = "303";
        } else if ("10506".equals(glorityInvoiceType)) {
            invoiceType = "302";
        } else if ("10505".equals(glorityInvoiceType)) {
            invoiceType = "304";
        } else if ("10400".equals(glorityInvoiceType)) {
            invoiceType = "999";
        } else if ("10507".equals(glorityInvoiceType)) {
            invoiceType = "999";
        } else if ("10900".equals(glorityInvoiceType)) {
            invoiceType = "999";
        } else if ("00000".equals(glorityInvoiceType)) {
            invoiceType = "999";
        } else if ("20100".equals(glorityInvoiceType)) {
            invoiceType = "999";
        }
        return invoiceType;
    }

    private static final BigDecimal parseNumber(String str) {
        try {
            return new BigDecimal(str);
        }
        catch (Exception e) {
            LOG.warning("\u6570\u5b57\u683c\u5f0f\u5316\u5f02\u5e38\uff1a" + str);
            return null;
        }
    }

    private static final Date parseDate(String dateStr, String pattern) {
        try {
            return new SimpleDateFormat(pattern).parse(dateStr);
        }
        catch (Exception e) {
            LOG.warning("\u65e5\u671f\u683c\u5f0f\u5316\u5f02\u5e38\uff1a" + dateStr + "->" + pattern);
            return null;
        }
    }
}

