/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.ex.client;

import com.baiwang.bop.client.BopException;
import com.baiwang.bop.client.impl.BopRestClient;
import com.baiwang.bop.ex.client.AbstractEXClient;
import com.baiwang.bop.ex.domain.ErrorResponse;
import com.baiwang.bop.ex.domain.ParamCheck;
import com.baiwang.bop.ex.domain.Response;
import com.baiwang.bop.ex.handler.IEXHandler;
import com.baiwang.bop.ex.handler.IEXHandlerFactory;
import com.baiwang.bop.ex.result.BWJsonResult;
import com.baiwang.bop.ex.result.BopsResult;
import com.baiwang.bop.ex.result.Result;
import com.baiwang.bop.ex.result.ResultBuilder;
import com.baiwang.bop.ex.result.ResultMsg;
import com.baiwang.bop.request.IBopRequest;
import com.baiwang.bop.respose.parser.IBopResposeParser;
import com.baiwang.bop.respose.parser.impl.JsonResposeParser;
import com.baiwang.bop.respose.parser.impl.XmlResposeParser;
import com.baiwang.bop.utils.BopHashMap;
import com.baiwang.bop.utils.BopUtils;
import com.baiwang.bop.utils.JacksonUtil;
import com.baiwang.bop.utils.OperationController;
import com.baiwang.bop.utils.StrUtils;
import com.baiwang.bop.utils.WebUtils;
import com.baiwang.fasterxml.jackson.databind.JsonNode;
import com.baiwang.fasterxml.jackson.databind.ObjectMapper;
import com.baiwang.open.utils.CommonWebUtils;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Logger;

public class BopEXClient
extends AbstractEXClient {
    private static final Logger LOG = Logger.getLogger(BopRestClient.class.toString());
    private static final String sdkVersion = BopEXClient.class.getPackage().getImplementationVersion();
    private static final String APP_KEY = "appKey";
    private static final String FORMAT = "format";
    private static final String METHOD = "method";
    private static final String TIMESTAMP = "timestamp";
    private static final String VERSION = "version";
    private static final String SIGN = "sign";
    private static final String SESSION = "token";
    private static final String TYPE = "type";
    private static final String REQUEST_ID = "requestId";
    private static final String SDK_VERSION = "sdkVersion";
    private String serverUrl;
    private String appKey;
    private String appSecret;
    private String format = "json";
    private WebUtils webUtils;
    private static ObjectMapper objectMapper = JacksonUtil.getMapper();

    public BopEXClient(String serverUrl, String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
        this.getWebUtil();
    }

    private WebUtils getWebUtil() {
        if (this.webUtils == null) {
            this.webUtils = new WebUtils();
        }
        return this.webUtils;
    }

    @Override
    public <T> T execute(IBopRequest request, String requestId, String session, Class<T> respClazz) throws BopException {
        String resp;
        Class rClazz;
        if (StrUtils.isEmpty(requestId)) {
            requestId = UUID.randomUUID().toString();
        }
        String requestJson = JacksonUtil.beanToString(request);
        if (OperationController.canLog(request.getApiName())) {
            LOG.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + requestJson);
        }
        String postServerUrl = this.appendSystemParamsToUrl(this.serverUrl, request.getApiName(), session, "sync", null, requestId, requestJson);
        LOG.info("\u8bf7\u6c42url\uff1a" + postServerUrl);
        try {
            IEXHandler handler = IEXHandlerFactory.getHandler(request.getApiName());
            rClazz = handler.getResponseClass();
            BopRestClient bopClient = new BopRestClient(this.serverUrl, this.appKey, this.appSecret);
            resp = handler.handle(bopClient, request, session, requestId);
        }
        catch (Exception e) {
            throw new BopException(e);
        }
        resp = this.convertResponse(resp, rClazz, requestId, request.getApiName());
        LOG.info("\u54cd\u5e94\u4fe1\u606f\uff1a" + resp);
        this.tryParseException(resp);
        return this.getResposeParser(this.format, respClazz).parse(resp, request.getApiName());
    }

    private String convertResponse(String resp, Class rClazz, String requestId, String method) {
        if (rClazz == null || resp == null) {
            return null;
        }
        Result result = null;
        String simpleName = rClazz.getSimpleName();
        if ("BWJsonResult".equals(simpleName)) {
            result = this.convertBWJsonResult(resp, requestId);
        } else if ("BopsResult".equals(simpleName)) {
            result = this.convertBopsResult(resp, requestId);
        }
        if (result != null) {
            resp = JacksonUtil.beanToString(result);
        }
        String version = "6.0";
        try {
            JsonNode responseJson = objectMapper.readTree(resp);
            if (resp.contains("success") && !responseJson.get("success").asBoolean()) {
                ErrorResponse errorResponse = ErrorResponse.newErrorResponse(method, requestId, ParamCheck.checkErrorCode(version, ParamCheck.checkErrorCode(version, 100006, this.appKey), this.appKey), "\u8fdc\u7a0b\u8bbf\u95ee\u9519\u8bef", responseJson.get("message").get("errorCode").asInt(), responseJson.get("message").get("errorMessage").asText());
                return JacksonUtil.beanToString(errorResponse);
            }
            if (resp.contains("success") && responseJson.get("success").asBoolean()) {
                Response response = new Response(method, requestId, responseJson.get("model"));
                return JacksonUtil.beanToString(response);
            }
        }
        catch (Exception e) {
            ErrorResponse errorResponse = ErrorResponse.newErrorResponse(method, requestId, ParamCheck.checkErrorCode(version, 60, this.appKey), "\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5", 400, "\u670d\u52a1\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u63d0\u4f9brequestId\u8054\u7cfb\u7ba1\u7406\u5458\u5b9a\u4f4d\u95ee\u9898\uff01");
            JacksonUtil.beanToString(errorResponse);
        }
        return resp;
    }

    private Result convertBopsResult(String resp, String requestId) {
        BopsResult bopsResult = JacksonUtil.jsonStrToObject(resp, BopsResult.class);
        ResultBuilder builder = ResultBuilder.newResult();
        Boolean success = bopsResult.getSuccess();
        Object data = bopsResult.getData();
        String message = bopsResult.getMessage();
        String code = bopsResult.getCode();
        String errorDetail = null;
        String traceId = null;
        if (null != bopsResult.getTraceInfo()) {
            errorDetail = bopsResult.getTraceInfo().getErrorDetail();
            traceId = bopsResult.getTraceInfo().getTraceId();
        }
        ResultMsg resultMsg = null;
        if (success.booleanValue()) {
            if (!StrUtils.isEmpty(message)) {
                resultMsg = new ResultMsg();
                resultMsg.setSuccessMessage(message);
            }
        } else {
            resultMsg = new ResultMsg();
            resultMsg.setInnerRequestId(traceId);
            resultMsg.setErrorCode(code);
            if (null == errorDetail) {
                resultMsg.setErrorMessage(message);
            } else {
                resultMsg.setErrorMessage(errorDetail);
            }
        }
        Result result = builder.setModel(data).setRequestId(requestId).setIsSuccess(success).setResultMsg(resultMsg).build();
        return result;
    }

    private Result convertBWJsonResult(String resp, String requestId) {
        BWJsonResult bwJsonResult = JacksonUtil.jsonStrToObject(resp, BWJsonResult.class);
        if (bwJsonResult == null) {
            return new Result();
        }
        Object responseBody = bwJsonResult.getData();
        boolean success = bwJsonResult.isSuccess();
        String message = bwJsonResult.getMessage();
        String errorCode = bwJsonResult.getErrorCode();
        String errorMsg = bwJsonResult.getErrorMsg();
        String innerRequestId = bwJsonResult.getRequestID();
        if (StrUtils.isEmpty(innerRequestId)) {
            innerRequestId = bwJsonResult.getRequestId();
        }
        ResultMsg resultMsg = null;
        if (success) {
            if (!StrUtils.isEmpty(message)) {
                resultMsg = new ResultMsg();
                resultMsg.setSuccessMessage(message);
            }
        } else {
            resultMsg = new ResultMsg();
            resultMsg.setInnerRequestId(innerRequestId);
            resultMsg.setErrorCode(errorCode);
            resultMsg.setErrorMessage(StrUtils.isEmpty(message) ? errorMsg : message);
        }
        Result result = ResultBuilder.newResult().setModel(responseBody).setIsSuccess(success).setRequestId(requestId).setResultMsg(resultMsg).build();
        return result;
    }

    private <T> IBopResposeParser<T> getResposeParser(String format, Class<T> clazz) {
        if (format.equals("xml")) {
            return new XmlResposeParser<T>(clazz);
        }
        return new JsonResposeParser<T>(clazz);
    }

    private void tryParseException(String rsp) throws BopException {
        if ("json".equals(this.format)) {
            BopUtils.tryParseException(rsp);
        } else {
            BopUtils.tryParseXmlException(rsp);
        }
    }

    private String appendSystemParamsToUrl(String url, String apiName, String session, String type, String asynId, String requestId, String body) {
        Long time = new Date().getTime();
        StringBuilder sburl = new StringBuilder(url);
        sburl = CommonWebUtils.adaptUrl(url, sburl);
        sburl.append(METHOD);
        sburl.append("=");
        sburl.append(apiName);
        sburl.append("&");
        sburl.append(VERSION);
        sburl.append("=6.0&");
        sburl.append(APP_KEY);
        sburl.append("=");
        sburl.append(this.appKey);
        sburl.append("&");
        sburl.append(FORMAT);
        sburl.append("=");
        sburl.append(this.format);
        sburl.append("&");
        sburl.append(TIMESTAMP);
        sburl.append("=");
        sburl.append(time);
        sburl.append("&");
        sburl.append(SESSION);
        sburl.append("=");
        sburl.append(session);
        sburl.append("&");
        sburl.append(TYPE);
        sburl.append("=");
        sburl.append(type);
        if (asynId != null) {
            sburl.append("&");
            sburl.append("asynRequestId");
            sburl.append("=");
            sburl.append(asynId);
        }
        if (requestId != null) {
            sburl.append("&");
            sburl.append(REQUEST_ID);
            sburl.append("=");
            sburl.append(requestId);
        }
        try {
            BopHashMap textParams = new BopHashMap();
            textParams.put(METHOD, apiName);
            textParams.put(VERSION, "6.0");
            textParams.put(APP_KEY, this.appKey);
            textParams.put(FORMAT, this.format);
            textParams.put(TIMESTAMP, (Object)time);
            textParams.put(SESSION, session);
            textParams.put(TYPE, type);
            if (requestId != null) {
                textParams.put(REQUEST_ID, requestId);
            }
            if (asynId != null) {
                textParams.put("asynRequestId", asynId);
            }
            sburl.append("&").append(SDK_VERSION).append("=").append(sdkVersion);
            textParams.put(SDK_VERSION, sdkVersion);
            sburl.append("&");
            sburl.append(SIGN);
            sburl.append("=");
            sburl.append(BopUtils.signTopRequest(textParams, this.appSecret, body));
        }
        catch (Exception e) {
            throw new BopException(e);
        }
        return sburl.toString();
    }
}

