/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.ex.handler.impl;

import com.baiwang.bop.client.BopException;
import com.baiwang.bop.client.IBopClient;
import com.baiwang.bop.ex.bean.common.OCRParseUtil;
import com.baiwang.bop.ex.bean.request.OCRSendResultRequest;
import com.baiwang.bop.ex.bean.request.OCRTokenRequest;
import com.baiwang.bop.ex.bean.response.OCRSendResultResponse;
import com.baiwang.bop.ex.bean.response.OCRTokenResponse;
import com.baiwang.bop.ex.bean.response.model.OCRToken;
import com.baiwang.bop.ex.bean.response.model.SingleTrialInfo;
import com.baiwang.bop.ex.handler.IEXHandler;
import com.baiwang.bop.ex.handler.impl.OcrGlorityHandlerImpl;
import com.baiwang.bop.ex.result.BWJsonResult;
import com.baiwang.bop.request.IBopRequest;
import com.baiwang.bop.request.impl.isp.impl.OcrReadRQRequest;
import com.baiwang.bop.utils.JacksonUtil;
import com.baiwang.bop.utils.StrUtils;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class OCRHandler
implements IEXHandler {
    private static final Logger LOG = Logger.getLogger(OCRHandler.class.toString());

    @Override
    public String handle(IBopClient bopClient, IBopRequest request, String token, String requestId) throws Exception {
        try {
            OCRTokenRequest tokenRequest = new OCRTokenRequest();
            tokenRequest.setRequestId(requestId);
            tokenRequest.setServiceCompany("1");
            OCRTokenResponse response = bopClient.execute(tokenRequest, requestId, token, OCRTokenResponse.class);
            if (response == null || response.getResponse() == null) {
                LOG.warning("\u83b7\u53d6Token\u5f02\u5e38\uff01");
                throw new Exception("OCR\u8bc6\u522b\u7f51\u7edc\u5f02\u5e38\uff01");
            }
            OCRToken ocrToken = response.getResponse().get(0);
            OcrReadRQRequest ocrReadRQRequest = (OcrReadRQRequest)request;
            OcrGlorityHandlerImpl glorityHandler = new OcrGlorityHandlerImpl();
            String ocrStr = glorityHandler.recInvoice(ocrToken, ocrReadRQRequest.getImageData());
            try {
                OCRSendResultRequest sendResultRequest = this.getSendRequest(ocrStr, ocrReadRQRequest.getImageData());
                sendResultRequest.setId(ocrToken.getId());
                sendResultRequest.setRequestId(requestId);
                OCRSendResultResponse oCRSendResultResponse = bopClient.execute(sendResultRequest, requestId, token, OCRSendResultResponse.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return JacksonUtil.beanToString(this.getReturnResponse(ocrStr));
        }
        catch (BopException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warning(e.getMessage());
            return JacksonUtil.beanToString(this.fail(e.getMessage()));
        }
    }

    private OCRSendResultRequest getSendRequest(String ocrResult, String imgData) {
        OCRSendResultRequest sendResultRequest = new OCRSendResultRequest();
        if (StrUtils.isEmpty(ocrResult)) {
            return sendResultRequest;
        }
        Map mapObject = JacksonUtil.jsonStrToObject(ocrResult, Map.class);
        sendResultRequest.setCompanyErrorCode(String.valueOf(mapObject.get("error")));
        sendResultRequest.setFailDesc(String.valueOf(mapObject.get("message")));
        if ("1".equals(String.valueOf(mapObject.get("result")))) {
            sendResultRequest.setOcrFlag("0");
            sendResultRequest.setInvoiceList(OCRParseUtil.parseStandInvoice(mapObject));
        } else {
            LOG.warning("OCR\u591a\u5f20\u8bc6\u522b\u5931\u8d25.");
            sendResultRequest.setOcrFlag("1");
            sendResultRequest.setImageData(imgData);
        }
        return sendResultRequest;
    }

    private BWJsonResult getReturnResponse(String ocrResult) {
        if (StrUtils.isEmpty(ocrResult)) {
            return this.fail("OCR\u8bc6\u522b\u9519\u8bef\uff01");
        }
        Map mapObject = JacksonUtil.jsonStrToObject(ocrResult, Map.class);
        if ("1".equals(String.valueOf(mapObject.get("result")))) {
            List<SingleTrialInfo> singleTrialInfoList = OCRParseUtil.parseCustomInvoice(mapObject);
            BWJsonResult<List<SingleTrialInfo>> jsonResult = new BWJsonResult<List<SingleTrialInfo>>(singleTrialInfoList);
            jsonResult.setTotal(singleTrialInfoList.size());
            jsonResult.setSuccess(true);
            jsonResult.setMessage("OCR\u8bc6\u522b\u6210\u529f\uff01");
            return jsonResult;
        }
        LOG.warning("OCR\u591a\u5f20\u8bc6\u522b\u5931\u8d25.");
        return this.fail("OCR\u8bc6\u522b\u5931\u8d25\uff01");
    }

    private BWJsonResult fail(String errMsg) {
        BWJsonResult jsonResult = new BWJsonResult();
        jsonResult.setSuccess(false);
        jsonResult.setMessage(errMsg);
        return jsonResult;
    }

    @Override
    public Class getResponseClass() {
        return BWJsonResult.class;
    }

    @Override
    public String getMethod() {
        return "baiwang.isp.ocr.rq";
    }
}

