/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.ex.handler.impl;

import com.baiwang.bop.ex.bean.response.model.OCRToken;
import com.baiwang.bop.ex.handler.OcrGlorityHandler;
import com.baiwang.bop.utils.JacksonUtil;
import com.baiwang.bop.utils.WebUtils;
import java.io.IOException;
import java.rmi.AccessException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class OcrGlorityHandlerImpl
implements OcrGlorityHandler {
    private static final Logger LOG = Logger.getLogger(OcrGlorityHandlerImpl.class.toString());

    @Override
    public String recInvoice(OCRToken token, String baseFileData) throws Exception {
        long start = System.currentTimeMillis();
        try {
            Map<String, String> request = this.getRequestMap(token, baseFileData);
            String ocrResult = WebUtils.doPost(token.getUrl(), JacksonUtil.beanToString(request));
            LOG.info("OCR\u591a\u5f20\u8bc6\u522b\u7ed3\u679c:" + ocrResult + ",\u8017\u65f6: ms" + (System.currentTimeMillis() - start));
            return ocrResult;
        }
        catch (AccessException ae) {
            LOG.warning("OCR\u591a\u5f20\u8bc6\u522b\u8bbf\u95ee\u8d85\u65f6!");
            LOG.warning(ae.getMessage());
            throw new Exception("OCR\u8bc6\u522b\u8bbf\u95ee\u8d85\u65f6\uff01");
        }
        catch (IOException ie) {
            LOG.warning("OCR\u8bc6\u522b\u6587\u4ef6\u5904\u7406\u5f02\u5e38!");
            LOG.warning(ie.getMessage());
            throw new Exception("OCR\u8bc6\u522b\u8bbf\u95ee\u8d85\u65f6\uff01");
        }
        catch (Exception e) {
            LOG.warning("OCR\u8bc6\u522b\u7ed3\u679c\u89e3\u6790\u5f02\u5e38!");
            LOG.warning(e.getMessage());
            LOG.warning("OCR\u8bc6\u522b\u7ed3\u679c\u89e3\u6790\u5f02\u5e38!");
            throw new Exception("OCR\u8bc6\u522b\u8bbf\u95ee\u8d85\u65f6\uff01");
        }
    }

    private Map<String, String> getRequestMap(OCRToken token, String baseFileData) {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("app_key", token.getAppKey());
        requestMap.put("timestamp", token.getTimestamp());
        requestMap.put("token", token.getToken());
        requestMap.put("image_data", baseFileData);
        return requestMap;
    }
}

