/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.request.impl;

import com.baiwang.bop.request.IBopRequest;
import com.baiwang.bop.utils.BopHashMap;
import com.baiwang.bop.utils.BopUtils;
import java.util.Date;
import java.util.Map;

public class LoginRequest
implements IBopRequest {
    private String appkey;
    private String appSecret;
    private String userName;
    private String passwordMd5;
    private String userSalt;

    public LoginRequest(String appkey, String appSecret, String userName, String passwordMd5) {
        this.appkey = appkey;
        this.appSecret = appSecret;
        this.userName = userName;
        this.passwordMd5 = passwordMd5;
    }

    public LoginRequest() {
    }

    public String getUserSalt() {
        return this.userSalt;
    }

    public void setUserSalt(String userSalt) {
        this.userSalt = userSalt;
    }

    public String getAppkey() {
        return this.appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPasswordMd5() {
        return this.passwordMd5;
    }

    public void setPasswordMd5(String passwordMd5) {
        this.passwordMd5 = passwordMd5;
    }

    @Override
    public String getApiName() {
        return "baiwang.oauth.token";
    }

    public Map<String, String> getTextParams() {
        BopHashMap rtnMap = new BopHashMap();
        rtnMap.put("grant_type", "password");
        rtnMap.put("client_id", this.appkey);
        rtnMap.put("method", this.getApiName());
        rtnMap.put("version", "6.0");
        rtnMap.put("timestamp", (Object)new Date().getTime());
        return rtnMap;
    }

    public Map<String, String> getTextBody() {
        BopHashMap rtnMap = new BopHashMap();
        rtnMap.put("client_secret", this.appSecret);
        rtnMap.put("username", this.userName);
        rtnMap.put("password", BopUtils.getUuidPasswd(this.passwordMd5, this.userSalt));
        return rtnMap;
    }
}

