/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.respose.parser.impl;

import com.baiwang.bop.client.BopException;
import com.baiwang.bop.respose.entity.isp.AddCustomerResponse;
import com.baiwang.bop.respose.parser.IBopResposeParser;
import com.baiwang.bop.utils.JacksonUtil;
import com.baiwang.fasterxml.jackson.databind.node.ArrayNode;
import com.baiwang.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.logging.Logger;

public class JsonResposeParser<T>
implements IBopResposeParser<T> {
    private static final Logger log = Logger.getLogger(JsonResposeParser.class.toString());
    private static final String METHOD = "method";
    private static final String RESPONSE = "response";
    private static final String SUCCESS = "success";
    private Class<T> clazz;

    public JsonResposeParser(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public T parse(String rsp, String api) throws BopException {
        try {
            ObjectNode respObj = JacksonUtil.getMapper().readValue(rsp, ObjectNode.class);
            if (respObj.has(METHOD) && respObj.get(METHOD).asText().equals(api)) {
                if ("null".equals(respObj.get(RESPONSE) + "")) {
                    return JacksonUtil.getMapper().readValue(rsp, this.clazz);
                }
                if (respObj.get(RESPONSE).isArray()) {
                    return this.parserToArray(respObj);
                }
                if (respObj.get(RESPONSE).get("content") != null && "pending".equals(respObj.get(RESPONSE).get("content").asText())) {
                    return null;
                }
                ObjectNode obj = (ObjectNode)respObj.get(RESPONSE);
                obj.set(METHOD, respObj.get(METHOD));
                obj.set("requestId", respObj.get("requestId"));
                if (!obj.has(SUCCESS) && respObj.has(SUCCESS)) {
                    obj.set(SUCCESS, respObj.get(SUCCESS));
                }
                return this.parserToObject(obj);
            }
            throw new BopException("the respose not in format");
        }
        catch (Exception e) {
            throw new BopException("system.error", rsp, e);
        }
    }

    private T parserToArray(ObjectNode respObj) {
        ArrayNode children = (ArrayNode)respObj.get(RESPONSE);
        ObjectNode node = JacksonUtil.getMapper().createObjectNode();
        Field[] properties = this.clazz.getDeclaredFields();
        for (int i = 0; i < properties.length; ++i) {
            if (!"interface java.util.List".equals(properties[i].getType() + "")) continue;
            node.set(properties[i].getName(), children);
        }
        node.set(METHOD, respObj.get(METHOD));
        node.set("requestId", respObj.get("requestId"));
        if (respObj.has(SUCCESS)) {
            node.set(SUCCESS, respObj.get(SUCCESS));
        }
        return this.parserToObject(node);
    }

    private T parserToObject(ObjectNode node) {
        T rtn = JacksonUtil.ObjectNodeToObject(node, this.clazz);
        if (null == rtn) {
            throw new BopException("the respose object not in format");
        }
        return rtn;
    }

    public static void main(String[] args) throws IOException {
        String json = "{\n    \"response\": [null],    \"method\": \"baiwang.output.customer.addcustomer\",\n    \"requestId\": \"reqid\",\n    \"success\": \"true\",\n    \"code\": \"code\",\n    \"message\": \"msg\"\n}";
        AddCustomerResponse parse = new JsonResposeParser<AddCustomerResponse>(AddCustomerResponse.class).parse(json, "baiwang.output.customer.addcustomer");
        System.err.println(parse);
    }
}

