/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.utils;

import com.baiwang.fasterxml.jackson.annotation.JsonInclude;
import com.baiwang.fasterxml.jackson.core.JsonProcessingException;
import com.baiwang.fasterxml.jackson.databind.DeserializationFeature;
import com.baiwang.fasterxml.jackson.databind.ObjectMapper;
import com.baiwang.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.baiwang.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class JacksonUtil {
    private static ObjectMapper mapper = new ObjectMapper();

    private JacksonUtil() {
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static <T> T jsonStrToObject(String jsonStr, Class<T> valueType) {
        try {
            return mapper.readValue(jsonStr, valueType);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static <T> T ObjectNodeToObject(ObjectNode objNode, Class<T> valueType) {
        try {
            return mapper.treeToValue(objNode, valueType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> String beanToString(T input) {
        try {
            return mapper.writeValueAsString(input);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        JsonNodeFactory jsonNodeFactory = new JsonNodeFactory(true);
        mapper.setNodeFactory(jsonNodeFactory);
    }
}

