/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.utils;

import com.baiwang.bop.client.BopException;
import com.baiwang.dom4j.Element;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class XmlUtil {
    private static final String keyXmlParserError = "This XML is not in the right format,please add a parent node for Node of the same name!";

    public static <T> List<T> getList(List<Element> elements, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            for (int i = 0; i < elements.size(); ++i) {
                T t = XmlUtil.getBean(elements.get(i), clazz);
                list.add(t);
            }
        }
        catch (Exception e) {
            throw new BopException(e);
        }
        return list;
    }

    public static <T> T getBean(Element root, Class<T> clazz) {
        return XmlUtil.getBean(root, clazz, null);
    }

    public static <T> T getBean(Element root, Class<T> clazz, Field[] propertiesParams) {
        try {
            T t = clazz.newInstance();
            Field[] properties = null;
            Field[] clazzproperties = clazz.getDeclaredFields();
            properties = null != propertiesParams && propertiesParams.length > 0 ? propertiesParams : clazz.getDeclaredFields();
            for (int i = 0; i < properties.length; ++i) {
                String fieldType = properties[i].getType() + "";
                Method setmeth = t.getClass().getMethod("set" + properties[i].getName().substring(0, 1).toUpperCase() + properties[i].getName().substring(1), properties[i].getType());
                if ("interface java.util.List".equals(fieldType)) {
                    List<?> listNode;
                    String fieldGenericType = properties[i].getGenericType() + "";
                    String[] sp1 = fieldGenericType.split("<");
                    String[] sp2 = sp1[1].split(">");
                    String className = sp2[0];
                    if (clazzproperties.length == 1 && clazzproperties[0].getName().equals(properties[i].getName())) {
                        listNode = XmlUtil.getList(root.element(properties[i].getName()).elements(), Class.forName(className));
                    } else {
                        List<Element> list = XmlUtil.getListElements(root, properties[i].getName());
                        listNode = XmlUtil.getList(list, Class.forName(className));
                    }
                    setmeth.invoke(t, listNode);
                    continue;
                }
                if ("class java.lang.Boolean".equals(fieldType)) {
                    setmeth.invoke(t, Boolean.valueOf(root.elementText(properties[i].getName())));
                    continue;
                }
                setmeth.invoke(t, root.elementText(properties[i].getName()));
            }
            return t;
        }
        catch (Exception e) {
            throw new BopException(e);
        }
    }

    public static boolean isList(Element root) {
        List elements;
        boolean type = false;
        if (root != null && (elements = root.elements()) != null && elements.size() > 0) {
            String elementNameFlag = ((Element)elements.get(0)).getName();
            for (int i = 1; i < elements.size(); ++i) {
                String elementName = ((Element)elements.get(i)).getName();
                if (!elementNameFlag.equals(elementName)) {
                    return false;
                }
                type = true;
            }
        }
        return type;
    }

    public static boolean isHaveList(Element root) {
        List elements;
        if (root != null && (elements = root.elements()) != null && elements.size() > 0) {
            HashSet<String> elementSet = new HashSet<String>();
            for (Element ele : elements) {
                elementSet.add(ele.getName());
            }
            if (elementSet.size() < elements.size()) {
                return true;
            }
        }
        return false;
    }

    public static List<Element> getRosponseElements(Element root) {
        List list = root.elements();
        for (int i = list.size() - 1; i > -1; --i) {
            if (!"method".equals(((Element)list.get(i)).getName()) && !"requestId".equals(((Element)list.get(i)).getName()) && !"success".equals(((Element)list.get(i)).getName())) continue;
            list.remove(list.get(i));
        }
        return list;
    }

    public static List<Element> getListElements(Element root, String name) {
        ArrayList<Element> list = new ArrayList<Element>();
        List listRoot = root.elements();
        for (int i = 0; i < listRoot.size(); ++i) {
            if (!name.equals(((Element)listRoot.get(i)).getName())) continue;
            list.add((Element)listRoot.get(i));
        }
        return list;
    }
}

